/*
################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
################################################################################
*/

/*global window,alert,document,jQuery */

var applicationsCommon = {

    renderServiceForm: function () {
        // change dynamically Queues and Hosts list values at Cluster selection
        if (jQuery(".ef-srv-opt-list-of-clusters").length === 1) { // skip if there is more than 1 cluster list
            if (jQuery(".ef-srv-opt-list-of-clusters option").length) {
                if (jQuery(".ef-srv-opt-list-of-clusters option:selected").length === 1) { // skip if there is more than 1 cluster selected
                    applicationsCommon.updateListOfHosts(jQuery(".ef-srv-opt-list-of-clusters").val());
                    applicationsCommon.updateListOfQueues(jQuery(".ef-srv-opt-list-of-clusters").val());
                    jQuery(".ef-srv-opt-list-of-clusters").change(function () {
                        applicationsCommon.updateListOfHosts(this.value);
                        applicationsCommon.updateListOfQueues(this.value);
                    });
                }
            }
            else {
                jQuery('#nj-content-div').prepend("<div id='ef-message-wrapper' />");
                jQuery('#ef-message-wrapper').hymessage().hymessage('alert', "EnginFrame cannot get Clusters information or you don't have visibility on any Cluster. Please contact your system administrator.");
            }
        }
    },

    updateSelect: function (selectId, selectValues) {
        jQuery(selectId).empty();
        jQuery(selectId).append('<option value="">--</option>');
        jQuery.each(selectValues, function (key, value) {
            jQuery(selectId).append('<option value="' + key + '">' + efEncodeHtml(value) + '</option>');
        });
    },

    updateListOfHosts: function (cluster_grid) {
        var showStatus = false;
        if (jQuery('.ef-srv-opt-list-of-host-with-status').length) {
            showStatus = true;
        }
        jQuery.hydrogen.invokeService({
            sdf: "/" + jQuery.enginframe.rootContext + "/applications/applications.xml",
            uri: "//applications/list.of.hosts",
            data: {
                cluster: cluster_grid.split(':')[0],
                grid: cluster_grid.split(':')[1],
                showStatus: showStatus
            },
            dataType: "xml",
            success: function (xml) {
                var selectValues = {};
                jQuery(xml).find('ef\\:option, option').each(function () {
                    selectValues[jQuery(this).attr("id")] = jQuery(this).text();
                });
                jQuery(".ef-srv-opt-list-of-hosts").each(function () {
                    applicationsCommon.updateSelect(this, selectValues);
                });
            }
        });
    },

    updateListOfQueues: function (cluster_grid) {
        jQuery.hydrogen.invokeService({
            sdf: "/" + jQuery.enginframe.rootContext + "/applications/applications.xml",
            uri: "//applications/list.of.queues",
            data: {
                cluster: cluster_grid.split(':')[0],
                grid: cluster_grid.split(':')[1]
            },
            dataType: "xml",
            success: function (xml) {
                var selectValues = {};
                jQuery(xml).find('ef\\:option, option').each(function () {
                    selectValues[jQuery(this).attr("id")] = jQuery(this).text();
                });
                jQuery(".ef-srv-opt-list-of-queues").each(function () {
                    applicationsCommon.updateSelect(this, selectValues);
                });
            }
        });
    },

    renderNavigation: function () {
        // move Services subfolders at navigation first level
        jQuery('.ef-published-root-folder').parent().append(jQuery('.ef-published-root-folder .ef-navigation-folder').detach());

        // move Service Providers subfolders at navigation first level
        jQuery('.ef-published-root-folder').parent().append(jQuery('.ef-navigation-folder.ef-service-provider-folder').detach());
    },

    renderMOTD: function () {
        if (document.getElementById("motd")) {
            // Replace content of <div id="motd"/> with the html returned by service
            jQuery.hydrogen.invokeService({
                sdf: "/" + jQuery.enginframe.rootContext + "/applications/applications.xml",
                uri: "//com.enginframe.themes/get.motd",
                data: {
                    plugin: "applications"
                },
                dataType: "text",
                success: function (output) {
                    jQuery('#motd').html(output);
                },
                error: function () {
                    jQuery('#nj-content-div').prepend("<div id='ef-message-wrapper' />");
                    jQuery('#ef-message-wrapper').hymessage().hymessage('alert', "An error occurred retrieving MOTD content. Please ask EF Portal administrator to check the logs");
                }
            });
        }
    }
};

jQuery(document).ready(function () {
    applicationsCommon.renderServiceForm();
    applicationsCommon.renderNavigation();
    applicationsCommon.renderMOTD();
});

// ex:ts=4:et:
