<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
                exclude-result-prefixes="ef">


  <!-- Overrides mode="navigation" : plugins/themes/lib/xsl/<theme_name>/layout.templates.xsl, com.enginframe.navigation.xsl -->
  <!-- It show services in folder ordered alphabetically by ef:name -->

  <!-- Any visible folder (except the root one) -->
  <xsl:template match="ef:folder[$ef-real-navigation = 'plain' and @id!=$ef.navigation.root and not(@hidden='true')]" mode="navigation">
    <li>
      <xsl:attribute name="class">
        <xsl:text>ef-navigation-folder </xsl:text>
        <xsl:apply-templates select="@class" mode="navigation"/>
      </xsl:attribute>
      <xsl:apply-templates select="@title" mode="navigation"/>
      <xsl:apply-templates select="ef:name" mode="navigation"/>
      <ul>
        <xsl:apply-templates select="descendant::ef:folder[current() = ancestor::ef:folder[1]] |
            descendant::ef:service[current() = ancestor::ef:folder[1]] |
            descendant::ef:service-link-list[current() = ancestor::ef:folder[1]]" mode="navigation">
          <xsl:sort select="ef:name" />
        </xsl:apply-templates>
        <xsl:text> </xsl:text>
      </ul>
    </li>
  </xsl:template>

  <!-- End override mode="navigation" -->

</xsl:stylesheet>
