#!/bin/bash

# Check the COMMAND is set. Do not check execution bit since it could be in PATH.
if [[ -z ${COMMAND} ]]; then
    echo "You must specify a command" >&2
    exit 1
fi

if [[ -z ${EXEC_DIR} ]]; then
    # Use the EF_SPOOLER in case no EXEC_DIR is specified.
    EXEC_DIR="${EF_SPOOLER}"
else
    if [[ -d ${EXEC_DIR} && -x ${EXEC_DIR} && -r ${EXEC_DIR} ]]; then
        # Create a local RSpooler to the EXEC_DIR (assumption: EXEC_DIR exists on EF node)
        "${EF_ROOT}/plugins/rspooler/bin/ef.rspooler.add.sh" -p "${EXEC_DIR}" -l "Execution directory"
    fi
fi

cd "${EXEC_DIR}" || exit 1

if [[ -n ${INPUT_FILE} ]]; then
    # The INPUT_FILE is not empty.
    # No additional checks needed, we just pass it to the COMMAND.
    "${COMMAND}" ${APP_OPTIONS} "${INPUT_FILE}"
else
    "${COMMAND}" ${APP_OPTIONS}
fi
