#!/bin/bash
# Parameters for the applications.submit

#  --jobname         <job name> - By default "${SM_SERVICE_NAME}"
#  --jobmanager      <lsf | sge | ...>
#  --cluster         <cluster>
#  --host            <host>
#  --queue           <queue name>
#  --project         <project>
#  --submitopts      <quoted string of extra options passed verbatim to the jobmanager submission command>
#  --stdout          <stdout>
#  --stdin           <stdin>
#  --stderr          <stderr>
#  --command         <command> <command parameters> - By Default is the Job Script

#  examples

#  applications.submit --jobmanager lsf --submitopts "-n ${NCORES} -q ${QUEUE}"
#  where NCORES and QUEUE are options ID from the service editor

#  applications.submit --jobname "SGE Test" --jobmanager sge --project "SGE Project" --host "node01"

if [ ! -f "${file}" ] && [ ! -f "${rfb_file}" ]; then
    echo "Input file empty or not found" >&2
    exit 1
fi

if [ "${rfb_file}" != "" ] ; then 
    _file=$(basename "${rfb_file}")
else 
    _file=$(file)
fi

# Set spooler name
EF_SPOOLER_NAME="Jupyter Notebook: \"${_file}\""
export EF_SPOOLER_NAME

# Submit the job
applications.submit --cluster "${cluster}" --jobname "Jupyter Notebook ${_file}"
