#!/bin/bash
# Parameters for the vdi.launch.session
#
#  --name            <session name> (Default: the service name)
#  --host            <host>  
#  --queue           <queue> (Default: job scheduler default or the value configured in
#                    EF_TOP/conf/plugins/interactive/interactive.efconf)
#  --project         <project>
#  --submitopts      <scheduler options> quoted string with the extra options passed verbatim
#                    to the jobmanager submission command
#                    <NICE DCV Session Manager delegate> quoted string with the extra requirements passed
#                    to the submission API
#  --close-on-exit   flag parameter to automatically close the session when the specified application
#                    launcher script exits or the monitored canary process terminates 
#  --canaryprocess   <process name> (Windows only) the name of the process to monitor for close-on-exit
#                    (Default: explorer.exe)
#  --logintimeout    <logintimeout> (Windows only) time in seconds to wait for user to login once the
#                    session is started (Default: inherited from interactive or scheduler configuration,
#                    usually 600 sec)
#  --loglevel        <level> verbosity of the session log (level range: 0 - 4) (Default: value configured
#                    in EF_TOP/conf/plugins/interactive/interactive.efconf, usually 3 - INFO)
#  --no-connect      flag parameter to avoid EF to automatically download the session connection file
#                    on session submission
#
#  --<remote>-*      <value> specific parameters for the remote visualization technology 
#                    (e.g. dcv2, etc.)
#    Supported options for NICE DCV (dcv2):
#      --dcv2-storage-root            <path> (e.g. %home%/Desktop)
#      --dcv2-gl                      <on|off>
#      --dcv2-permissions-file        <path>
#      --dcv2-init                    <path>
#      --dcv2-max-concurrent-clients  <value>
#      --dcv2-client-eviction-policy  <policy>
#      --dcv2-disable-login-monitor   <true|false>
#      More background can be found here: https://docs.aws.amazon.com/dcv/latest/adminguide/managing-sessions-start.html
#      The dcv create-session parameter --gl-display is implemented via the gpu.balancer
#
#  --delegate-*      <value> specific parameter for the configured delegate
#    Supported options for NICE DCV Session Manager:
#      --delegate-storage-root              <path> (e.g. “%home%/Desktop”)
#      -–delegate-dcv-gl-enabled            <true|false>
#      -–delegate-init-file                 <path>
#      --delegate-autorun-file              <path>
#      --delegate-autorun-arguments         <comma_separated_list> (e.g. "arg1, arg2")
#      -–delegate-max-concurrent-clients    <value>
#      --delegate-enqueue                   <true|false>
#      --delegate-disable-retry-on-failure  <true|false>
#
#  --cwd             <path> the path to the remote working directory where the command will be launched
#                    (Default: depends on the underlying scheduler configuration)
#
#  Examples:
#
#  vdi.launch.session --name "My Session" --submitopts "-n ${NCORES} -q ${QUEUE}"
#        where NCORES and QUEUE are options ID from the service editor
#  vdi.launch.session --dcv2-storage-root %home%/Desktop
#        set storage root with dcv2 remote on the underlying job scheduler
#  vdi.launch.session --delegate-storage-root %home%/Desktop
#        set storage root with DCV Session Manager

vdi.launch.session
