#!/bin/bash
# ANSYS Mechanical job script
run() {
    echo "Entering JOB_WORKING_DIR: \"${JOB_WORKING_DIR}\""
    if [ -d "${JOB_WORKING_DIR}" ]; then
        cd "${JOB_WORKING_DIR}"
    else
        echo "Unable to change directory to \"${JOB_WORKING_DIR}\"" >&2
        exit 1
    fi
    echo "Running \"$*\""
    "$@"
}

run "${MECHANICAL_EXECUTABLE}" \
    -np "${NCORES}" \
    "-${MODE}" \
    -driver x11 \
    -goff \
    -gu \
    -b \
    -j "${JOB_NAME}" \
    < "${INPUT_FILE}"
