#!/bin/bash
# BLAST job script
run() {
    echo "Entering JOB_WORKING_DIR: \"${JOB_WORKING_DIR}\""
    if [ -d "${JOB_WORKING_DIR}" ]; then
        cd "${JOB_WORKING_DIR}"
    else
        echo "Unable to change directory to \"${JOB_WORKING_DIR}\"" >&2
        exit 1
    fi
    echo "Running \"$*\""
    "$@"
}

run "${BLAST_EXECUTABLE}" \
    -query "${INPUT_FILE}" \
    -db "${BLAST_DATABASE}" \
    -num_threads "${NCORES}" \
    -out results.txt \
    ${OPTIONS}
