#!/bin/bash
# Blender job script
run() {
    echo "Entering JOB_WORKING_DIR: \"${JOB_WORKING_DIR}\""
    if [ -d "${JOB_WORKING_DIR}" ]; then
        cd "${JOB_WORKING_DIR}"
    else
        echo "Unable to change directory to \"${JOB_WORKING_DIR}\"" >&2
        exit 1
    fi
    echo "Running \"$*\""
    "$@"
}

run "${BLENDER_EXECUTABLE}" \
    -b "${INPUT_FILE}" \
    -o "${JOB_WORKING_DIR}/render_" \
    -F "${RENDER_FORMAT}" \
    -s "${START_FRAME}" \
    -e "${END_FRAME}" \
    -j "${JUMP_FRAMES}" \
    -a \
    -t "${NCORES}" \
    ${OPTIONS}
