#!/bin/bash
# MSC Nastran batch action script

# Important!
# This examples assumes that JOB_WORKING_DIR is shared with the execution host.
# By default the JOB_WORKING_DIR is set to to the EF_SPOOLER directory, so this
# example works only if the spooler directory is shared with the execution host.
#
# This is not a requirement of EnginFrame Applications portal but a
# simplification used by this example.

link_in_spooler() {
    # get canonical path of input files and create symlink in spooler
    declare -a _files=()
    while read -r; do
        _files+=("$(readlink -f "${REPLY}")")
    done <<< "${1:-}"

    # create symlink from spoolers to input files
    for _file in "${_files[@]}"; do
        if [ -r "${_file}" ]; then
            ln -s "${_file}" "${EF_SPOOLER}"
        fi
    done
}

main() {
    local -a args=(
        ${JOB_NAME:+--jobname "${JOB_NAME}"}
        ${PROJECT:+--project "${PROJECT}"}
        ${NCORES:+--processors "${NCORES}"}
        ${QUEUE:+--queue "${QUEUE}"}
        --stdout "${JOB_WORKING_DIR}/stdout.txt"
        --stderr "${JOB_WORKING_DIR}/stderr.txt"
    )

    link_in_spooler "${INPUT_FILE}"

    export NASTRAN_EXECUTABLE="${!VERSION}"

    applications.submit "${args[@]}"
}

export JOB_WORKING_DIR="${JOB_WORKING_DIR:-${EF_SPOOLER}}"

main
