################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
################################################################################

# Variables:
# - CLUSTER_ID
# - EF_XMLNS_grid
# - statusmap

# Sample "awsbhosts -d" output
#ec2InstanceId            : i-047a3dddeadc79aa4
#containerInstanceArn     : arn:aws:ecs:eu-west-1:<account-id>:container-instance/0a3269a5-bf1b-4c0a-9ea1-a6860f4d55e6
#status                   : ACTIVE
#instanceType             : m4.large
#privateIpAddress         : 172.31.19.225
#publicIpAddress          : 52.30.24.239
#privateDnsName           : ip-172-31-19-225.eu-west-1.compute.internal
#publicDnsName            : ec2-52-30-24-239.eu-west-1.compute.amazonaws.com
#runningJobs              : 1
#pendingJobs              : 0
#registeredCPUs           : 2
#registeredMemory[MB]     : 7945
#availableCPUs            : 1
#availableMemory[MB]      : 7817
#-------------------------

BEGIN {
    # Read status mapping file
    while (getline < statusmap > 0) {
        # E.g. ok:ACTIVE
        split($0, fields, ":")
        s=split(fields[2], label, " ")
        for (i=1; i<=s; i++) {
            status[label[i]] = fields[1]
        }
    }
    close(statusmap);

    print "<grid:host-list type=\"awsbatch\" cluster=\"" escapeXmlAttribute(CLUSTER_ID) "\" " EF_XMLNS_grid ">"
}

END {
    print "</grid:host-list>"
    exit 0
}

function resetVars() {
    HOST=""
    STATUS=""
    USAGE=""
    split("", RESOURCES)
}

function printXML() {
    print "  <grid:host type=\"awsbatch\" arch-family=\"LINUX\" name=\"" escapeXmlAttribute(HOST) "\" ncpus=\"" MAX_CPUS "\">"
    efStatus = status[STATUS];
    if (status[STATUS] == "") {
        efStatus = "unknown";
    }
    print "    <grid:status ef=\"" efStatus "\" grid=\"" STATUS "\" base=\"" escapeXmlAttribute(STATUS) "\" batch=\"" STATUS "\"/>"
    for (i in RESOURCES) {
        print "    <grid:resource name=\"" i "\">" escapeXmlContent(RESOURCES[i]) "</grid:resource>"
    }
    print "    <grid:resource name=\"mem\" max=\"" MAX_MEMORY "\">" FREE_MEMORY "</grid:resource>"
    print "    <grid:usage running-jobs=\"" escapeXmlAttribute(USAGE) "\"/>"
    print "  </grid:host>"
}


/^containerInstanceArn/ {
    RESOURCE[$1] = $3
}

/^status/ {
    STATUS = $3
}

/^ec2InstanceId/ {
    HOST = $3
}

/^instanceType/ {
    RESOURCES[$1] = $3
}

/^privateIpAddress/ {
    RESOURCES[$1] = $3
}

/^publicIpAddress/ {
    if ($3 != "-") {
        RESOURCES[$1] = $3
    }
}

/^privateDnsName/ {
    RESOURCES[$1] = $3
}

/^publicDnsName/ {
    if ($3 != "-") {
        RESOURCES[$1] = $3
    }
}

/^runningJobs/ {
    USAGE = $3
}

/^pendingJobs/ {
    next
}

/^registeredCPUs/ {
    MAX_CPUS = $3
}

/^registeredMemory/ {
    MAX_MEMORY = $3 * 1024 * 1024
}

/^availableCPUs/ {
    FREE_CPUS = $3
}

/^availableMemory/ {
    FREE_MEMORY = $3 * 1024 * 1024
}

/^--*/ {
    printXML()
    resetVars()
}

# vi: ts=4 sw=4 et syntax=awk :
