################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
################################################################################

# Variables:
# - EF_XMLNS_grid

# Sample "awsbqueues -d" output
#jobQueueArn              : arn:aws:batch:eu-west-1:<account-id>:job-queue/parallelcluster-batch
#jobQueueName             : parallelcluster-batch
#priority                 : 1
#status                   : VALID
#statusReason             : JobQueue Healthy
#-------------------------

BEGIN {
    print "<grid:queue-list type=\"awsbatch\" " EF_XMLNS_grid ">"
}

END {
    print "</grid:queue-list>"
    exit 0
}

function resetVars() {
    QUEUE=""
    STATUS=""
}

function printXML() {
    print "  <grid:queue name=\"" escapeXmlAttribute(QUEUE) "\" type=\"awsbatch\" >";
    if (STATUS == "AVAILABLE") {
        _status="OK"
    } else {
        _status="CLOSED"
    }
    print "    <grid:status>" _status "</grid:status>";
    print "  </grid:queue>"
}


/^jobQueueArn/ {
    next
}

/^jobQueueName/ {
    QUEUE = $3
}

/^priority/ {
    next
}

/^status / {
    STATUS = $3
}

/^statusReason/ {
    next
}

/^--*/ {
    printXML()
    resetVars()
}

# vi: ts=4 sw=4 et syntax=awk :
