################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
################################################################################

# Variables:
# - COMPRESS_ARRAY
# - GRID_TAG_SIZE_LIMIT
# - JOBID_FILTER_IN
# - JOBID_FILTER_OUT
# - statusmap

# Sample "awsbstat -d" output
#jobId                    : e0acb127-7e6d-42b0-8ca0-82b766161fd1
#jobName                  : sleep
#createdAt                : 2018-11-23 11:38:50
#startedAt                : -
#stoppedAt                : -
#status                   : RUNNABLE
#statusReason             : -
#jobDefinition            : parallelcluster-batch:1
#jobQueue                 : parallelcluster-batch
#command                  : sleep 1000
#exitCode                 : -
#reason                   : -
#vcpus                    : 1
#memory[MB]               : 128
#nodes                    : 1
#logStream                : -
#log                      : -
#log                      : -
#s3FolderUrl              : s3://parallelcluster-xxx/batch/job-xxx
#-------------------------

BEGIN {
    # Read status mapping file
    while (getline < statusmap > 0) {
        # E.g. "Pending: SUBMITTED PENDING RUNNABLE STARTING"
        split($0, fields, ":")
        s = split(fields[2], label, " ")
        for (i=1; i<=s; i++) {
            states[label[i]] = fields[1]
        }
    }
    close(statusmap)
}

END {
    exit 0
}

function truncate(_s) {
    if ((GRID_TAG_SIZE_LIMIT != "") && (length(_s) > GRID_TAG_SIZE_LIMIT)) {
        _s = substr(_s, 1, GRID_TAG_SIZE_LIMIT - 5)
        sub(/ [^ ]*$/, "", _s);
        return _s "[...]"
    } else {
        return _s
    }
}

function resetVars() {
    JOB=""
    SUBMISSION_TIME=""
    EXECUTION_TIME=""
    TERMINATION_TIME=""
    STATUS=""
    NAME=""
    USER=""
    QUEUE=""
    COMMAND=""
    VCPUS=""
    MEMORY=""
    split("", REASONS)
}

function printXML() {
    # modify id and name according to the job type
    if (split(JOB, val, ":") > 1) {
        # array child (e.g. "jobid:1")
        if (COMPRESS_ARRAY == "true") {
            print "  <grid:job type=\"awsbatch\" id=\"" JOB "\" is-array=\"true\" mode=\"array\">"
        } else {
            print "  <grid:job type=\"awsbatch\" id=\"" JOB "\" array-id=\"" val[1] "\" index=\"" val[2] "\" >" ;
        }
        print "    <grid:name>" escapeXmlContent(NAME) "</grid:name>"

    } else if (split(JOB, val, "#") > 1) {
        # mnp child (e.g. "jobid#1")
        print "  <grid:job type=\"awsbatch\" id=\"" JOB "\">"
        # append mnp child identifier to the name
        print "    <grid:name>" escapeXmlContent(NAME) "#" val[2] "</grid:name>"

    } else {
        # parent mnp (e.g. "jobid *N"), parent array (e.g. "jobid [2]") or simple job
        # remove awsbatch job type information from the id, if there.
        split(JOB, val, " ")
        print "  <grid:job type=\"awsbatch\" id=\"" val[1] "\">"
        # append awsbatch job type taken from the id to the name
        print "    <grid:name>" escapeXmlContent(NAME) "" val[2] "</grid:name>"
    }

    print "    <grid:submission-time>" escapeXmlContent(SUBMISSION_TIME) "</grid:submission-time>"
    if (EXECUTION_TIME != "-") {
        print "    <grid:execution-time>" escapeXmlContent(EXECUTION_TIME) "</grid:execution-time>"
    }
    if (TERMINATION_TIME != "-") {
        print "    <grid:termination-time>" escapeXmlContent(TERMINATION_TIME) "</grid:termination-time>"
    }

    efStatus = states[STATUS]
    if (efStatus == "") {
        efStatus = "Unknown"
    }
    print "    <grid:status grid=\"" STATUS "\" ef=\"" efStatus "\">" STATUS "</grid:status>"
    print "    <grid:owner>" escapeXmlContent(USER) "</grid:owner>"
    print "    <grid:queue>" escapeXmlContent(QUEUE) "</grid:queue>"

    command = truncate(COMMAND)
    print "    <grid:command>" escapeXmlContent(command) "</grid:command>"
    print "    <grid:total-cpu-usage>" escapeXmlContent(VCPUS) "</grid:total-cpu-usage>"
    print "    <grid:memory-usage>" escapeXmlContent(MEMORY) "</grid:memory-usage>"

    print "    <grid:reasons>"
    for (i in REASONS) {
        print "      <grid:reason>" escapeXmlContent(REASONS[i]) "</grid:reason>"
    }
    print "    </grid:reasons>"
    print "  </grid:job>"
}


/^jobId/ {
    JOB = substr($0, index($0, $3))
}

/^jobName/ {
    if (index($3, "---")) {
        split($3, val, "---")
        if (val[1] != "" && val[2] != "") {
            NAME = val[1]
            USER = val[2]
        } else {
            NAME = $3
        }
    } else {
        NAME = $3
    }
}

/^createdAt/ {
    SUBMISSION_TIME = substr($0, index($0, $3))
}

/^startedAt/ {
    EXECUTION_TIME = substr($0, index($0, $3))
}

/^stoppedAt/ {
    TERMINATION_TIME = substr($0, index($0, $3))
}

/^status / {
    STATUS = $3
}

/^statusReason/ {
    _statusReason = substr($0, index($0, $3))
    if (_statusReason != "-") {
        REASONS[$1] = _statusReason
    }
}

/^jobDefinition/ {
    next
}

/^jobQueue/ {
    QUEUE = $3
}

/^command/ {
    COMMAND = substr($0, index($0, $3))
}

/^exitCode/ {
    next
}

/^reason/ {
    _reason = substr($0, index($0, $3))
    if (_reason != "-") {
        REASONS[$1] = _reason
    }
}

/^vcpus/ {
    VCPUS = $3
}

/^memory/ {
    MEMORY = $3 " Mbytes"
}

/^nodes/ {
    next
}

/^logStream/ {
    next
}

/^log/ {
    next
}

/^s3FolderUrl/ {
    next
}

/^--*/ {
    # print only jobs for which the jobid contains the given JOBID_FILTER_IN and does not contain the given JOBID_FILTER_OUT
    # "*" --> parent MNP job
    # "#" --> MNP job child
    # "[" --> parent job array
    # ":" --> array job child

    if ((JOBID_FILTER_IN != "" && (split(JOB, val, JOBID_FILTER_IN) > 1)) || JOBID_FILTER_IN == "") {
        if ((JOBID_FILTER_OUT != "" && !(split(JOB, val, JOBID_FILTER_OUT) > 1)) || JOBID_FILTER_OUT == "") {
            printXML()
        }
    }
    resetVars()
}

# vi: ts=4 sw=4 et syntax=awk :
