#!/bin/bash

# Source the xmlfuncs file since we need to use the ef_xml_escape function
. "${EF_ROOT}/plugins/ef/lib/xmlfuncs"

echo "<h3>Uploaded files</h3>"
echo "<ul>"

if [ -n "${file_var}" ]; then
    echo "<li>Single file: " $(ef_xml_escape_content -i "${file_var}") "</li>"
fi

if [ -n "${text_file_var}" ]; then
    echo "<li>Text file: " $(ef_xml_escape_content -i "${text_file_var}") "</li>"
fi

echo "${multiple_files_var}" | while read i; do
    if [ -n "${i}" ]; then
        echo "<li>Multiple files: " $(ef_xml_escape_content -i "${i}") "</li>"
    fi
done

if [ -z "${file_var}" -a -z "${text_file_var}" -a -z "${multiple_files_var}" ]; then
    echo "<li>No file uploaded</li>"
fi

echo "</ul>"

# Rename the spooler
"${EF_ROOT}/plugins/ef/bin/ef.rename.spooler" "${EF_SPOOLER_URI}" "File Option Example"
