#!/bin/bash

# Avoid exploitation, it's supposed to be an uploaded file available in the cwd (the spooler).
file=$(basename "${file}")
if [ ! -f "${file}" ]; then
    echo "Please select an input file" >&2
    exit 1
fi

# Set spooler name
EF_SPOOLER_NAME="GZip \"$file\""
export EF_SPOOLER_NAME

# Submit the job
if [ -n "${scheduler}" ]; then
    "${EF_ROOT}/plugins/grid/bin/grid.submit" --jobmanager ${scheduler} --jobname "gzip $file" --command gzip -$level "${EF_SPOOLER}/$file"
else
    "${EF_ROOT}/plugins/grid/bin/grid.submit" --jobname "gzip $file" --command gzip -$level "${EF_SPOOLER}/$file"
fi
