#!/bin/bash

# Source the xmlfuncs file since we need to use the ef_xml_escape function
. "${EF_ROOT}/plugins/ef/lib/xmlfuncs"

_xml_safe_var=`ef_xml_escape -i "${text_var}"`

cat << EOF
<ef:call-service uri="//showcase/scheduled.service">
  <ef:with-option id="option_var">${_xml_safe_var}</ef:with-option>
  <ef:with-option id="EF_REUSE_SPOOLER">${EF_SPOOLER_URI}</ef:with-option>
  <ef:with-option id="EF_RESET_SPOOLER_TTL">false</ef:with-option>
  <ef:trigger type="simple">
    <ef:start-time-seconds-in-future>5</ef:start-time-seconds-in-future>
    <ef:repeat-count>8</ef:repeat-count>
    <ef:repeat-interval unit="SECONDS">15</ef:repeat-interval>
  </ef:trigger>
</ef:call-service>
EOF

# Rename the spooler
"${EF_ROOT}/plugins/ef/bin/ef.rename.spooler" "${EF_SPOOLER_URI}" "Simple Trigger Example"

# Show the spooler view
"${EF_ROOT}/plugins/ef/bin/ef.show.spooler" --redirect "${EF_SPOOLER_URI}"
