/*
	  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.	  */
	 /*global jQuery */
	 var hyHpc = {

	     loadHpcOutput: function (textarea, uri, clusterid, jobid, actionName) {
	         jQuery.enginframe.invokeService({
	             sdf: '/' + jQuery.enginframe.rootContext + '/hpc/lib/xml/grid.hpc.job.actions.xml',
	             uri: uri,
	             data: {
	                 cluster_id: clusterid,
	                 job_id: jobid,
	                 action_name: actionName
	             },
	             success: function (output) {
	                 textarea.val(output);
	             },
	             dataType: 'text'
	         });
	     },

	     getActionDialog: function (clusterid, jobid, actionName) {
	         var dialog, textarea;
	         dialog = jQuery('<div class="hy-action-dialog"/>').appendTo(jQuery('body'));
	         textarea = jQuery('<textarea rows="25" readonly="readonly" style="width: 99%; height: 99%;"/>').appendTo(dialog);
	         dialog.dialog({
	             title: actionName.charAt(0).toUpperCase() + actionName.slice(1) + " of Job: " + efEncodeHtml(jobid),
	             buttons: {
	                 "Close": function() {
	                     jQuery(this).dialog("close");
	                 }
	             },
	             width: jQuery(80).toPx(),
	             bgiframe: true,
	             modal: true
	         });
	         hyHpc.loadHpcOutput(textarea, '//grid.hpc.job.actions/job.action', clusterid, jobid, actionName);
	     }
	 };
