/*
 * EnginFrame Ajax
 * # vi: ts=4 sw=4 et :
 * ----------------------------------------------------------------------------
 *
 * Requirements:
 * - prototype: http://www.prototypejs.org/
 *
 * Example (fake) request:
 *
 * {
 *     sdf: '/SDF/path/file.xml',  // URL absolute path of SDF
 *     uri: 'URI_value',           // the service URI (_uri)
 *     opts: ['p1=v1', 'p2=v2'],   // service opts as a list of key=value
 *     extra: {
 *         method: 'post',         // extra information for underlaying libs
 *     }
 * }
 *
 */



/* ---[ CONFIGURATION ]----------------------------------------------------- */


/*
 * 1 -  Debug configuration (default is OFF): if you want to enable debug,
 *      please override these definitions.
 */

/* Set to true if you want to enable debug */
var EF_ajax_debug = false;

/* Set to true if you want to enable debug for private functions */
var EF_ajax_debug_private = false;



/* ---[ PUBLIC FUNCTIONS ]-------------------------------------------------- */


/*
 * EF_new_request
 * --------------
 * Return a new request object, with prefilled default values.
 *
 * Arguments:
 * @uri: the uri for the request.
 */

function ef_new_request(uri) {
    var req = {
        sdf: ef_guess_sdf(),
        uri: uri,
        opts: [],
        extra: {
            method: 'post'
        }
    };

    return req;
}


/*
 * EF_req_extend
 * -------------
 * Return a new request object that extends the existing request /req/ with a
 * new field /name/ = /value/.
 *
 * Arguments:
 * @req: the request to extend
 * @name: the name of the new field
 * @value: the value of the new field
 */

function ef_req_extend(req, name, value) {

    req.extra[name] = value;

    return req;
}


/*
 * EF_update_element
 * -----------------
 * Update the element /id/ with the result of request /req/.
 *
 * Arguments:
 * @id: the element id to update
 * @req: the request object
 * @ef_custom [flag]: determinate if use a custom replace (true) or default
 *     Prototype library updater (false).
 */

function ef_update_element(id, req, ef_custom) {
    var url = req.sdf;

    if (ef_custom) {
        ef_ajax_request(req, ef_custom_replace, id);
    }
    else {
        var myAjax = new Ajax.Updater(
            id,
            url,
            ef_compose_pt_options(req)
        );
    }

}


/*
 * EF_req_extend_opts
 * ------------------
 * Extend the basic request /req/ using the options /opts/
 * This is useful for reuse multiple time the same request with different
 * options.
 *
 * Arguments:
 * @req: the base request object to extend
 * @opts: a list of options (suitable for request object) to use.
 */

function ef_req_extend_opts(req, opts) {
    var rl = req.opts.length;
    var i=0;

    for (i=0; i<opts.length; i++) {
        req.opts[rl+i] = opts[i];
    }

    if (EF_ajax_debug) {
        var debug_msg = '[EF_REQ_EXTEND_OPTS]';
        for (i=0; i<req.opts.length; i++) {
            debug_msg += 'opt[' + i + ']="' + req.opts[i] + '"\n';
        }
        window.alert(debug_msg);
    }

    return req;
}


/*
 * EF_run_js
 * ---------
 * Run remote JavaScript code returnet by request /req/
 *
 * Arguments:
 * @req: a request object to use
 */

function ef_run_js(req) {
    var debug_msg = '';

    if (EF_ajax_debug && EF_ajax_debug_private) {
        debug_msg = '[EF_RUN_JS]\n';
    }

    var url = req.sdf;
    req.extra.onComplete = ef_eval_resp_js;
    // req.extra.onSuccess = ef_eval_resp_js;
    var opts = ef_compose_pt_options(req);

    if (EF_ajax_debug && EF_ajax_debug_private) {
        debug_msg += 'url: ' + url + '\n';
        debug_msg += 'opts: ' + $H(opts).inspect() + '\n';
        window.alert(debug_msg);
    }

    var myAjax = new Ajax.Request(url, opts);
}


/*
 * EF_ajax_request
 * ---------------
 * Execute Ajax request /req/ and (optional) run /fhandler/ with option /args/
 * (optional) on completion.
 *
 * Arguments:
 * @req: the request object
 * @fhandler (optional): a function pointer to use
 * @args (optional): argument for the function pointer
 */

function ef_ajax_request(req, fhandler, args) {
    var url = req.sdf;

    if (fhandler != false) {
        req.extra.onComplete = function (resp) {fhandler(resp, args);};
    }

    var opts = ef_compose_pt_options(req);

    var myAjax = new Ajax.Request(url, opts);
}


/*
 * EF_serviceform_register_onchange
 * --------------------------------
 * Register /callback/ to form /form_id/ onchange events.
 *
 * Arguments:
 * @form_id: the if of the form
 * @callback: the callback function to register
 */

function ef_serviceform_register_onchange(form_id, callback) {

    var opts = ef_get_all_options(form_id);

    var len = opts.length;

    for (var i=0; i<len; i++) {
        var id = opts[i].id;
        Event.observe(id, 'change', callback, false);
    }
}


/*
 * EF_service_update
 * -----------------
 * Run asyncronously action /action_id/ of service /service_uri/ (must be
 * callable from your SDF) and eval returned JavaScript.
 *
 * Arguments:
 * @service_uri: service URI for the request
 * @action_id: the action to execute
 */

function ef_service_update(service_uri, action_id) {

    if (EF_ajax_debug) {
        var debug_msg = '';

        debug_msg += 'EF_SERVICE_UPDATE' +
            ' invoking action "' + action_id + '"' +
            ' of service "' + service_uri + '"';

        window.alert(debug_msg);
    }

    var req = ef_prepare_req_from_serviceform(service_uri, action_id);

    ef_run_js(req);

    return;
}


/*
 * EF_guess_sdf
 * ------------
 * Try to guess SDF.
 */

function ef_guess_sdf() {
    var sdf = window.location.pathname;
    return sdf;
}


/*
 * EF_serviceform_serialize
 * ------------------------
 * Form serialize
 *
 * Arguments:
 * @mode: (optional) mode for serialization; could be:
 *   - array (default): serialize in an array of name=value
 *   - string: serialize in a query string (excluding the trailing '?'
 */

function ef_serviceform_serialize(mode) {
    var f = $('serviceform');

    var t = null;
    var res = [];
    //var msg = '';
    var els = Form.getElements(f);

    //msg = '';
    for (var i=0; i<els.length; i++) {
        t = els[i].type;
        //msg += '' + i + ') ' + 'name=' + els[i].name + ', t=' + t + '\n';
        if (t == 'submit')
            continue;
        if (t == 'button')
            continue;
        res.push(els[i]);
    }

    //window.alert('Input = \n' + msg);
    //msg = '';
    //for (var i=0; i<res.length; i++) {
    //    msg += '' + i + ') name=' + res[i].name + ', t=' + res[i].type + ', el=' + res[i] + '\n';
    //}

    //window.alert('Res:\n' + msg);
    res = Form.serializeElements(res);
    //window.alert('Serialized:\n' + serialized);

   if (mode) {
       switch(mode) {

           /* Serialize as a query-string */
           case 'string':
               break;

           /* It's already an array */
           case 'array':
           case 'list':
               res = res.split('&');
               break;

       }

    }

    return res;
}



/* ---[ PRIVATE FUNCTIONS ]------------------------------------------------- */


/*
 * EF_compose_pt_parameters (PRIVATE)
 * ----------------------------------
 * Used by ef_compose_pt_options.
 *
 * Compose Prototype Ajax request.
 *
 * Arguments:
 * @req: the request object
 */

function ef_compose_pt_parameters(req) {
    var pars = '';
    pars =
        "_uri=" + req.uri +
        "&EF_MODE=ajax" +
        '';
        //"&EF_METHOD=xml" +
    var i=0;
    for (i=0; i<req.opts.length; i++) {
        pars += '&' + req.opts[i];
    }

    return pars;
}


/*
 * EF_compose_pt_options (PRIVATE)
 * -------------------------------
 * Used by ef_update_element, ef_run_js and ef_ajax_request.
 *
 * Compose Prototype Ajax request.
 *
 * Arguments:
 * @req: the request object
 */

function ef_compose_pt_options(req) {
    var res = {};
    var i = 0;

    if (req.extra) {
        //res = res.merge(req.extra);
        res = req.extra;
    }

    /*
    var iev = ['onComplete', 'onFailure', 'onSuccess', 'onException', 'evalScripts'];
    for (i=0; i<iev.length; i++) {
        if (req.extra[iev[i]]) {
            res[iev[i]] = req.extra[iev[i]];
        }
    }
    */

    res.parameters = ef_compose_pt_parameters(req);

    if (EF_ajax_debug && EF_ajax_debug_private) {
        window.alert('EF_COMPOSE_PT_OPTIONS: res = ' + $H(res).inspect());
    }

    return res;
}


/*
 * EF_custom_replace (PRIVATE)
 * ---------------------------
 * Used by ef_update_element.
 *
 * Arguments:
 * @resp: the response object
 * @tr: the element to replace
 */

function ef_custom_replace(resp, tr) {
    var debug_msg = '';

    if (EF_ajax_debug && EF_ajax_debug_private) {
        debug_msg = '[MY_CUSTOM_REPLACE] called';

        debug_msg += '\n- resp=' + resp;
        debug_msg += '\n- tr=' + tr;
    }

    var res = resp.responseText;
    // Hack: remove the HTML comment imposed by EF
    var rx_HtmlComments = /\<\!-- .* --\>/g;
    // Remove black lines
    var rx_BlankLines = /^$/g;
    var rx_ComEfJs = /\<script src="\/[^\/]+\/lib\/js\/com\.enginframe\.system\.js" type="text\/javascript">\<!-- .* --\>\<\/script\>/g;
    res = res.replace(rx_HtmlComments, '');
    res = res.replace(rx_BlankLines, '');
    res = res.replace(rx_ComEfJs, '');
    if (EF_ajax_debug && EF_ajax_debug_private) {
        debug_msg += '\n -response content (text) is: ' + res;
        window.alert(debug_msg);
    }

    tr_element = $(tr);
    if (tr_element) {
        tr_element.innerHTML = res;
    }

    return;
}


/*
 * EF_eval_resp_js (PRIVATE)
 * -------------------------
 * Used by ef_run_js
 *
 * Get, clean and evaluate javascript from Ajax response /resp/.
 *
 * Arguments:
 * @resp: the repsonse object
 */

function ef_eval_resp_js(resp) {
    var res = resp.responseText;

    if (EF_ajax_debug && EF_ajax_debug_private) {
        var debug_msg = '[EF_EVAL_RESP_JS]\n';
        debug_msg += 'Response to evaluate is:\n--\n' + res + '\n--\n';
        window.alert(debug_msg);
    }

    eval(res);
}


/*
 * EF_get_all_options (PRIVATE)
 * ----------------------------
 * Used by ef_serviceform_register_onchange.
 *
 * Get all options of the form /form_id/.
 *
 * Arguments:
 * @form_id: the form ID
 */

function ef_get_all_options(form_id) {
    var i;
    var opts = new Array();

    var f = $(form_id);
    var tags = ['input', 'textarea', 'select'];

    for (i=0; i < tags.length; i++) {
        var items = f.getElementsByTagName(tags[i]);
        for (var j=0; j < items.length; j++) {
            if ( items[j].type  != 'submit' && items[j].type != 'button' ) {
                opts.push(items[j]);
            }
        }
    }

    if (EF_ajax_debug && EF_ajax_debug_private) {
        var len = opts.length;
        var debug_msg = '[EF_GET_ALL_OPTIONS]\n';

        debug_msg += 'Form ID: ' + form_id + '\n';
        debug_msg += 'Form object is: ' + f + '\n';
        debug_msg += 'Items (len: ' + len + '):\n';

        for (i=0; i<len; i++) {
            debug_msg += '-  [' + i + ']';
            debug_msg += ' id="' + opts[i].id + '"';
            debug_msg += ' name="' + opts[i].nodeName.toLowerCase() + '"';
            if (opts[i].nodeName == 'INPUT') {
                debug_msg += ' type="' + opts[i].type + '"';
            }
            debug_msg += '\n';
        }

        debug_msg += 'Onchange Query:\n';
        for (i=0; i<len; i++) {
            debug_msg += '[' + i + ': ' + opts[i].id + '] ' + 'onchange="' + opts[i].onchange + '"\n';
        }

        window.alert(debug_msg);
    }

    return opts;
}


/*
 * EF_prepare_req_from_serviceform (PRIVATE)
 * -----------------------------------------
 * Used by ef_service_update
 *
 * Serialize serviceform and use it to prepare a requesto to service
 * /service_uri/ for action /action_id/.
 *
 * Arguments:
 * @service_uri: the service URI
 * @action_id: the action ID
 */

function ef_prepare_req_from_serviceform (service_uri, action_id) {
    var debug_msg = '';

    if (EF_ajax_debug && EF_ajax_debug_private) {
        debug_msg = '[EF_PREPARE_REQ_FROM_SERVICEFORM]\n';
    }

    opt = ef_serviceform_serialize('array');
    opt.push('' + action_id + '=Submit');
    opt.push('_actionid=' + action_id);

    var req = {
        sdf: ef_guess_sdf(),
        uri: service_uri,
        opts: opt,
        extra: {
            method: 'post'
        }
    };


    if (EF_ajax_debug && EF_ajax_debug_private) {
        debug_msg += 'sdf: ' + req.sdf + '\n' +
                     'uri: ' + req.uri + '\n' +
                     'opts: ' + req.opts + '\n' +
                     '';
        window.alert(debug_msg);
    }

    return req;
}

/* ------------------------------------------------------------------------- */

