/*
 # vim: ts=2 sw=2 et
 */

/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

var footerReady = 0;
var multi = 'false';
var isDefault = 'false';
var target = 'file';
var uri = '//com.enginframe.rfb/browse';
var selectcounter = 0;
var isSelected = new Array();     // (=1 if a file is selected)
var isModified = new Array();     // (=1 if a file selection is modified)
var modifiedFiles = new Array();  // (list all modified files)
var fspath;
var checkbox2file = new Array();  // (assign a checkbox to each file)


// fixPath() escapes strange charcters in the selected path

function fixPath(p) {
    p = escape(p);
    return p.replace(/\+/g, "%2B");
}

// selectAll() selects all files in current directory

function selectAll(n) {
    for(var i = 0; i < top.main.document.rfb_list.elements.length; i++) {
        var e = top.main.document.rfb_list.elements[i];
        selectFile(fspath + "/" + checkbox2file[e.name], n, e);
    }

    if(n == 0) {
        // forgets also selections in other directories
        top.isSelected = new Array();
        top.isModified = new Array();
        top.modifiedFiles = new Array();
        top.selectcounter = 0;
    }
}

// selectFile(path, n, checkbox) sets selection to n for the file specified as path
// and modifies the checkbox value accordingly

function selectFile(path, n, checkbox) {
    top.isSelected[path] = n;
    if(top.isModified[path] != 1) {
        top.isModified[path] = 1;
        top.modifiedFiles[top.selectcounter++] = path;
    }

    if(checkbox) {
        if(n == 0) {
            checkbox.checked = false;
        }
        else {
            checkbox.checked = true;
        }
    }
}

// toggleSelection(path) updates the selection value for the specified file.

function toggleSelection(path, checkbox) {
    if(top.isSelected[path] == 1) {
        selectFile(path, 0, checkbox);
    }
    else {
        selectFile(path, 1, checkbox);
    }
}

// updateFooter(dir, fil, checkbox) updates the contents of the footer
// and, if needed, update the appropriate checkbox

function updateFooter(dir, fil, checkbox) {
    if(footerReady) {
        var footer_form = top.footer.document.forms.rfb_footer;
        if(dir != '') {
            footer_form.newpath.value = dir;
        }

        if(top.multi == 'true' && fil != '') {
            toggleSelection(footer_form.newpath.value + "/" + fil, checkbox);
        }

        footer_form.selected.value = fil;
    }

    if(dir != '') {
        top.document.title = dir;
    }
}

// fillField(dir, fil) saves a selected path/file to the input field
// that was requested by the window originating the RFB request.

function fillField(dir, fil) {
    if(dir == '') {
        dir = top.footer.document.rfb_footer.newpath.value;
    }

    if(top.multi == 'true') {
        var outstring = "";
        for(var i = 0; i < top.selectcounter; i++) {
            if(modifiedFiles[i] != '' && isSelected[modifiedFiles[i]] == 1) {
                outstring = outstring + modifiedFiles[i] + "\n";
            }
        }
        top.targetField.value = outstring;
    }
    else {
        if(dir != '') {
            if (top.target == 'directory'){
                top.targetField.value = dir;
            }else{
                top.targetField.value = dir + '/' + fil;
            }
        }
    }

    if(dir != '') {
        if(isDefault == 'true') {
            SetCookie('browsePath_' + top.targetField.name, dir, null, "/");
        }
        SetCookie('browsePath_' + top.target, dir, null, "/");
    }
    top.close();
}

// autoFillField() uses the info contained in the footer to call
// fillField.

function autoFillField() {
    var footer_form = top.footer.document.rfb_footer;
    fillField(footer_form.newpath.value, footer_form.selected.value);
}

// openDir() requests the contents of a specific directory

function openDir(name) {
    updateFooter(name, "", "");
    browseTo();
}

// browseUp() requests the contents of the parent directory.

function browseUp() {
    openDir(top.footer.document.rfb_footer.newpath.value + "/..");
}

// browseTo() uses the info contained in the footer to browse to
// a new location into the 'main' frame

function browseTo() {
    if(top.uri === null || top.uri.length == 0) {
        top.main.location = top.document.location.pathname +
        "?_uri=//com.enginframe.rfb/browse" +
        "&_path="   + fixPath(top.footer.document.rfb_footer.newpath.value) +
        "&_multi="  + top.multi +
        "&_target=" + top.target +
        "&_plugin=" + top.plugin +
        "&_filter=" + top.filter +
        '';
    }else{
        top.main.location = top.document.location.pathname +
        "?_uri=" + top.uri +
        "&_path="   + fixPath(top.footer.document.rfb_footer.newpath.value) +
        "&_multi="  + top.multi +
        "&_target=" + top.target +
        "&_plugin=" + top.plugin +
        "&_filter=" + top.filter +
        '';
    }
}

function deleteParamSort(){
    var tmp=top.main.location+"";
    var url=top.main.location+"";
    var posX=tmp.search(/&_sort/);
    var posY=posX+15;
    if(posX!=-1){
        url=tmp.substring(0,posX);
        url+=tmp.substring(posY,tmp.length)+"";
    }
    return url;
}



function redirectTo(param){
    var newUrl=deleteParamSort()+'&'+param;
    top.main.location = newUrl;
}

// mainLoaded() is invoked when the footer is loaded, and
// redirects the main frame to the appropriate path

function mainLoaded() {
    for(var i = 0; i < top.main.document.rfb_list.elements.length; i++) {
        var e = top.main.document.rfb_list.elements[i];
        if(isSelected[fspath + "/" + checkbox2file[e.name]]) {
            selectFile(fspath + "/" + checkbox2file[e.name], 1, e);
        }
    }
}

// footerLoaded(newPath) is invoked when the footer is loaded, and
// redirects the main frame to the appropriate path

function footerLoaded(newPath, isMulti, whichTarget, defaultValue, whichPlugin, whichUri, whichFilter) {
    top.footerReady = 1;
    top.multi = isMulti;
    top.target = whichTarget;
    top.plugin = whichPlugin;
    if(whichUri != null && whichUri.length > 0){
        top.uri = whichUri;
    }

    if (whichFilter != null && whichFilter.length > 0){
        top.filter = whichFilter;
    } else {
        top.filter = '';
    }

    var oldPath = defaultValue;
    if(!oldPath) {
        oldPath = top.GetCookie("browsePath_" + top.targetField.name);
    }
    else {
        top.isDefault = 'true';
    }

    if(!oldPath) {
        oldPath = top.GetCookie("browsePath_" + top.target);
    }

    if(oldPath) {
        top.updateFooter(oldPath, '', '');
    }
    else {
        top.updateFooter(newPath, '', '');
    }

    var splitstring = '\n';
    if(top.targetField.value.indexOf('\r') != -1) {
        splitstring = '\r\n';
    }

    top.modifiedFiles = top.targetField.value.split(splitstring);
    top.selectcounter = top.modifiedFiles.length;

    for(var i = 0; i < top.selectcounter; i++) {
        if(top.modifiedFiles[i] != '') {
            top.isSelected[top.modifiedFiles[i]] = 1;
            top.isModified[top.modifiedFiles[i]] = 1;
        }
    }

    top.browseTo();
}

// Returns "true" if "e" is a return key hit.
// Does cross browser checking.

function isReturnKey(e) {
    if(!e) {
        // if the browser did not pass the event information to the
        // function, we will have to obtain it from the event register
        if(window.event) {
            // Internet Explorer
            e = window.event;
        }
        else {
            // total failure, we have no way of referencing the event
            return false;
        }
    }
    if(typeof(e.keyCode) == 'number') {
        // DOM
        e = e.keyCode;
    }
    else if(typeof(e.which) == 'number') {
        // NS 4 compatible
        e = e.which;
    }
    else if(typeof(e.charCode) == 'number') {
        // also NS 6+, Mozilla 0.9+
        e = e.charCode;
    }
    else {
        // total failure, we have no way of obtaining the key code
        return false;
    }
    return e == 13 || e == 3;
}

// Returns "true" if "e" is handled as a return key
// hit and thus "top.browse()" function is called.

function handleKey(e) {
    if(isReturnKey(e)) {
        top.browseTo();
        return false;
    }
    else {
        return true;
    }
}


// ---------------------------------------------------------------
// Cookie Functions - Second Helping  (21-Jan-96)
// Written by:  Bill Dortch, hIdaho Design <BDORTCH@NETW.COM>
// The following functions are released to the public domain.

// The Second Helping version of the cookie functions dispenses with
// my encode and decode functions, in favor of JavaScript's new built-in
// escape and unescape functions, which do more complete encoding, and
// which are probably much faster.

// The new version also extends the SetCookie function, though in
// a backward-compatible manner, so if you used the First Helping of
// cookie functions as they were written, you will not need to change any
// code, unless you want to take advantage of the new capabilities.

// The following changes were made to SetCookie:

// 1.  The expires parameter is now optional - that is, you can omit
//     it instead of passing it null to expire the cookie at the end
//     of the current session.

// 2.  An optional path parameter has been added.

// 3.  An optional domain parameter has been added.

// 4.  An optional secure parameter has been added.

// For information on the significance of these parameters, and
// and on cookies in general, please refer to the official cookie
// spec, at:

// http://www.netscape.com/newsref/std/cookie_spec.html


// "Internal" function to return the decoded value of a cookie

function getCookieVal (offset) {
    var endstr = document.cookie.indexOf (";", offset);
    if(endstr == -1) {
        endstr = document.cookie.length;
    }
    return unescape(document.cookie.substring(offset, endstr));
}

// Function to return the value of the cookie specified by "name".
//   name - String object containing the cookie name.
//   returns - String object containing the cookie value, or null if
//      the cookie does not exist.

function GetCookie (name) {
    var arg = name + "=";
    var alen = arg.length;
    var clen = document.cookie.length;
    var i = 0;
    while(i < clen) {
        var j = i + alen;
        if(document.cookie.substring(i, j) == arg) {
            return getCookieVal (j);
        }
        i = document.cookie.indexOf(" ", i) + 1;
        if(i == 0) {
            break;
        }
    }
    return null;
}


// Function to create or update a cookie.
//   name - String object object containing the cookie name.
//   value - String object containing the cookie value.  May contain
//     any valid string characters.
//   [expires] - Date object containing the expiration data of the cookie.  If
//     omitted or null, expires the cookie at the end of the current session.
//   [path] - String object indicating the path for which the cookie is valid.
//     If omitted or null, uses the path of the calling document.
//   [domain] - String object indicating the domain for which the cookie is
//     valid.  If omitted or null, uses the domain of the calling document.
//   [secure] - Boolean (true/false) value indicating whether cookie transmission
//     requires a secure channel (HTTPS).

// The first two parameters are required.  The others, if supplied, must
// be passed in the order listed above.  To omit an unused optional field,
// use null as a place holder.  For example, to call SetCookie using name,
// value and path, you would code:

// SetCookie ("myCookieName", "myCookieValue", null, "/");

// Note that trailing omitted parameters do not require a placeholder.

// To set a secure cookie for path "/myPath", that expires after the
// current session, you might code:

//     SetCookie (myCookieVar, cookieValueVar, null, "/myPath", null, true);

function SetCookie (name, value) {
    var argv = arguments;
    var argc = arguments.length;
    var expires = (argc > 2) ? argv[2] : null;
    var path = (argc > 3) ? argv[3] : null;
    var domain = (argc > 4) ? argv[4] : null;
    var secure = (argc > 5) ? argv[5] : false;
    document.cookie = name + "=" + escape (value) +
    ((expires == null) ? "" : ("; expires=" + expires.toGMTString())) +
    ((path == null) ? "" : ("; path=" + path)) +
    ((domain == null) ? "" : ("; domain=" + domain)) +
    ((secure == true) ? "; secure" : "");
}

// Function to delete a cookie. (Sets expiration date to current date/time)
//   name - String object containing the cookie name

function DeleteCookie (name) {
    var exp = new Date();
    exp.setTime (exp.getTime() - 1);  // This cookie is history
    var cval = GetCookie (name);
    document.cookie = name + "=" + cval + "; expires=" + exp.toGMTString();
}
