/*
 # vim: ts=2 sw=2 et
 */

////////////////////////////////////////////////////////////////////////////////
// Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
// Copyright 1999-2023 by Nice, srl., All rights reserved.
//
// This software includes confidential and proprietary information
// of NI SP Software GmbH ("Confidential Information").
// You shall not disclose such Confidential Information
// and shall use it only in accordance with the terms of
// the license agreement you entered into with NI SP Software.
////////////////////////////////////////////////////////////////////////////////


// This function search for the very first field in all the forms of a page of type
// text or textarea or file or password which is not already filled and
// it is not disabled and set the focus to it.
function efSetFocus() {
    if(document.forms) {
        for(var n = 0; n <document.forms.length; n++) {
            var _form=document.forms[n];
            for(var i = 0; i < _form.length; i++) {
                var element=_form.elements[i];
                var type=element.type;
                var className=element.className;
                if(((type=="text") || (type=="textarea") || (type=="file") || (type=="password")) &&
                        element.value=="" && !element.disabled && className!="hasDatepicker" ) {
                    try {
                        element.focus();
                    } catch(errorObject) {
                        // Throw away the error
                    }
                    break;
                }
            }
        }
    }
}

function efOptionGroups() {
    if (typeof(jQuery) !== "function") {
        // JQuery is not loaded
        return;
    }

    jQuery("fieldset.ef_option_group_collapsible").each(function() {
        var fieldset, legend, content, icon;

        fieldset = jQuery(this);
        legend = fieldset.children("legend");
        content = fieldset.children("div.ef_option_group_content");
        icon = legend.children("span.ui-icon");
        icon.addClass("ef_option_group_legend_icon");

        legend.hover(function() {
            legend.addClass("ui-state-hover");
        }, function() {
            legend.removeClass("ui-state-hover");
        });

        legend.click(function() {
            content.toggle();
            fieldset.toggleClass("ef_option_group_collapsed");
            icon.toggleClass("ui-icon-triangle-1-s");
            icon.toggleClass("ui-icon-triangle-1-e");
        });
    });
}

function efPreventDoubleSubmission() {
    if (typeof(jQuery) !== "function") {
        // JQuery is not loaded
        return;
    }

    jQuery("form#serviceform").on('submit',function(e) {
        var form, lastSubmitTime, now;

        form = $(this);

        lastSubmitTime = form.data('EFLastSubmitTime');
        now = jQuery.now();

        if (lastSubmitTime === undefined || (now - lastSubmitTime > 3000 /* ms */)) {
            // SetEFLastSubmitTime  so that the next submit can be ignored if performed before next 3000 ms
            form.data('EFLastSubmitTime', now);
        } else {
            // Previously submitted - don't submit again
            e.preventDefault();
        }
    });
}

// This function is loaded by every page of EnginFrame
function efonload() {
    efSetFocus();
    efOptionGroups();
    efPreventDoubleSubmission();
}

// If you want to use on a given page multiple scripts that execute
// when the page has finished loading, the last script to register
// itself with window.onload will be the only script to execute.
// What's really needed is a way to attach our function to the onload
// handler of the window object without overwriting what's already there.
// Unfortunately, Internet Explorer and other browsers differ on how
// this kind of dynamic event attachment should be handled.
// We need a function that handles these differences. Here it is.
function addEvent(obj, evType, fn) {
    if(obj.addEventListener) {
        obj.addEventListener(evType, fn, true);
        return true;
    }
    else if(obj.attachEvent) {
        return obj.attachEvent("on" + evType, fn);
    }
    else {
        return false;
    }
}

// Here we set the "onload"
// It corresponds to write <body onload="efonload()"> inside the HTML but
// in this way it is more elegant (and we don't need to modify every
// single xsl/html file! Read the previous comment for further explanations.
// Be careful about the missing () after efonload: we don't want to
// set window.onload to the return value of function efonload(),
// but to the function itself!
addEvent(window, 'load', efonload);


// Save the current action ID that's being submitted
// This value is used in 'efApplets.fileUploadCallback' to submit
// the form once the Applet has successfully finished.

// Input: 'target' is stored in global 'targetActionId'

var targetActionId;

function setTargetActionId(target) {
    targetActionId = target.id;
}


var EF_PARAM_ACTIONID="_actionid";

// Adds some extra information to elem's form parent
// This is needed to assure that the server can read
// the action name without having to peek at post body
function rewriteFormAction(elem) {
    var _action = "" + elem.form.action;
    var _actionidParam = EF_PARAM_ACTIONID + "=" + escape(elem.name);
    // window.alert("_action="+_action + "\n_actionidParam=" + _actionidParam);
    if(_action.indexOf("&" + EF_PARAM_ACTIONID + "=") >= 0) {
        var regexp = new RegExp(EF_PARAM_ACTIONID + "=[^&]*");
        _action = _action.replace(regexp, _actionidParam);
        // window.alert("_action.replaced="+_action);
    }
    else {
        _action += "&" + _actionidParam;
        //  window.alert("_action.added="+_action);
    }

    elem.form.action = _action;
    return true;
}

function submitResetChange(form) {
    return form.submit();
}

function ClearSelection(form) {
    for(var i = 0; i < form.elements.length; i++) {
        if(form.elements[i].type == 'checkbox') {
            form.elements[i].checked = false;
        }
    }
}

function ToggleSelection(form) {
    for(var i = 0; i < form.elements.length; i++) {
        if(form.elements[i].type == 'checkbox') {
            form.elements[i].checked = !(form.elements[i].checked);
        }
    }
}

function toggleListControls(toggle1, toggle2) {
    if(document.getElementById(toggle1).className == "box-closed") {
        document.getElementById(toggle1).className = "box-opened";
        if(document.getElementById(toggle2)) {
            document.getElementById(toggle2).style.display = "none";
        }
    }
    else {
        document.getElementById(toggle1).className = "box-closed";
        if(document.getElementById(toggle2)) {
            document.getElementById(toggle2).style.display = "block";
        }
    }
}

function countSelectedElements(form) {
    var counter = 0;
    for(var i = 0; i < form.elements.length; i++) {
        if(form.elements[i].type == 'checkbox') {
            if(form.elements[i].checked) {
                counter++;
            }
        }
    }
    return counter;
}

function submitMultipleDelete(form) {
    var counter = countSelectedElements(form);
    if (counter == 0) {
        alert('Please select one or more spoolers');
        return false;
    }

    if (confirm("Do you really want to delete the selected spoolers?")) {
        return form.submit();
    }
    else {
        return false;
    }
}

function submitActions(form, root_context) {
    submitActionsNew(form, form._action, root_context);
}

function submitActionsNew(form, selectElem, root_context) {
    var index = selectElem.selectedIndex;
    var value = selectElem.options[index].value;

    if (index == 0) {
        selectElem.selectedIndex = 0;
        return false;
    }

    if (value == '' || value == 'nothing') {
        selectElem.selectedIndex = 0;
        return false;
    }

    var counter = countSelectedElements(form);
    if (counter == 0) {
        alert('Please select one or more files');
        selectElem.selectedIndex = 0;
        return false;
    }

    // Special behaviour for value: 'Download' (old value), 'Download@ef'
    // (download for plugin EF), 'Download@rspooler' (download for plugin
    // rspooler): start MFD.
    if (value == 'Download' || value == 'Download@ef' || value == 'Download@rspooler' ) {
        return doMultipleDownload(form, selectElem, root_context);
    }

    var _myOption = selectElem.options[index];
    if (_myOption.getAttribute) {
        label = _myOption.getAttribute('custom_confirm');
    }
    else {
        label = _myOption.custom_confirm;
    }

    if (label == '') {
        label = "Are you sure?";
    }

    if (confirm(label)) {
        return form.submit();
    }
    else {
        selectElem.selectedIndex = 0;
        return false;
    }
}

function doMultipleDownload(form, selectElem, root_context) {
    var spoolerURI = form._spooler.value;
    var plugin     = form._plugin.value;
    var subdir     = form._sub.value;
    if (subdir && subdir != '') {
        subdir += "/";
    }

    var fileList = "";
    var fileSizes = "";
    for(var i = 0; i < form.elements.length; i++) {
        if(form.elements[i].type == 'checkbox') {
            if(form.elements[i].checked) {
                var val = form.elements[i].value;
                fileList += subdir + val + ",";
                fileSizes += findFileSize(form, val) + ",";
            }
        }
    }
    efApplets.openMFDWindow(root_context, spoolerURI, plugin, fileList, fileSizes);
    ClearSelection(form);
    selectElem.selectedIndex = 0;
    return false;
}

function findFileSize(form, filename) {
    var fileSize = 0;
    for(var i = 0; i < form.elements.length; i++) {
        if(form.elements[i].type == 'hidden') {
            if(form.elements[i].name == filename) {
                fileSize = form.elements[i].value;
                break;
            }
        }
    }
    return fileSize;
}

function powershow(name, type, status, cpu, memory, swap, url, type) {
    output = "<br><table>" +
        "<tr><th>Host: </th><td><a href=" + url + "?_uri=//com.enginframe." + encodeURIComponent(type) + "/host.info&amp;_host=" + encodeURIComponent(name) + ">" + efEncodeHtml(name) + "</a></td></tr>" +
        "<tr><th>Type: </th><td><b>" + efEncodeHtml(type) + "</b></td></tr>" +
        "<tr><th>Status: </th><td><b>" + efEncodeHtml(status) + "</b></td></tr>" +
        "<tr><th>Cpu: </th><td><b>" + efEncodeHtml(cpu) + "%</b></td></tr>" +
        "<tr><th>Memory:&nbsp; </th><td><b>" + efEncodeHtml(memory) + "</b></td></tr>" +
        "<tr><th>Swap: </th><td><b>" + efEncodeHtml(swap) + "</b></td></tr>" +
    "</table>";

    if((document.layers) && (parseFloat(navigator.appVersion) < 5)) {
        var l = document.layers.TextHere.document;
        l.open();
        l.write(output);
        l.close();
    }

    if(document.getElementById || document.all) {
        var mydiv = document.getElementById ? document.getElementById("TextHere") : document.all["TextHere"];
        if (mydiv && typeof mydiv.innerHTML != "undefined") {
            mydiv.innerHTML = output;
        }
    }
}

var rfb_window = 0;
function openRFB(theContext, theField, thePath, multi, target, defaultValue, useSessionID, plugin, uri, filter) {
    // Change the size of the RFB window here
    var w = 500;      // Width of the window (in pixel)
    var h = 400;      // Height of the window (in pixel)
    var f = 60;       // Height of the navigation footer (in pixel)

    if(is_unix) {
        f += 24;
    }

    if(rfb_window && !rfb_window.closed) {
        rfb_window.close();
    }

    var rfbPath = '/' + theContext;
    var rfb_path_qs = '';

    rfb_path_qs += '?_footer_height=' + f +
        '&_path='   + thePath +
        '&_target=' + target  +
        '&_plugin=' + plugin  +
        '&_multi='  + multi   +
        '&uri='     + uri     +
        '&_filter=' + escape(filter) +
        '';

    if(useSessionID == 'true') {
        rfb_path_qs += '&rfb.xslt=true';
    }
    else {
        rfbPath += '/lib/xml/com.enginframe.rfb.xml';
    }

    rfbPath += rfb_path_qs;

    rfb_window = window.open(rfbPath, 'rfb', 'resizable=yes,width=' + w + ',height=' + h);

    rfb_window.targetField = theField;
    rfb_window.defaultValue = defaultValue;
    rfb_window.focus();
}

// New RFB hooks
function onRfbOpen(id) {
    if (typeof efApplets !== "undefined" && typeof efApplets.hideAll != 'undefined') {
        efApplets.hideAll();
    }
}

function onRfbOk(id) {
    if (typeof efApplets !== "undefined" && typeof efApplets.showAll != 'undefined') {
        efApplets.showAll();
    }
}

function onRfbCancel(id) {
    if (typeof efApplets !== "undefined" && typeof efApplets.showAll != 'undefined') {
        efApplets.showAll();
    }
}

// HTML escape

var htmlEntityMap = {
    "&": "&amp;",
    "<": "&lt;",
    ">": "&gt;",
    '"': "&quot;",
    "'": "&#39;",
    "/": "&#47;"
};

function efEncodeHtml(string) {
    return String(string || '').replace(/[&<>"'\/]/g, function (s) {
        return htmlEntityMap[s];
    });
}



var stderr_window = 0;
function openSTDERR(rootContext, title, errorTitle, message) {
    // These options control window behaviour
    var myOptions = "";
    myOptions = myOptions +       "toolbar=no";
    myOptions = myOptions + "," + "location=no";
    myOptions = myOptions + "," + "directories=no";
    myOptions = myOptions + "," + "status=no";
    myOptions = myOptions + "," + "menubar=no";
    myOptions = myOptions + "," + "scrollbars=yes";
    myOptions = myOptions + "," + "resizable=yes";
    myOptions = myOptions + "," + "copyhistory=no";
    myOptions = myOptions + "," + "width=500";
    myOptions = myOptions + "," + "height=200";

    if(stderr_window && !stderr_window.closed) {
        stderr_window.close();
    }

    stderr_window = window.open('', 'efstderr', myOptions);
    stderr_window.document.writeln('<html>');
    stderr_window.document.writeln('  <head>');
    stderr_window.document.writeln('    <link type="text/css" rel="StyleSheet" href="/' + rootContext + '/lib/css/com.enginframe.style.css" />');
    stderr_window.document.writeln('    <title>' + title + ' (by EnginFrame)</title>');
    stderr_window.document.writeln('  </head>');
    stderr_window.document.writeln('  <body>');
    stderr_window.document.writeln('    <h3 class="large-user-error">' + efEncodeHtml(errorTitle) + '</h3>');
    stderr_window.document.writeln('    <i class="small-user-error">This is the error message:</i>');
    stderr_window.document.writeln('    <pre class="small-user-error">' + message + '</pre>');
    stderr_window.document.writeln('  </body>');
    stderr_window.document.writeln('</html>');
    stderr_window.document.close();
    stderr_window.focus();
}

function findObj(n, d) {
    var p,i,x;  if(!d) d=document;
    if (d.getElementById) return d.getElementById(n);
    if((p=n.indexOf("?"))>0&&parent.frames.length) {
        d=parent.frames[n.substring(p+1)].document; n=n.substring(0,p);}
    if(!(x=d[n])&&d.all) x=d.all[n]; for (i=0;!x&&i<d.forms.length;i++) x=d.forms[i][n];
    for(i=0;!x&&d.layers&&i<d.layers.length;i++) x=findObj(n,d.layers[i].document); return x;
}

function preloadImages() {
    var d=document;
    if (d.images){
        if (!d.p) d.p=new Array();
        var i,j=d.p.length,a=preloadImages.arguments;
        for (i=0; i<a.length; i++)
            if (a[i].indexOf("#")!=0){
                d.p[j] = new Image();
                d.p[j++].src=a[i];
            }
    }
}

// Open 'panel' and fill it with the details of the
// file located at 'error_number'. The contents are
// fetched as XHTMLusing AJAX on a "rest" service.
function showErrorFileContents(panel, error_number, root_context) {
    // This function is called only when jquery is enabled in EF so it's safe to use the library here
    var pageToLoad = "/" + root_context + "/lib/xml/com.enginframe.system.xml?_uri=//com.enginframe.system/read_error_file&errorNumber=" + error_number;
    document.getElementById(panel).innerHTML = '<div id="file_box_contents"></div>';
    var locator = "#" + panel + " #file_box_contents";
    jQuery(locator).load(pageToLoad);
}

// convert all characters to lowercase to simplify testing
var agt = navigator.userAgent.toLowerCase();

var is_sun    = (agt.indexOf("sunos")!=-1);
var is_irix   = (agt.indexOf("irix") !=-1); // SGI
var is_hpux   = (agt.indexOf("hp-ux")!=-1);
var is_aix    = (agt.indexOf("aix") !=-1);  // IBM
var is_linux  = (agt.indexOf("inux")!=-1);
var is_sco    = (agt.indexOf("sco")!=-1) || (agt.indexOf("unix_sv")!=-1);
var is_mpras  = (agt.indexOf("ncr")!=-1);
var is_reliant= (agt.indexOf("reliantunix")!=-1);
var is_dec    = ((agt.indexOf("dec")!=-1) || (agt.indexOf("osf1")!=-1) ||
        (agt.indexOf("dec_alpha")!=-1) || (agt.indexOf("alphaserver")!=-1) ||
        (agt.indexOf("ultrix")!=-1) || (agt.indexOf("alphastation")!=-1));
var is_sinix  = (agt.indexOf("sinix")!=-1);
var is_freebsd= (agt.indexOf("freebsd")!=-1);
var is_bsd    = (agt.indexOf("bsd")!=-1);
var is_unix   = ((agt.indexOf("x11")!=-1) || is_sun || is_irix || is_hpux ||
        is_sco ||agt.indexOf("unix_system_v")!=-1 || is_mpras || is_reliant ||
        is_dec || is_sinix || is_aix || is_linux || is_bsd || is_freebsd);
