<?xml version="1.0"?>

<xsl:stylesheet
  version="1.0"
  xmlns="http://www.w3.org/1999/xhtml"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:exsl="http://exslt.org/common"
  extension-element-prefixes="exsl"
  exclude-result-prefixes="ef exsl"
  >

  <!--
  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
  -->


  <!--
  If left empty, use old-style serviceform container.
  -->
  <xsl:variable name="ef.serviceform.container"></xsl:variable>


  <!--
  How to render the RFB
  Set to 'classic' to use the old style RFB
  Set to the name of the UI to let the UI plugin take care of the rendering
  -->
  <xsl:variable name="ef.serviceform.option.rfb.renderer">hydrogen</xsl:variable>

  <!--
  The number of items the RFB hydrogen widget requests to the server on each request
  -->
  <xsl:variable name="hy.rfb.page.size">150</xsl:variable>

  <!--
  Set to 'debug' to use debug versions of enginframe javascript files
  -->
  <xsl:variable name="ef.js.debug"></xsl:variable>

  <!--
   Toggle inclusion of jquery javascript library and related plugins
  -->
  <xsl:variable name="ef.jquery.enabled">1</xsl:variable>
  <xsl:variable name="ef.jquery.ui.enabled">1</xsl:variable>

  <xsl:variable name="ef.jquery.ui.theme" select="concat('/', $_root_context, '/third-party/themes/gray/jquery-ui.css', '?', $_ef_cache_timestamp)"/>

  <!--
    Whether to enable the serviceprofile feature by default on all services
  -->
  <xsl:variable name="ef.serviceprofile.enabled">false</xsl:variable>

  <!--
   Which plugin takes care of rendering the profile selector
  -->
  <xsl:variable name="ef.serviceprofile.renderer">hydrogen</xsl:variable>

  <!--
  If left empty, use old-style navigation.
  -->
  <xsl:variable name="ef.navigation"></xsl:variable>

  <!-- The ID of the root folder used by the navigation -->
  <xsl:variable name="ef.navigation.root">root</xsl:variable>

  <!--
  Configuration for navigation.treeview
  =====================================
  -->

  <!-- ID of the cookie used for storing selections -->
  <xsl:variable name="ef.navigation.treeview.cookie.id">ef.navigation.list.selection</xsl:variable>
  <!-- Start treeview with all folder collapsed (if no cookie available) -->
  <xsl:variable name="ef.navigation.treeview.collapsed">true</xsl:variable>
  <!-- Allow only one folder per level opened at the same time -->
  <xsl:variable name="ef.navigation.treeview.unique">false</xsl:variable>

  <!--
  EF Applets configuration variables
  =====================================
  -->
  <!-- Enable FTP protocol -->
  <xsl:variable name="ef.applets.upload.ftp">false</xsl:variable>
  <!-- Enable FileCatalyst protocol -->
  <xsl:variable name="ef.applets.upload.fc">false</xsl:variable>


  <!--
  Old style variables
  -->


  <!-- File actions settings -->
  <xsl:variable name="show_file_timestamp">1</xsl:variable>
  <xsl:variable name="file_actions">0</xsl:variable>

  <xsl:variable name="upload_file">0</xsl:variable>
  <xsl:variable name="uplaod_file_default_width">40</xsl:variable>

  <!-- Streaming download settings -->
  <xsl:variable name="streaming_download">0</xsl:variable>
  <xsl:variable name="streaming_download_offset">0</xsl:variable>
  <xsl:variable name="streaming_download_keepalive">true</xsl:variable>
  <xsl:variable name="scroll_at_start">0</xsl:variable>

  <!-- Rendering settings -->
  <xsl:variable name="dtree_enabled">0</xsl:variable>
  <xsl:variable name="name_length">30</xsl:variable>


  <!-- Gloabl widget size settings; override in your XSL file. -->
  <xsl:variable name="input_default_width">15</xsl:variable>
  <xsl:variable name="textarea_default_width">40</xsl:variable>
  <xsl:variable name="textarea_default_height">8</xsl:variable>
  <xsl:variable name="rfb_default_width">15</xsl:variable>
  <xsl:variable name="rfb_multi_default_width">30</xsl:variable>
  <xsl:variable name="rfb_multi_default_height">5</xsl:variable>


  <xsl:variable name="EF_CHARSET"/>
  <xsl:variable name="navigation"/>
  <xsl:variable name="null" select="concat('/', $_root_context, '/images/shim.gif')"/>
  <xsl:variable name="img" select="concat('/', $_root_context, '/images')"/>
  <xsl:variable name="agent_name">
    <xsl:variable name="_name" select="ef:agent/ef:name" />
    <xsl:choose>
      <xsl:when test="$_name and $_name!=''">
        <xsl:value-of select="$_name" />
      </xsl:when>
      <xsl:otherwise>EnginFrame</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="agent" select="//ef:agent/@id"/>
  <xsl:variable name="url" select="concat($agent, '.xml')"/>


  <!-- AJAX support -->

  <!-- Include javascript libraries for AJAX (used in head_rendering template) -->
  <xsl:variable name="ef_ajax_enabled">0</xsl:variable>

  <!-- Include Prototype javascript library (used by head_rendering template) -->
  <xsl:variable name="ef_lib_prototype_enabled">0</xsl:variable>

  <!-- Prefix for ID (help avoiding name clashing) -->
  <xsl:variable name="service_info_prefix">serviceinfo_</xsl:variable>
  <xsl:variable name="service_opt_prefix">serviceopt_</xsl:variable>
  <xsl:variable name="service_action_prefix">serviceaction_</xsl:variable>
  <xsl:variable name="reuse_spooler_id"><xsl:value-of select="concat($service_opt_prefix, 'EF_REUSE_SPOOLER')"/></xsl:variable>

</xsl:stylesheet>

