<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
                xmlns:grid="http://www.enginframe.com/2000/GRID"
                xmlns:encode="org.owasp.encoder.Encode"
                exclude-result-prefixes="ef grid encode">

<!--
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
-->

  <!-- Job list options -->
  <xsl:variable name="show_owner">0</xsl:variable>
  <xsl:variable name="show_queue">0</xsl:variable>
  <xsl:variable name="show_host">1</xsl:variable>
  <xsl:variable name="show_command">0</xsl:variable>
  <xsl:variable name="show_project">1</xsl:variable>
  <xsl:variable name="job_statusbar_width">108</xsl:variable>
  <xsl:variable name="job_statusbar_height">16</xsl:variable>
  <xsl:variable name="job_multicpu_details">1</xsl:variable>
  <xsl:variable name="show_full_job_details">1</xsl:variable>
  <xsl:variable name="job_stdout">1</xsl:variable>
  <xsl:variable name="name_length">32</xsl:variable>
  <xsl:variable name="job_name_max_length">50</xsl:variable>

  <!-- Host list options -->
  <xsl:variable name="hostcellspace">80</xsl:variable>
  <xsl:variable name="cols_number">8</xsl:variable>
  <xsl:variable name="cols_number_minimal">16</xsl:variable>
  <xsl:variable name="cellspace_minimal"><xsl:value-of select="number($hostcellspace div 3)"/></xsl:variable>
  <xsl:variable name="cellspace_minimal_vert">20</xsl:variable>
  <xsl:variable name="nhost_for_compact_view">16</xsl:variable>
  <xsl:variable name="nhost_for_minimal_view">64</xsl:variable>
  <xsl:variable name="show_base_batch_status">0</xsl:variable>

  <!-- Host details options -->
  <xsl:variable name="max_resource_cols">11</xsl:variable>
  <xsl:variable name="min_resource_col_width">10</xsl:variable>
  <xsl:variable name="host_details_bar_height">10</xsl:variable>
  <xsl:variable name="host_details_bar_width">100</xsl:variable>


  <xsl:param name="_jobid"/>
  <xsl:param name="uri"/>

<!--
 * GridML compliant templates
-->

  <!--
  Define the overall appearence of
  the different output of the
  components of the Grid objects
   -->
  <xsl:template match="grid:job-list" mode="link">
    <a href="#{encode:forUriComponent(@showref)}"><img src="/{$_root_context}/images/go-bottom.png" border="0" alt="Show job information" title="Show job information" /></a>
  </xsl:template>


  <xsl:template match="grid:job-list">
    <xsl:variable name="job_sortby"><xsl:value-of select="//ef:profile/ef:session-list/ef:session[@id='job_sortby']"/></xsl:variable>
    <xsl:variable name="sort_order">
      <xsl:choose>
        <xsl:when test="//ef:profile/ef:session-list/ef:session[@id='sort_order']"><xsl:value-of select="//ef:profile/ef:session-list/ef:session[@id='sort_order']"/></xsl:when>
        <xsl:otherwise>ascending</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:choose>
      <xsl:when test="count(grid:job) > 0">
        <script type="text/javascript">
          <xsl:comment>
          <![CDATA[function submitForm(form, id, action) {
                    if(action == "") return false;
                    if(action == null) action="modify";
                    if(confirm("Do you really want to " + action + " job " + id + "?"))
                      return form.submit();

                    return false;
                  }
          ]]>
          // </xsl:comment>
        </script>

        <xsl:if test="count(grid:job) = 1">
          <xsl:apply-templates select="grid:message"/>
        </xsl:if>

        <xsl:variable name="mySeparator">
          <xsl:text>?</xsl:text>
        </xsl:variable>

        <xsl:variable name="sort_base_href">
          <xsl:value-of select="concat($agent, '.xml?_uri=', $_uri)" />
        </xsl:variable>

        <!-- Column header name (with associated HELP informations) -->
        <xsl:variable name="help_ID">
          <xsl:call-template name="ef_help">
            <xsl:with-param name="help-href">job-list.html#def_JobID</xsl:with-param>
          </xsl:call-template>
        </xsl:variable>

        <xsl:variable name="help_Owner">
          <xsl:call-template name="ef_help">
            <xsl:with-param name="help-href">job-list.html#def_JobOwner</xsl:with-param>
          </xsl:call-template>
        </xsl:variable>

        <xsl:variable name="help_Project">
          <xsl:call-template name="ef_help">
            <xsl:with-param name="help-href">job-list.html#def_JobProject</xsl:with-param>
          </xsl:call-template>
        </xsl:variable>

        <xsl:variable name="help_Queue">
          <xsl:call-template name="ef_help">
            <xsl:with-param name="help-href">job-list.html#def_JobQueue</xsl:with-param>
          </xsl:call-template>
        </xsl:variable>

        <xsl:variable name="help_Time">
          <xsl:call-template name="ef_help">
            <xsl:with-param name="help-href">job-list.html#def_JobTime</xsl:with-param>
          </xsl:call-template>
        </xsl:variable>

        <xsl:variable name="help_Status">
          <xsl:call-template name="ef_help">
            <xsl:with-param name="help-href">job-list.html#def_JobStatus</xsl:with-param>
          </xsl:call-template>
        </xsl:variable>

        <xsl:variable name="help_Host">
          <xsl:call-template name="ef_help">
            <xsl:with-param name="help-href">job-list.html#def_ExecutionHost</xsl:with-param>
          </xsl:call-template>
        </xsl:variable>

        <xsl:variable name="help_Name">
          <xsl:call-template name="ef_help">
            <xsl:with-param name="help-href">job-list.html#def_JobName</xsl:with-param>
          </xsl:call-template>
        </xsl:variable>

        <table class="ef_job_list" cellpadding="1" border="0" width="100%" cellspacing="1">
          <tr>
            <td>
              <a name="{@showref}" />
            </td>
          </tr>
          <tr>
            <xsl:choose>
              <xsl:when test="count(grid:job) = 1">
                <th>
                  ID
                  <xsl:copy-of select="$help_ID"/>
                </th>
                <xsl:if test="$show_owner = 1">
                  <th>
                    Owner
                    <xsl:copy-of select="$help_Owner"/>
                  </th>
                </xsl:if>
                <xsl:if test="$show_project = 1">
                  <th>
                    Project
                    <xsl:copy-of select="$help_Project"/>
                  </th>
                </xsl:if>
                <xsl:if test="$show_queue = 1">
                  <th>
                    Queue
                    <xsl:copy-of select="$help_Queue"/>
                  </th>
                </xsl:if>
                <th>
                  Time
                  <xsl:copy-of select="$help_Time"/>
                </th>
                <th>
                  Status
                  <xsl:copy-of select="$help_Status"/>
                </th>
                <xsl:if test="$show_host = 1">
                  <th>
                    Host
                    <xsl:copy-of select="$help_Host"/>
                  </th>
                </xsl:if>
                <th>
                  Name
                  <xsl:copy-of select="$help_Name"/>
                </th>
              </xsl:when>
              <xsl:otherwise>
                <th>
                  <a title="Sort by ID" href="{$sort_base_href}&amp;_sortby=id">ID</a>
                  <xsl:copy-of select="$help_ID"/>
                </th>
                <xsl:if test="$show_owner = 1">
                  <th>
                    <a title="Sort by Owner" href="{$sort_base_href}&amp;_sortby=owner">Owner</a>
                    <xsl:copy-of select="$help_Owner"/>
                  </th>
                </xsl:if>
                <xsl:if test="$show_project = 1">
                  <th>
                    <a title="Sort by Project" href="{$sort_base_href}&amp;_sortby=account">Project</a>
                    <xsl:copy-of select="$help_Project"/>
                  </th>
                </xsl:if>
                <xsl:if test="$show_queue = 1">
                  <th>
                    <a title="Sort by Queue" href="{$sort_base_href}&amp;_sortby=queue">Queue</a>
                    <xsl:copy-of select="$help_Queue"/>
                  </th>
                </xsl:if>
                <th>
                  <a title="Sort by Time" href="{$sort_base_href}&amp;_sortby=time">Time</a>
                  <xsl:copy-of select="$help_Time"/>
                </th>
                <th>
                  <a title="Sort by Status" href="{$sort_base_href}&amp;_sortby=status">Status</a>
                  <xsl:copy-of select="$help_Status"/>
                </th>
                <xsl:if test="$show_host = 1">
                  <th>
                    <a title="Sort by Host" href="{$sort_base_href}&amp;_sortby=host">Host</a>
                    <xsl:copy-of select="$help_Host"/>
                  </th>
                </xsl:if>
                <th>
                  <a title="Sort by Name" href="{$sort_base_href}&amp;_sortby=name">Name</a>
                  <xsl:copy-of select="$help_Name"/>
                </th>
              </xsl:otherwise>
            </xsl:choose>
          </tr>
          <xsl:choose>
            <xsl:when test="$_jobid and @type = 'globus'">
              <xsl:apply-templates select="grid:job[@id = $_jobid]" mode="list"/>
            </xsl:when>
           <xsl:otherwise>
              <xsl:choose>
                <xsl:when test="$job_sortby = 'owner'">
                  <xsl:apply-templates select="grid:job" mode="list">
                    <xsl:sort select="grid:owner" order="{$sort_order}"/>
                  </xsl:apply-templates>
                </xsl:when>
                <xsl:when test="$job_sortby = 'account'">
                  <xsl:apply-templates select="grid:job" mode="list">
                    <xsl:sort select="grid:account" order="{$sort_order}"/>
                  </xsl:apply-templates>
                </xsl:when>
                <xsl:when test="$job_sortby = 'status'">
                  <xsl:choose>
                    <xsl:when test="$sort_order = 'ascending'">
                      <xsl:apply-templates select="grid:job" mode="list">
                        <xsl:sort select="grid:status" order="descending"/>
                      </xsl:apply-templates>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:apply-templates select="grid:job" mode="list">
                        <xsl:sort select="grid:status" order="ascending"/>
                      </xsl:apply-templates>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:when>
                <xsl:when test="$job_sortby = 'queue'">
                  <xsl:choose>
                    <xsl:when test="$sort_order = 'ascending'">
                      <xsl:apply-templates select="grid:job" mode="list">
                        <xsl:sort select="grid:queue" order="descending"/>
                      </xsl:apply-templates>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:apply-templates select="grid:job" mode="list">
                        <xsl:sort select="grid:queue" order="ascending"/>
                      </xsl:apply-templates>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:when>
                <xsl:when test="$job_sortby = 'host'">
                  <xsl:apply-templates select="grid:job" mode="list">
                    <xsl:sort select="grid:execution-host" order="{$sort_order}"/>
                  </xsl:apply-templates>
                </xsl:when>
                <xsl:when test="$job_sortby = 'name'">
                  <xsl:apply-templates select="grid:job" mode="list">
                    <xsl:sort select="grid:name" order="{$sort_order}"/>
                  </xsl:apply-templates>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:apply-templates select="grid:job" mode="list">
                    <xsl:sort select="@id" order="{$sort_order}"/>
                  </xsl:apply-templates>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:otherwise>
          </xsl:choose>
        </table>
        <xsl:choose>
          <xsl:when test="$_jobid and @type = 'globus'">
            <xsl:apply-templates select="grid:job[@id = $_jobid]" mode="details"/>
          </xsl:when>
          <xsl:when test="count(grid:job) = 1">
            <xsl:apply-templates select="grid:job" mode="details"/>
          </xsl:when>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>Sorry - You have no jobs to be listed!</xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="grid:job[@type='globus']/grid:status">
    <xsl:variable name="action-url">
      <xsl:value-of select="$url" />
      <xsl:text>?_uri=//com.enginframe.</xsl:text>
      <xsl:value-of select="encode:forUriComponent(../@type)" />
      <xsl:text>/job.status&amp;_jobid=</xsl:text>
      <xsl:value-of select="encode:forUriComponent(../@id)" />
      <xsl:text>&amp;_spooler=</xsl:text>
      <xsl:value-of select="encode:forUriComponent(../submission-directory/text())"/>
    </xsl:variable>
    <form name="status{generate-id()}" action="{$action-url}" method="post">
      <img src="{$null}" width="2" height="1" alt="" />
      <xsl:variable name="js-escaped-id" select="encode:forJavaScriptAttribute(../@id)"/>
      <xsl:choose>
        <xsl:when test="normalize-space(text()) = 'CLEANED'">
          <strong>CLEANED</strong>
        </xsl:when>
        <xsl:when test="normalize-space(text()) = 'ABORTED'">
          <strong>ABORTED</strong>
        </xsl:when>
        <xsl:when test="normalize-space(text()) = 'DONE'">
          <select name="_action" onChange="submitForm(this.form, '{$js-escaped-id}', 'get output of');">
            <option value=""><xsl:value-of select="text()"/></option>
            <option value="output">GET OUTPUT</option>
          </select>
        </xsl:when>
        <xsl:otherwise>
          <select name="_action" onChange="submitForm(this.form, '{$js-escaped-id}', 'cancel');">
            <option value=""><xsl:value-of select="text()"/></option>
            <option value="cancel">CANCEL</option>
          </select>
        </xsl:otherwise>
      </xsl:choose>
      <img src="{$null}" width="2" height="1" alt="" />
    </form>
  </xsl:template>

  <xsl:template match="grid:job" priority="+1" mode="list">
    <xsl:variable name="my_id">
      <xsl:value-of select="@id"/>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="following-sibling::grid:job/@id = $my_id" />
      <xsl:when test="preceding-sibling::grid:job/@id = $my_id">
        <!-- renders job arrays -->
        <xsl:call-template name="normal_job">
          <xsl:with-param name="mode">array</xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <!-- renders normal jobs -->
        <xsl:call-template name="normal_job"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:variable name="ef_user" select="//ef:profile/ef:user"/>

  <xsl:template name="status_actions">
    <xsl:param name="status"/>

    <xsl:variable name="grid_owner">
      <xsl:choose>
        <xsl:when test="contains(../grid:owner,'\')">
          <xsl:value-of select="substring-after(../grid:owner,'\')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="../grid:owner"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:choose>
      <xsl:when test="$status='DONE' or $status='EXIT' or not($grid_owner=$ef_user)"><strong><xsl:value-of select="$status"/></strong></xsl:when>
      <xsl:otherwise>
        <xsl:variable name="js-escaped-id" select="encode:forJavaScriptAttribute(../@id)"/>
        <select name="_action" onChange="submitForm(this.form, '{$js-escaped-id}', this.value);">
          <option value="">
            <xsl:value-of select="$status"/>
          </option>
          <option value="kill">KILL</option>
          <xsl:choose>
            <xsl:when test="$status = 'PSUSP'">
               <option value="resume">RESUME</option>
            </xsl:when>
            <xsl:when test="$status = 'USUSP'">
               <option value="resume">RESUME</option>
            </xsl:when>
            <xsl:otherwise>
              <option value="stop">STOP</option>
            </xsl:otherwise>
          </xsl:choose>
        </select>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="grid:job/grid:status" mode="array">
    <xsl:variable name="my_id" select="../@id"/>
    <xsl:variable name="size" select="count(../../grid:job[@id=$my_id])"/>
    <xsl:variable name="done" select="count(../../grid:job[@id=$my_id and grid:status = 'DONE'])"/>
    <xsl:variable name="exit" select="count(../../grid:job[@id=$my_id and grid:status = 'EXIT'])"/>
    <xsl:variable name="run" select="count(../../grid:job[@id=$my_id and grid:status = 'RUN'])"/>
    <xsl:variable name="pend" select="count(../../grid:job[@id=$my_id and grid:status = 'PEND'])"/>
    <xsl:variable name="wait" select="count(../../grid:job[@id=$my_id and grid:status = 'WAIT'])"/>
    <xsl:variable name="finished" select="($done + $exit) = $size"/>
    <xsl:variable name="tooltip">
      <xsl:if test="$done > 0">[<xsl:value-of select="$done"/>]completed </xsl:if>
      <xsl:if test="$exit > 0">[<xsl:value-of select="$exit"/>]aborted </xsl:if>
      <xsl:if test="$run > 0">[<xsl:value-of select="$run"/>]running </xsl:if>
      <xsl:if test="$wait > 0">[<xsl:value-of select="$wait"/>]buffered </xsl:if>
      <xsl:if test="$pend > 0">[<xsl:value-of select="$pend"/>]pending</xsl:if>
    </xsl:variable>
    <xsl:variable name="action-url">
      <xsl:value-of select="$url" />
      <xsl:text>?_uri=//com.enginframe.</xsl:text>
      <xsl:value-of select="encode:forUriComponent(../@type)" />
      <xsl:text>/job.status&amp;_jobid=</xsl:text>
      <xsl:value-of select="encode:forUriComponent(../@id)" />
    </xsl:variable>
    <form name="status{../@id}" action="{$action-url}" method="post">
      <img src="{$null}" width="2" height="1" alt="" />
      <table border="0" cellpadding="0" cellspacing="0">
        <tr>
          <td>
            <table border="0" cellpadding="1" cellspacing="0" bgcolor="gray">
              <tr>
                <td>
                  <table style="width: {$job_statusbar_width}px; height: {$job_statusbar_height}px; text-align: left;" border="0" cellpadding="0" cellspacing="0">
                    <tr>
                      <xsl:if test="$exit > 0">
                      <td title="{$tooltip}"
                          style="width: {($job_statusbar_width * $exit) div $size}px;  background-color: rgb(255, 0, 0);"
                          bgcolor="#FF0000">
                         <img src="{$null}" border="0" alt="{$tooltip}" width="{($job_statusbar_width * $exit) div $size}" height="{$job_statusbar_height}"/>
                      </td>
                      </xsl:if>
                      <xsl:if test="$done > 0">
                        <td title="{$tooltip}"
                            style="width: {($job_statusbar_width * $done) div $size}px;  background-color: rgb(0, 255, 0);"
                            bgcolor="#00FF00">
                           <img src="{$null}" border="0" alt="{$tooltip}" width="{($job_statusbar_width * $done) div $size}" height="{$job_statusbar_height}"/>
                        </td>
                      </xsl:if>
                      <xsl:if test="$run > 0">
                        <td title="{$tooltip}"
                            style="width: {($job_statusbar_width * $run) div $size}px;  background-color: rgb(255, 255, 0);"
                            bgcolor="#FFFF00">
                           <img src="{$null}" border="0" alt="{$tooltip}" width="{($job_statusbar_width * $run) div $size}" height="{$job_statusbar_height}"/>
                        </td>
                      </xsl:if>
                      <xsl:if test="$wait > 0">
                        <td title="{$tooltip}"
                            style="width: {($job_statusbar_width * $wait) div $size}px; background-color: rgb(200, 200, 150);"
                            bgcolor="#C8C896">
                           <img src="{$null}" border="0" alt="{$tooltip}" width="{($job_statusbar_width * $wait) div $size}" height="{$job_statusbar_height}"/>
                        </td>
                      </xsl:if>
                      <xsl:if test="$pend > 0">
                        <td title="{$tooltip}"
                            style="width: {($job_statusbar_width * $pend) div $size}px; background-color: rgb(150, 150, 150);"
                            bgcolor="#969696">
                           <img src="{$null}" border="0" alt="{$tooltip}" width="{($job_statusbar_width * $pend) div $size}" height="{$job_statusbar_height}"/>
                        </td>
                      </xsl:if>
                    </tr>
                  </table>
                </td>
              </tr>
            </table>
          </td>
          <td>
            <img src="{$null}" width="4" height="1" alt="" />
            <xsl:call-template name="status_actions">
              <xsl:with-param name="status">
                <xsl:choose>
                  <xsl:when test="$pend = $size">PEND</xsl:when>
                  <xsl:when test="$exit + $pend + $wait + $run + $done != $size">USUSP</xsl:when>
                  <xsl:when test="$done = $size">DONE</xsl:when>
                  <xsl:when test="$finished">EXIT</xsl:when>
                  <xsl:otherwise>RUN</xsl:otherwise>
                </xsl:choose>
              </xsl:with-param>
            </xsl:call-template>
          </td>
        </tr>
      </table>
      <img src="{$null}" width="2" height="1" alt="" />
    </form>
  </xsl:template>

  <xsl:template match="grid:job/grid:status" priority="-1">
    <xsl:variable name="action-url">
      <xsl:value-of select="$url" />
      <xsl:text>?_uri=//com.enginframe.</xsl:text>
      <xsl:value-of select="encode:forUriComponent(../@type)" />
      <xsl:text>/job.status&amp;_jobid=</xsl:text>
      <xsl:value-of select="encode:forUriComponent(../@id)" />
    </xsl:variable>
    <form name="status{../@id}" action="{$action-url}" method="post">
      <img src="{$null}" width="2" height="1" alt="" />
      <table border="0" cellpadding="0" cellspacing="0">
        <tr>
          <td>
            <table border="0" cellpadding="1" cellspacing="0" bgcolor="gray">
              <tr>
                <td>
                  <table style="width: {$job_statusbar_width}px; height: {$job_statusbar_height}px; text-align: left;" border="0" cellpadding="0" cellspacing="0">
                    <tr>
                      <xsl:choose>
                        <xsl:when test="text() = 'DONE'">
                          <td style="background-color: rgb(0, 255, 0);"
                              bgcolor="#00FF00"><img src="{$null}" width="{$job_statusbar_width}" height="{$job_statusbar_height}" alt="" /></td>
                        </xsl:when>
                        <xsl:when test="text() = 'RUN'">
                          <td style="background-color: rgb(255, 255, 0);"
                              bgcolor="#FFFF00"><img src="{$null}" width="{$job_statusbar_width}" height="{$job_statusbar_height}" alt="" /></td>
                        </xsl:when>
                        <xsl:when test="text() = 'EXIT'">
                          <td style="background-color: rgb(255, 0, 0);"
                              bgcolor="#FF0000"><img src="{$null}" width="{$job_statusbar_width}" height="{$job_statusbar_height}" alt="" /></td>
                        </xsl:when>
                        <xsl:otherwise>
                          <td style="background-color: rgb(150, 150, 150);"
                              bgcolor="#969696"><img src="{$null}" width="{$job_statusbar_width}" height="{$job_statusbar_height}" alt="" /></td>
                        </xsl:otherwise>
                      </xsl:choose>
                    </tr>
                  </table>
                </td>
              </tr>
            </table>
          </td>
          <td>
            <img src="{$null}" width="4" height="1" alt="" />
            <xsl:call-template name="status_actions">
              <xsl:with-param name="status">
                <xsl:value-of select="text()"/>
              </xsl:with-param>
            </xsl:call-template>
          </td>
        </tr>
      </table>
      <img src="{$null}" width="2" height="1" alt="" />
    </form>
  </xsl:template>

  <xsl:template match="grid:message">
    <h3><xsl:value-of select="text()"/></h3>
  </xsl:template>

  <!--
  Show job information
  -->

  <xsl:template match="grid:job/grid:execution-host[@licensed='false' and count(../grid:execution-host) = 1]" priority="+2">
    <xsl:apply-templates select="@licensed">
      <xsl:with-param name="name" select="text()" />
    </xsl:apply-templates>
  </xsl:template>


  <xsl:template name="normal_job">
    <xsl:param name="mode"/>

    <xsl:variable name="pending" select="status = 'PEND' or status = 'PENDING' or status = 'PSUSP'" />
    <xsl:variable name="name"><xsl:value-of select="grid:name" />
      <xsl:if test="not(grid:name)"><xsl:value-of select="grid:command" /></xsl:if>
    </xsl:variable>
    <xsl:variable name="status" select="grid:status/text()" />

    <xsl:variable name="evenodd">
      <xsl:choose>
        <xsl:when test="(position()) mod 2 != 0">odd</xsl:when>
        <xsl:otherwise>even</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <tr class="list_spoolers_{$evenodd}">
    <!-- display job ID w/ link to job.details -->
    <td>
      <table border="0" cellpadding="1" cellspacing="0">
        <tr>
        <td>
        <img src="{$null}" width="2" height="1" alt="" />
          <xsl:variable name="action-url">
            <xsl:value-of select="$url" />
            <xsl:text>?_uri=//com.enginframe.</xsl:text>
            <xsl:value-of select="encode:forUriComponent(@type)" />
            <xsl:text>/job.details&amp;_jobid=</xsl:text>
            <xsl:value-of select="encode:forUriComponent(@id)" />
            <xsl:if test="@type = 'globus'">&amp;_spooler=<xsl:value-of select="encode:forUriComponent(grid:submission-directory)"/></xsl:if>
          </xsl:variable>
          <a href="{$action-url}">
            <xsl:value-of select="@id"/>
          </a>
          <xsl:if test="$mode = 'array'">
            <xsl:variable name="my_id" select="@id"/>
            <xsl:variable name="len" select="count(../grid:job[@id = $my_id])"/>
            <img src="{$null}" width="2" height="1" alt="" />[<xsl:value-of select="$len"/>]
          </xsl:if>
          <img src="{$null}" width="2" height="1" alt="" />
        </td>
        <xsl:if test="$job_stdout = 1">
          <td>
          <xsl:if test="@type = 'lsf' and $status != 'EXIT' and $status != 'DONE' and $status != 'PEND' and $status != 'PSUSP'">
            <img src="{$null}" width="2" height="1" alt="" />
            <xsl:variable name="action-url">
              <xsl:value-of select="$url" />
              <xsl:text>?_uri=//com.enginframe.</xsl:text>
              <xsl:value-of select="encode:forUriComponent(@type)" />
              <xsl:text>/job.stdout&amp;_jobid=</xsl:text>
              <xsl:value-of select="encode:forUriComponent(@id)" />
              <xsl:text>&amp;_jobname='</xsl:text>
              <xsl:value-of select="encode:forUriComponent($name)" />
              <xsl:text>';</xsl:text>
            </xsl:variable>
            <a href="{$action-url}" title="View Job stdout" >
              <img align="middle" src="/{$_root_context}/images/job_stdout.gif" border="0" alt="" />
            </a>
            <img src="{$null}" width="2" height="1" alt="" />
          </xsl:if>
          </td>
        </xsl:if>
        </tr>
      </table>
    </td>

    <!-- display job owner -->
      <xsl:if test="$show_owner = 1">
      <td>
        <img src="{$null}" width="2" height="1" alt="" />
        <tt><xsl:value-of select="grid:owner"/></tt>
        <img src="{$null}" width="2" height="1" alt="" />
      </td>
      </xsl:if>

      <!-- display job project -->
      <xsl:if test="$show_project = 1">
      <td>
        <img src="{$null}" width="2" height="1" alt="" />
        <tt><xsl:value-of select="grid:account"/></tt>
        <img src="{$null}" width="2" height="1" alt="" />
      </td>
      </xsl:if>

    <!-- display job queue -->
      <xsl:if test="$show_queue = 1">
      <td>
        <img src="{$null}" width="2" height="1" alt="" />
        <tt><xsl:value-of select="grid:queue"/></tt>
        <img src="{$null}" width="2" height="1" alt="" />
      </td>
      </xsl:if>

    <!-- display job submission time -->
    <td>
      <img src="{$null}" width="2" height="1" alt="" />
        <xsl:apply-templates select="grid:submission-time"/>
      <img src="{$null}" width="2" height="1" alt="" />
    </td>

    <!-- display/modify job status -->
    <td>
        <xsl:choose>
          <xsl:when test="not(grid:status)">N/A</xsl:when>
          <xsl:when test="$mode = 'array'">
            <xsl:apply-templates select="grid:status" mode="array"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="grid:status"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>

    <!-- display execution host(s) w/ links to host.info -->
      <xsl:if test="$show_host = 1">
        <td>
        <img src="{$null}" width="2" height="1" alt="" />

          <xsl:choose>
            <xsl:when test="$mode = 'array'">
              <xsl:variable name="my_id" select="@id"/>
              <xsl:variable name="run" select="count(../grid:job[(@id = $my_id) and (grid:status = 'RUN')])"/>
              <xsl:choose>
                <xsl:when test="$run != 0">
                  <div>Running on <xsl:value-of select="$run"/> processors</div>
                </xsl:when>
                <xsl:otherwise>
                  <div><center>-</center></div>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
              <xsl:apply-templates select="grid:execution-host"/>
            </xsl:otherwise>
          </xsl:choose>

        <img src="{$null}" width="2" height="1" alt="" />
      </td>
      </xsl:if>

    <!-- display/modify job name -->
      <td>
        <xsl:variable name="action-url">
          <xsl:value-of select="$url" />
          <xsl:text>?_uri=//com.enginframe.</xsl:text>
          <xsl:value-of select="encode:forUriComponent(../@type)" />
          <xsl:text>/job.job.rename&amp;_jobid=</xsl:text>
          <xsl:value-of select="encode:forUriComponent(../@id)" />
        </xsl:variable>
        <xsl:variable name="js-escaped-id" select="encode:forUriComponent(@id)" />
        <form name="rename{@id}"
            action="{$action-url}"
            onSubmit="return submitForm(this, '{$js-escaped-id}', 'change name to');"
            method="post"
        >
        <img src="{$null}" width="2" height="1" alt="" />
        <xsl:variable name="name">
          <xsl:value-of select="substring-before(concat(grid:name,'['),'[')"/>
          <xsl:if test="not(grid:name)">
            <xsl:value-of select="grid:command"/>
          </xsl:if>
        </xsl:variable>

        <xsl:choose>
          <xsl:when test="not($pending) or @index">
            <tt>
              <xsl:value-of select="substring($name, 0, $job_name_max_length)" />
            </tt>
            <xsl:if test="string-length($name) &gt; $job_name_max_length">
              <small title="Job name truncated...">&#160;&#160;...</small>
            </xsl:if>
          </xsl:when>
          <xsl:otherwise>
            <input name="_name" value="{$name}" size="{$name_length}" title="{$name}" alt="{$name}" />
          </xsl:otherwise>
        </xsl:choose>

        <img src="{$null}" width="2" height="1" alt="" />
        </form>
    </td>
  </tr>
  </xsl:template>

  <xsl:template match="grid:reason">
    <tr>
      <td valign="top">-</td>
      <td valign="top"><xsl:apply-templates/></td>
    </tr>
  </xsl:template>

  <xsl:template match="grid:execution-time|grid:termination-time|grid:submission-time">
    <xsl:value-of select="@month"/>&#160;<xsl:value-of select="@day"/>,&#160;<xsl:value-of select="@hour"/>:<xsl:value-of select="@minute"/>
  </xsl:template>

  <xsl:template match="grid:job" mode="details">
    <xsl:variable name="isDhtmlCapable"><xsl:call-template name="is_dhtml_capable"/></xsl:variable>
    <xsl:variable name="status" select="grid:status/text()"/>

    <table cellpadding="1" border="0" cellspacing="1">
        <tr>
          <xsl:if test="$show_full_job_details = 1 and $isDhtmlCapable = 'true'">
            <td>
              <img src="{$null}" width="3" height="1" alt="" />
              <div id="Details">
                <a href="javascript:void(0)" id="ShowJobDetails" class="box-opened" onclick="toggleListControls('ShowJobDetails','JobDetails')"><img src="{$null}" width="12" height="10" border="0" alt="" />Details</a>
                <xsl:call-template name="ef_help">
                  <xsl:with-param name="help-href">job-details.html</xsl:with-param>
                </xsl:call-template>
              </div>
              <img src="{$null}" width="3" height="1" alt="" />
            </td>
          </xsl:if>
          <xsl:if test="grid:reasons/grid:reason">
            <td>
              <img src="{$null}" width="3" height="1" alt="" />
              Reasons:
              <img src="{$null}" width="3" height="1" alt="" />
            </td>
            <td>
              <table border="0">
                <xsl:apply-templates select="grid:reasons/grid:reason"/>
              </table>
            </td>
          </xsl:if>
          <xsl:if test="grid:total-cpu-usage or grid:memory-usage or grid:swap-usage">
            <th>
              <img src="{$null}" width="3" height="1" alt="" />
              Resource usage:
              <img src="{$null}" width="3" height="1" alt="" />
            </th>
            <td>
              <table border="0">
                <xsl:if test="grid:total-cpu-usage">
                  <td>CPU: <strong><xsl:value-of select="grid:total-cpu-usage"/>s.</strong></td>
                  <td>&#160;</td>
                </xsl:if>
                <xsl:if test="grid:memory-usage">
                  <td>Memory: <strong><xsl:value-of select="grid:memory-usage"/></strong></td>
                  <td>&#160;</td>
                </xsl:if>
                <xsl:if test="grid:swap-usage">
                  <td>Swap: <strong><xsl:value-of select="grid:swap-usage"/></strong></td>
                  <td>&#160;</td>
                </xsl:if>
              </table>
            </td>
          </xsl:if>
          <xsl:if test="grid:handle">
          <th>
            <img src="{$null}" width="3" height="1" alt="" />
            Handle:
            <img src="{$null}" width="3" height="1" alt="" />
          </th>
          <td>
            <table border="0">
              <tt><xsl:value-of select="grid:handle"/></tt>
            </table>
          </td>
        </xsl:if>
      </tr>

    </table>

    <!-- New Job details view -->
    <xsl:if test="$show_full_job_details = 1">
      <div id="JobDetails" style="display:none">
        <table width="100%" class="Detailed">
          <tr>
            <td><strong>Submission:</strong></td><td></td>
          </tr>
          <tr>
            <td>
              <ul>
                <li>Job manager:</li>
              </ul>
            </td>
            <td><xsl:value-of select="@type"/></td>
          </tr>
          <tr>
            <td>
              <ul>
                <li>Time:</li>
              </ul>
            </td>
            <td><xsl:apply-templates select="grid:submission-time"/></td>
          </tr>
          <tr>
            <td>
              <ul>
                <li>Host:</li>
              </ul>
            </td>
            <td><xsl:value-of select="grid:submission-host"/></td>
          </tr>
          <tr>
            <td>
              <ul>
                <li>Directory:</li>
              </ul>
            </td>
            <td><xsl:value-of select="grid:submission-directory"/></td>
          </tr>
          <xsl:if test="grid:command and $show_command = 1">
            <tr>
              <td>
                <ul>
                  <li>Command:</li>
                </ul>
              </td>
              <td><xsl:value-of select="grid:command"/></td>
            </tr>
          </xsl:if>

          <xsl:if test="grid:group">
            <tr>
              <td>
                <ul>
                  <li>Job group:</li>
                </ul>
              </td>
              <td><xsl:value-of select="grid:group"/></td>
            </tr>
          </xsl:if>

          <xsl:if test="$status != 'PEND'">
            <tr>
              <td><strong>Execution:</strong></td><td></td>
            </tr>
            <tr>
              <td>
                <ul>
                  <li>Time:</li>
                </ul>
              </td>
              <td><xsl:apply-templates select="grid:execution-time"/></td>
            </tr>
            <tr>
              <td>
                <ul>
                  <li>Host:</li>
                </ul>
              </td>
              <td><xsl:value-of select="grid:execution-host"/></td>
            </tr>
            <tr>
              <td>
                <ul>
                  <li>Directory:</li>
                </ul>
              </td>
              <td><xsl:value-of select="grid:execution-directory"/></td>
            </tr>
            <xsl:if test="grid:pid-group">
              <tr>
                <td>
                  <ul>
                    <li>Job group pid:</li>
                  </ul>
                </td>
                <td><xsl:value-of select="grid:pid-group"/></td>
              </tr>
            </xsl:if>
            <xsl:if test="grid:pids">
              <tr>
                <td>
                  <ul>
                    <li>Job pids:</li>
                  </ul>
                </td>
                <td><xsl:value-of select="grid:pids"/></td>
              </tr>
            </xsl:if>
          </xsl:if>
          <xsl:if test="$status = 'DONE' or $status = 'EXIT'">
            <tr>
              <td><strong>Termination:</strong></td><td></td>
            </tr>
            <tr>
              <td>
                <ul>
                  <li>Time:</li>
                </ul>
              </td>
              <td><xsl:apply-templates select="grid:termination-time"/></td>
            </tr>
            <tr>
              <td>
                <ul>
                  <li>Total cpu usage:</li>
                </ul>
              </td>
              <td><xsl:value-of select="grid:total-cpu-usage"/></td>
            </tr>
            <tr>
              <td>
                <ul>
                  <li>Exit code:</li>
                </ul>
              </td>
              <td><xsl:value-of select="grid:exit-code"/></td>
            </tr>
          </xsl:if>
        </table>
      </div>
    </xsl:if>
  </xsl:template>


  <xsl:template match="grid:job" priority="-1">
  </xsl:template>



  <!--
  ### =========================================================================
  ##    HOST INFORMATIONS
  #   =========================================================================
  -->


  <!-- GRID:HOST-LIST empty -->
  <xsl:template match="grid:host-list[count(child::grid:host)= 0]">
    <p>
      Selected Grid host does not exist on this cluster.
    </p>
  </xsl:template>

  <xsl:template match="grid:host-list" priority="-1" />

  <!-- GRID:HOST-LIST with more than $nhost_for_minimal_view hosts -->
  <xsl:template match="grid:host-list[count(grid:host) > $nhost_for_minimal_view]">
    <table cellpadding="0" border="0" width="99%" cellspacing="0">
      <tr>
        <td>
          Sort&#160;by:&#160;
          <a href="{$agent}.xml?_uri=//com.enginframe.{@type}/host.load&amp;_csortby=name">Name</a>&#160;
          <a href="{$agent}.xml?_uri=//com.enginframe.{@type}/host.load&amp;_csortby=njobs">#Jobs</a>&#160;
          <xsl:if test="not(@type = 'pbs')"><a href="{$agent}.xml?_uri=//com.enginframe.{@type}/host.load&amp;_csortby=r1m">r1m</a>&#160;</xsl:if>
          <a href="{$agent}.xml?_uri=//com.enginframe.{@type}/host.load&amp;_csortby=ut">CPU</a>&#160;
          <xsl:if test="not(@type = 'pbs')"><a href="{$agent}.xml?_uri=//com.enginframe.{@type}/host.load&amp;_csortby=swp">Swap</a>&#160;</xsl:if>
          <a href="{$agent}.xml?_uri=//com.enginframe.{@type}/host.load&amp;_csortby=mem">Mem</a>
        </td>
      </tr>
    </table>
    <br/>
    <table cellpadding="0" border="0" width="99%" cellspacing="0">
      <tr>
        <xsl:variable name="cluster_sortby"><xsl:value-of select="//ef:profile/ef:session-list/ef:session[@id='cluster_sortby']"/></xsl:variable>
        <xsl:variable name="cluster_sort_order"><xsl:value-of select="//ef:profile/ef:session-list/ef:session[@id='cluster_sort_order']"/></xsl:variable>
        <xsl:choose>
          <xsl:when test="$cluster_sortby = 'status'">
            <xsl:choose>
              <xsl:when test="$cluster_sort_order = 'ascending'">
                <xsl:apply-templates select="grid:host" mode="minimal">
                  <xsl:sort select="grid:status/@base" order="ascending"/>
                </xsl:apply-templates>
              </xsl:when>
              <xsl:otherwise>
                <xsl:apply-templates select="grid:host" mode="minimal">
                  <xsl:sort select="grid:status/@base" order="descending"/>
                </xsl:apply-templates>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:when test="$cluster_sortby = 'njobs'">
            <xsl:choose>
              <xsl:when test="$cluster_sort_order = 'ascending'">
                <xsl:apply-templates select="grid:host" mode="minimal">
                  <xsl:sort select="grid:usage/@running-jobs" order="ascending"/>
                </xsl:apply-templates>
              </xsl:when>
              <xsl:when test="$cluster_sort_order = 'descending'">
                <xsl:apply-templates select="grid:host" mode="minimal">
                  <xsl:sort select="grid:usage/@running-jobs" order="descending"/>
                </xsl:apply-templates>
              </xsl:when>
            </xsl:choose>
          </xsl:when>
          <xsl:otherwise><xsl:apply-templates select="grid:host" mode="minimal"/></xsl:otherwise>
        </xsl:choose>
      </tr>
    </table>
    <br/>

    <div id="TextHere" width="400" style="position:relative; visibility:visible; top:10px;left:28px;width:40px">&#160;
      <table width="100%">
        <tr>
          <td>
            <span>
              This&#160;is&#160;your&#160;cluster&#160;status.
              <br/>
              Press&#160;the&#160;mouse&#160;over&#160;a&#160;cell&#160;to&#160;display&#160;host&#160;details.
              <br/>
              <br/>
              The&#160;cell&#160;colors&#160;indicate:
              <br/>
            </span>

            <table border="1" cellspacing="0" cellpadding="0">
              <tr>
                <td bgcolor="#baf2ab">
                   &#160;Green&#160;
                </td>
                <td>
                  &#160;Host&#160;is&#160;<strong>ok</strong>
                </td>
              </tr>
              <tr>
                <td bgcolor="#fffdb5">
                   &#160;Yellow&#160;
                </td>
                <td>
                  &#160;Host&#160;is&#160;<strong>closed</strong>
                </td>
              </tr>
              <tr>
                <td bgcolor="#ffb5b5">
                   &#160;Red&#160;
                </td>
                <td>
                  &#160;Host&#160;is&#160;<strong>unlicensed,&#160;unreachable&#160;or&#160;unavailable</strong>
                </td>
              </tr>
            </table>
          </td>
        </tr>
      </table>
    </div>
    <br/>
    <br/>
  </xsl:template>


  <!-- GRID:HOST-LIST with only 1 host -->
  <xsl:template match="grid:host-list[count(grid:host) = 1]">
    <xsl:apply-templates select="grid:host" mode="details"/>
  </xsl:template>


  <!-- GRID:HOST-LIST with more than $nhost_for_compat_view -->
  <xsl:template match="grid:host-list[(count(grid:host) > $nhost_for_compact_view) and (count(grid:host) &lt;= $nhost_for_minimal_view)]">

    <table cellpadding="0" border="0" width="99%" cellspacing="0">
      <tr>
        <td>
          Sort by:&#160;
            <a href="{$agent}.xml?_uri=//com.enginframe.{@type}/host.load&amp;_csortby=name">Name</a>&#160;
            <a href="{$agent}.xml?_uri=//com.enginframe.{@type}/host.load&amp;_csortby=njobs">#Jobs</a>&#160;
            <xsl:if test="not(@type = 'pbs')"><a href="{$agent}.xml?_uri=//com.enginframe.{@type}/host.load&amp;_csortby=r1m">r1m</a>&#160;</xsl:if>
            <a href="{$agent}.xml?_uri=//com.enginframe.{@type}/host.load&amp;_csortby=ut">CPU</a>&#160;
            <xsl:if test="not(@type = 'pbs')"><a href="{$agent}.xml?_uri=//com.enginframe.{@type}/host.load&amp;_csortby=swp">Swap</a>&#160;</xsl:if>
            <a href="{$agent}.xml?_uri=//com.enginframe.{@type}/host.load&amp;_csortby=mem">Mem</a>
          <span style="margin-left: 20px">
            <xsl:call-template name="ef_help">
              <xsl:with-param name="help-href">host-list-compact.html</xsl:with-param>
            </xsl:call-template>
          </span>
        </td>
      </tr>
    </table>
    <br/>
    <table cellpadding="0" border="0" width="99%" cellspacing="0">
      <tr>
        <xsl:variable name="cluster_sortby"><xsl:value-of select="//ef:profile/ef:session-list/ef:session[@id='cluster_sortby']"/></xsl:variable>
        <xsl:variable name="cluster_sort_order">
          <xsl:choose>
            <xsl:when test="//ef:profile/ef:session-list/ef:session[@id='cluster_sort_order']"><xsl:value-of select="//ef:profile/ef:session-list/ef:session[@id='cluster_sort_order']"/></xsl:when>
            <xsl:otherwise>ascending</xsl:otherwise>
          </xsl:choose>
        </xsl:variable>

        <xsl:choose>
          <xsl:when test="$cluster_sortby = 'status'">
            <xsl:apply-templates select="grid:host" mode="compact">
              <xsl:sort select="grid:status/@base" order="{$cluster_sort_order}"/>
            </xsl:apply-templates>
          </xsl:when>
          <xsl:when test="$cluster_sortby = 'njobs'">
            <xsl:apply-templates select="grid:host" mode="compact">
              <xsl:sort select="grid:usage/@running-jobs" order="{$cluster_sort_order}"/>
            </xsl:apply-templates>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="grid:host" mode="compact"/>
          </xsl:otherwise>
        </xsl:choose>
      </tr>
    </table>
  </xsl:template>


  <!-- GRID:HOST-LIST  [1 < nhosts <= $nhost_for_compact_view] -->
  <xsl:template match="grid:host-list[(count(grid:host) &lt;=$nhost_for_compact_view) and (count(grid:host) &gt; 1)]">
    <table cellpadding="0" border="0" width="100%" cellspacing="0">
      <tr>
            <th>
              <a href="{$agent}.xml?_uri=//com.enginframe.{@type}/host.load&amp;_csortby=name">Host name</a>
              <xsl:call-template name="ef_help">
                <xsl:with-param name="help-href">host-list.html#name</xsl:with-param>
              </xsl:call-template>
            </th>
            <th>
              <a href="{$agent}.xml?_uri=//com.enginframe.{@type}/host.load&amp;_csortby=status">
                <xsl:choose>
                  <xsl:when test="$show_base_batch_status = 1">
                    Status base/batch
                  </xsl:when>
                  <xsl:otherwise>
                    Status
                  </xsl:otherwise>
                </xsl:choose>
              </a>
              <xsl:call-template name="ef_help">
                <xsl:with-param name="help-href">host-list.html#status</xsl:with-param>
              </xsl:call-template>
            </th>
            <th>
              <a href="{$agent}.xml?_uri=//com.enginframe.{@type}/host.load&amp;_csortby=njobs">#Jobs</a>
              <xsl:call-template name="ef_help">
                <xsl:with-param name="help-href">host-list.html#njobs</xsl:with-param>
              </xsl:call-template>
            </th>
            <xsl:if test="not(@type = 'pbs')">
              <th>
                <a href="{$agent}.xml?_uri=//com.enginframe.{@type}/host.load&amp;_csortby=r1m">r1m</a>
                <xsl:call-template name="ef_help">
                  <xsl:with-param name="help-href">host-list.html#r1m</xsl:with-param>
                </xsl:call-template>
              </th>
            </xsl:if>
            <th>
              <a href="{$agent}.xml?_uri=//com.enginframe.{@type}/host.load&amp;_csortby=ut">CPU</a>
              <xsl:call-template name="ef_help">
                <xsl:with-param name="help-href">host-list.html#cpu_utilization</xsl:with-param>
              </xsl:call-template>
            </th>
            <xsl:if test="not(@type = 'pbs')">
              <th>
                <a href="{$agent}.xml?_uri=//com.enginframe.{@type}/host.load&amp;_csortby=swp">Swap</a>
                <xsl:call-template name="ef_help">
                  <xsl:with-param name="help-href">host-list.html#swap</xsl:with-param>
                </xsl:call-template>
              </th>
            </xsl:if>
            <th>
              <a href="{$agent}.xml?_uri=//com.enginframe.{@type}/host.load&amp;_csortby=mem">Mem</a>
              <xsl:call-template name="ef_help">
                <xsl:with-param name="help-href">host-list.html#mem</xsl:with-param>
              </xsl:call-template>
            </th>
      </tr>
      <xsl:variable name="cluster_sortby"><xsl:value-of select="//ef:profile/ef:session-list/ef:session[@id='cluster_sortby']"/></xsl:variable>
      <xsl:variable name="cluster_sort_order">
        <xsl:choose>
          <xsl:when test="//ef:profile/ef:session-list/ef:session[@id='cluster_sort_order']">
            <xsl:value-of select="//ef:profile/ef:session-list/ef:session[@id='cluster_sort_order']" />
          </xsl:when>
          <xsl:otherwise>ascending</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:choose>
        <xsl:when test="$cluster_sortby = 'status'">
          <xsl:apply-templates select="grid:host" mode="list">
            <xsl:sort select="grid:status/@base" order="{$cluster_sort_order}"/>
          </xsl:apply-templates>
        </xsl:when>
        <xsl:when test="$cluster_sortby = 'njobs'">
          <xsl:apply-templates select="grid:host" mode="list">
            <xsl:sort select="grid:usage/@running-jobs" order="{$cluster_sort_order}"/>
          </xsl:apply-templates>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates select="grid:host" mode="list"/>
        </xsl:otherwise>
      </xsl:choose>
    </table>
  </xsl:template>





  <!--
  ### =========================================================================
  ##    [GRID:HOST in LIST mode]
  #   =========================================================================
  -->


  <!-- GRID:HOST/@licensed mode="list", when host is unlicensed! -->
  <xsl:template match="grid:host[@licensed='false']/@licensed|grid:execution-host[@licensed='false']/@licensed">
    <xsl:param name="mode">list</xsl:param>
    <xsl:param name="name" />
    <xsl:variable name="style">
      <!--
      <xsl:text>border-bottom: 1px dashed red;</xsl:text>
      <xsl:text>font-weight: bold;</xsl:text>
      -->
      <xsl:text>color: red;</xsl:text>
      <xsl:text>font-style: italic;</xsl:text>
    </xsl:variable>

    <span class="ef-host-unlicensed" style="{$style}">
      <xsl:attribute name="title">
        <xsl:text>License for host '</xsl:text>
        <xsl:value-of select="../@name" />
        <xsl:text>' has been preempted.</xsl:text>
      </xsl:attribute>
      <xsl:choose>
        <xsl:when test="$name != ''">
          <xsl:value-of select="$name" />
        </xsl:when>
        <xsl:when test="$mode = 'list' or $mode = 'compact'">
          <xsl:text>unlicensed</xsl:text>
        </xsl:when>
        <xsl:when test="$mode = 'minimal'">
          <xsl:text>!</xsl:text>
        </xsl:when>
      </xsl:choose>
    </span>
  </xsl:template>



  <!-- GRID:HOST mode="list", when host is unlicensed! -->
  <xsl:template match="grid:host[@licensed='false']" mode="list" priority="+1">
    <xsl:variable name="span">
      <xsl:choose>
        <xsl:when test="@type='pbs'">5</xsl:when>
        <xsl:otherwise>7</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="evenodd">
      <xsl:call-template name="ef-position-evenodd" />
    </xsl:variable>

    <tr class="list_spoolers_{$evenodd}">
      <td>
        <!-- <del> -->
        <xsl:value-of select="@name" />
        <!-- </del> -->
      </td>
      <td>
        <xsl:apply-templates select="@licensed">
          <xsl:with-param name="mode">list</xsl:with-param>
        </xsl:apply-templates>
      </td>
      <td style="text-align: center">-</td>
      <td style="text-align: center">-</td>
      <td style="text-align: center">-</td>
      <xsl:if test="@type!='pbs'">
        <td style="text-align: center">-</td>
        <td style="text-align: center">-</td>
      </xsl:if>
    </tr>
  </xsl:template>


  <!-- GRID:HOST mode="list" -->
  <xsl:template match="grid:host" mode="list">

    <xsl:variable name="evenodd">
      <xsl:call-template name="ef-position-evenodd" />
    </xsl:variable>

    <tr class="list_spoolers_{$evenodd}">
      <td>
        <xsl:variable name="action-url">
          <xsl:value-of select="$url"/>
          <xsl:text>?_uri=//com.enginframe.</xsl:text>
          <xsl:value-of select="encode:forUriComponent(@type)"/>
          <xsl:text>/host.info&amp;_host=</xsl:text>
          <xsl:value-of select="encode:forUriComponent(@name)"/>
        </xsl:variable>
        <a href="{$action-url}"><xsl:value-of select="@name"/></a><br/>
      </td>
      <td align="center">
        <xsl:if test="$show_base_batch_status = 1">
          <xsl:value-of select="grid:status/@base"/> /
        </xsl:if>
        <xsl:choose>
          <xsl:when test="grid:status/@batch">
            <xsl:value-of select="grid:status/@batch"/>
          </xsl:when>
          <xsl:otherwise>
            -
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td align="center">
        <xsl:value-of select="grid:usage/@running-jobs"/>
      </td>
      <xsl:if test="not(@type = 'pbs')">
        <td align="center">
          <xsl:apply-templates select="grid:resource[@name='r1m']"/>
        </td>
      </xsl:if>
      <td align="center" >
        <xsl:apply-templates select="grid:resource[@name='ut']"/>
      </td>
      <td align="center">
        <xsl:apply-templates select="grid:resource[@name='swp']"/>
      </td>
      <td align="center">
        <xsl:apply-templates select="grid:resource[@name='mem']"/>
      </td>
    </tr>
  </xsl:template>



  <!--
  ### =========================================================================
  ##    [GRID:HOST in MINIMAL mode]
  #   =========================================================================
  -->


  <!-- GRID:HOST mode="minimal" -->
  <xsl:template match="grid:host[@licensed='false']" mode="minimal" priority="+1">
    <td style="text-align: center; background-color: #D3D0C3;">
      <xsl:apply-templates select="@licensed">
        <xsl:with-param name="mode">minimal</xsl:with-param>
      </xsl:apply-templates>
    </td>
  </xsl:template>


  <!-- GRID:HOST mode="minimal" -->

  <xsl:template match="grid:host" mode="minimal">
    <xsl:variable name="bg_color">
      <xsl:choose>
        <xsl:when test="grid:status/@batch = 'ok'">
          <xsl:text>#baf2ab</xsl:text>
        </xsl:when>
        <xsl:when test="grid:status/@batch = 'unavail' or grid:status/@batch = 'unreach'">
          <xsl:text>#ffb5b5</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>#fffdb5</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="clk">
      <xsl:text>powershow('</xsl:text>
      <xsl:value-of select="encode:forJavaScriptAttribute(@name)"/>
      <xsl:text>','</xsl:text>
      <xsl:value-of select="encode:forJavaScriptAttribute(@arch)"/>
      <xsl:text>','</xsl:text>
      <xsl:value-of select="encode:forJavaScriptAttribute(grid:status/@batch)"/>
      <xsl:text>','</xsl:text>
      <xsl:value-of select="encode:forJavaScriptAttribute(grid:resource[@name='ut'])"/>
      <xsl:text>','</xsl:text>
      <xsl:value-of select="encode:forJavaScriptAttribute(grid:resource[@name='mem'])"/>
      <xsl:text>/</xsl:text>
      <xsl:value-of select="encode:forJavaScriptAttribute(grid:resource[@name='mem']/@max)"/>
      <xsl:text>','</xsl:text>
      <xsl:value-of select="encode:forJavaScriptAttribute(grid:resource[@name='swp'])"/>
      <xsl:text>/</xsl:text>
      <xsl:value-of select="encode:forJavaScriptAttribute(grid:resource[@name='swp']/@max)"/>
      <xsl:text>','</xsl:text>
      <xsl:value-of select="encode:forJavaScriptAttribute($url)"/>
      <xsl:text>','</xsl:text>
      <xsl:value-of select="encode:forJavaScriptAttribute(../@type)"/>
      <xsl:text>')</xsl:text>
    </xsl:variable>

    <td style="background-color: {$bg_color}; vertical-align: top; text-align: center">
      <a class="highlight" href="javascript:void(0)" onclick="{$clk}">
      <xsl:choose>
        <xsl:when test="@arch-family">
          <img src="/{$_root_context}/images/arch-family/20x20/{@arch-family}.gif" alt="{@name}" title="{@name}" width="20" height="20" border="0" align="center" />
        </xsl:when>
        <xsl:when test="@arch">
          <img src="/{$_root_context}/images/arch-family/20x20/{@arch}.gif" alt="{@name}" title="{@name}" width="20" height="20" border="0" align="center" />
        </xsl:when>
        <xsl:otherwise>
          <img src="/{$_root_context}/images/arch-family/20x20/UNKNOWN.gif" alt="{@name}" title="{@name}" width="20" height="20" border="0" align="center" />
        </xsl:otherwise>
      </xsl:choose>
      </a>
    </td>
    <!-- TODO: improve this solution -->
    <xsl:if test="position() mod $cols_number_minimal = 0">
      <tr />
    </xsl:if>
  </xsl:template>


  <xsl:template name="normalize_memory">
    <!-- removes "G" or "M" and applies related multipliers -->
    <xsl:param name="value"/>

    <xsl:choose>
      <xsl:when test="../@type = 'pbs'">

        <xsl:choose>
          <xsl:when test="contains($value,'kb')">
            <xsl:value-of select="substring-before($value,'kb')"/>
          </xsl:when>
          <xsl:when test="contains($value,'Mb')">
            <xsl:value-of select="(substring-before($value,'Mb')) * 1024"/>
          </xsl:when>
          <xsl:when test="contains($value,'Gb')">
            <xsl:value-of select="(substring-before($value,'Gb')) * 1024 * 1024"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$value"/>
          </xsl:otherwise>
        </xsl:choose>

      </xsl:when>
      <xsl:otherwise>

        <xsl:choose>
          <xsl:when test="contains($value,'M')">
            <xsl:value-of select="(substring-before($value,'M')) * 1024"/>
          </xsl:when>
          <xsl:when test="contains($value,'G')">
            <xsl:value-of select="(substring-before($value,'G')) * 1024 * 1024"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$value"/>
          </xsl:otherwise>
        </xsl:choose>

      </xsl:otherwise>
    </xsl:choose>

  </xsl:template>


  <xsl:template name="draw_gauge">
    <!-- draws a progress bar -->
    <xsl:param name="value"/>
    <xsl:param name="max">100</xsl:param>

    <table style="width: 100%; text-align: left;" border="1" cellpadding="0" cellspacing="0">
      <tr>
        <!-- check value isnt zero or negative -->
        <xsl:choose>
          <xsl:when test="0 >= $value">
            <td style="width: {$host_details_bar_width}px;  background-color: #00ff00;">
              <img src="{$null}" border="0" alt="" width="{$host_details_bar_width}" height="{$host_details_bar_height}"/>
            </td>
          </xsl:when>
          <xsl:when test="$max = $value">
            <td style="width: {$host_details_bar_width}px;  background-color: #ff0000;">
              <img src="{$null}" border="0" alt="" width="{$host_details_bar_width}" height="{$host_details_bar_height}"/>
            </td>
          </xsl:when>
          <!-- check value is minor than max -->
          <xsl:when test="$value > $max">
            <td style="width: {$host_details_bar_width}px;  background-color: #ff0000;">
              <img src="{$null}" border="0" alt="" width="{$host_details_bar_width}" height="{$host_details_bar_height}"/>
            </td>
          </xsl:when>
          <xsl:otherwise>
            <td style="width: {($value * $host_details_bar_width) div $max}px;  background-color: #ff0000;">
              <img src="{$null}" border="0" alt="" width="{($value * $host_details_bar_width) div $max}" height="{$host_details_bar_height}"/>
            </td>
            <td style="width: {(($max - $value) * $host_details_bar_width) div $max}px;  background-color: #00ff00;">
              <img src="{$null}" border="0" alt="" width="{(($max - $value) * $host_details_bar_width) div $max}" height="{$host_details_bar_height}"/>
            </td>
          </xsl:otherwise>
        </xsl:choose>
      </tr>
    </table>
  </xsl:template>


  <!-- GRID:HOST mode="compact"  when unlicensed! -->
  <xsl:template match="grid:host[@licensed='false']" mode="compact" priority="+1">
    <td style="text-align: center; vertical-align: top; background-color: #D3D0C3">
      <xsl:value-of select="@name" />
      <br />
      <xsl:apply-templates select="@licensed">
        <xsl:with-param name="mode">compact</xsl:with-param>
      </xsl:apply-templates>
      <br />
    </td>
  </xsl:template>


  <!-- GRID:HOST mode="compact" type="pbs" -->
  <xsl:template match="grid:host[position() mod $cols_number = 0 and @type = 'pbs']" mode="compact" >
    <xsl:variable name="cpu_gauge">
      <xsl:choose>
        <xsl:when test="number(substring-before(grid:resource[@name='ut'], '/')) = 0">
          <xsl:value-of select="number(ceiling($hostcellspace div 100))" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="((number(substring-before(grid:resource[@name='ut'], '/'))) div (number(substring-after(grid:resource[@name='ut'], '/'))) * $hostcellspace) div 100"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="free">
      <xsl:call-template name="normalize_memory">
         <xsl:with-param name="value"><xsl:value-of select="grid:resource[@name='mem']"/></xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="max">
      <xsl:call-template name="normalize_memory">
        <xsl:with-param name="value"><xsl:value-of select="grid:resource[@name='mem']/@max"/></xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="mem_gauge"><xsl:value-of select="ceiling((($free) div number($max)) * $hostcellspace)"/></xsl:variable>

    <xsl:variable name="action-url">
      <xsl:value-of select="$url"/>
      <xsl:text>?_uri=//com.enginframe.</xsl:text>
      <xsl:value-of select="encode:forUriComponent(../@type)"/>
      <xsl:text>/host.info&amp;_host=</xsl:text>
      <xsl:value-of select="encode:forUriComponent(@name)"/>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="grid:status/@batch = 'ok'">
        <td bgcolor="#baf2ab" valign="top">
          <table border="0" cellpadding="0" cellspacing="0">
            <tr>
              <td>
                <img src="{$null}" width="4" height="20" alt="" />
              </td>
            <td align="center">
              <xsl:choose>
                <xsl:when test="@arch-family">
                  <img src="/{$_root_context}/images/arch-family/20x20/{encode:forUriComponent(@arch-family)}.gif" alt="{@name}" title="{@name}" width="20" height="20" border="0" align="center" />
                </xsl:when>
                <xsl:when test="@arch">
                  <img src="/{$_root_context}/images/arch-family/20x20/{encode:forUriComponent(@arch)}.gif" alt="{@name}" title="{@name}" width="20" height="20" border="0" align="center" />
                </xsl:when>
                <xsl:otherwise>
                  <img src="/{$_root_context}/images/arch-family/20x20/UNKNOWN.gif" alt="{@name}" title="{@name}" width="20" height="20" border="0" align="center" />
                </xsl:otherwise>
              </xsl:choose>
            </td>
            <td>
              <img src="{$null}" width="4" height="20" alt="" />
            </td>
            <td>
              <table border="0" cellpadding="0" cellspacing="0">
                <tr>
                  <td>
                    <a href="{$action-url}">
                      <xsl:value-of select="@name"/>
                    </a>
                  </td>
                </tr>
                <tr>
                  <td>
                    <font size="-2"><xsl:value-of select="@arch"/></font>
                  </td>
                </tr>
              </table>
              </td>
            </tr>
            <tr>
              <td colspan="4">
                <table border="0" cellpadding="0" cellspacing="0">
                  <tr>
                    <td><img src="/{$_root_context}/images/cpu_small.gif" alt="CPU" /></td>
                    <td>
                      <img src="/{$_root_context}/images/bluedot.gif" width="{$cpu_gauge}" height="4" alt="" />
                      <xsl:if test="($hostcellspace - $cpu_gauge) > 0">
                        <img src="/{$_root_context}/images/graydot.gif" width="{$hostcellspace - $cpu_gauge}" height="4" alt="" />
                      </xsl:if>
                      <img src="/{$_root_context}/images/graydot_2.gif" width="2" height="3" alt="" />
                      <br/>
                      <img src="/{$_root_context}/images/bluedot_2.gif" width="{$cpu_gauge}" height="2" alt="" />
                      <img src="/{$_root_context}/images/graydot_2.gif" width="{$hostcellspace - $cpu_gauge + 2}" height="2" alt="" />
                    </td>
                  </tr>
                  <tr>
                    <td><img src="/{$_root_context}/images/mem_small.gif" alt="MEM" /></td>
                    <td>
                      <img src="/{$_root_context}/images/browndot.gif" width="{$mem_gauge}" height="4" alt="" />
                      <xsl:if test="($hostcellspace - $mem_gauge) > 0">
                        <img src="/{$_root_context}/images/graydot.gif" width="{$hostcellspace - $mem_gauge}" height="4" alt="" />
                      </xsl:if>
                      <img src="/{$_root_context}/images/graydot_2.gif" width="2" height="3" alt="" />
                      <br/>
                      <img src="/{$_root_context}/images/browndot_2.gif" width="{$mem_gauge}" height="2" alt="" />
                      <img src="/{$_root_context}/images/graydot_2.gif" width="{$hostcellspace - $mem_gauge + 2}" height="2" alt="" />
                    </td>
                  </tr>
                  <tr>
                  <td colspan="4">
                      <img src="{$null}" width="100%" height="1" alt="" />
                    </td>
                  </tr>
                </table>
              </td>
            </tr>
            <tr>
              <td colspan="4">
                <img src="{$null}" width="{$hostcellspace + 14}" height="1" alt="" />
              </td>
            </tr>
          </table>
        </td>
      </xsl:when>
      <xsl:when test="grid:status/@batch = 'unavail' or grid:status/@batch = 'unreach'">
        <td bgcolor="#ffb5b5" valign="top">
          <center><a href="{$action-url}"><xsl:value-of select="@name"/></a></center>
          <br/>
          <center><xsl:value-of select="grid:status/@batch"/></center>
          <br/>
          <img src="{$null}" width="{$hostcellspace}" height="1" alt="" />
        </td>
      </xsl:when>
      <xsl:otherwise>
        <td bgcolor="#fffdb5">
          <table border="0" cellpadding="0" cellspacing="0">
            <tr>
              <td>
                <img src="{$null}" width="4" height="20" alt="" />
              </td>
              <td align="center">
                <xsl:choose>
                  <xsl:when test="@arch-family">
                    <img src="/{$_root_context}/images/arch-family/20x20/{encode:forUriComponent(@arch-family)}.gif" alt="{@name}" title="{@name}" width="20" height="20" border="0" align="center" />
                  </xsl:when>
                  <xsl:when test="@arch">
                    <img src="/{$_root_context}/images/arch-family/20x20/{encode:forUriComponent(@arch)}.gif" alt="{@name}" title="{@name}" width="20" height="20" border="0" align="center" />
                  </xsl:when>
                  <xsl:otherwise>
                    <img src="/{$_root_context}/images/arch-family/20x20/UNKNOWN.gif" alt="{@name}" title="{@name}" width="20" height="20" border="0" align="center" />
                  </xsl:otherwise>
                </xsl:choose>
              </td>
              <td>
                <img src="{$null}" width="4" height="20" alt="" />
              </td>
              <td>
                <table border="0" cellpadding="0" cellspacing="0">
                  <tr>
                    <td>
                      <a href="{$action-url}">
                        <xsl:value-of select="@name"/>
                      </a>
                    </td>
                  </tr>
                  <tr>
                    <td>
                      <font size="-2"><xsl:value-of select="@arch"/></font>
                    </td>
                  </tr>
                </table>
              </td>
            </tr>
            <tr>
              <td colspan="4">
                <table border="0" cellpadding="0" cellspacing="0">
                  <tr>
                    <td><img src="/{$_root_context}/images/cpu_small.gif" alt="CPU" /></td>
                    <td>
                      <img src="/{$_root_context}/images/bluedot.gif" width="{$cpu_gauge}" height="4" alt="" />
                      <xsl:if test="($hostcellspace - $cpu_gauge) > 0">
                        <img src="/{$_root_context}/images/graydot.gif" width="{$hostcellspace - $cpu_gauge}" height="4" alt="" />
                      </xsl:if>
                      <img src="/{$_root_context}/images/graydot_2.gif" width="2" height="3" alt="" />
                      <br/>
                      <img src="/{$_root_context}/images/bluedot_2.gif" width="{$cpu_gauge}" height="2" alt="" />
                      <img src="/{$_root_context}/images/graydot_2.gif" width="{$hostcellspace - $cpu_gauge + 2}" height="2" alt="" />
                    </td>
                  </tr>
                  <tr>
                    <td><img src="/{$_root_context}/images/mem_small.gif" alt="MEM" /></td>
                    <td>
                      <img src="/{$_root_context}/images/browndot.gif" width="{$mem_gauge}" height="4" alt="" />
                      <xsl:if test="($hostcellspace - $mem_gauge) > 0">
                        <img src="/{$_root_context}/images/graydot.gif" width="{$hostcellspace - $mem_gauge}" height="4" alt="" />
                      </xsl:if>
                      <img src="/{$_root_context}/images/graydot_2.gif" width="2" height="3" alt="" />
                      <br/>
                      <img src="/{$_root_context}/images/browndot_2.gif" width="{$mem_gauge}" height="2" alt="" />
                      <img src="/{$_root_context}/images/graydot_2.gif" width="{$hostcellspace - $mem_gauge + 2}" height="2" alt="" />
                    </td>
                  </tr>
                  <tr>
                    <td colspan="4">
                      <img src="{$null}" width="100%" height="1" alt="" />
                    </td>
                  </tr>
                </table>
              </td>
            </tr>
            <tr>
              <td colspan="4">
                <img src="{$null}" width="{$hostcellspace + 14}" height="1" alt="" />
              </td>
            </tr>
          </table>
        </td>
      </xsl:otherwise>
    </xsl:choose>
    <tr/>
  </xsl:template>


  <xsl:template match="grid:host[@type='pbs' and not(position() mod $cols_number = 0)]" mode="compact">
    <xsl:variable name="cpu_gauge">
      <xsl:choose>
        <xsl:when test="number(substring-before(grid:resource[@name='ut'], '/')) = 0">
          <xsl:value-of select="number(ceiling($hostcellspace div 100))" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="((number(substring-before(grid:resource[@name='ut'], '/'))) div (number(substring-after(grid:resource[@name='ut'], '/'))) * $hostcellspace) div 100"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="free">
      <xsl:call-template name="normalize_memory">
         <xsl:with-param name="value"><xsl:value-of select="grid:resource[@name='mem']"/></xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="max">
      <xsl:call-template name="normalize_memory">
        <xsl:with-param name="value"><xsl:value-of select="grid:resource[@name='mem']/@max"/></xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="mem_gauge"><xsl:value-of select="ceiling((($free) div number($max)) * $hostcellspace)"/></xsl:variable>

    <xsl:variable name="action-url">
      <xsl:value-of select="$url"/>
      <xsl:text>?_uri=//com.enginframe.</xsl:text>
      <xsl:value-of select="encode:forUriComponent(../@type)"/>
      <xsl:text>/host.info&amp;_host=</xsl:text>
      <xsl:value-of select="encode:forUriComponent(@name)"/>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="grid:status/@batch = 'ok'">
        <td bgcolor="#baf2ab" valign="top">
          <table border="0" cellpadding="0" cellspacing="0">
            <tr>
              <td>
                <img src="{$null}" width="4" height="20" alt="" />
              </td>
              <td align="center">
                <xsl:choose>
                  <xsl:when test="@arch-family">
                    <img src="/{$_root_context}/images/arch-family/20x20/{encode:forUriComponent(@arch-family)}.gif" alt="{@name}" title="{@name}" width="20" height="20" border="0" align="center" />
                  </xsl:when>
                  <xsl:when test="@arch">
                    <img src="/{$_root_context}/images/arch-family/20x20/{encode:forUriComponent(@arch)}.gif" alt="{@name}" title="{@name}" width="20" height="20" border="0" align="center" />
                  </xsl:when>
                  <xsl:otherwise>
                    <img src="/{$_root_context}/images/arch-family/20x20/UNKNOWN.gif" alt="{@name}" title="{@name}" width="20" height="20" border="0" align="center" />
                  </xsl:otherwise>
                </xsl:choose>
              </td>
              <td>
                <img src="{$null}" width="4" height="20" alt="" />
              </td>
              <td>
                <table border="0" cellpadding="0" cellspacing="0">
                  <tr>
                    <td>
                      <a href="{$action-url}">
                        <xsl:value-of select="@name"/>
                      </a>
                    </td>
                  </tr>
                  <tr>
                    <td>
                      <font size="-2"><xsl:value-of select="@arch"/></font>
                    </td>
                  </tr>
                </table>
              </td>
            </tr>
            <tr>
            <td colspan="4">
                <table border="0" cellpadding="0" cellspacing="0">
                  <tr>
                    <td><img src="/{$_root_context}/images/cpu_small.gif" alt="CPU" /></td>
                    <td>
                      <img src="/{$_root_context}/images/bluedot.gif" width="{$cpu_gauge}" height="4" alt="" />
                      <xsl:if test="($hostcellspace - $cpu_gauge) > 0">
                        <img src="/{$_root_context}/images/graydot.gif" width="{$hostcellspace - $cpu_gauge}" height="4" alt="" />
                      </xsl:if>
                      <img src="/{$_root_context}/images/graydot_2.gif" width="2" height="3" alt="" />
                      <br/>
                      <img src="/{$_root_context}/images/bluedot_2.gif" width="{$cpu_gauge}" height="2" alt="" />
                      <img src="/{$_root_context}/images/graydot_2.gif" width="{$hostcellspace - $cpu_gauge + 2}" height="2" alt="" />
                    </td>
                  </tr>
                  <tr>
                    <td><img src="/{$_root_context}/images/mem_small.gif" alt="MEM" /></td>
                    <td>
                      <img src="/{$_root_context}/images/browndot.gif" width="{$mem_gauge}" height="4" alt="" />
                      <xsl:if test="($hostcellspace - $mem_gauge) > 0">
                        <img src="/{$_root_context}/images/graydot.gif" width="{$hostcellspace - $mem_gauge}" height="4" alt="" />
                      </xsl:if>
                      <img src="/{$_root_context}/images/graydot_2.gif" width="2" height="3" alt="" />
                      <br/>
                      <img src="/{$_root_context}/images/browndot_2.gif" width="{$mem_gauge}" height="2" alt="" />
                      <img src="/{$_root_context}/images/graydot_2.gif" width="{$hostcellspace - $mem_gauge + 2}" height="2" alt="" />
                    </td>
                  </tr>
                  <tr>
                    <td colspan="4">
                      <img src="{$null}" width="100%" height="1" alt="" />
                    </td>
                  </tr>
                </table>
              </td>
            </tr>
            <tr>
              <td colspan="4">
                <img src="{$null}" width="{$hostcellspace + 14}" height="1" alt="" />
              </td>
            </tr>
          </table>
        </td>
      </xsl:when>
      <xsl:when test="grid:status/@batch = 'unavail' or grid:status/@batch = 'unreach' or grid:status/@batch = 'unlicensed'">
        <td bgcolor="#ffb5b5" valign="top">
          <center><a href="{$action-url}"><xsl:value-of select="@name"/></a></center>
          <br/>
          <center><xsl:value-of select="grid:status/@batch"/></center>
          <br/>
          <img src="{$null}" width="{$hostcellspace}" height="1" alt="" />
        </td>
      </xsl:when>
      <xsl:otherwise>
        <td bgcolor="#fffdb5" valign="top">
          <table border="0" cellpadding="0" cellspacing="0">
            <tr>
              <td>
                <img src="{$null}" width="4" height="20" alt="" />
              </td>
              <td align="center">
                <xsl:choose>
                  <xsl:when test="@arch-family">
                    <img src="/{$_root_context}/images/arch-family/20x20/{encode:forUriComponent(@arch-family)}.gif" alt="{@name}" title="{@name}" width="20" height="20" border="0" align="center" />
                  </xsl:when>
                  <xsl:when test="@arch">
                    <img src="/{$_root_context}/images/arch-family/20x20/{encode:forUriComponent(@arch)}.gif" alt="{@name}" title="{@name}" width="20" height="20" border="0" align="center" />
                  </xsl:when>
                  <xsl:otherwise>
                    <img src="/{$_root_context}/images/arch-family/20x20/UNKNOWN.gif" alt="{@name}" title="{@name}" width="20" height="20" border="0" align="center" />
                  </xsl:otherwise>
                </xsl:choose>
              </td>
              <td>
                <img src="{$null}" width="4" height="20" alt="" />
              </td>
              <td>
                <table border="0" cellpadding="0" cellspacing="0">
                  <tr>
                    <td>
                      <a href="{$action-url}">
                        <xsl:value-of select="@name"/>
                      </a>
                    </td>
                  </tr>
                  <tr>
                    <td>
                      <font size="-2"><xsl:value-of select="@arch"/></font>
                    </td>
                  </tr>
                </table>
              </td>
            </tr>
            <tr>
              <td colspan="4">
                <table border="0" cellpadding="0" cellspacing="0">
                  <tr>
                    <td><img src="/{$_root_context}/images/cpu_small.gif" alt="CPU" /></td>
                    <td>
                      <img src="/{$_root_context}/images/bluedot.gif" width="{$cpu_gauge}" height="4" alt="" />
                      <xsl:if test="($hostcellspace - $cpu_gauge) > 0">
                        <img src="/{$_root_context}/images/graydot.gif" width="{$hostcellspace - $cpu_gauge}" height="4" alt="" />
                      </xsl:if>
                      <img src="/{$_root_context}/images/graydot_2.gif" width="2" height="3" alt="" />
                      <br/>
                      <img src="/{$_root_context}/images/bluedot_2.gif" width="{$cpu_gauge}" height="2" alt="" />
                      <img src="/{$_root_context}/images/graydot_2.gif" width="{$hostcellspace - $cpu_gauge + 2}" height="2" alt="" />
                    </td>
                  </tr>
                  <tr>
                    <td><img src="/{$_root_context}/images/mem_small.gif" alt="MEM" /></td>
                    <td>
                      <img src="/{$_root_context}/images/browndot.gif" width="{$mem_gauge}" height="4" alt="" />
                      <xsl:if test="($hostcellspace - $mem_gauge) > 0">
                        <img src="/{$_root_context}/images/graydot.gif" width="{$hostcellspace - $mem_gauge}" height="4" alt="" />
                      </xsl:if>
                      <img src="/{$_root_context}/images/graydot_2.gif" width="2" height="3" alt="" />
                      <br/>
                      <img src="/{$_root_context}/images/browndot_2.gif" width="{$mem_gauge}" height="2" alt="" />
                      <img src="/{$_root_context}/images/graydot_2.gif" width="{$hostcellspace - $mem_gauge + 2}" height="2" alt="" />
                    </td>
                  </tr>
                  <tr>
                    <td colspan="4">
                     <img src="{$null}" width="100%" height="1" alt="" />
                    </td>
                  </tr>
                </table>
              </td>
            </tr>
            <tr>
              <td colspan="4">
               <img src="{$null}" width="{$hostcellspace + 14}" height="1" alt="" />
              </td>
            </tr>
          </table>
        </td>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- GRID:HOST mode="compact" -->
  <xsl:template match="grid:host[(position()) mod $cols_number = 0 and not(@type= 'pbs') ]" mode="compact">
    <xsl:variable name="cpu_gauge">
      <xsl:choose>
        <xsl:when test="number(ceiling(grid:resource[@name='ut'])) = 0">
          <xsl:value-of select="number(ceiling($hostcellspace div 100))" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='ut'] * $hostcellspace) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="mem_gauge"><xsl:value-of select="ceiling((number(substring-before(grid:resource[@name='mem'],'M')) div number(substring-before(grid:resource[@name='mem']/@max,'M'))) * $hostcellspace)"/></xsl:variable>
    <xsl:variable name="swp_gauge"><xsl:value-of select="ceiling((number(substring-before(grid:resource[@name='swp'],'M')) div number(substring-before(grid:resource[@name='swp']/@max,'M'))) * $hostcellspace)"/></xsl:variable>
    <xsl:variable name="action-url">
      <xsl:value-of select="$url"/>
      <xsl:text>?_uri=//com.enginframe.</xsl:text>
      <xsl:value-of select="encode:forUriComponent(../@type)"/>
      <xsl:text>/host.info&amp;_host=</xsl:text>
      <xsl:value-of select="encode:forUriComponent(@name)"/>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="grid:status/@batch = 'ok'">
        <td bgcolor="#baf2ab" valign="top">
          <table border="0" cellpadding="0" cellspacing="0">
            <tr>
              <td>
                <img src="{$null}" width="4" height="20" alt="" />
              </td>
            <td align="center">
              <xsl:choose>
                <xsl:when test="@arch-family">
                  <img src="/{$_root_context}/images/arch-family/20x20/{encode:forUriComponent(@arch-family)}.gif" alt="{@name}" title="{@name}" width="20" height="20" border="0" align="center" />
                </xsl:when>
                <xsl:when test="@arch">
                  <img src="/{$_root_context}/images/arch-family/20x20/{encode:forUriComponent(@arch)}.gif" alt="{@name}" title="{@name}" width="20" height="20" border="0" align="center" />
                </xsl:when>
                <xsl:otherwise>
                  <img src="/{$_root_context}/images/arch-family/20x20/UNKNOWN.gif" alt="{@name}" title="{@name}" width="20" height="20" border="0" align="center" />
                </xsl:otherwise>
              </xsl:choose>
            </td>
            <td>
              <img src="{$null}" width="4" height="20" alt="" />
            </td>
            <td>
              <table border="0" cellpadding="0" cellspacing="0">
              <tr>
                <td>
                    <a href="{$action-url}">
                        <xsl:value-of select="@name"/>
                      </a>
                    </td>
                  </tr>
                  <tr>
                    <td>
                    <font size="-2"><xsl:value-of select="@arch"/></font>
                  </td>
                </tr>
              </table>
              </td>
            </tr>
            <tr>
              <td colspan="4">
                <table border="0" cellpadding="0" cellspacing="0">
                  <tr>
                    <td><img src="/{$_root_context}/images/cpu_small.gif" alt="CPU" /></td>
                    <td>
                      <img src="/{$_root_context}/images/bluedot.gif" width="{$cpu_gauge}" height="4" alt="" />
                      <xsl:if test="($hostcellspace - $cpu_gauge) > 0">
                        <img src="/{$_root_context}/images/graydot.gif" width="{$hostcellspace - $cpu_gauge}" height="4" alt="" />
                      </xsl:if>
                      <img src="/{$_root_context}/images/graydot_2.gif" width="2" height="3" alt="" />
                      <br/>
                      <img src="/{$_root_context}/images/bluedot_2.gif" width="{$cpu_gauge}" height="2" alt="" />
                      <img src="/{$_root_context}/images/graydot_2.gif" width="{$hostcellspace - $cpu_gauge + 2}" height="2" alt="" />
                    </td>
                  </tr>
                  <tr>
                    <td><img src="/{$_root_context}/images/mem_small.gif" alt="MEM" /></td>
                    <td>
                      <img src="/{$_root_context}/images/browndot.gif" width="{$mem_gauge}" height="4" alt="" />
                      <xsl:if test="($hostcellspace - $mem_gauge) > 0">
                        <img src="/{$_root_context}/images/graydot.gif" width="{$hostcellspace - $mem_gauge}" height="4" alt="" />
                      </xsl:if>
                      <img src="/{$_root_context}/images/graydot_2.gif" width="2" height="3" alt="" />
                      <br/>
                      <img src="/{$_root_context}/images/browndot_2.gif" width="{$mem_gauge}" height="2" alt="" />
                      <img src="/{$_root_context}/images/graydot_2.gif" width="{$hostcellspace - $mem_gauge + 2}" height="2" alt="" />
                    </td>
                  </tr>
                  <tr>
                    <td><img src="/{$_root_context}/images/swp_small.gif" alt="SWP" /></td>
                    <td>
                      <img src="/{$_root_context}/images/velvetdot.gif" width="{$swp_gauge}" height="4" alt="" />
                      <xsl:if test="($hostcellspace - $swp_gauge) > 0">
                        <img src="/{$_root_context}/images/graydot.gif" width="{$hostcellspace - $swp_gauge}" height="4" alt="" />
                      </xsl:if>
                      <img src="/{$_root_context}/images/graydot_2.gif" width="2" height="3" alt="" />
                      <br/>
                      <img src="/{$_root_context}/images/velvetdot_2.gif" width="{$swp_gauge}" height="2" alt="" />
                      <img src="/{$_root_context}/images/graydot_2.gif" width="{$hostcellspace - $swp_gauge + 2}" height="2" alt="" /><br/>
                      <img src="{$null}" width="{$hostcellspace + 2}" height="1" alt="" />
                    </td>
                  </tr>
                  <tr>
                  <td colspan="4">
                      <img src="{$null}" width="100%" height="1" alt="" />
                    </td>
                  </tr>
                </table>
              </td>
            </tr>
            <tr>
              <td colspan="4">
                <img src="{$null}" width="{$hostcellspace + 14}" height="1" alt="" />
              </td>
            </tr>
          </table>
        </td>
      </xsl:when>
      <xsl:when test="grid:status/@batch = 'unavail' or grid:status/@batch = 'unreach'">
        <td bgcolor="#ffb5b5" valign="top">
          <center><a href="{$action-url}"><xsl:value-of select="@name"/></a></center>
          <br/>
          <center><xsl:value-of select="grid:status/@batch"/></center>
          <br/>
          <img src="{$null}" width="{$hostcellspace}" height="1" alt="" />
        </td>
      </xsl:when>
      <xsl:otherwise>
        <td bgcolor="#fffdb5">
          <table border="0" cellpadding="0" cellspacing="0">
            <tr>
              <td>
                <img src="{$null}" width="4" height="20" alt="" />
              </td>
              <td align="center">
                <xsl:choose>
                  <xsl:when test="@arch-family">
                    <img src="/{$_root_context}/images/arch-family/20x20/{encode:forUriComponent(@arch-family)}.gif" alt="{@name}" title="{@name}" width="20" height="20" border="0" align="center" />
                  </xsl:when>
                  <xsl:when test="@arch">
                    <img src="/{$_root_context}/images/arch-family/20x20/{encode:forUriComponent(@arch)}.gif" alt="{@name}" title="{@name}" width="20" height="20" border="0" align="center" />
                  </xsl:when>
                  <xsl:otherwise>
                    <img src="/{$_root_context}/images/arch-family/20x20/UNKNOWN.gif" alt="{@name}" title="{@name}" width="20" height="20" border="0" align="center" />
                  </xsl:otherwise>
                </xsl:choose>
              </td>
              <td>
                <img src="{$null}" width="4" height="20" alt="" />
              </td>
              <td>
                <table border="0" cellpadding="0" cellspacing="0">
                  <tr>
                    <td>
                      <a href="{$action-url}">
                        <xsl:value-of select="@name"/>
                      </a>
                    </td>
                  </tr>
                  <tr>
                    <td>
                      <font size="-2"><xsl:value-of select="@arch"/></font>
                    </td>
                  </tr>
                </table>
              </td>
            </tr>
            <tr>
              <td colspan="4">
                <table border="0" cellpadding="0" cellspacing="0">
                  <tr>
                    <td><img src="/{$_root_context}/images/cpu_small.gif" alt="CPU" /></td>
                    <td>
                      <img src="/{$_root_context}/images/bluedot.gif" width="{$cpu_gauge}" height="4" alt="" />
                      <xsl:if test="($hostcellspace - $cpu_gauge) > 0">
                        <img src="/{$_root_context}/images/graydot.gif" width="{$hostcellspace - $cpu_gauge}" height="4" alt="" />
                      </xsl:if>
                      <img src="/{$_root_context}/images/graydot_2.gif" width="2" height="3" alt="" />
                      <br/>
                      <img src="/{$_root_context}/images/bluedot_2.gif" width="{$cpu_gauge}" height="2" alt="" />
                      <img src="/{$_root_context}/images/graydot_2.gif" width="{$hostcellspace - $cpu_gauge + 2}" height="2" alt="" />
                    </td>
                  </tr>
                  <tr>
                    <td><img src="/{$_root_context}/images/mem_small.gif" alt="MEM" /></td>
                    <td>
                      <img src="/{$_root_context}/images/browndot.gif" width="{$mem_gauge}" height="4" alt="" />
                      <xsl:if test="($hostcellspace - $mem_gauge) > 0">
                        <img src="/{$_root_context}/images/graydot.gif" width="{$hostcellspace - $mem_gauge}" height="4" alt="" />
                      </xsl:if>
                      <img src="/{$_root_context}/images/graydot_2.gif" width="2" height="3" alt="" />
                      <br/>
                      <img src="/{$_root_context}/images/browndot_2.gif" width="{$mem_gauge}" height="2" alt="" />
                      <img src="/{$_root_context}/images/graydot_2.gif" width="{$hostcellspace - $mem_gauge + 2}" height="2" alt="" />
                    </td>
                  </tr>
                  <tr>
                    <td><img src="/{$_root_context}/images/swp_small.gif" alt="SWP" /></td>
                    <td>
                      <img src="/{$_root_context}/images/velvetdot.gif" width="{$swp_gauge}" height="4" alt="" />
                      <xsl:if test="($hostcellspace - $swp_gauge) > 0">
                        <img src="/{$_root_context}/images/graydot.gif" width="{$hostcellspace - $swp_gauge}" height="4" alt="" />
                      </xsl:if>
                      <img src="/{$_root_context}/images/graydot_2.gif" width="2" height="3" alt="" />
                      <br/>
                      <img src="/{$_root_context}/images/velvetdot_2.gif" width="{$swp_gauge}" height="2" alt="" />
                      <img src="/{$_root_context}/images/graydot_2.gif" width="{$hostcellspace - $swp_gauge + 2}" height="2" alt="" /><br/>
                      <img src="{$null}" width="{$hostcellspace + 2}" height="1" alt="" />
                    </td>
                  </tr>
                  <tr>
                    <td colspan="4">
                      <img src="{$null}" width="100%" height="1" alt="" />
                    </td>
                  </tr>
                </table>
              </td>
            </tr>
            <tr>
              <td colspan="4">
                <img src="{$null}" width="{$hostcellspace + 14}" height="1" alt="" />
              </td>
            </tr>
          </table>
        </td>
      </xsl:otherwise>
    </xsl:choose>
    <tr/>
  </xsl:template>


  <xsl:template match="grid:host" mode="compact">
    <xsl:variable name="cpu_gauge">
      <xsl:choose>
        <xsl:when test="number(ceiling(grid:resource[@name='ut'])) = 0">
          <xsl:value-of select="number(ceiling($hostcellspace div 100))" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(ceiling((grid:resource[@name='ut'] * $hostcellspace) div 100))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="mem_gauge"><xsl:value-of select="ceiling((number(substring-before(grid:resource[@name='mem'],'M')) div number(substring-before(grid:resource[@name='mem']/@max,'M'))) * $hostcellspace)"/></xsl:variable>
    <xsl:variable name="swp_gauge"><xsl:value-of select="ceiling((number(substring-before(grid:resource[@name='swp'],'M')) div number(substring-before(grid:resource[@name='swp']/@max,'M'))) * $hostcellspace)"/></xsl:variable>
    <xsl:variable name="action-url">
      <xsl:value-of select="$url"/>
      <xsl:text>?_uri=//com.enginframe.</xsl:text>
      <xsl:value-of select="encode:forUriComponent(../@type)"/>
      <xsl:text>/host.info&amp;_host=</xsl:text>
      <xsl:value-of select="encode:forUriComponent(@name)"/>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="grid:status/@batch = 'ok'">
        <td bgcolor="#baf2ab" valign="top">
          <table border="0" cellpadding="0" cellspacing="0">
            <tr>
              <td>
                <img src="{$null}" width="4" height="20" alt="" />
              </td>
              <td align="center">
                <xsl:choose>
                  <xsl:when test="@arch-family">
                    <img src="/{$_root_context}/images/arch-family/20x20/{encode:forUriComponent(@arch-family)}.gif" alt="{@name}" title="{@name}" width="20" height="20" border="0" align="center" />
                  </xsl:when>
                  <xsl:when test="@arch">
                    <img src="/{$_root_context}/images/arch-family/20x20/{encode:forUriComponent(@arch)}.gif" alt="{@name}" title="{@name}" width="20" height="20" border="0" align="center" />
                  </xsl:when>
                  <xsl:otherwise>
                    <img src="/{$_root_context}/images/arch-family/20x20/UNKNOWN.gif" alt="{@name}" title="{@name}" width="20" height="20" border="0" align="center" />
                  </xsl:otherwise>
                </xsl:choose>
              </td>
              <td>
                <img src="{$null}" width="4" height="20" alt="" />
              </td>
              <td>
                <table border="0" cellpadding="0" cellspacing="0">
                  <tr>
                    <td>
                      <a href="{$action-url}">
                        <xsl:value-of select="@name"/>
                      </a>
                    </td>
                  </tr>
                  <tr>
                    <td>
                      <font size="-2"><xsl:value-of select="@arch"/></font>
                    </td>
                  </tr>
                </table>
              </td>
            </tr>
            <tr>
            <td colspan="4">
                <table border="0" cellpadding="0" cellspacing="0">
                  <tr>
                    <td><img src="/{$_root_context}/images/cpu_small.gif" alt="CPU" /></td>
                    <td>
                      <img src="/{$_root_context}/images/bluedot.gif" width="{$cpu_gauge}" height="4" alt="" />
                      <xsl:if test="($hostcellspace - $cpu_gauge) > 0">
                        <img src="/{$_root_context}/images/graydot.gif" width="{$hostcellspace - $cpu_gauge}" height="4" alt="" />
                      </xsl:if>
                      <img src="/{$_root_context}/images/graydot_2.gif" width="2" height="3" alt="" />
                      <br/>
                      <img src="/{$_root_context}/images/bluedot_2.gif" width="{$cpu_gauge}" height="2" alt="" />
                      <img src="/{$_root_context}/images/graydot_2.gif" width="{$hostcellspace - $cpu_gauge + 2}" height="2" alt="" />
                    </td>
                  </tr>
                  <tr>
                    <td><img src="/{$_root_context}/images/mem_small.gif" alt="MEM" /></td>
                    <td>
                      <img src="/{$_root_context}/images/browndot.gif" width="{$mem_gauge}" height="4" alt="" />
                      <xsl:if test="($hostcellspace - $mem_gauge) > 0">
                        <img src="/{$_root_context}/images/graydot.gif" width="{$hostcellspace - $mem_gauge}" height="4" alt="" />
                      </xsl:if>
                      <img src="/{$_root_context}/images/graydot_2.gif" width="2" height="3" alt="" />
                      <br/>
                      <img src="/{$_root_context}/images/browndot_2.gif" width="{$mem_gauge}" height="2" alt="" />
                      <img src="/{$_root_context}/images/graydot_2.gif" width="{$hostcellspace - $mem_gauge + 2}" height="2" alt="" />
                    </td>
                  </tr>
                  <tr>
                    <td><img src="/{$_root_context}/images/swp_small.gif" alt="SWP" /></td>
                    <td>
                      <img src="/{$_root_context}/images/velvetdot.gif" width="{$swp_gauge}" height="4" alt="" />
                      <xsl:if test="($hostcellspace - $swp_gauge) > 0">
                        <img src="/{$_root_context}/images/graydot.gif" width="{$hostcellspace - $swp_gauge}" height="4" alt="" />
                      </xsl:if>
                      <img src="/{$_root_context}/images/graydot_2.gif" width="2" height="3" alt="" />
                      <br/>
                      <img src="/{$_root_context}/images/velvetdot_2.gif" width="{$swp_gauge}" height="2" alt="" />
                      <img src="/{$_root_context}/images/graydot_2.gif" width="{$hostcellspace - $swp_gauge + 2}" height="2" alt="" /><br/>
                      <img src="{$null}" width="{$hostcellspace + 2}" height="1" alt="" />
                    </td>
                  </tr>
                  <tr>
                    <td colspan="4">
                      <img src="{$null}" width="100%" height="1" alt="" />
                    </td>
                  </tr>
                </table>
              </td>
            </tr>
            <tr>
              <td colspan="4">
                <img src="{$null}" width="{$hostcellspace + 14}" height="1" alt="" />
              </td>
            </tr>
          </table>
        </td>
      </xsl:when>
      <xsl:when test="grid:status/@batch = 'unavail' or grid:status/@batch = 'unreach' or grid:status/@batch = 'unlicensed'">
        <td bgcolor="#ffb5b5" valign="top">
          <center><a href="{$action-url}"><xsl:value-of select="@name"/></a></center>
          <br/>
          <center><xsl:value-of select="grid:status/@batch"/></center>
          <br/>
          <img src="{$null}" width="{$hostcellspace}" height="1" alt="" />
        </td>
      </xsl:when>
      <xsl:otherwise>
        <td bgcolor="#fffdb5" valign="top">
          <table border="0" cellpadding="0" cellspacing="0">
            <tr>
              <td>
                <img src="{$null}" width="4" height="20" alt="" />
              </td>
              <td align="center">
                <xsl:choose>
                  <xsl:when test="@arch-family">
                    <img src="/{$_root_context}/images/arch-family/20x20/{encode:forUriComponent(@arch-family)}.gif" alt="{@name}" title="{@name}" width="20" height="20" border="0" align="center" />
                  </xsl:when>
                  <xsl:when test="@arch">
                    <img src="/{$_root_context}/images/arch-family/20x20/{encode:forUriComponent(@arch)}.gif" alt="{@name}" title="{@name}" width="20" height="20" border="0" align="center" />
                  </xsl:when>
                  <xsl:otherwise>
                    <img src="/{$_root_context}/images/arch-family/20x20/UNKNOWN.gif" alt="{@name}" title="{@name}" width="20" height="20" border="0" align="center" />
                  </xsl:otherwise>
                </xsl:choose>
              </td>
              <td>
                <img src="{$null}" width="4" height="20" alt="" />
              </td>
              <td>
              <table border="0" cellpadding="0" cellspacing="0">
                <tr>
                  <td>
                    <a href="{$action-url}">
                      <xsl:value-of select="@name"/>
                    </a>
                  </td>
                </tr>
                <tr>
                  <td>
                    <font size="-2"><xsl:value-of select="@arch"/></font>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
          <tr>
            <td colspan="4">
                <table border="0" cellpadding="0" cellspacing="0">
                  <tr>
                    <td><img src="/{$_root_context}/images/cpu_small.gif" alt="CPU" /></td>
                    <td>
                      <img src="/{$_root_context}/images/bluedot.gif" width="{$cpu_gauge}" height="4" alt="" />
                      <xsl:if test="($hostcellspace - $cpu_gauge) > 0">
                        <img src="/{$_root_context}/images/graydot.gif" width="{$hostcellspace - $cpu_gauge}" height="4" alt="" />
                      </xsl:if>
                      <img src="/{$_root_context}/images/graydot_2.gif" width="2" height="3" alt="" />
                      <br/>
                      <img src="/{$_root_context}/images/bluedot_2.gif" width="{$cpu_gauge}" height="2" alt="" />
                      <img src="/{$_root_context}/images/graydot_2.gif" width="{$hostcellspace - $cpu_gauge + 2}" height="2" alt="" />
                    </td>
                  </tr>
                  <tr>
                    <td><img src="/{$_root_context}/images/mem_small.gif" alt="MEM" /></td>
                    <td>
                      <img src="/{$_root_context}/images/browndot.gif" width="{$mem_gauge}" height="4" alt="" />
                      <xsl:if test="($hostcellspace - $mem_gauge) > 0">
                        <img src="/{$_root_context}/images/graydot.gif" width="{$hostcellspace - $mem_gauge}" height="4" alt="" />
                      </xsl:if>
                      <img src="/{$_root_context}/images/graydot_2.gif" width="2" height="3" alt="" />
                      <br/>
                      <img src="/{$_root_context}/images/browndot_2.gif" width="{$mem_gauge}" height="2" alt="" />
                      <img src="/{$_root_context}/images/graydot_2.gif" width="{$hostcellspace - $mem_gauge + 2}" height="2" alt="" />
                    </td>
                  </tr>
                  <tr>
                    <td><img src="/{$_root_context}/images/swp_small.gif" alt="SWP" /></td>
                    <td>
                      <img src="/{$_root_context}/images/velvetdot.gif" width="{$swp_gauge}" height="4" alt="" />
                      <xsl:if test="($hostcellspace - $swp_gauge) > 0">
                        <img src="/{$_root_context}/images/graydot.gif" width="{$hostcellspace - $swp_gauge}" height="4" alt="" />
                      </xsl:if>
                      <img src="/{$_root_context}/images/graydot_2.gif" width="2" height="3" alt="" />
                      <br/>
                      <img src="/{$_root_context}/images/velvetdot_2.gif" width="{$swp_gauge}" height="2" alt="" />
                      <img src="/{$_root_context}/images/graydot_2.gif" width="{$hostcellspace - $swp_gauge + 2}" height="2" alt="" /><br/>
                      <img src="{$null}" width="{$hostcellspace + 2}" height="1" alt="" />
                    </td>
                  </tr>
                  <tr>
                    <td colspan="4">
                     <img src="{$null}" width="100%" height="1" alt="" />
                    </td>
                  </tr>
                </table>
              </td>
            </tr>
            <tr>
              <td colspan="4">
               <img src="{$null}" width="{$hostcellspace + 14}" height="1" alt="" />
              </td>
            </tr>
          </table>
        </td>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <!-- GRID:HOST mode="details"  when unlicensed ! -->
  <xsl:template match="grid:host[@licensed='false']" mode="details" priority="+1">
    <table class="Detailed" style="width: 100%">
      <tr>
        <th colspan="3" style="text-align: left">
          <span style="font-size: 110%">Host <em><xsl:value-of select="@name"/></em></span>
          &#160;
          <xsl:call-template name="ef_help">
            <xsl:with-param name="help-href">host-details.html</xsl:with-param>
          </xsl:call-template>
        </th>
      </tr>
      <tr>
        <td align="center" valign="center">
          <img src="{$null}" border="0" alt="" width="1" height="{$host_details_bar_height}"/>
        </td>
      </tr>
      <tr>
        <td style="vertical-align: top">
          <strong>Status:</strong>
        </td>
        <td>
          <xsl:apply-templates select="@licensed" />
        </td>
        <td style="vertical-align: top">
          <table style="width: 100%; text-align: left;" border="1" cellpadding="0" cellspacing="0">
            <tr>
              <td style="width: {$host_details_bar_width}px;  background-color: #ff0000;" bgcolor="#ff0000">
                <img src="{$null}" border="0" alt="" width="{$host_details_bar_width}" height="{$host_details_bar_height}"/>
              </td>
            </tr>
          </table>
        </td>
      </tr>
    </table>
  </xsl:template>


  <!-- GRID:HOST mode="details" -->
  <xsl:template match="grid:host" mode="details">
    <table class="Detailed" width="100%">
      <tr>
        <th style="text-align: left" colspan="3">
          <span style="font-size: 110%">Host <em><xsl:value-of select="@name"/></em></span>
          &#160;
          <xsl:call-template name="ef_help">
            <xsl:with-param name="help-href">host-details.html</xsl:with-param>
          </xsl:call-template>
        </th>
      </tr>
      <tr>
        <td align="center" valign="center">
          <img src="{$null}" border="0" alt="" width="1" height="{$host_details_bar_height}"/>
        </td>
      </tr>
      <tr>
        <td><strong>Status:</strong></td>
        <td>
          <xsl:choose>
            <xsl:when test="grid:status/@base">
              <xsl:value-of select="grid:status/@base"/>
            </xsl:when>
            <xsl:otherwise>
              -
            </xsl:otherwise>
          </xsl:choose>
          <xsl:if test="$show_base_batch_status = 1"> /<xsl:value-of select="grid:status/@batch"/></xsl:if>
        </td>
        <td>
          <xsl:choose>
            <xsl:when test="grid:status/@base='ok'">
              <table style="width: 100%; text-align: left;" border="1" cellpadding="0" cellspacing="0">
                <tr>
                  <td style="background-color: #00ff00;" bgcolor="#00ff00">
                    <img src="{$null}" border="0" alt="" width="{$host_details_bar_width}" height="{$host_details_bar_height}"/>
                  </td>
                </tr>
              </table>
            </xsl:when>
            <xsl:when test="grid:status/@batch = 'unavail' or grid:status/@batch = 'unreach' or grid:status/@batch = 'unlicensed'">
              <table style="width: 100%; text-align: left;" border="1" cellpadding="0" cellspacing="0">
                <tr>
                  <td style="width: {$host_details_bar_width}px;  background-color: #ff0000;" bgcolor="#ff0000">
                    <img src="{$null}" border="0" alt="" width="{$host_details_bar_width}" height="{$host_details_bar_height}"/>
                  </td>
                </tr>
              </table>
            </xsl:when>
            <xsl:otherwise>
              <table style="width: 100%; text-align: left;" border="1" cellpadding="0" cellspacing="0">
                <tr>
                  <td style="width: {$host_details_bar_width}px;  background-color: #fffdb5;" bgcolor="#fffdb5">
                    <img src="{$null}" border="0" alt="" width="{$host_details_bar_width}" height="{$host_details_bar_height}"/>
                  </td>
                </tr>
              </table>
            </xsl:otherwise>
          </xsl:choose>
        </td>
      </tr>
      <tr>
        <td><strong>Hardware:</strong></td><td></td>
        <xsl:choose>
          <xsl:when test="@arch-family">
            <td rowspan="6"><img src="/{$_root_context}/images/arch-family/{encode:forUriComponent(@arch-family)}.gif" alt=" "/></td>
          </xsl:when>
          <xsl:otherwise>
            <td rowspan="6"><img src="/{$_root_context}/images/arch-family/{encode:forUriComponent(@arch)}.gif" alt=" "/></td>
          </xsl:otherwise>
        </xsl:choose>
      </tr>
      <tr>
        <td>
          <ul>
            <li>Host type</li>
          </ul>
        </td>
        <td><xsl:value-of select="@arch"/></td>
      </tr>
      <xsl:if test="@model">
        <tr>
          <td>
            <ul>
              <li>Host model</li>
            </ul>
          </td>
          <td><xsl:value-of select="@model"/></td>
        </tr>
      </xsl:if>
      <tr>
        <td>
          <ul>
            <li>Number of processors<br/></li>
          </ul>
        </td>
        <td><xsl:value-of select="@ncpus"/></td>
      </tr>
      <tr>
        <td>
          <ul>
            <li>Physical memory<br/></li>
          </ul>
        </td>
        <td>
          <xsl:value-of select="grid:resource[@name='mem']/@max"/>
          <xsl:if test="not(grid:resource[@name='mem']/@max)">UNKNOWN</xsl:if>
        </td>
      </tr>
      <xsl:if test="not(../@type = 'pbs')" >
        <tr>
          <td>
            <ul>
              <li>Swap space<br/></li>
            </ul>
          </td>
          <td>
            <xsl:value-of select="grid:resource[@name='swp']/@max"/>
            <xsl:if test="not(grid:resource[@name='swp']/@max)">UNKNOWN</xsl:if>
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="grid:resource">
        <tr>
          <td><strong>Load:</strong></td><td></td><td></td>
        </tr>
      </xsl:if>
      <xsl:if test="grid:resource[@name='ls']">
        <tr>
          <td>
            <ul>
              <li>Number of users<br/></li>
            </ul>
          </td>
          <td><xsl:value-of select="grid:resource[@name='ls']"/></td>
          <td>
            <br/>
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="grid:resource[@name='ut']">
        <tr>
          <td>
            <ul>
              <li>CPU utilization<br/></li>
            </ul>
          </td>
          <td><xsl:apply-templates select="grid:resource[@name='ut']"/></td>
          <td>
            <xsl:choose>
              <xsl:when test="../@type = 'pbs'"></xsl:when>
              <xsl:otherwise>
                <xsl:call-template name="draw_gauge">
                  <xsl:with-param name="value"><xsl:value-of select="grid:resource[@name='ut']"/></xsl:with-param>
                </xsl:call-template>
              </xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="grid:resource[@name='r1m']">
        <tr>
          <td>
            <ul>
              <li>CPU run queue length<br/></li>
            </ul>
          </td>
          <td></td>
          <td>
            <br/>
          </td>
        </tr>
        <tr>
          <td>
            <ul>
              <ul><li>Averaged over 15 sec<br/></li></ul>
            </ul>
          </td>
          <td><xsl:value-of select="grid:resource[@name='r15s']"/></td>
          <td>
            <br/>
          </td>
        </tr>
        <tr>
          <td>
            <ul>
              <ul><li>Averaged over 1 min<br/></li></ul>
            </ul>
          </td>
          <td><xsl:value-of select="grid:resource[@name='r1m']"/></td>
          <td><br/>
          </td>
        </tr>
        <tr>
          <td>
            <ul>
              <ul><li>Averaged over 15 min<br/></li></ul>
            </ul>
          </td>
          <td><xsl:value-of select="grid:resource[@name='r15m']"/></td>
          <td><br/>
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="grid:resource[@name='mem']">
        <tr>
          <td>
            <ul>
              <li>Available physical memory<br/></li>
            </ul>
          </td>
          <td><xsl:value-of select="grid:resource[@name='mem']"/> / <xsl:value-of select="grid:resource[@name='mem']/@max"/></td>
          <td>
            <xsl:variable name="free">
              <xsl:call-template name="normalize_memory">
                <xsl:with-param name="value"><xsl:value-of select="grid:resource[@name='mem']"/></xsl:with-param>
              </xsl:call-template>
            </xsl:variable>
            <xsl:variable name="max">
              <xsl:call-template name="normalize_memory">
                <xsl:with-param name="value"><xsl:value-of select="grid:resource[@name='mem']/@max"/></xsl:with-param>
              </xsl:call-template>
            </xsl:variable>
            <xsl:choose>
              <xsl:when test="../@type = 'pbs'">
                <xsl:call-template name="draw_gauge">
                  <xsl:with-param name="value"><xsl:value-of select="$free"/></xsl:with-param>
                  <xsl:with-param name="max"><xsl:value-of select="$max"/></xsl:with-param>
                </xsl:call-template>
              </xsl:when>
              <xsl:otherwise>
                <xsl:call-template name="draw_gauge">
                  <xsl:with-param name="value"><xsl:value-of select="$max - $free"/></xsl:with-param>
                  <xsl:with-param name="max"><xsl:value-of select="$max"/></xsl:with-param>
                </xsl:call-template>
              </xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="grid:resource[@name='swp']">
        <tr>
          <td>
            <ul>
              <li>Available swap space<br/></li>
            </ul>
          </td>
          <td><xsl:value-of select="grid:resource[@name='swp']"/> / <xsl:value-of select="grid:resource[@name='swp']/@max"/></td>
          <td>
            <xsl:variable name="free">
              <xsl:call-template name="normalize_memory">
                <xsl:with-param name="value"><xsl:value-of select="grid:resource[@name='swp']"/></xsl:with-param>
              </xsl:call-template>
            </xsl:variable>
            <xsl:variable name="max">
              <xsl:call-template name="normalize_memory">
                <xsl:with-param name="value"><xsl:value-of select="grid:resource[@name='swp']/@max"/></xsl:with-param>
              </xsl:call-template>
            </xsl:variable>
            <xsl:call-template name="draw_gauge">
              <xsl:with-param name="value"><xsl:value-of select="$max - $free"/></xsl:with-param>
              <xsl:with-param name="max"><xsl:value-of select="$max"/></xsl:with-param>
            </xsl:call-template>
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="grid:resource[@name='tmp']">
        <tr>
          <td>
            <ul>
              <li>Free space in /tmp<br/></li>
            </ul>
          </td>
          <td><xsl:value-of select="grid:resource[@name='tmp']"/></td>
          <td><br/>
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="grid:resource[@name='pg']">
        <tr>
          <td>
            <ul>
              <li>Paging rate<br/></li>
            </ul>
          </td>
          <td><xsl:value-of select="grid:resource[@name='pg']"/> pages/sec</td>
          <td><br/>
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="grid:resource[@name='io']">
        <tr>
          <td>
            <ul>
              <li>I/O throughput<br/></li>
            </ul>
          </td>
          <td><xsl:value-of select="grid:resource[@name='io']"/> Kb/sec</td>
          <td><br/>
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="grid:resource[@name='it']">
        <tr>
          <td>
            <ul>
              <li>Idle time<br/></li>
            </ul>
          </td>
          <td><xsl:value-of select="grid:resource[@name='it']"/> min</td>
          <td><br/>
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="count(grid:resource) > 11">
        <tr>
          <td><strong>Other resources:</strong></td><td></td><td></td>
        </tr>
        <xsl:for-each select="grid:resource">
          <xsl:if test="@name != 'io' and @name != 'pg' and @name != 'tmp' and @name != 'swp' and @name != 'mem' and @name != 'r15s' and @name != 'r1m' and @name != 'r15m' and @name != 'ut' and @name != 'ls' and @name != 'it'">
          <tr><td>
            <ul>
              <li><xsl:value-of select="@name"/><br/></li>
            </ul>
          </td>
          <td><xsl:value-of select="."/></td>
          <td><br/>
          </td></tr>
          </xsl:if>
        </xsl:for-each>
      </xsl:if>
    </table>
  </xsl:template>

  <xsl:template match="grid:resource[@name='ut']">
    <xsl:value-of select="text()"/>
    <xsl:choose>
      <xsl:when test="../@type = 'pbs'" ></xsl:when>
      <xsl:otherwise>%</xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="grid:resource">
    <xsl:value-of select="text()"/>
    <xsl:if test="not(not(@max))">
      / <xsl:value-of select="@max"/>
    </xsl:if>
  </xsl:template>

  <!--
  Accessories
   -->

  <xsl:template match="grid:submission-time|grid:dispatch-time|grid:finish-time">
    <xsl:value-of select="@month"/>&#160;<xsl:value-of select="@day"/>&#160;<xsl:value-of select="@hour"/>:<xsl:value-of select="@minute"/>
  </xsl:template>

  <xsl:template match="grid:swap-usage" mode="title">
    <xsl:choose>
      <xsl:when test="../@type = 'pbs'"></xsl:when>
      <xsl:otherwise>Swap: <xsl:apply-templates/></xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="grid:memory-usage" mode="title">Memory: <xsl:apply-templates/></xsl:template>

  <xsl:template match="grid:total-cpu-usage" mode="title">CPU: <xsl:apply-templates/> s.</xsl:template>

  <xsl:template match="grid:execution-host[../@type = 'globus']">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="grid:submission-host|grid:execution-host[position() = 1]" priority="+1">
    <xsl:variable name="isDhtmlCapable"><xsl:call-template name="is_dhtml_capable"/></xsl:variable>
    <xsl:variable name="action-url">
      <xsl:value-of select="$url"/>
      <xsl:text>?_uri=//com.enginframe.</xsl:text>
      <xsl:value-of select="encode:forUriComponent(../@type)"/>
      <xsl:text>/host.info&amp;_host=</xsl:text>
      <xsl:value-of select="encode:forUriComponent(.)"/>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="($job_multicpu_details = 0) or not($isDhtmlCapable = 'true')">
        <a href="{$action-url}">
          <xsl:if test="../grid:total-cpu-usage or ../grid:swap-usage">
            <xsl:attribute name="title">
              Resource usage: <xsl:apply-templates select="../grid:total-cpu-usage|../grid:memory-usage|../grid:swap-usage" mode="title"/>
            </xsl:attribute>
          </xsl:if>
          <xsl:apply-templates/>
        </a>
        <xsl:if test="count(../grid:execution-host) > 1">
          (<xsl:value-of select="count(../grid:execution-host)"/>&#160;Hosts)
        </xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <xsl:if test="count(../grid:execution-host) = 1">
          <a href="{$action-url}">
            <xsl:if test="../grid:total-cpu-usage or ../grid:swap-usage">
              <xsl:attribute name="title">
                 Resource usage: <xsl:apply-templates select="../grid:total-cpu-usage|../grid:memory-usage|../grid:swap-usage" mode="title"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
          </a>
        </xsl:if>
        <xsl:if test="count(../grid:execution-host) > 1">
          <div id="xtraDetails{../@id}">
            <div><a href="javascript:void(0)" id="ShowHideDetails{../@id}" class="box-opened" onclick="toggleListControls('ShowHideDetails{../@id}', 'ExtraDetails{../@id}')">
            &#160;&#160;&#160;&#160;<xsl:value-of select="count(../grid:execution-host)"/>&#160;Hosts</a></div></div>
          <div id="ExtraDetails{../@id}" style="display:none"><div>
            <table class="Detailed">
              <tr>
                <td>
                  <xsl:for-each select="../grid:execution-host[not(text() = preceding-sibling::grid:execution-host)]">
                    <!-- TODO: create an ad-hoc template -->
                    <xsl:variable name="id" select="text()"/>
                    <xsl:choose>
                      <xsl:when test="@licensed = 'false'">
                        <span style="color: red" title="Host unlicensed">
                          <xsl:value-of select="text()" />
                          (<xsl:value-of select="count(following-sibling::grid:execution-host[text() = $id]) + 1"/>)
                        </span>
                      </xsl:when>
                      <xsl:otherwise>
                        <a href="{$action-url}">
                          <xsl:if test="../grid:total-cpu-usage or ../grid:swap-usage">
                            <xsl:attribute name="title">
                              Resource usage: <xsl:apply-templates select="../grid:total-cpu-usage|../grid:memory-usage|../grid:swap-usage" mode="title"/>
                            </xsl:attribute>
                          </xsl:if>
                          <xsl:apply-templates/>
                          (<xsl:value-of select="count(following-sibling::grid:execution-host[text() = $id]) + 1"/>)
                        </a>
                      </xsl:otherwise>
                    </xsl:choose>
                    <br/>
                  </xsl:for-each>
                </td>
              </tr>
            </table>
          </div></div>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="grid:submission-host|grid:execution-host[position() > 1]" priority="+1" />

</xsl:stylesheet>
