<?xml version = "1.0" encoding = "utf-8"?>

<!--
  EnginFrame Online Help
  ======================

  This XSL handle everything related to EnginFrame Online Help

  If you want to add help to your XSLT, you must call the template:
    ef_help

  using these optional parameters:

  * help-plugin: if help is not related to system (defaults to '')
    * you need to specify this, only if the help you want to show is not related to the system
  * help-type:  the help type (defaults to 'info')
  * help-text: tooltip help text (defaults to '')
    * if you don't set this, you will obtain the default popup message
  * help-href: the URL for the help (defaults to '')
    * if you don't set this, you will not obtain a link
-->

<xsl:stylesheet version="1.0"
  xmlns="http://www.w3.org/1999/xhtml"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:encode="org.owasp.encoder.Encode"
  exclude-result-prefixes="ef encode">


  <!-- Variable: format for help popup window -->
  <xsl:variable name="ef_help_popup_fmt">width=600,height=500,menubar=no,location=no,resizable=yes,scrollbars=yes,status=yes</xsl:variable>

  <xsl:variable name="ef_help_session_var_name">EFHELP</xsl:variable>
  <xsl:variable name="ef_help_default_lang">en_EN</xsl:variable>
  <xsl:variable name="ef_help_img"><xsl:value-of select="concat('/', $_root_context, '/images')" /></xsl:variable>
  <xsl:variable name="ef_help_default_type">info</xsl:variable>



  <xsl:template name="ef_help">
    <xsl:param name="help-plugin" /> 
    <xsl:param name="help-type" select="$ef_help_default_type" />
    <xsl:param name="help-text" />
    <xsl:param name="help-href" />

    <!-- call real rendering template, only if HELP is enabled -->
    <xsl:if test="//ef:session-list/ef:session[@id=$ef_help_session_var_name]">

      <!-- Choose the language -->
      <xsl:variable name="help-lang">
        <xsl:choose>
          <xsl:when test="//ef:session-list/ef:session[@id=$ef_help_session_var_name]/ef:help-conf[@lang]">
            <xsl:value-of select="//ef:session-list/ef:session[@id=$ef_help_session_var_name]/ef:help-conf/@lang" />
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$ef_help_default_lang" />
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>

      <xsl:call-template name="ef_help_render">
        <xsl:with-param name="help-plugin" select="$help-plugin" />
        <xsl:with-param name="help-type"   select="$help-type"   />
        <xsl:with-param name="help-text"   select="$help-text"   />
        <xsl:with-param name="help-href"   select="$help-href"   />
        <xsl:with-param name="help-lang"   select="$help-lang"   />
      </xsl:call-template>
    </xsl:if>
  </xsl:template>


  <!-- Paolo: real implementation of EF_HELP -->
  <xsl:template name="ef_help_render">
    <xsl:param name="help-plugin" />
    <xsl:param name="help-type" />
    <xsl:param name="help-text" />
    <xsl:param name="help-href" />
    <xsl:param name="help-lang" />
    <!--
    <xsl:param name="help_mode" />
    -->

    <!-- Plugin URL (add this to base url) -->
    <xsl:variable name="ef_help_plugin_url">
      <xsl:choose>
        <xsl:when test="not($help-plugin = '')">
          <xsl:value-of select="concat('/', $help-plugin)" />
        </xsl:when>
        <xsl:otherwise />
      </xsl:choose>
    </xsl:variable>

    <!-- Compose the base URL -->
    <xsl:variable name="ef_help_base_url">
      <xsl:value-of select="concat('/', $_root_context, $ef_help_plugin_url, '/help/', $help-lang)" />
    </xsl:variable>

    <!-- Prepare the help base content -->
    <xsl:variable name="ef_help_base">
      <xsl:choose>
        <xsl:when test="$help-type = 'tip'">
          <img class="ef_help_img" alt="tip" src="{$ef_help_img}/help_tip.gif" title="{$help-text}" />
        </xsl:when>
        <xsl:when test="$help-type = 'info' or $help-type = ''">
          <img class="ef_help_img" alt="info" src="{$ef_help_img}/help_info.gif" title="{$help-text}" style="margin-left: 3px"/>
        </xsl:when>
        <xsl:when test="$help-type = 'q' or $help-type='qmark'">
          <img class="ef_help_img" alt="qmark" src="{$ef_help_img}/help_qmark.gif" title="{$help-text}" />
        </xsl:when>
        <xsl:otherwise />
      </xsl:choose>
    </xsl:variable>

    <!-- The complete help -->
    <xsl:variable name="ef_help_content">
      <xsl:choose>
        <!--
        <xsl:when test="$help_mode = 'link' and $href != ''">
          <a href="{$href}">
            <xsl:copy-of select="$help_base" />
          </a>
        </xsl:when>
        -->
        <!--
        <xsl:when test="$help_mode = 'popup' and $href != ''">
        -->
        <xsl:when test="$help-href != ''">
          <xsl:variable name="ef_help_full_href" select="concat($ef_help_base_url, '/', $help-href)" />
          <a href="javascript:void(0)" class="ef_help_link">
            <xsl:attribute name="onclick">
              var ef_help_popup_window = window.open(
                '',
                'EF_help',
                '<xsl:value-of select="encode:forJavaScriptAttribute($ef_help_popup_fmt)"/>'
              );
              ef_help_popup_window.location.href = '<xsl:value-of select="encode:forJavaScriptAttribute($ef_help_full_href)" />';
              ef_help_popup_window.focus();
            </xsl:attribute>
            <xsl:copy-of select="$ef_help_base" />
          </a>
        </xsl:when>
        <xsl:otherwise>
          <xsl:copy-of select="$ef_help_base" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <!-- No further elaborations, return the help -->
    <xsl:copy-of select="$ef_help_content" />

  </xsl:template>


  <!-- New tags defined by EnginFrame Online Help -->


  <!-- Help status - by default does nothing -->
  <xsl:template match="ef:help-status" priority="-17" />


  <!-- Prune all ef:help without a specific match -->
  <xsl:template match="ef:help" priority="-1" />


  <!-- Render ef:help for ef:service/ef:name -->
  <xsl:template match="ef:service/ef:help" mode="ef:name">
    <xsl:variable name="id" select="../@id" />

    <xsl:call-template name="ef_help">
      <xsl:with-param name="help-type">
        <xsl:choose>
          <xsl:when test="@type"><xsl:value-of select="@type" /></xsl:when>
          <xsl:otherwise><xsl:value-of select="$ef_help_default_type" /></xsl:otherwise>
        </xsl:choose>
      </xsl:with-param>
      <xsl:with-param name="help-text">
        <xsl:value-of select="concat('Help for service ', $id)" />
      </xsl:with-param>
      <xsl:with-param name="help-href" select="@href" />
      <xsl:with-param name="help-plugin" select="@plugin" />
    </xsl:call-template>
  </xsl:template>



</xsl:stylesheet>
