<?xml version="1.0"?>

<xsl:stylesheet
  version="1.0"
  xmlns="http://www.w3.org/1999/xhtml"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:exsl="http://exslt.org/common"
  xmlns:efactions="http://www.enginframe.com/2000/efactions"
  xmlns:java="http://xml.apache.org/xalan/java"
  xmlns:encode="org.owasp.encoder.Encode"
  extension-element-prefixes="exsl"
  exclude-result-prefixes="ef exsl efactions java encode"
  >

  <!--
  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
  -->


  <!-- Include -->

  <xsl:include href="com.enginframe.efactions.xsl"/>


  <!-- Front end template -->


  <xsl:template name="item_action_list_rendering">
    <xsl:param name="id"/>
    <xsl:choose>
      <xsl:when test="($id != '')">
        <xsl:apply-templates select="/ef:agent/ef:item-action-list[@id=$id]"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="/ef:agent/ef:item-action-list"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>



  <!-- EF:item-action -->


  <xsl:template match="ef:item-action-list">
    <xsl:if test="ef:item-action-group|ef:item-action|ef:item-separator">
      <ul>
        <xsl:apply-templates select="@id|@class"/>
        <xsl:apply-templates select="ef:item-action-group|ef:item-action|ef:item-separator"/>
      </ul>
    </xsl:if>
  </xsl:template>


  <xsl:template match="ef:item-action">
    <li class="ef-item-action">
      <xsl:apply-templates select="@id|@class|@icon"/>
      <xsl:choose>
        <xsl:when test="efactions:*">
          <xsl:apply-templates select="efactions:*"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates select="ef:name"/>
        </xsl:otherwise>
      </xsl:choose>
    </li>
  </xsl:template>


  <xsl:template match="
    ef:item-action/ef:name
    |
    ef:item-action-group/ef:name
    ">
    <span class="ef-item-action-name">
      <xsl:value-of select="text()"/>
    </span>
  </xsl:template>


  <xsl:template match="ef:item-separator">
    <li class="ef-item-separator">
      <xsl:apply-templates select="@id|@class"/>
      <xsl:comment/>
    </li>
  </xsl:template>


  <xsl:template match="ef:item-action-group">
    <li class="ef-item-action-group">
      <xsl:apply-templates select="@id|@class"/>
      <xsl:apply-templates select="ef:name"/>
      <xsl:if test="ef:item-action-group|ef:item-action|ef:item-separator">
        <ul>
          <xsl:apply-templates select="ef:item-action-group|ef:item-action|ef:item-separator"/>
        </ul>
      </xsl:if>
    </li>
  </xsl:template>


  <xsl:template match="
    ef:item-action-list/@id
    |
    ef:item-action/@id
    |
    ef:item-separator/@id
    |
    ef:item-action-group/@id
    ">
    <xsl:attribute name="id">
      <!--<xsl:value-of select="concat('ef_item_action_', .)"/>-->
      <xsl:value-of select="."/>
    </xsl:attribute>
  </xsl:template>


  <xsl:template match="ef:item-action-list/@class">
    <xsl:attribute name="class">
      <xsl:text>ef-item-action-list</xsl:text>
      <xsl:text> </xsl:text>
      <xsl:value-of select="."/>
    </xsl:attribute>
  </xsl:template>


  <xsl:template match="ef:item-action/@class">
    <xsl:attribute name="class">
      <xsl:text>ef-item-action</xsl:text>
      <xsl:text> </xsl:text>
      <xsl:value-of select="."/>
    </xsl:attribute>
  </xsl:template>


  <xsl:template match="ef:item-action-group/@class">
    <xsl:attribute name="class">
      <xsl:text>ef-item-action-group</xsl:text>
      <xsl:text> </xsl:text>
      <xsl:value-of select="."/>
    </xsl:attribute>
  </xsl:template>


  <xsl:template match="ef:item-separator/@class">
    <xsl:attribute name="class">
      <xsl:text>ef-item-separator</xsl:text>
      <xsl:text> </xsl:text>
      <xsl:value-of select="."/>
    </xsl:attribute>
  </xsl:template>


  <xsl:template match="
    ef:item-action/@icon
    |
    ef:item-action-group/@icon
    ">
    <xsl:variable name="src">
      <xsl:apply-templates select="." mode="expand.ef.variables"/>
    </xsl:variable>
    <img src="{encode:forUriComponent($src)}"/>
  </xsl:template>


</xsl:stylesheet>


<!--
# vi: ts=2 sw=2 et syntax=xslt :
-->

