<?xml version="1.0"?>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
                xmlns:encode="org.owasp.encoder.Encode"
                exclude-result-prefixes="ef encode">

<!--
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
-->

  <xsl:variable name="show_error_details">0</xsl:variable>


  <xsl:template match="ef:system-error[position() = 1]">
    <pre class="large-app-error">Error caused by <xsl:value-of select="@request-uri"/></pre>
    <p><xsl:apply-templates/></p>
  </xsl:template>


  <!-- priority +1 is necessary to override system.xsl template for ef:error/* tags.
       They have the same level of specificity but system templates are defined later -->
  <xsl:template match="ef:system-error/ef:message | ef:system-error/ef:error/ef:title | ef:system-error/ef:error/ef:message | ef:system-error/ef:error/ef:secondary-message" priority="+1">
    <p />
    <xsl:call-template name="br-replace">
      <xsl:with-param name="text"><xsl:value-of select="."/></xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <!-- priority +1, the reason above -->
  <xsl:template match="ef:system-error/ef:details[$show_error_details = 1] | ef:system-error/ef:error/ef:command" priority="+1">
    <p />
    <em class="small-app-error">This is the detailed error:</em>
    <pre class="small-app-error"><xsl:value-of select="."/></pre>
  </xsl:template>


  <xsl:template match="ef:system-error/ef:details[$show_error_details = 0]" />


  <xsl:template name="br-replace">
    <xsl:param name="text"/>
    <xsl:variable name="cr" select="'&#xa;'"/>
    <xsl:choose>
      <!-- If the value of the $text parameter contains carriage return -->
      <xsl:when test="contains($text, $cr)">
        <!-- Return the substring of $text before the carriage return -->
        <xsl:value-of select="substring-before($text, $cr)"/>
        <!-- And construct a <br/> element -->
        <br />
        <!--
         | Then invoke this same br-replace template again, passing the
         | substring *after* the carriage return as the new "$text" to
         | consider for replacement
         +-->
        <xsl:call-template name="br-replace">
          <xsl:with-param name="text" select="substring-after($text, $cr)"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$text"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <!--
  EF-replace-string
  =================
  Reusable function for replace strings.

  Arguments:
  - text: the text to be replaced
  - from: the pattern to find
  - to:   the value to replace
  -->

  <xsl:template name="ef-replace-string">
    <xsl:param name="text" />
    <xsl:param name="from" />
    <xsl:param name="to" />
    <xsl:choose>
      <xsl:when test="contains($text, $from)">
        <xsl:variable name="before" select="substring-before($text, $from)" />
        <xsl:variable name="after" select="substring-after($text, $from)" />
        <xsl:variable name="prefix" select="concat($before, $to)" />
        <xsl:value-of select="$before" />
        <xsl:value-of select="$to" />
        <xsl:call-template name="ef-replace-string">
          <xsl:with-param name="text" select="$after" />
          <xsl:with-param name="from" select="$from" />
          <xsl:with-param name="to" select="$to" />
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$text" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <!--
  EF-js-escape-single-quoted-string
  =================================
  -->

  <xsl:template name="ef-js-escape-single-quoted-string">
    <xsl:param name="string" />
    <xsl:call-template name="ef-replace-string">
      <xsl:with-param name="text">
        <xsl:call-template name="ef-replace-string">
          <xsl:with-param name="text" select="$string" />
          <xsl:with-param name="from">\</xsl:with-param>
          <xsl:with-param name="to">\\</xsl:with-param>
        </xsl:call-template>
      </xsl:with-param>
      <xsl:with-param name="from">'</xsl:with-param>
      <xsl:with-param name="to">\'</xsl:with-param>
    </xsl:call-template>
  </xsl:template>


  <!--
  EF-position-evenodd
  ===================
  Return string 'even' or 'odd' depending on current position of the node.
  -->

  <xsl:template name="ef-position-evenodd">
    <xsl:choose>
      <xsl:when test="(position()) mod 2 != 0">odd</xsl:when>
      <xsl:otherwise>even</xsl:otherwise>
    </xsl:choose>
  </xsl:template>


</xsl:stylesheet>
