<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
                xmlns:encode="org.owasp.encoder.Encode"
                exclude-result-prefixes="ef encode">

<!--
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
 * $Id: admin.layout.templates.xsl 6900 2007-05-24 11:00:25Z robby $
-->

  <xsl:variable name="external_link_name" select="/ef:agent/ef:result/ef:profile/ef:session-list/ef:session[@id='EXT_LINK_NAME']"/>
  <xsl:variable name="external_link_value" select="/ef:agent/ef:result/ef:profile/ef:session-list/ef:session[@id='EXT_LINK_VALUE']"/>

  <xsl:variable name="_external_link_name">
    <xsl:choose>
      <xsl:when test="$external_link_name"><xsl:value-of select="$external_link_name"/></xsl:when>
      <xsl:otherwise>Start page</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="_external_link_value">
    <xsl:choose>
      <xsl:when test="$external_link_value"><xsl:value-of select="$external_link_value"/></xsl:when>
      <xsl:otherwise>/<xsl:value-of select="$_root_context"/>/</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:template name="header_rendering">
    <title><xsl:value-of select="$agent_name"/></title>
    <xsl:call-template name="head_rendering"/>
    <link type="text/css" rel="StyleSheet" href="{encode:forUriComponent($css)}/layout.css?{$_ef_cache_timestamp}" />
    <link rel="shortcut icon" href="/{$_root_context}/images/favicon.ico" />
  </xsl:template>

  <xsl:template name="banner_rendering">
    <div id="banner">
      <ul>
        <li class="banner-level-1">
          <a href="/{$_root_context}/" title="EnginFrame logo" />
        </li>
        <li class="banner-level-2">
           <a href="http://www.ni-sp-software.com" title="NI SP Software logo" />
        </li>
      </ul>
    </div>
  </xsl:template>

  <xsl:template name="topmenu_rendering">
    <div id="topmenu">
      <div id="topmenu-level-1">
        <a id="topmenu-a1" href="/{$_root_context}/admin/">
          <p class="topmenu-level-b">
            Administration
          </p>
        </a>
      </div>
      <div id="topmenu-level-7">
        <a id="topmenu-a7" href="{encode:forUriComponent($_external_link_value)}">
          <p class="topmenu-level-b">
            <xsl:value-of select="$_external_link_name" />
          </p>
        </a>
      </div>
      <div id="topmenu-level-11">
        <a id="topmenu-a11" href="{$agent}.xml?_uri=//com.enginframe.system/logout">
          <img src="{$img}/shim.gif" width="40" height="39" border="0" alt="Logout" title="Logout" />
        </a>
      </div>
   </div>
  </xsl:template>

  <!-- contents rendering -->
  <xsl:template name="contents_rendering">
    <div id="contents">
      <table id="contenttable">
        <tr id="contenttr">
          <td id="navigationtd">
            <div id="navigationdiv">
              <xsl:call-template name="navigation_rendering"/>
            </div>
          </td>
          <td id="contenttd">
            <div id="contentdiv">
              <xsl:call-template name="content_rendering"/>
            </div>
          </td>
        </tr>
      </table>
    </div>
  </xsl:template>

  <!-- footer rendering -->
  <xsl:template name="footer_rendering">
    <div id="footer">
      <ul>
        <li class="footer-level-1">
	  Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.<br/>
	  Copyright 1999-2023 by Nice, srl., All rights reserved.<br/>
          All trademarks and logos on this page are owned by NI SP Software GmbH, NICE s.r.l. or by their respective owners.
        </li>
      </ul>
    </div>
  </xsl:template>

</xsl:stylesheet>
