/*global jQuery, hydrogenConf */
////////////////////////////////////////////////////////////////////////////////
// Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
// Copyright 1999-2023 by Nice, srl., All rights reserved.
//
// This software includes confidential and proprietary information
// of NI SP Software GmbH ("Confidential Information").
// You shall not disclose such Confidential Information
// and shall use it only in accordance with the terms of
// the license agreement you entered into with NI SP Software.
////////////////////////////////////////////////////////////////////////////////

var adminHttpAccounts = {
    refresh: function (id) {
        jQuery('#' + id + '-table').hytable('reload');
    },

    init: function (id) {
        jQuery(document).ready(function () {
            var msg, toolbar, table;

            msg = jQuery('#' + id + '-message').hymessage();

            toolbar = jQuery('#' + id + '-toolbar').hytoolbar({
                conf: hydrogenConf[id],
                searchBoxHint: 'Search by name'
            });

            table = jQuery('#' + id + '-table').hytable({
                xmlreader: {
                    root: 'tomcat-users',
                    row: 'user',
                    page: 'tomcat-users>page',
                    total: 'tomcat-users>total',
                    records: 'tomcat-users>records',
                    repeatitems: false,
                    id: 'name'
                },
                conf: hydrogenConf[id]
            });

            table.bind('hytableloadError', function (e, data) {
                // If the status is ok (200) and we had an error, we assume
                // we just got an empty response because no jobs were associated
                // with this spooler
                if (data.xhr.status !== 200) {
                    jQuery.hydrogen.manageTableLoadErrorResult(data,
                        'Cannot obtain the list of HTTP accounts from the server.', msg);
                }
            });

            table.bind('hytableaction', function (e, data) {
                jQuery.hydrogen.executeAction(data.action,
                    {'%CURRENT_ID%': data.currentId},
                    function () {
                        table.hytable('reload');
                    });
            });

            toolbar.bind('hytoolbaraction', function (e, action) {
                jQuery.hydrogen.executeAction(action, {
                    '%SELECTED_IDS%': function () {
                        return jQuery('#' + id + '-table').hytable('selected').join('\n');
                    }
                }, function () {
                    table.hytable('reload');
                });
            });

            toolbar.bind('hytoolbarsearch', function (e, s) {
                var formula;

                formula = table.data('filter');

                if (formula !== null && formula !== '') {
                    if (s.search !== '') {
                        formula += " and name ?:= '" + s.search + "'";
                    }
                } else {
                    if (s.search !== '') {
                        formula = "name ?:= '" + s.search + "'";
                    } else {
                        formula = "";
                    }
                }

                table.hytable('filter', formula);
            });
        });
    }
};

// ex:ts=4:et:

