/*global jQuery, hydrogenConf */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */


var userSessions = {
    refresh: function (id) {
        jQuery('#' + id + '-table').hytable('reload');
    },

    init: function (id) {
        jQuery(document).ready(function () {
            var msg, toolbar, table;

            msg = jQuery('#' + id + '-message').hymessage();

            toolbar = jQuery('#' + id + '-toolbar').hytoolbar({
                conf: hydrogenConf[id],
                searchBoxHint: 'Search by user name'
            });

            table = jQuery('#' + id + '-table').hytable({
                xmlreader: {
                    root: 'http-session-list',
                    row: 'http-session',
                    page: 'http-session-list>page',
                    total: 'http-session-list>total',
                    records: 'http-session-list>records',
                    repeatitems: false,
                    id: 'id'
                },
                conf: hydrogenConf[id],
                messageArea: msg,
                defaultLoadErrorMessage: 'Cannot obtain the list of user sessions from the server.'
            });

            table.bind('hytableaction', function (e, data) {
                jQuery.hydrogen.executeAction(data.action, {
                    '%CURRENT_ID%': data.currentId
                }, function () {
                    table.hytable('reload');
                }, msg);
            });

            table.bind('hytableselectionchanged', function (e, data) {
                toolbar.hytoolbar('viewProperties', {
                    'selected': table.hytable('selected').length
                });
            });

            toolbar.bind('hytoolbaraction', function (e, action) {
                jQuery.hydrogen.executeAction(action,
                    {'%SELECTED_IDS%': function () {
                        return table.hytable('selected').join('\n');
                    }
                        },
                    function () {
                        table.hytable('reload');
                    },
                    msg);
            });

            toolbar.bind('hytoolbarsearch', function (e, s) {
                var formula;

                formula = hydrogenConf[id].params.serviceParams.filter;

                if (formula !== null && formula !== '' && formula !== undefined) {
                    if (s.search !== '') {
                        formula += " and login ?:= '" + s.search + "'";
                    }
                } else {
                    if (s.search !== '') {
                        formula = "login ?:= '" + s.search + "'";
                    } else {
                        formula = "";
                    }
                }

                table.hytable('filter', formula);
            });
        });
    }
};

