/*global jQuery, hydrogenConf */
////////////////////////////////////////////////////////////////////////////////
// Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
// Copyright 1999-2023 by Nice, srl., All rights reserved.
//
// This software includes confidential and proprietary information
// of NI SP Software GmbH ("Confidential Information").
// You shall not disclose such Confidential Information
// and shall use it only in accordance with the terms of
// the license agreement you entered into with NI SP Software.
////////////////////////////////////////////////////////////////////////////////

var listTriggers = {
    refresh: function (id) {
        jQuery('#' + id + '-table').hytable('reload');
    },

    init: function (id) {
        jQuery(document).ready(function () {
            var msg, toolbar, table, box;

            msg = jQuery('#' + id + '-message').hymessage();

            box = jQuery('#' + id + '-wrapper').collapsibleBox({
                cookieNamePrefix: id + '-box'
            });

            toolbar = jQuery('#' + id + '-toolbar').hytoolbar({
                conf: hydrogenConf[id],
                searchBoxHint: 'Search by service'
            });

            table = jQuery('#' + id + '-table').hytable({
                xmlreader: {
                    root: 'list-triggers',
                    row: 'trigger',
                    page: 'list-triggers>page',
                    total: 'list-triggers>total',
                    records: 'list-triggers>records',
                    repeatitems: false,
                    id: 'full-id'
                },
                conf: hydrogenConf[id],
                messageArea: msg,
                defaultLoadErrorMessage: 'Cannot obtain the list of triggers from the server.'
            });

            table.bind('hytableaction', function (e, data) {
                jQuery.hydrogen.executeAction(data.action, {
                    '%CURRENT_ID%': data.currentId
                }, function () {
                    table.hytable('reload');
                }, msg);
            });

            table.bind('hytableselectionchanged', function (e, data) {
                toolbar.hytoolbar('viewProperties', {
                    'selected': table.hytable('selected').length
                });
            });

            toolbar.bind('hytoolbaraction', function (e, action) {
                jQuery.hydrogen.executeAction(action,
                    {'%SELECTED_IDS%': function () {
                        return table.hytable('selected').join('\n');
                    }
                        },
                    function () {
                        table.hytable('reload');
                    },
                    msg);
            });

            toolbar.bind('hytoolbarsearch', function (e, s) {
                var formula;

                formula = hydrogenConf[id].params.serviceParams.filter;

                if (formula !== null && formula !== '') {
                    if (s.search !== '') {
                        formula += " and service ?:= '" + s.search + "'";
                    }
                } else {
                    if (s.search !== '') {
                        formula = "service ?:= '" + s.search + "'";
                    } else {
                        formula = "";
                    }
                }

                table.hytable('filter', formula);
            });
        });
    },

    formatter: {

        persistent : function (val, opt, row) {
            var cl = "";
            if (val === "true") {
                cl = "hy-persistent";
            }
            return "<div class=\"" + cl + "\" title=\"Persistent\" />";
        },

        idFormatter: function (val, opt, row) {
            var isSystem, triggerGroup;

            isSystem = jQuery(row).attr('system') || false;
            triggerGroup = jQuery(row).attr('group') || '';

            return '<a href="javascript:void(0)" class="hy-trigger-id" onclick="detailsDialog(\'' +
                        val + '\', \'' + triggerGroup + '\', \'' + isSystem + '\')">' + val + '</a>';
        },

        status: function (val, opt, row) {
            var s;

            switch (val) {
            case "NORMAL":
                s = "IDLE";
                break;
            case "BLOCKED":
                s = "EXECUTING";
                break;
            default:
                s = val;
                break;
            }

            return '<div class="status ' + val + '">' + s.toLowerCase() + '</div>';
        },

        system : function (val, opt, row) {
            var cl = "";

            if (val === "true") {
                cl = "hy-system";
            }

            return "<div class=\"" + cl + "\" title=\"System\" />";
        },

        timings : function (val, opt, row) {
            var date, submitDate, startDate, previousDate, nextDate;

            date = jQuery(jQuery.hydrogen.prettyDateFormatter(val, opt)).removeAttr('abbr').text() || "-";
            submitDate = jQuery(jQuery.hydrogen.prettyDateFormatter(jQuery("submission-time", row).text(), opt)).
                            removeAttr('abbr').text();
            startDate = jQuery(jQuery.hydrogen.prettyDateFormatter(jQuery("start-time", row).text(), opt)).
                            removeAttr('abbr').text();
            previousDate = jQuery(jQuery.hydrogen.prettyDateFormatter(jQuery("previous-fire-time", row).text(), opt)).
                            removeAttr('abbr').text();
            nextDate = jQuery(jQuery.hydrogen.prettyDateFormatter(jQuery("next-fire-time", row).text(), opt)).
                            removeAttr('abbr').text();
            return '<div title="Creation:&#09;' + submitDate + '&#10;Start:&#09;' +
                        ((startDate === null) ? "-" : startDate) + '&#10;Previous:&#09;' +
                        ((previousDate === null) ? "-" : previousDate) + '&#10;Next:&#09;' +
                        ((nextDate === null) ? "-" : nextDate) + '">' + date + '</div>';
        }
    }
};

function fillDialog(toFill, uri, id, group, isSystem, action) {
    jQuery.enginframe.invokeService({
        sdf: '/' + jQuery.enginframe.rootContext + '/admin/com.enginframe.triggers.xml',
        uri: uri,
        data: {
            triggerId: id,
            triggerAction: action,
            triggerGroup: group,
            isSystem: isSystem
        },
        success: function (output) {
            toFill.html(output);
        },
        dataType: 'html'
    });
}

function detailsDialog(targetId, targetGroup, isSystem) {
    var dialog, container;
    dialog = jQuery('<div class="hy-action-dialog"/>').appendTo(jQuery('body'));
    container = jQuery('<div id="trigger-details-container" />').appendTo(dialog);
    dialog.dialog({
        title: "Trigger details: " + targetId,
        buttons: {
            "Close": function () {
                jQuery(this).dialog("close");
            }
        },
        position: { my: "center", at: "top+25%", of: window },
        width: jQuery(50).toPx(),
        bgiframe: true,
        modal: true
    });
    fillDialog(container, '//com.enginframe.triggers/trigger.action', targetId, targetGroup, isSystem, 'details');
}

// ex:ts=4:et:

