#!/bin/bash

################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
################################################################################

printtitle () {
  echo "<h2 class=\"ef-service-title\">$1</h2>"
}

printsubtitle () {
  echo "<h3>$1</h3>"
}

printok () {
  echo "<td><font color=\"green\">"
  echo "&#160;&#160; $1"
  echo "</font></td></tr>"
}


printerror () {
  echo "<td><font color=\"red\">"
  echo "&#160;&#160; $1"
  echo "</font></td></tr>"
}

printsoloerror () {
  echo "<tr><td colspan=\"2\"><br/><font color=\"red\">"
  echo "$1"
  echo "</font></td></tr>"
}

printwarning () {
  echo "<td><font color=\"orange\">"
  echo "&#160;&#160; $1"
  echo "</font></td></tr>"
}

printsolowarning () {
  echo "<tr><td colspan=\"2\"><br/><font color=\"orange\">"
  echo "$1"
  echo "</font></td></tr>"
}

startsection () {
  echo "<b>"
  echo "$1"
  echo "</b><hr/>"
  echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">"
}

closesection () {
  echo "</table>"
  echo "<br/><br/>"
}

printexit () {
  closesection
  echo "<br/><br/>"
  echo "<p>--- Fatal errors found. Please contact your EnginFrame Administrator ---</p>"
}

printvoice () {
  echo "<tr><td>&#160;&#160;&#160;"
  echo "$1"
  echo "</td>"
}

printsolovoice () {
  echo "<tr><td colspan=\"2\">&#160;&#160;&#160;"
  echo "$1"
  echo "</td></tr>"
}

printsubvoice () {
  echo "<tr><td>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;"
  echo "$1"
  echo "</td>"
}

begincommandoutput () {
  echo "<pre>"
}

endcommandoutput () {
  echo "</pre>"
}

commandescape () {
  . "${EF_ROOT}/plugins/ef/lib/xmlfuncs"
  ef_xml_escape_content -
}

format_changes() {
  echo "<tr><td colspan=\"2\">"
  awk -f "${EF_ROOT}/plugins/admin/bin/format-report-changes.awk" -f "${EF_ROOT}/plugins/ef/lib/awk/utils.awk"
  echo "</td></tr>"
}

. "${EF_ROOT}/plugins/admin/bin/common_tests.sh"
