#!/bin/bash

################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
################################################################################

# Print web server info


cat << EOF

Running on: `hostname`
`uname -a`

Memory:
EOF

if [ -r "/proc/meminfo" ]; then
  cat /proc/meminfo | head -n 2
else 
  MEM_INFO="`vmstat 2>/dev/null`"
  INFOOK="`echo $MEM_INFO | grep memory`"
  [ "x$INFOOK" = "x" ] && echo "- not available -" || echo "$MEM_INFO"
fi

cat << EOF

Uptime:
`uptime 2>/dev/null`

Client info:
User: ${EF_USER}, connected from: ${REMOTE_ADDR}

Disk space:
`df -k`

EOF

