<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ef-component="http://www.enginframe.com/descriptor"
                xmlns:encode="org.owasp.encoder.Encode"
                exclude-result-prefixes="ef-component encode">

<!--
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
 * $Id$
-->

  <xsl:strip-space elements="ef-component:descriptor" />
  <xsl:key name="unique_groups" match="ef-component:descriptor/ef-component:group" use="."/>

  <xsl:template match="descriptor-list">
    <div id="descriptor-list">
      <h2 class="ef-service-title">Installed Components</h2>
      <table>
        <tr>
          <td>
            <div id="component-list">

              <ul>
                <xsl:for-each select="ef-component:descriptor/ef-component:group[generate-id() = generate-id(key('unique_groups',.)[1])]">
                  <xsl:variable name="groupname"><xsl:value-of select="." /></xsl:variable>
                  <li><a href='#{encode:forUriComponent($groupname)}'><span><p><xsl:value-of select="." /></p></span></a></li>
                </xsl:for-each>
              </ul>

              <xsl:for-each select="ef-component:descriptor/ef-component:group[generate-id() = generate-id(key('unique_groups',.)[1])]">
                <xsl:variable name="innergroupname"><xsl:value-of select="." /></xsl:variable>

                <div id="{encode:forHtmlAttribute($innergroupname)}">
                  <ul>
                    <xsl:for-each select="../../ef-component:descriptor[child::ef-component:group = $innergroupname]">
                      <xsl:variable name="compid"><xsl:value-of select="ef-component:id" /></xsl:variable>
                      <li><a href='#{encode:forUriComponent($compid)}'><span><p><xsl:value-of select="ef-component:name" /></p></span></a></li>
                    </xsl:for-each>
                  </ul>
                  <xsl:apply-templates select="../../ef-component:descriptor[child::ef-component:group = $innergroupname]" />

                </div>
              </xsl:for-each>

            </div>
          </td>
        </tr>
      </table>
    </div>
  </xsl:template>

  <xsl:template match="ef-component:descriptor[child::ef-component:group = 'Bundle']">
    <xsl:variable name="compid"><xsl:value-of select="ef-component:id" /></xsl:variable>
    <div id="{encode:forHtmlAttribute($compid)}">
      <table>
        <tr>
          <td class="parameter2">
            Name:
          </td>
          <td class="parameter2-value">
            <xsl:value-of select="ef-component:name" />
          </td>
        </tr>
        <tr>
          <td class="parameter3">
            Version:
          </td>
          <td class="parameter3-value">
            <xsl:value-of select="ef-component:version" /><xsl:if test="ef-component:revision">&#160;(rev.&#160;<xsl:value-of select="ef-component:revision" />)</xsl:if>
          </td>
        </tr>
        <tr>
          <td class="parameter3">
            Description:
          </td>
          <td class="parameter3-value">
            <xsl:value-of select="ef-component:description" />
          </td>
        </tr>
        <tr>
          <td class="parameter3">
            Group:
          </td>
          <td class="parameter3-value">
            <xsl:value-of select="ef-component:group" />
          </td>
        </tr>
        <xsl:if test="ef-component:dependencies/text()">
          <tr>
            <td class="parameter3">
              Dependencies:
            </td>
            <td class="parameter3-value">
              <xsl:value-of select="ef-component:dependencies" />
            </td>
          </tr>
        </xsl:if>
        <tr>
          <td class="parameter3">
            Architecture:
          </td>
          <td class="parameter3-value">
            <xsl:value-of select="ef-component:architecture" />
          </td>
        </tr>
        <tr>
          <td class="parameter3">
            Created by:
          </td>
          <td class="parameter3-value">
            <xsl:value-of select="ef-component:organization" />
          </td>
        </tr>
        <xsl:if test="ef-component:date">
          <tr>
            <td class="parameter3">
              Last Modified:
            </td>
            <td class="parameter3-value">
              <xsl:value-of select="ef-component:date" />
            </td>
          </tr>
        </xsl:if>
      </table>
    </div>
  </xsl:template>

  <xsl:template match="ef-component:descriptor[child::ef-component:group != 'Bundle']">
    <xsl:variable name="compid"><xsl:value-of select="ef-component:id" /></xsl:variable>
    <div id="{encode:forHtmlAttribute($compid)}">
      <table>
        <tr>
          <td class="parameter2">
            Name:
          </td>
          <td class="parameter2-value">
            <xsl:value-of select="ef-component:name" />
          </td>
        </tr>
        <tr>
          <td class="parameter">
            Version:
          </td>
          <td class="parameter-value">
            <xsl:value-of select="ef-component:version" /><xsl:if test="ef-component:revision">&#160;(rev.&#160;<xsl:value-of select="ef-component:revision" />)</xsl:if>
          </td>
        </tr>
        <tr>
          <td class="parameter">
            Description:
          </td>
          <td class="parameter-value">
            <xsl:value-of select="ef-component:description" />
          </td>
        </tr>
        <tr>
          <td class="parameter">
            Group:
          </td>
          <td class="parameter-value">
            <xsl:value-of select="ef-component:group" />
          </td>
        </tr>
        <xsl:if test="ef-component:dependencies/text()">
          <tr>
            <td class="parameter">
              Dependencies:
            </td>
            <td class="parameter-value">
              <xsl:value-of select="ef-component:dependencies" />
            </td>
          </tr>
        </xsl:if>
        <tr>
          <td class="parameter">
            Architecture:
          </td>
          <td class="parameter-value">
            <xsl:value-of select="ef-component:architecture" />
          </td>
        </tr>
        <tr>
          <td class="parameter">
            Created by:
          </td>
          <td class="parameter-value">
            <xsl:value-of select="ef-component:organization" />
          </td>
        </tr>
        <xsl:if test="ef-component:date">
          <tr>
            <td class="parameter">
              Last Modified:
            </td>
            <td class="parameter-value">
              <xsl:value-of select="ef-component:date" />
            </td>
          </tr>
        </xsl:if>
      </table>
    </div>
  </xsl:template>

</xsl:stylesheet>
