<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ef-component="http://www.enginframe.com/descriptor"
                xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
                xmlns:encode="org.owasp.encoder.Encode"
                exclude-result-prefixes="ef ef-component encode">

<!--
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. * $Id$
-->

  <xsl:template name="normalize_num">
    <xsl:param name="value">0</xsl:param>
    <xsl:param name="unit"></xsl:param>
    <xsl:choose>
      <xsl:when test="not($value)">-</xsl:when>
      <xsl:when test="string($value)='NaN'">-</xsl:when>
      <xsl:when test="$value = 0">0</xsl:when>
      <xsl:when test="$value > 1125899906842624">
        <xsl:value-of select="format-number($value div 1125899906842624, '# P')"/><xsl:value-of select="$unit"/>
      </xsl:when>
      <xsl:when test="$value > 1099511627776">
        <xsl:value-of select="format-number($value div 1099511627776, '# T')"/><xsl:value-of select="$unit"/>
      </xsl:when>
      <xsl:when test="$value > 1073741824">
        <xsl:value-of select="format-number($value div 1073741824, '# G')"/><xsl:value-of select="$unit"/>
      </xsl:when>
      <xsl:when test="$value > 1048576">
        <xsl:value-of select="format-number($value div 1048576, '# M')"/><xsl:value-of select="$unit"/>
      </xsl:when>
      <xsl:when test="$value > 1024">
        <xsl:value-of select="format-number($value div 1024, '# K')"/><xsl:value-of select="$unit"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$value"/> <xsl:value-of select="$unit"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="chart_interval_selector">
    <div class="ef-graph-select-container ui-widget">
      <select class="ef-graph-select">
        <xsl:for-each select="..//ef:sm-time-window-list/ef:sm-time-window">
          <option>
            <xsl:attribute name="value"><xsl:value-of select="@interval"/></xsl:attribute>
            <xsl:value-of select="@label"/>
          </option>
        </xsl:for-each>
      </select>
    </div>
  </xsl:template>

  <xsl:template name="save_as_csv">
    <xsl:if test="count(./ef:sm-graph) &gt; 0">
      <xsl:variable name="js_escaped_database" select="encode:forJavaScriptAttribute(./../@database)" />
      <xsl:variable name="js_escaped_datasource" select="encode:forJavaScriptAttribute(./ef:sm-graph/@datasource)" />
      <xsl:variable name="js_escaped_unit" select="encode:forJavaScriptAttribute(./ef:sm-graph/@unit)" />
      <a href="#" onClick="adminStatistics.generateCsvFile('{$js_escaped_database}', '{$js_escaped_datasource}', '{$js_escaped_unit}')" title="Save as CSV" ><div class="save-as-csv" /></a>
    </xsl:if>
  </xsl:template>

  <xsl:template name="server_load">
    <div id="sm-view-list-tab-1" class="sm-view-list-tab">
      <xsl:choose>
        <xsl:when test="count(ef:sm-group[@type='remote-load']) &gt; 1">
          <xsl:for-each select="ef:sm-group[@type='remote-load']">
            <div class="vertical-text"><xsl:value-of select="@host"/></div>
            <div class="sm-group host">
              <xsl:apply-templates />
              <div class="clear"></div>
            </div>
          </xsl:for-each>
          <xsl:for-each select="ef:sm-group[@type='load']">
            <div class="sm-group host-noborder">
              <xsl:apply-templates />
              <div class="clear"></div>
            </div>
          </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
          <xsl:for-each select="ef:sm-group[@type='remote-load']">
            <div class="sm-group">
              <xsl:apply-templates />
              <div class="clear"></div>
            </div>
          </xsl:for-each>
          <xsl:for-each select="ef:sm-group[@type='load']">
            <div class="sm-group">
              <xsl:apply-templates />
              <div class="clear"></div>
            </div>
          </xsl:for-each>
        </xsl:otherwise>
      </xsl:choose> 
    </div>
    <div id="sm-view-list-tab-2" class="sm-view-list-tab">
      <xsl:call-template name="chart_interval_selector" />
      <xsl:choose>
        <xsl:when test="count(ef:sm-group[@type='remote-history']) &gt; 1">
          <xsl:for-each select="ef:sm-group[@type='remote-history']">
            <div class="vertical-text"><xsl:value-of select="@host"/></div>
            <div class="sm-group host-history">
              <xsl:apply-templates />
              <div class="clear"></div>
            </div>
          </xsl:for-each>
          <xsl:for-each select="ef:sm-group[@type='history']">
            <div class="sm-group host-noborder">
              <xsl:apply-templates />
              <div class="clear"></div>
            </div>
          </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
          <xsl:for-each select="ef:sm-group[@type='remote-history']">
            <div class="sm-group">
              <xsl:apply-templates />
              <div class="clear"></div>
            </div>
          </xsl:for-each>
          <xsl:for-each select="ef:sm-group[@type='history']">
            <div class="sm-group">
              <xsl:apply-templates />
              <div class="clear"></div>
            </div>
          </xsl:for-each>
        </xsl:otherwise>
      </xsl:choose>
    </div>
  </xsl:template>

  <xsl:template match="ef:system-monitor" >
    <div id="system-monitor">
      <script type="text/javascript">
        adminStatistics.defaultChartInterval = "<xsl:value-of select="encode:forJavaScriptBlock(..//ef:sm-time-window-list/ef:sm-time-window[1]/@interval)" />";
      </script>
      <xsl:choose>
        <xsl:when test="(count(ef:sm-group) &gt; 1) and (ef:sm-group[1]/@type = 'load')">
          <h2 class="ef-service-title">Server Load</h2>
          <div id="sm-view-list">
            <ul class="sm-view-list-tab-1">
              <li><a href="#sm-view-list-tab-1"><span><p>Current</p></span></a></li>
              <li><a href="#sm-view-list-tab-2"><span><p>History</p></span></a></li>
            </ul>
            <xsl:call-template name="server_load" />
          </div>
        </xsl:when>
        <xsl:when test="ef:sm-group/@type = 'statistics'">
          <h2 class="ef-service-title">Usage Statistics</h2>
          <xsl:call-template name="chart_interval_selector" />
          <xsl:apply-templates />
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates />
        </xsl:otherwise>
      </xsl:choose>
    </div>
  </xsl:template>

  <xsl:template match="ef:sm-group">
    <xsl:variable name="sm-view-list-tab-id">sm-view-list-tab-<xsl:number format="1" /></xsl:variable>
    <div id="{$sm-view-list-tab-id}" class="sm-view-list-tab">
      <div class="sm-group">
        <xsl:choose>
          <xsl:when test="@type ='load'">
            <xsl:if test="count(./../ef:sm-group) = 1">
              <h2>Server Load</h2>
            </xsl:if>
          </xsl:when>
          <xsl:when test="(@type ='history')">
            <xsl:call-template name="chart_interval_selector" />
          </xsl:when>
          <xsl:otherwise> <!-- (@type ='statistics') -->
            <!-- do nothing -->
          </xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates />
      </div>
    </div>
  </xsl:template>

  <xsl:template match="ef:sm-view">
    <xsl:choose>
      <xsl:when test="@type ='memory'">
        <div class="sm-view">
          <xsl:call-template name="save_as_csv"/>
          <div class="sm-view-name">JVM Memory</div>
          <xsl:apply-templates />
        </div>
      </xsl:when>
      <xsl:when test="@type ='license'">
        <div class="sm-view-license">
          <xsl:call-template name="save_as_csv"/>
          <div class="sm-view-name">Historical Usage</div>
          <xsl:call-template name="chart_interval_selector" />
          <xsl:apply-templates />
        </div>
      </xsl:when>
      <xsl:when test="@type ='license-alert'">
        <!-- do nothing: see admin.license-status.xsl -->
      </xsl:when>
      <xsl:when test="@type ='logged-users'">
        <div class="sm-view">
          <xsl:call-template name="save_as_csv"/>
          <xsl:choose>
            <xsl:when test="@name ='EF_Base'">
              <div class="sm-view-name">Logged Users</div>
            </xsl:when>
            <xsl:otherwise>
              <div class="sm-view-name">
                <xsl:value-of select="@name" /> Logged Users
              </div>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:apply-templates />
        </div>
      </xsl:when>
      <xsl:when test="@type ='cpu'">
        <div class="sm-view">
          <xsl:call-template name="save_as_csv"/>
          <div class="sm-view-name">System CPU</div> 
          <xsl:apply-templates />
        </div>
      </xsl:when>
      <xsl:when test="@type ='jobs'">
        <div class="sm-view">
          <xsl:call-template name="save_as_csv"/>
          <div class="sm-view-name">Overall Number of Jobs</div>
          <xsl:apply-templates />
        </div>
      </xsl:when>
      <xsl:when test="@type ='spoolers-no'">
        <div class="sm-view">
          <xsl:call-template name="save_as_csv"/>
          <div class="sm-view-name">Overall Number of Spoolers</div>
          <xsl:apply-templates />
        </div>
      </xsl:when>
      <xsl:when test="@type ='interactive-spoolers-no'">
        <div class="sm-view">
          <xsl:call-template name="save_as_csv"/>
          <div class="sm-view-name">Overall Number of Interactive Sessions</div>
          <xsl:apply-templates />
        </div>
      </xsl:when>
      <xsl:when test="@type ='file-system'">
        <div class="sm-view">
          <xsl:call-template name="save_as_csv"/>
          <div class="sm-view-name">
            <xsl:call-template name="file-system-name" />
          </div>
          <xsl:apply-templates />
        </div>
      </xsl:when>
      <xsl:otherwise>
        <div class="sm-view">
          <xsl:attribute name="id"><xsl:value-of select="@type" /></xsl:attribute>
          <xsl:apply-templates />
        </div>
        <div class="clear" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="file-system-name">
    <xsl:choose>
      <xsl:when test="count(./ef:chart) &gt; 0">
        <xsl:choose>
           <xsl:when test="count(./ef:sm-data-item) &gt; 1">
              <xsl:for-each select="ef:sm-data-item">
                <xsl:value-of select="text()" />
                <xsl:if test="position() != last()"><xsl:text>, </xsl:text></xsl:if>
              </xsl:for-each>
              File Systems
           </xsl:when>
           <xsl:otherwise>
             <xsl:if test="ef:sm-data-item !=''">
               <xsl:value-of select="ef:sm-data-item" /> File System
             </xsl:if>
           </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:if test="@name !=''">
          <xsl:value-of select="@name" /> Size
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="ef:chart">
    <div class="chart">
      <xsl:choose>
        <xsl:when test="@type ='file-system'">
          <div class="chart-title">Mount Point: 
            <span class="chart-description">'<xsl:value-of select="../@name" />'</span>
          </div>
          <div class="chart-title">Disk 
            <span class="chart-description">
              <xsl:choose>
                <xsl:when test="number(@description) = @description">
                  (Total Size
                    <xsl:call-template name="normalize_num">
                      <xsl:with-param name="value"><xsl:value-of select="@description" /></xsl:with-param>
                      <xsl:with-param name="unit">B</xsl:with-param>
                    </xsl:call-template>)
                </xsl:when>
                <xsl:otherwise>
                  (<xsl:value-of select="@description" />)
                </xsl:otherwise>
              </xsl:choose>
            </span>
          </div>
        </xsl:when>
        <xsl:when test="@type ='inodes'">
          <div class="chart-title">Inodes 
            <span class="chart-description">
              <xsl:choose>
                <xsl:when test="number(@description) = @description">
                  (Total
                    <xsl:call-template name="normalize_num">
                      <xsl:with-param name="value"><xsl:value-of select="@description" /></xsl:with-param>
                    </xsl:call-template>)
                </xsl:when>
                <xsl:otherwise>
                  (<xsl:value-of select="@description" />)
                </xsl:otherwise>
              </xsl:choose>
            </span>
          </div>
        </xsl:when>
        <xsl:otherwise>
          <!-- No chart title -->
        </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates />
    </div>
  </xsl:template>

  <xsl:template match="ef:sm-data-item">
    <xsl:choose>
      <xsl:when test="@type = 'jobs'">
        <div class="data-item">
          <xsl:if test="position() = 2" >
            <div class="sm-view-description">Current Jobs:</div>
          </xsl:if>
          <xsl:choose>
            <xsl:when test="@description ='done'">
              <div class="data-item-label"><span class="legend legend-green" /> Done</div>
              <div class="data-item-value"><xsl:value-of select="text()" /></div>
            </xsl:when>
            <xsl:when test="@description ='running'">
              <div class="data-item-label"><span class="legend legend-blue" /> Running</div>
              <div class="data-item-value"><xsl:value-of select="text()" /></div>
            </xsl:when>
            <xsl:when test="@description ='pending'">
              <div class="data-item-label"><span class="legend legend-yellow" /> Pending</div>
              <div class="data-item-value"><xsl:value-of select="text()" /></div>
            </xsl:when>
            <xsl:when test="@description ='total'">
              <div class="data-item-label"><span class="legend legend-red" /> Total</div>
              <div class="data-item-value"><xsl:value-of select="text()" /></div>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="text()" />
            </xsl:otherwise>
          </xsl:choose>
        </div>
      </xsl:when>
      <xsl:when test="@type ='folder'">
        <!-- do nothing, see ef:sm-view/@type ='file-system' -->
      </xsl:when>
      <xsl:when test="@type ='jvm-detail'">
        <div class="data-item">
          <xsl:choose>
            <xsl:when test="@description ='start-time'">
              <div class="item-label"> Server Start Time: </div>
              <xsl:choose>
                <xsl:when test="text() != ''">
                  <div class="item-value hy-iso8601-time"><xsl:value-of select="text()" /></div>
                </xsl:when>
                <xsl:otherwise>
                  <div class="item-value">N\A</div>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <xsl:when test="@description ='uptime'">
              <div class="item-label"> Server Uptime: </div>
              <div class="item-value">
                <xsl:choose>
                  <xsl:when test="text() != ''">
                    <xsl:value-of select="text()" />
                  </xsl:when>
                  <xsl:otherwise>
                    N\A
                  </xsl:otherwise>
                </xsl:choose>
              </div>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="text()" />
            </xsl:otherwise>
          </xsl:choose>
        </div>
      </xsl:when>
      <xsl:when test="@type ='load-avg'">
        <div class="data-item">
          <div class="item-label chart-label">Load Average: </div>
          <div class="item-value chart-value"><b><xsl:value-of select="text()" /></b></div>
        </div>
      </xsl:when>
      <xsl:otherwise>
        <div class="data-item">
          <div class="data-item-label"> Current </div>
          <div class="data-item-value"><xsl:value-of select="text()" /></div>
        </div>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="ef:sm-graph" name="ef:sm-graph" >
      <div class="ef-graph">
        <xsl:attribute name="title"><xsl:value-of select="@timeInterval" /></xsl:attribute>
        <xsl:variable name="graph-id">
          <xsl:number count="*" level="any" format="1" />
        </xsl:variable>
        <xsl:variable name="img-src"><xsl:value-of select="text()" /></xsl:variable> 
        <img id="graphImg-{$graph-id}" src="{$img-src}" onerror="this.src='../hydrogen/images/image-not-available.png';"/>
      </div>
  </xsl:template>

    <xsl:template match="ef:sm-warning">
        <xsl:choose>
          <xsl:when test="text() = ''">
            <div class="ef-sm-warning-msg">
              Server Unavailable
            </div>
          </xsl:when>
          <xsl:otherwise>
            <div class="clear" />
            <div class="ef-sm-warning-msg">
              <xsl:value-of select="text()" />
            </div>
          </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="ef:sm-info">
      <div class="ef-sm-info-msg">
        <xsl:value-of select="text()" />
      </div>
    </xsl:template>

</xsl:stylesheet>
