<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
                xmlns:efactions="http://www.enginframe.com/2009/efactions"
                xmlns:encode="org.owasp.encoder.Encode"
                exclude-result-prefixes="ef xsl efactions encode">

  <!--
    * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.  -->

  <xsl:output
    encoding="utf-8"
    method="html"
    media-type="text/html"
    doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
    doctype-system="http://www.w3.org/TR/html4/loose.dtd"
    omit-xml-declaration="yes"
  />

  <xsl:param name="_root_context"/>

  <xsl:variable name="actions.sdf.href" select="concat('/', $_root_context, '/admin/com.enginframe.triggers.xml')"/>
  <xsl:variable name="actions.service">//com.enginframe.triggers/trigger.action</xsl:variable>
  <xsl:variable name="details.javascript">detailsDialog</xsl:variable>
  <xsl:variable name="icon.href" select="concat('/', $_root_context, '/third-party/fugue-icons/icons')"/>

  <xsl:template match="/">
    <ef:item-action-list>
      <xsl:apply-templates/>
    </ef:item-action-list>
  </xsl:template>

  <xsl:template match="ef:trigger">
    <xsl:variable name="triggerState" select="state" />
    <xsl:variable name="isSystem" select="@system" />
    <xsl:call-template name="trigger_javascript">
      <xsl:with-param name="triggerId" select="@id" />
      <xsl:with-param name="triggerGroup" select="@group" />
      <xsl:with-param name="isSystem" select="$isSystem" />
      <xsl:with-param name="label">Details</xsl:with-param>
      <xsl:with-param name="icon">application-detail.png</xsl:with-param>
      <xsl:with-param name="service" select="$details.javascript"/>
    </xsl:call-template>
    <xsl:if test="$triggerState = 'NORMAL'">
      <xsl:call-template name="trigger_service">
        <xsl:with-param name="triggerId" select="@id" />
        <xsl:with-param name="triggerGroup" select="@group" />
        <xsl:with-param name="isSystem" select="$isSystem" />
        <xsl:with-param name="label">Pause</xsl:with-param>
        <xsl:with-param name="icon">control-pause.png</xsl:with-param>
        <xsl:with-param name="action">pause</xsl:with-param>
        <xsl:with-param name="service" select="$actions.service"/>
      </xsl:call-template>
    </xsl:if>
    <xsl:if test="$triggerState = 'PAUSED'">
      <xsl:call-template name="trigger_service">
        <xsl:with-param name="triggerId" select="@id" />
        <xsl:with-param name="triggerGroup" select="@group" />
        <xsl:with-param name="isSystem" select="$isSystem" />
        <xsl:with-param name="label">Resume</xsl:with-param>
        <xsl:with-param name="icon">control.png</xsl:with-param>
        <xsl:with-param name="action">resume</xsl:with-param>
        <xsl:with-param name="service" select="$actions.service"/>
      </xsl:call-template>
    </xsl:if>
    <xsl:if test="not($isSystem = 'true')">
      <xsl:call-template name="trigger_service">
        <xsl:with-param name="triggerId" select="@id" />
        <xsl:with-param name="triggerGroup" select="@group" />
        <xsl:with-param name="label">Delete</xsl:with-param>
        <xsl:with-param name="icon">cross-circle.png</xsl:with-param>
        <xsl:with-param name="action">delete</xsl:with-param>
        <xsl:with-param name="confirmation">Do you really want to delete this scheduled service?</xsl:with-param>
        <xsl:with-param name="service" select="$actions.service"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="trigger_service">
    <xsl:param name="triggerId" />
    <xsl:param name="triggerGroup" />
    <xsl:param name="isSystem" />
    <xsl:param name="label" />
    <xsl:param name="icon" />
    <xsl:param name="action" />
    <xsl:param name="service" />
    <xsl:param name="confirmation" />

    <ef:item-action id="{$triggerId}" icon="{$icon.href}/{$icon}">
      <ef:name><xsl:value-of select="$label" /></ef:name>
      <xsl:choose>
        <xsl:when test="$confirmation">
          <efactions:invoke-service
            sdf="{$actions.sdf.href}"
            uri="{$service}"
            confirmation="{$confirmation}" >
            <efactions:param id="triggerId"><xsl:value-of select="$triggerId" /></efactions:param>
            <efactions:param id="triggerGroup"><xsl:value-of select="$triggerGroup" /></efactions:param>
            <efactions:param id="triggerAction"><xsl:value-of select="$action" /></efactions:param>
            <efactions:param id="isSystem"><xsl:value-of select="$isSystem" /></efactions:param>
          </efactions:invoke-service>
        </xsl:when>
        <xsl:otherwise>
          <efactions:invoke-service
            sdf="{$actions.sdf.href}"
            uri="{$service}" >
            <efactions:param id="triggerId"><xsl:value-of select="$triggerId" /></efactions:param>
            <efactions:param id="triggerGroup"><xsl:value-of select="$triggerGroup" /></efactions:param>
            <efactions:param id="triggerAction"><xsl:value-of select="$action" /></efactions:param>
            <efactions:param id="isSystem"><xsl:value-of select="$isSystem" /></efactions:param>
          </efactions:invoke-service>
        </xsl:otherwise>
      </xsl:choose>
    </ef:item-action>
  </xsl:template>

  <xsl:template name="trigger_javascript">
    <xsl:param name="triggerId" />
    <xsl:param name="triggerGroup" />
    <xsl:param name="isSystem" />
    <xsl:param name="label" />
    <xsl:param name="icon" />
    <xsl:param name="service" />

    <ef:item-action id="{$triggerId}" icon="{$icon.href}/{$icon}">
      <ef:name><xsl:value-of select="$label" /></ef:name>
      <efactions:invoke-javascript>
        <xsl:value-of select="encode:forJavaScriptBlock($service)" />(
            "<xsl:value-of select="encode:forJavaScriptBlock($triggerId)" />",
            "<xsl:value-of select="encode:forJavaScriptBlock($triggerGroup)" />",
            "<xsl:value-of select="encode:forJavaScriptBlock($isSystem)" />"
          );
      </efactions:invoke-javascript>
    </ef:item-action>
  </xsl:template>

</xsl:stylesheet>
