<?xml version="1.0"?>

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:encode="org.owasp.encoder.Encode"
  exclude-result-prefixes="ef encode">

  <!--
    * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.  -->

  <xsl:template match="ef:trigger">
    <xsl:variable name="triggerState" select="state" />
    <xsl:variable name="formattedTriggerState">
      <xsl:choose>
        <xsl:when test="$triggerState = 'NORMAL'">Idle</xsl:when>
        <xsl:when test="$triggerState = 'BLOCKED'">Executing</xsl:when>
        <xsl:when test="$triggerState = 'COMPLETE'">Complete</xsl:when>
        <xsl:when test="$triggerState = 'ERROR'">Error</xsl:when>
        <xsl:when test="$triggerState = 'UNKNOWN'">Unknown</xsl:when>
        <xsl:when test="$triggerState = 'PAUSED'">Paused</xsl:when>
        <!-- The following should never happen -->
        <xsl:otherwise><xsl:value-of select="$triggerState"/></xsl:otherwise> 
      </xsl:choose>
    </xsl:variable>
    <script type="text/javascript"><xsl:comment>
      jQuery(document).ready(function () {
        var opt={colModel:{"index":"time","name":"time","resizable":false,"label":"Created on","xmlmap":"time","sortable":true,"width":170,"title":true,"hidden":false}};
        $($('#trigger-data .time')).each(function (i) {
          $(this).html($(jQuery.hydrogen.prettyDateFormatter($(this).text(), opt)));
        });
      });
      // </xsl:comment></script>

      <div id="trigger-data">
         <ul class="ui-state-highlight" >
           <li class="parameter">Group</li><li class="parameter-value"><xsl:value-of select="@group" /></li>
           <li class="parameter">System trigger</li><li class="parameter-value">
             <xsl:choose>
               <xsl:when test="@system = 'true'">true</xsl:when>
               <xsl:otherwise>false</xsl:otherwise>
             </xsl:choose>
           </li>
           <li class="parameter">Persistent</li><li class="parameter-value"><xsl:value-of select="@persistent" /></li>
           <li class="parameter">Type</li><li class="parameter-value"><xsl:value-of select="@type" /></li>
           <li class="parameter">Misfire instruction</li><li class="parameter-value"><xsl:value-of select="misfire-instruction" /></li>
         </ul>
         <ul>
           <li class="parameter">State</li><li class="parameter-value status {$triggerState}"><xsl:value-of select="$formattedTriggerState" /></li>
         </ul>
         <ul class="ui-state-highlight" >
           <li class="parameter">User login name</li><li class="parameter-value"><xsl:value-of select="user/@loginname" /></li>
           <li class="parameter">Service</li><li class="parameter-value"><xsl:value-of select="service" /></li>
           <li class="parameter">Priority</li><li class="parameter-value"><xsl:value-of select="priority" /></li>
         </ul>
         <ul>
           <li class="parameter">Start time</li><li class="parameter-value time"><xsl:value-of select="start-time" /></li>
           <li class="parameter">Submission time</li><li class="parameter-value time"><xsl:value-of select="submission-time" /></li>
           <li class="parameter">Previous fire</li><li class="parameter-value time"><xsl:value-of select="previous-fire-time" /></li>
           <li class="parameter">Next fire</li><li class="parameter-value time"><xsl:value-of select="next-fire-time" /></li>
         </ul>
         <ul class="ui-state-highlight" >
           <xsl:choose>
             <xsl:when test="@type = 'cron'">
               <li class="parameter">Cron expression</li><li class="parameter-value"><xsl:value-of select="cron-expression" /></li>
             </xsl:when>
             <xsl:otherwise>
               <li class="parameter">Iterations</li><li class="parameter-value">
                  <xsl:value-of select="times-triggered" />
                  <xsl:if test="@repeat-count !='-1'"> of <xsl:value-of select="repeat-count" /></xsl:if>
               </li>
               <li class="parameter">Repeat interval</li><li class="parameter-value"><xsl:value-of select="repeat-interval" /></li>
             </xsl:otherwise>
           </xsl:choose>
         </ul>
      </div>
  </xsl:template>

</xsl:stylesheet>
