
#
################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
#################################################################################

# bits2str --- turn a byte into readable 1's and 0's
# From: https://www.gnu.org/software/gawk/manual/html_node/Bitwise-Functions.html
function bits2str(bits,        data, mask)
{
    if (bits == 0)
        return "0"

    mask = 1
    for (; bits != 0; bits = rshift(bits, 1))
        data = (and(bits, mask) ? "1" : "0") data

    while ((length(data) % 8) != 0)
        data = "0" data

    return data
}

# Converts a string in the form "a.b.c.d" into the binary representation
function inet_aton(addr) {
    split(addr, ip, ".");
    return (((ip[1]*256)+ip[2])*256+ip[3])*256+ip[4]
}

# Converts a network prefix into the netmask binary representation
# Example:
#  24 => 255.255.255.0 => 255*2^24 + 255*2^16 + 255*2^8 + 0 = 4294967040
function prefix_to_netmask(prefix) {
    return and(lshift(0xffffffff, 32 - prefix), 0xffffffff)
}
