################################################################################
################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
################################################################################
################################################################################


/^-/ {
    if(list_files == "true") {
        print "<file timestamp=\"" getTimestamp() "\" size=\"" $5 "\" name=\"" escapeXmlAttribute(getName()) "\"/>";
    }
    next
}

/^d/ {
    print "<directory timestamp=\"" getTimestamp() "\" name=\"" escapeXmlAttribute(getName()) "\"/>";
    next
}


function getName() {
    # Remove the first 8 fields and keep the filename. Note that we can't
    # use $9 etc since awk would not handle multiple spaces in the file name 
    m = match($0, "^([^ ]+ +)([^ ]+ +)([^ ]+ +)([^ ]+ +)([^ ]+ +)([^ ]+ +)([^ ]+ +)([^ ]+ +)");
    if (m > 0) 
        return substr($0, 1 + RLENGTH);
    else
        # This should never happen
        return "Could not obtain file name";
}


# Return the timestamp based on 'use_iso_timestamp' input
# If the value is true then RFC 3339 a profile of ISO 8601
# is used otherwise the old, i.e. field 6 + " " + field 7 + " " + field 8, is used
function getTimestamp() {
    timestamp=$6 " " $7 " " $8;
    if (use_iso_timestamp) {
        timestamp=getTimestampISO();
    }
    return timestamp;
}


# Format the date according to 'YYYY-MM-DDTHH:mm:ss+HHmm' pattern
# The format is RFC 3339 a profile of ISO 8601
# As an example, 2009-09-28T12:17:00+0200
function getTimestampISO() {

    # Translate months to numbers
    sub("Jan", "01", $6);
    sub("Feb", "02", $6);
    sub("Mar", "03", $6);
    sub("Apr", "04", $6);
    sub("May", "05", $6);
    sub("Jun", "06", $6);
    sub("Jul", "07", $6);
    sub("Aug", "08", $6);
    sub("Sep", "09", $6);
    sub("Oct", "10", $6);
    sub("Nov", "11", $6);
    sub("Dec", "12", $6);

    if (split($8, a, ":" ) > 1) {
      # Compare file month+day with current month+day, since ls may not indicate
      # the year from up to six months ago
      FILE_MONTHDAY=sprintf("%.2d%.2d", $6, $7);
      if ( FILE_MONTHDAY > CURRENT_MONTHDAY ) 
        iso_timestamp=sprintf("%d-%.2d-%.2dT%s:00%s", CURRENT_YEAR - 1 , $6, $7, $8, MYTIMEZONE);
      else 
        iso_timestamp=sprintf("%d-%.2d-%.2dT%s:00%s", CURRENT_YEAR, $6, $7, $8, MYTIMEZONE);
    }
    else {
      iso_timestamp=sprintf("%d-%.2d-%.2dT00:00:00%s", $8, $6, $7, MYTIMEZONE);
    }

    return iso_timestamp;
}

