<?xml version="1.0"?>
<!--
  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.-->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
                xmlns:efrss="http://www.enginframe.com/2010/rss"
                xmlns:grid="http://www.enginframe.com/2000/GRID"
                  xmlns:encode="org.owasp.encoder.Encode"
                exclude-result-prefixes="ef grid encode">

  <xsl:include href="$(EF_ROOT)/plugins/rss/lib/xsl/com.enginframe.rss.xsl"/>

  <xsl:strip-space elements="*" />

  <xsl:output media-type="application/rss+xml" version="1.0" indent="yes" encoding="UTF-8"/>

  <xsl:variable name="agent_id">
    <xsl:value-of select="/ef:agent/@id"/>
  </xsl:variable>

  <xsl:template match="/efrss:metadata">
    <rss version="2.0">
      <channel>
        <title>
           <xsl:value-of select="$channel_title"/>
        </title>
        <description>
          <xsl:value-of select="$channel_description"/>
        </description>
        <language>en-us</language>
        <pubDate>
           <xsl:value-of select="$pub-date"/>
        </pubDate>
        <!--
        <generator>EnginFrame 2010 RC1</generator>
        -->
        <docs>https://blogs.law.harvard.edu/tech/rss</docs>
        <ttl>
           <xsl:value-of select="$ttl"/>
        </ttl>
        <xsl:apply-templates select="/ef:agent" mode="services"/>
      </channel>
    </rss>
  </xsl:template>

  <xsl:template match="/ef:agent"/>

  <xsl:template match="/ef:agent" mode="services">
      <link>
         <xsl:value-of select="$url"/>
      </link>
      <xsl:apply-templates select="descendant::ef:service" mode="rss"/>
  </xsl:template>

  <xsl:template match="ef:service" mode="rss" priority="+10">
    <xsl:choose>
      <xsl:when test="not(descendant::ef:option[not(@type = 'hidden')])" >
        <xsl:apply-templates select="ef:action" mode="hidden.option"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="." mode="item"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="ef:action" mode="hidden.option" >
    <xsl:choose>
      <xsl:when test="(@mode = 'exec') and (@type = 'javascript')"/>
      <xsl:when test="not(../descendant::ef:action[@type = 'javascript'])">
        <xsl:apply-templates select="parent::ef:service" mode="item.hidden.option">
          <xsl:with-param name="id" select="@id"/>
          <xsl:with-param name="label" select="@label"/>
        </xsl:apply-templates>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select=".." mode="item"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="ef:service" mode="item.hidden.option">
    <xsl:param name="id"/>
    <xsl:param name="label"/>
    <item>
      <title>
        <xsl:value-of select="ef:name"/>
        <xsl:text> - </xsl:text>
        <xsl:choose>
          <xsl:when test="$label!=''">
            <xsl:value-of select="$label"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$id"/>
          </xsl:otherwise>
        </xsl:choose>
      </title>
      <description>
        <xsl:value-of select="ef:info"/>
      </description>
      <link>
        <xsl:call-template name="generate_service_href._uri">
          <xsl:with-param name="id" select="$id"/>
        </xsl:call-template>
      </link>
      <guid isPermaLink="true">
        <xsl:call-template name="generate_service_href._uri">
          <xsl:with-param name="id" select="$id"/>
        </xsl:call-template>
      </guid>
      <pubDate>
        <xsl:value-of select="$pub-date"/>
      </pubDate>
    </item>
  </xsl:template>

  <xsl:template match="ef:service" mode="item" >
    <item>
      <title>
        <xsl:value-of select="ef:name"/>
      </title>
      <description>
        <xsl:value-of select="ef:info"/>
      </description>
      <link>
        <xsl:call-template name="generate_service_href._service"/>
      </link>
      <guid isPermaLink="true">
        <xsl:call-template name="generate_service_href._service"/>
      </guid>
      <pubDate>
        <xsl:value-of select="$pub-date"/>
      </pubDate>
    </item>
  </xsl:template>

  <xsl:template name="generate_service_href._uri">
    <xsl:param name="id"/>
    <xsl:value-of select="encode:forUriComponent($url)"/>
    <xsl:text>?_uri=//</xsl:text>
    <xsl:value-of select="encode:forUriComponent($agent_id)"/>
    <xsl:text>/</xsl:text>
    <xsl:value-of select="encode:forUriComponent(@id)"/>
    <xsl:text>&amp;_actionid=</xsl:text>
    <xsl:value-of select="encode:forUriComponent($id)"/>
  </xsl:template>

  <xsl:template name="generate_service_href._service">
    <xsl:value-of select="$url"/>
    <xsl:text>?_service=</xsl:text>
    <xsl:value-of select="encode:forUriComponent(@id)"/>
  </xsl:template>

  <xsl:template match="ef:service[@hidden='true']" mode="rss" priority="+10" />

</xsl:stylesheet>

