<?xml version="1.0"?>
<!--
  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.-->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
                xmlns:efrss="http://www.enginframe.com/2010/rss"
                xmlns:grid="http://www.enginframe.com/2000/GRID"
                xmlns:java="http://xml.apache.org/xalan/java"
                xmlns:encode="org.owasp.encoder.Encode"
                exclude-result-prefixes="ef grid java encode">

  <xsl:include href="$(EF_ROOT)/plugins/rss/lib/xsl/com.enginframe.rss.xsl"/>

  <xsl:strip-space elements="*" />

  <xsl:output media-type="application/rss+xml" version="1.0" indent="yes" encoding="UTF-8"/>

  <xsl:template match="/efrss:metadata">
    <rss version="2.0">
      <channel>
        <title>
           <xsl:value-of select="$channel_title"/>
        </title>
        <description>
          <xsl:value-of select="$channel_description"/>
        </description>
        <language>en-us</language>
        <pubDate>
           <xsl:value-of select="$pub-date"/>
        </pubDate>
        <docs>https://blogs.law.harvard.edu/tech/rss</docs>
        <ttl>
           <xsl:value-of select="$ttl"/>
        </ttl>
        <xsl:apply-templates select="/ef:list-spoolers" mode="rss"/>
      </channel>
    </rss>
  </xsl:template>

  <xsl:template match="/ef:list-spoolers"/>

  <xsl:template match="/ef:list-spoolers" mode="rss">
    <link>
      <xsl:value-of select="$url"/>
      <xsl:text>?_uri=//com.enginframe.system/list.spoolers</xsl:text>
    </link>
    <xsl:apply-templates select="ef:spooler" mode="rss"/>
  </xsl:template>

  <xsl:template match="ef:spooler" mode="rss">
    <xsl:variable name="hidden" select="@hidden"/>
    <xsl:choose>
      <xsl:when test="$hidden = 'true'"/>
      <xsl:otherwise>
        <item>
          <xsl:variable name="name" select="ef:name/text()"/>
          <title>
            <xsl:text>Spooler Name: </xsl:text>
            <xsl:value-of select="$name"/>
          </title>
          <description>
            <xsl:apply-templates select="ef:creation-time" mode="phrase"/>
            <xsl:apply-templates select="ef:last-modified-time" mode="phrase"/>
            <xsl:apply-templates select="ef:expiration-time" mode="phrase"/>
            <xsl:apply-templates select="ef:items" mode="phrase"/>
          </description>
          <link>
            <xsl:value-of select="encode:forUriComponent($url)"/>
            <xsl:text>?_uri=//com.enginframe.system</xsl:text>
            <xsl:text>/show.spooler&amp;_spooler=</xsl:text>
            <xsl:value-of select="encode:forUriComponent(@uri)"/>
          </link>
          <guid isPermaLink="false">
            <xsl:value-of select="$url"/>
            <xsl:text>/</xsl:text>
            <xsl:value-of select="@uri"/>
          </guid>
          <pubDate>
            <xsl:apply-templates select="ef:creation-time" mode="rss"/>
          </pubDate>
        </item>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="ef:creation-time" mode="rss">
    <xsl:value-of select="java:com.enginframe.common.utils.DateFormatter.parseDateAsRFC3339(text())" />
  </xsl:template>

  <xsl:template match="ef:creation-time" mode="phrase">
    <xsl:text>This spooler</xsl:text>
    <xsl:text> was created on </xsl:text>
    <xsl:value-of select="java:com.enginframe.common.utils.DateFormatter.parseDateAsRFC3339(text())" />
  </xsl:template>

  <xsl:template match="ef:last-modified-time" mode="phrase">
    <xsl:text> was last modified on </xsl:text>
    <xsl:value-of select="java:com.enginframe.common.utils.DateFormatter.parseDateAsRFC3339(text())" />
  </xsl:template>

  <xsl:template match="ef:expiration-time" mode="phrase">
    <xsl:text> Expires on </xsl:text>
    <xsl:value-of select="java:com.enginframe.common.utils.DateFormatter.parseDateAsRFC3339(text())" />
  </xsl:template>

  <xsl:template match="ef:items" mode="phrase">
    <xsl:text> It contains </xsl:text>
    <xsl:value-of select="text()"/>
    <xsl:if test="text()=1"> item. </xsl:if>
    <xsl:if test="text() &lt; 1 or text() > 1"> items. </xsl:if>
  </xsl:template>

</xsl:stylesheet>

