#!/bin/bash

################################################################################
################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
################################################################################


#  nvidia-smi --query-gpu=index,utilization.gpu,utilization.memory,temperature.gpu --format=csv,noheader,nounits >> gpu-log.$HOSTNAME



#    <grid:resource name="ngpus">4.0</grid:resource>
#    <grid:resource name="ngpus_physical">4.0</grid:resource>
#    <grid:resource name="gpu_avg_ut">65</grid:resource>
#    <grid:resource name="gpu_avg_mut">18</grid:resource>
#    <grid:resource name="gpu_idx_ut_0">65</grid:resource>
#    <grid:resource name="gpu_idx_mut_0">16</grid:resource>
#    <grid:resource name="gpu_idx_ut_1">62</grid:resource>
#    <grid:resource name="gpu_idx_mut_1">19</grid:resource>
#    <grid:resource name="gpu_idx_ut_2">72</grid:resource>
#    <grid:resource name="gpu_idx_mut_2">23</grid:resource>

input="$1" 

if [ ! -f $1 ] ; then
    exit
fi

# Initialize variables
total_gpu_ut=0
total_gpu_mut=0

ngpus=$(cat $input | grep -v \# | wc -l)

if [ "$ngpus" == "0" ] ; then
    exit
fi

# Read GPU data (excluding the header line)
while IFS=, read -r idx cpu_ut gpu_ut temp
do
  # Skip the header or empty lines
    [[ "$idx" =~ ^#.*$ || -z "$idx" ]] && continue
    
    # Accumulate total GPU and memory utilization
    total_gpu_ut=$((total_gpu_ut + gpu_ut))
    total_gpu_mut=$((total_gpu_mut + cpu_ut))
    # Write XML entries to the output file
    echo "    <grid:resource name=\"gpu_idx_ut_$idx\">$gpu_ut</grid:resource>" 
    echo "    <grid:resource name=\"gpu_idx_mut_$idx\">$cpu_ut</grid:resource>"
    echo "    <grid:resource name=\"gpu_idx_temp_$idx\">$temp</grid:resource>"
  
done < <(cat $input) # Skip the first line (header) of the csv file

# Calculate averages
gpu_avg_ut=$(echo "scale=0; $total_gpu_ut / $ngpus" | bc)
gpu_avg_mut=$(echo "scale=0; $total_gpu_mut / $ngpus" | bc)

cat <<EOF  
    <grid:resource name="ngpus">$ngpus</grid:resource>
    <grid:resource name="ngpus_physical">$ngpus</grid:resource>
    <grid:resource name="gpu_avg_ut">$gpu_avg_ut</grid:resource>
    <grid:resource name="gpu_avg_mut">$gpu_avg_mut</grid:resource>
EOF
