<?xml version="1.0" encoding="utf-8"?>
<!--
  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.-->
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:grid="http://www.enginframe.com/2000/GRID"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:math="http://exslt.org/math"
  xmlns:java="http://xml.apache.org/xalan/java"
  extension-element-prefixes="math"
  exclude-result-prefixes="ef grid java">

  <!--
  <xsl:output
    encoding="utf-8"
    method="xml"
    media-type="text/xml"
    indent="yes"
    xalan:indent-amount="2" xmlns:xalan="http://xml.apache.org/xslt"
  />
  -->

  <xsl:key name="jobarrays" match="grid:job[@array-id]" use="@array-id"/>
  <!-- use array-id and execution-host name as key for the execution-hosts -->
  <xsl:key name="execution-hosts-by-array-id" match="grid:job[@array-id]/grid:execution-host" use="concat(../@array-id, text())"/>

  <xsl:template match="grid:job-list[@expand-array='true']">
    <xsl:copy>
      <xsl:apply-templates select="grid:job|@*" />
    </xsl:copy>
  </xsl:template>

  <xsl:template match="grid:job-list[count(grid:job) &gt; 1]">
    <xsl:copy>
      <xsl:apply-templates select="grid:job|@*" mode="compact" />
    </xsl:copy>
  </xsl:template>

  <xsl:template match="grid:execution-host" mode="compact-execution-hosts">
    <xsl:variable name="execution-host-key" select="concat(../@array-id, text())" />
    <!-- Use the current element only if it is the first item for the given execution-host-by-array-id key.
      Generate a single grid:execution-host item for each key and avoid duplicates (see Muenchian Method). E.g.
         <grid:job array-id="1">
            <grid:execution-host>A -> key 1-A -> use
         <grid:job array-id="1">
            <grid:execution-host>A -> key 1-A -> skip
            <grid:execution-host>B -> key 1-B -> use
         <grid:job array-id="1">
            <grid:execution-host>B -> key 1-B -> skip
            <grid:execution-host>C -> key 1-C -> use
    -->
    <xsl:if test="generate-id(.) = generate-id(key('execution-hosts-by-array-id', $execution-host-key)[1])">
      <grid:execution-host>
        <xsl:attribute name="cores">
          <xsl:choose>
            <xsl:when test="@cores">
              <xsl:value-of select="sum(key('execution-hosts-by-array-id', $execution-host-key)/@cores)" />
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="count(key('execution-hosts-by-array-id', $execution-host-key))" />
            </xsl:otherwise>
          </xsl:choose>
        </xsl:attribute>
        <xsl:value-of select="text()" />
      </grid:execution-host>
    </xsl:if>
  </xsl:template>

  <!-- Priority is raised because the "dynamic" predicate on key() is not considered as more specific than grid:job[@index] -->
  <xsl:template match="grid:job[@id=key('jobarrays', @array-id)[1]/@id]" mode="compact" priority="+1">
    <xsl:variable name="name">
    <xsl:choose>
        <xsl:when test="contains(grid:name, '[')"><xsl:value-of select="substring-before(grid:name, '[')" /></xsl:when>
        <xsl:when test="java:matches(string(grid:name), '.*-[0-9]*$')"><xsl:value-of select="java:substring(string(grid:name), 0, java:lastIndexOf(string(grid:name), '-'))" /></xsl:when>
        <xsl:otherwise><xsl:value-of select="grid:name" /></xsl:otherwise>
    </xsl:choose>
    </xsl:variable>
    <grid:job id="{@array-id}" type="{@type}" is-array="true"> 
      <grid:name><xsl:value-of select="concat($name, '[', ']')"/></grid:name>

      <xsl:apply-templates select="grid:owner|grid:account|grid:queue|grid:command|grid:submission-host|grid:submission-directory|grid:submission-time"/>

      <!-- merge grid:job/grid:execution-host for the given array-id -->
      <xsl:apply-templates select="key('jobarrays', @array-id)/grid:execution-host" mode="compact-execution-hosts"/>

      <grid:array-status>
        <grid:counter ef="" grid="NJOBS"><xsl:value-of select="count(key('jobarrays', @array-id))"/></grid:counter>
        <grid:counter ef="Pending" grid="PEND"><xsl:value-of select="count(key('jobarrays', @array-id)[grid:status/@ef='Pending'])"/></grid:counter>
        <grid:counter ef="Running" grid="RUN"><xsl:value-of select="count(key('jobarrays', @array-id)[grid:status/@ef='Running'])"/></grid:counter>
        <grid:counter ef="Done" grid="DONE"><xsl:value-of select="count(key('jobarrays', @array-id)[grid:status/@ef='Done'])"/></grid:counter>
        <grid:counter ef="Exit" grid="EXIT"><xsl:value-of select="count(key('jobarrays', @array-id)[grid:status/@ef='Exit'])"/></grid:counter>
        <grid:counter ef="Interrupted" grid="SSUSP"><xsl:value-of select="count(key('jobarrays', @array-id)[grid:status/@ef='Interrupted'])"/></grid:counter>
        <grid:counter ef="Suspended" grid="USUSP"><xsl:value-of select="count(key('jobarrays', @array-id)[grid:status/@ef='Suspended'])"/></grid:counter>
        <grid:counter ef="Unknown" grid="UNKWN"><xsl:value-of select="count(key('jobarrays', @array-id)[grid:status/@ef='Unknown'])"/></grid:counter>
        <grid:counter ef="Zombie" grid="ZOMBI"><xsl:value-of select="count(key('jobarrays', @array-id)[grid:status/@ef='Zombie'])"/></grid:counter>
      </grid:array-status>
    </grid:job>
  </xsl:template>

  <xsl:template match="grid:job[@array-id]" mode="compact" />

  <xsl:template match="*|@*" mode="compact">
    <!-- Demand to the default behaviour -->
    <xsl:apply-templates select="." />
  </xsl:template>

  <!-- This copies also the processing instruction -->
  <!--  <xsl:template match="node()|@*">  -->
  <xsl:template match="*|@*" priority="-1">
    <xsl:copy>
      <xsl:apply-templates select="node()|@*"/>
    </xsl:copy>
  </xsl:template>


  <!-- This is to be used with the copy template that uses match="node()|@*" -->
  <!--
  <xsl:template match="processing-instruction()"/>
  -->

  <!-- This is done by the grid.job.list.xsl -->
  <!--
  <xsl:import href="$(EF_ROOT)/plugins/grid/lib/xsl/grid.filter.library.xsl" />
  
  <xsl:template match="grid:submission-time" mode="jobarray">
    <grid:submission-time><xsl:copy-of select="@*"/>
    <xsl:value-of select="grid:date-time(.)" />
    </grid:submission-time>
  </xsl:template>
  -->

</xsl:stylesheet>
<!--
# vi:ts=2:et:ai:
-->
