<?xml version="1.0" encoding="UTF-8"?>
<!--
  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.-->
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:grid="http://www.enginframe.com/2000/GRID"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:efactions="http://www.enginframe.com/2009/efactions"
  xmlns:encode="org.owasp.encoder.Encode"
  exclude-result-prefixes="grid ef efactions encode">

  <xsl:output indent="yes" method="xml" encoding="UTF-8"/>

  <xsl:variable name="confFile" select="document('../../conf/list.hosts.status.conf.xml')" />

  <!-- Get charts colors and labels from the configuration file -->
  <xsl:variable name="chart_ok_label">
    <xsl:call-template name="getProperty">
      <xsl:with-param name="key" select="'chart_ok_label'"/>
    </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="chart_ok_color">
    <xsl:call-template name="getProperty">
      <xsl:with-param name="key" select="'chart_ok_color'"/>
    </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="chart_unavailable_label">
    <xsl:call-template name="getProperty">
      <xsl:with-param name="key" select="'chart_unavailable_label'"/>
    </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="chart_unavailable_color">
    <xsl:call-template name="getProperty">
      <xsl:with-param name="key" select="'chart_unavailable_color'"/>
    </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="chart_closed_label">
    <xsl:call-template name="getProperty">
      <xsl:with-param name="key" select="'chart_closed_label'"/>
    </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="chart_closed_color">
    <xsl:call-template name="getProperty">
      <xsl:with-param name="key" select="'chart_closed_color'"/>
    </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="chart_busy_label">
    <xsl:call-template name="getProperty">
      <xsl:with-param name="key" select="'chart_busy_label'"/>
    </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="chart_busy_color">
    <xsl:call-template name="getProperty">
      <xsl:with-param name="key" select="'chart_busy_color'"/>
    </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="chart_unlicensed_label">
    <xsl:call-template name="getProperty">
      <xsl:with-param name="key" select="'chart_unlicensed_label'"/>
    </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="chart_unlicensed_color">
    <xsl:call-template name="getProperty">
      <xsl:with-param name="key" select="'chart_unlicensed_color'"/>
    </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="chart_unknown_label">
    <xsl:call-template name="getProperty">
      <xsl:with-param name="key" select="'chart_unknown_label'"/>
    </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="chart_unknown_color">
    <xsl:call-template name="getProperty">
      <xsl:with-param name="key" select="'chart_unknown_color'"/>
    </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="chart_registered_label">
    <xsl:call-template name="getProperty">
      <xsl:with-param name="key" select="'chart_registered_label'"/>
    </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="chart_registered_color">
    <xsl:call-template name="getProperty">
      <xsl:with-param name="key" select="'chart_registered_color'"/>
    </xsl:call-template>
  </xsl:variable>

  <!--Retrieve a property from a properties file by specifying the key -->
  <xsl:template name="getProperty">
    <xsl:param name="key" />
    <xsl:value-of select="substring-before(substring-after($confFile, concat($key,'=')), '&#xA;')" />
  </xsl:template>

  <!-- Charts building -->

  <xsl:param name="chart">status</xsl:param>
  <xsl:param name="width">281</xsl:param>
  <xsl:param name="height">281</xsl:param>

  <xsl:variable name="ok_count" select="count(/grid:host-list/grid:host[grid:status/@ef='ok'])"/>
  <xsl:variable name="unavailable_count" select="count(/grid:host-list/grid:host[grid:status/@ef='unavailable'])"/>
  <xsl:variable name="busy_count" select="count(/grid:host-list/grid:host[grid:status/@ef='busy'])"/>
  <xsl:variable name="unlicensed_count" select="count(/grid:host-list/grid:host[grid:status/@ef='unlicensed'])"/>
  <xsl:variable name="closed_count" select="count(/grid:host-list/grid:host[grid:status/@ef='closed'])"/>
  <xsl:variable name="unknown_count" select="count(/grid:host-list/grid:host[grid:status/@ef='unknown'])"/>
  <xsl:variable name="registered_count" select="count(/grid:host-list/grid:host[grid:status/@ef='registered'])"/>

  <xsl:variable name="pie_values">
    <xsl:if test="$ok_count &gt; 0"><xsl:value-of select="$ok_count"/>,</xsl:if>
    <xsl:if test="$unavailable_count &gt; 0"><xsl:value-of select="$unavailable_count"/>,</xsl:if>
    <xsl:if test="$busy_count &gt; 0"><xsl:value-of select="$busy_count"/>,</xsl:if>
    <xsl:if test="$unlicensed_count &gt; 0"><xsl:value-of select="$unlicensed_count"/>,</xsl:if>
    <xsl:if test="$closed_count &gt; 0"><xsl:value-of select="$closed_count"/>,</xsl:if>
    <xsl:if test="$unknown_count &gt; 0"><xsl:value-of select="$unknown_count"/>,</xsl:if>
    <xsl:if test="$registered_count &gt; 0"><xsl:value-of select="$registered_count"/>,</xsl:if>
  </xsl:variable>

  <xsl:variable name="pie_labels">
    <xsl:if test="$ok_count &gt; 0"><xsl:value-of select="$chart_ok_label"/> (<xsl:value-of select="$ok_count"/>),</xsl:if>
    <xsl:if test="$unavailable_count &gt; 0"><xsl:value-of select="$chart_unavailable_label"/> (<xsl:value-of select="$unavailable_count"/>),</xsl:if>
    <xsl:if test="$busy_count &gt; 0"><xsl:value-of select="$chart_busy_label"/> (<xsl:value-of select="$busy_count"/>),</xsl:if>
    <xsl:if test="$unlicensed_count &gt; 0"><xsl:value-of select="$chart_unlicensed_label"/> (<xsl:value-of select="$unlicensed_count"/>),</xsl:if>
    <xsl:if test="$closed_count &gt; 0"><xsl:value-of select="$chart_closed_label"/> (<xsl:value-of select="$closed_count"/>),</xsl:if>
    <xsl:if test="$unknown_count &gt; 0"><xsl:value-of select="$chart_unknown_label"/> (<xsl:value-of select="$unknown_count"/>),</xsl:if>
    <xsl:if test="$registered_count &gt; 0"><xsl:value-of select="$chart_registered_label"/> (<xsl:value-of select="$registered_count"/>),</xsl:if>
  </xsl:variable>

  <xsl:variable name="pie_colors">
    <xsl:if test="$ok_count &gt; 0"><xsl:value-of select="$chart_ok_color"/>,</xsl:if><!-- Ok -->
    <xsl:if test="$unavailable_count &gt; 0"><xsl:value-of select="$chart_unavailable_color"/>,</xsl:if><!-- Unavailable -->
    <xsl:if test="$busy_count &gt; 0"><xsl:value-of select="$chart_busy_color"/>,</xsl:if><!-- Busy -->
    <xsl:if test="$unlicensed_count &gt; 0"><xsl:value-of select="$chart_unlicensed_color"/>,</xsl:if><!-- Unlicensed -->
    <xsl:if test="$closed_count &gt; 0"><xsl:value-of select="$chart_closed_color"/>,</xsl:if><!-- Closed -->
    <xsl:if test="$unknown_count &gt; 0"><xsl:value-of select="$chart_unknown_color"/></xsl:if><!-- Unknown -->
    <xsl:if test="$registered_count &gt; 0"><xsl:value-of select="$chart_registered_color"/></xsl:if><!-- Registered -->
  </xsl:variable>

  <xsl:template match="/grid:host-list[$chart='slots']" priority="+1">
    <h4>Not yet implemented</h4>
  </xsl:template>

  <xsl:template match="/grid:host-list[$chart='usage']" priority="+1">
    <h4>Not yet implemented</h4>
  </xsl:template>

  <xsl:template match="/grid:host-list">
    <h4>Unknown chart type <xsl:value-of select="$chart"/></h4>
  </xsl:template>

  <xsl:template match="/grid:host-list[$chart='status']" priority="+1">
    <ch:chart xmlns:ch="http://www.enginframe.com/2010/chart">
      <ch:data>
        <ch:series><xsl:value-of select="$pie_values"/></ch:series>
        <ch:labels><xsl:value-of select="$pie_labels"/></ch:labels>
      </ch:data>
      <ch:view type="pie" width="{$width}" height="{$height}">
        <ch:option name="colors"><xsl:value-of select="$pie_colors"/></ch:option>
        <ch:option name="is3D">false</ch:option>
        <ch:option name="legend">bottom</ch:option>
        <ch:option name="legendOrientation">vertical</ch:option>
      </ch:view>
    </ch:chart>
  </xsl:template>
</xsl:stylesheet>
