<?xml version="1.0"?>
<!--
  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.-->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
                xmlns:efrss="http://www.enginframe.com/2010/rss"
                xmlns:grid="http://www.enginframe.com/2000/GRID"
                xmlns:java="http://xml.apache.org/xalan/java"
                xmlns:encode="org.owasp.encoder.Encode"
                exclude-result-prefixes="ef grid java encode">

  <xsl:include href="$(EF_ROOT)/plugins/rss/lib/xsl/com.enginframe.rss.xsl"/>

  <xsl:strip-space elements="*" />

  <xsl:output media-type="application/rss+xml" version="1.0" indent="yes" encoding="UTF-8"/>

  <xsl:template match="/efrss:metadata">
    <rss version="2.0">
      <channel>
        <title>
           <xsl:value-of select="$channel_title"/>
        </title>
        <description>
          <xsl:value-of select="$channel_description"/>
        </description>
        <language>en-us</language>
        <pubDate>
           <xsl:value-of select="$pub-date"/>
        </pubDate>
        <docs>http://blogs.law.harvard.edu/tech/rss</docs>
        <ttl>
           <xsl:value-of select="$ttl"/>
        </ttl>
        <link>
          <xsl:value-of select="$url"/>
          <xsl:text>?_uri=//com.enginframe.grid</xsl:text>
          <xsl:if test="$channel_title = 'All Jobs'">
            <xsl:text>/list.all.jobs </xsl:text>
          </xsl:if>
          <xsl:if test="$channel_title = 'My Jobs'">
            <xsl:text>/list.jobs</xsl:text>
          </xsl:if>
        </link>
        <xsl:apply-templates select="/grid:job-list[not (@mode = 'array')]" mode="jobs"/>
        <xsl:apply-templates select="/grid:job-list[@mode = 'array']" mode="jobs-array"/>
      </channel>
    </rss>
  </xsl:template>

  <xsl:template match="/grid:job-list"/>

  <xsl:template match="grid:job-list" mode="jobs">
    <xsl:apply-templates select="grid:job[not (@mode = 'array')]" mode="jobs">
      <xsl:sort select="@id" data-type="number" order="ascending"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="grid:job-list" mode="jobs-array">
    <xsl:apply-templates select="grid:job" mode="jobs-array">
      <xsl:sort select="@id" data-type="number" order="ascending"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="grid:job" mode="jobs">
    <!-- renders normal jobs -->
    <xsl:call-template name="normal_job"/>
  </xsl:template>

  <xsl:template match="grid:job" mode="jobs-array">
    <!-- renders job arrays -->
    <xsl:call-template name="normal_job">
      <xsl:with-param name="mode">array</xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="normal_job">
    <xsl:param name="mode"/>
    <item>
      <xsl:variable name="name">
        <xsl:value-of select="substring-before(concat(grid:name,'['),'[')"/>
        <xsl:if test="not(grid:name)">
          <xsl:value-of select="grid:command"/>
        </xsl:if>
      </xsl:variable>
      <xsl:choose>
        <xsl:when test="$mode = 'array'">
          <xsl:variable name="my_id" select="@id"/>
          <xsl:variable name="len" select="concat('[',substring-after(grid:name/text(),'['))"/>
          <title>
            <xsl:text>Job Array ID: </xsl:text>
            <xsl:value-of select="@id"/>
            <xsl:text> </xsl:text>
            <xsl:value-of select="$len"/>
            <xsl:text>, Name: </xsl:text>
            <xsl:value-of select="$name"/>
          </title>
        </xsl:when>
        <xsl:otherwise>
          <title>
            <xsl:text>Job ID: </xsl:text>
            <xsl:value-of select="@id"/>
            <xsl:text>, Name: </xsl:text>
            <xsl:value-of select="$name"/>
          </title>
        </xsl:otherwise>
      </xsl:choose>
      <description>
        <xsl:choose>
          <xsl:when test="$mode = 'array'">
            <xsl:apply-templates select="grid:submission-time" mode="phrase">
              <xsl:with-param name="array">yes</xsl:with-param>
            </xsl:apply-templates>
            <xsl:apply-templates select="grid:owner" mode="phrase"/>
            <xsl:apply-templates select="grid:array-status" mode="array"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="grid:submission-time" mode="phrase"/>
            <xsl:apply-templates select="grid:owner" mode="phrase"/>
            <xsl:apply-templates select="grid:status" mode="jobs"/>
            <xsl:if test="grid:reasons">
              <xsl:apply-templates select="grid:reasons/grid:reason" mode="jobs"/>
            </xsl:if>
            <xsl:apply-templates select="grid:total-cpu-usage" mode="phrase"/>
            <xsl:apply-templates select="grid:memory-usage" mode="phrase"/>
            <xsl:apply-templates select="grid:swap-usage" mode="phrase"/>
          </xsl:otherwise>
        </xsl:choose>
      </description>
      <xsl:variable name="extra.details">
        <xsl:if test="@type = 'globus'">
          <xsl:text>&amp;_spooler=</xsl:text>
          <xsl:value-of select="grid:submission-directory"/>
        </xsl:if>
      </xsl:variable>
      <link>
        <xsl:value-of select="$url"/>
        <xsl:text>?_uri=//com.enginframe.grid</xsl:text>
        <xsl:text>/job.info&amp;jobid=</xsl:text>
        <xsl:value-of select="encode:forUriComponent(@id)"/>
        <xsl:value-of select="encode:forUriComponent($extra.details)"/>
      </link>
      <guid isPermaLink="false">
        <xsl:value-of select="$url"/>
        <xsl:text>/</xsl:text>
        <xsl:value-of select="@type"/>
        <xsl:text>/</xsl:text>
        <xsl:value-of select="@id"/>
        <xsl:text>/</xsl:text>
        <xsl:value-of select="grid:status/text()"/>
        <xsl:text>/</xsl:text>
        <xsl:value-of select="$extra.details"/>
      </guid>
      <pubDate>
        <xsl:apply-templates select="grid:submission-time" mode="jobs"/>
      </pubDate>
    </item>
  </xsl:template>

  <xsl:template match="grid:job[@type='globus']/grid:status" mode="jobs">
    The job state is: <xsl:value-of select="text()"/>
  </xsl:template>

  <xsl:template match="grid:status" priority="-1" mode="jobs">
    <xsl:choose>
      <xsl:when test="@ef = 'Done'">
        <xsl:text>The job finished normally. </xsl:text>
      </xsl:when>
      <xsl:when test="@ef = 'Exit'">
        <xsl:text>The job terminated abnormally. </xsl:text>
      </xsl:when>
      <xsl:when test="@ef = 'Pending'">
        <xsl:text>The job is waiting for scheduling and dispatch. </xsl:text>
      </xsl:when>
      <xsl:when test="@ef = 'Running'">
        <xsl:text>The job is running on host </xsl:text>
        <xsl:apply-templates select="parent::*/grid:execution-host"/>
        <xsl:text>. </xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>The job has been suspended. </xsl:text>
      </xsl:otherwise>
    </xsl:choose>

  </xsl:template>

  <xsl:template match="grid:array-status" mode="array">
    <xsl:variable name="my_id" select="../@id"/>
    <xsl:variable name="size" select="grid:counter[@ef='']/text()"/>
    <xsl:variable name="done" select="grid:counter[@ef='Done']/text()"/>
    <xsl:variable name="exit" select="grid:counter[@ef='Exit']/text()"/>
    <xsl:variable name="run" select="grid:counter[@ef='Running']/text()"/>
    <xsl:variable name="pend" select="grid:counter[@ef='Pending']/text()"/>
    <xsl:variable name="susp" select="sum(grid:counter[@ef='Suspended']/text())"/>
    <xsl:variable name="int" select="grid:counter[@ef='Interrupted']/text()"/>
    <xsl:variable name="finished" select="$done + $exit"/>
    <xsl:text>The job array is composed by </xsl:text><xsl:value-of select="$size"/><xsl:text> jobs. </xsl:text>
    <xsl:if test="$finished = $size">
      <xsl:text>All the jobs terminated. </xsl:text>
    </xsl:if>
    <xsl:if test="$done = 1"><xsl:text>One job completed successfully. </xsl:text></xsl:if>
    <xsl:if test="($done > 1 and $finished > $done)"><xsl:value-of select="$done"/><xsl:text> jobs completed successfully. </xsl:text></xsl:if>
    <xsl:if test="$exit = 1"><xsl:text>One job terminated abnormally. </xsl:text></xsl:if>
    <xsl:if test="$exit > 1"><xsl:value-of select="$exit"/><xsl:text> jobs terminated abnormally. </xsl:text></xsl:if>
    <xsl:if test="$run = 1"><xsl:text>One job is running. </xsl:text></xsl:if>
    <xsl:if test="$run > 1"><xsl:value-of select="$run"/><xsl:text> jobs are running. </xsl:text></xsl:if>
    <xsl:if test="$pend = 1"><xsl:text>One job is waiting for scheduling and dispatch. </xsl:text></xsl:if>
    <xsl:if test="$pend > 1"><xsl:value-of select="$pend"/><xsl:text> jobs are waiting for scheduling and dispatch. </xsl:text></xsl:if>
    <xsl:if test="$susp = 1"><xsl:text>One job has been suspended. </xsl:text></xsl:if>
    <xsl:if test="$susp > 1"><xsl:value-of select="$susp"/><xsl:text> jobs have been suspended. </xsl:text></xsl:if>
    <xsl:if test="$int = 1"><xsl:text>One job has been interrupted. </xsl:text></xsl:if>
    <xsl:if test="$int > 1"><xsl:value-of select="$int"/><xsl:text> jobs have been interrupted. </xsl:text></xsl:if>
  </xsl:template>

  <xsl:template match="grid:execution-host" mode="jobs">
    <xsl:value-of select="text()"/>
  </xsl:template>

  <xsl:template match="grid:reason" mode="jobs">
    <xsl:value-of select="text()"/>
    <xsl:if test="position()!=last()">
      <xsl:text>. </xsl:text>
    </xsl:if>
    <xsl:if test="position()=last()">
      <xsl:text>.</xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="grid:submission-time|grid:dispatch-time|grid:finish-time" mode="jobs">
    <xsl:value-of select="java:com.enginframe.common.utils.DateFormatter.formatAsRFC822String(@year, @month, @day, @hour, @minute)" />
  </xsl:template>

  <xsl:template match="grid:submission-time" mode="phrase">
    <xsl:param name="array"/>
    <xsl:text>This job</xsl:text>
    <xsl:if test="$array='yes'"> array</xsl:if>
    <xsl:text> was submitted on </xsl:text>
    <xsl:value-of select="@day"/>
    <xsl:text> </xsl:text>
    <xsl:value-of select="@month"/>
    <xsl:text> </xsl:text>
    <xsl:value-of select="@year"/>
    <xsl:text> at </xsl:text>
    <xsl:value-of select="@hour"/>
    <xsl:text>:</xsl:text>
    <xsl:value-of select="@minute"/>
  </xsl:template>

  <xsl:template match="grid:owner" mode="phrase">
    <xsl:text> by user </xsl:text>
    <xsl:value-of select="text()"/>
    <xsl:text>. </xsl:text>
  </xsl:template>

  <xsl:template match="grid:total-cpu-usage" mode="phrase">
    <xsl:text> Total CPU usage </xsl:text>
    <xsl:value-of select="substring-before(text(),'.')"/>
    <xsl:text> sec.</xsl:text>
  </xsl:template>

  <xsl:template match="grid:memory-usage" mode="phrase">
    <xsl:text> Memory usage </xsl:text>
    <xsl:value-of select="text()"/>
    <xsl:text>. </xsl:text>
  </xsl:template>

  <xsl:template match="grid:swap-usage" mode="phrase">
    <xsl:text> Swap usage </xsl:text>
    <xsl:value-of select="text()"/>
    <xsl:text>. </xsl:text>
  </xsl:template>
</xsl:stylesheet>


