/*global jQuery */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

(function ($) {

    $.widget('ui.hycharts', {

        options: {
            conf: {}
        },

        _create: function () {

            var self;

            this.element.hide().addClass('hy-box hy-charts ui-widget');

            this.headerDiv = $('<div><table cellspacing="0" cellpadding="0"><tr><td/><td/></tr></table></div>').appendTo(this.element);
            this.contentDiv = $('<div></div>').appendTo(this.element);

            this.headerDiv.addClass('hy-box-header ui-widget-header');
            this.contentDiv.addClass('hy-box-content ui-widget-content');

            this.titleTd = this.headerDiv.find("td:first-child");
            this.titleTd.width('99%');

            this.contentDiv.text('Loading...');

            this.hasMenu = false;
            this.menu = null;
            this.selected = null;
            self = this;

            if (this.options.conf.charts) {
                // FIXME: manage default chart
                $.each(this.options.conf.charts || {}, function (i, chart) {
                    if (i === 0) {
                        self.titleTd.text(chart.label);
                        self.element.show();
                        self._load(chart.chartid);
                    } else {
                        self.hasMenu = true;
                        return false;
                    }
                });
            }

            if (this.hasMenu) {
                $("<div></div>").addClass("hy-charts-arrow-down png-bg").appendTo(this.headerDiv.find("td:last-child"));

                this.headerDiv.hover(function () {
                    $(this).addClass('ui-state-hover');
                }, function () {
                    $(this).removeClass('ui-state-hover');
                });

                this.headerDiv.click(function () {
                    self._openMenu();
                });
            }
        },

        _openMenu: function () {
            var menu_width, menu, self, topCorrection, leftCorrection, options;

            if (this.menu === null) {
                topCorrection = 3;
                leftCorrection = 0;
                self = this;

                if (false ) { // $.browser.name === "msie"
                    topCorrection = 1;
                    if ($.browser.version.indexOf("8.") >= 0) {
                        topCorrection = -1;
                    }
                    leftCorrection = 1;
                    if ($.browser.version.indexOf("8.") >= 0) {
                        topCorrection = 1;
                    }
                    if ($.browser.version.indexOf("7.") >= 0) {
                        topCorrection = 4;
                    }
                }
		var userAgent = navigator.userAgent.toLowerCase();

		if (userAgent.indexOf("chrome") > -1 || userAgent.indexOf("safari") > -1) {
                    // if ($.browser.name === "chrome" || $.browser.name === "safari") {
                    topCorrection = 4;
                    leftCorrection = 1;
                }

                menu_width =  this.headerDiv.width() * 2 / 3;
                options = {
                    minWidth: menu_width,
                    offsetLeft: this.headerDiv.innerWidth() - menu_width + leftCorrection,
                    offsetTop: this.headerDiv.height() - topCorrection,
                    divClass: "hy-charts-menu",
                    // effect: "blind",
                    onClick: function (e, menuItem) {
                        self.titleTd.text(menuItem.data.label);
                        self._load(menuItem.data.chartid);
                    }
                };  // 2px more cause margins

                this.menu = new $.Menu(this.headerDiv, null, options);

                $.each(this.options.conf.charts, function (i, item) {
                    self.menu.addItem(new $.MenuItem({
                        src: efEncodeHtml(item.label),
                        data: item
                    }, options));
                });
            }
            this.menu.show();
        },

        _load: function (chart) {
            if (this.element.is(':visible')) {
                this.selected = chart;
                this.contentDiv.load(
                    this.options.conf.params.SDF + '?_uri=' + this.options.conf.params.chartServiceUri,
                    $.extend({'chart': chart, 'width': this.contentDiv.width(), 'height': this.contentDiv.width()},
                        this.options.conf.params.chartServiceParams)
                );
            }
        },

        setPostDataItem: function (key, value) {
            this.options.conf.params.chartServiceParams[key] = value;
        },

        reload: function () {
            this._load(this.selected);
        },

        destroy: function () {

            this.element.removeClass('hy-box hy-charts ui-widget');

            this.headerDiv.remove();
            this.contentDiv.remove();
            this.menuDiv.remove();

            $.Widget.prototype.destroy.apply(this, arguments);

            return this;
        }
    });

}(jQuery));

// ex:ts=4:et:
