/*global jQuery */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

(function ($) {

    $.widget('ui.hyclusters', {

        options: {
            title: null,
            conf: {}
        },

        _create: function () {
            var self, defaultCluster;

            self = this;
            this._selected = null;

            defaultCluster = this.options.conf.params.currentCluster;
            var facet = this.options.conf.params.facet;

            if (!this.options.conf.params.hideClusterSelector && this.options.conf.clusters && this.options.conf.clusters.length > 1) {
                this.element.addClass('hy-box hy-clusters ui-widget');

                this.headerDiv = $('<div></div>').appendTo(this.element);
                this.contentDiv = $('<div></div>').appendTo(this.element);
                this.contentUl = $('<ul></ul>').appendTo(this.contentDiv);

                this.headerDiv.addClass('hy-box-header ui-widget-header');
                this.contentDiv.addClass('hy-box-content ui-widget-content');
                this.contentUl.addClass('ui-helper-reset');

                if (this.options.title === null) {
                    this.headerDiv.text('Clusters');
                } else {
                    this.headerDiv.text(this.options.title);
                }

                $.each(this.options.conf.clusters, function (i, cluster) {
                    if (facet === "HOSTS" && cluster.status !== "READY") return

                    var clusterLi = $('<li>' + efEncodeHtml(cluster.name) + ' [' + efEncodeHtml(cluster.status) + ']</li>');
                    self.contentUl.append(clusterLi);
                    if (i === 0 || (cluster.type === defaultCluster.type && cluster.id === defaultCluster.id)) {
                        self.contentUl.children('li.ui-state-highlight').removeClass('ui-state-highlight');
                        clusterLi.addClass('ui-state-highlight');
                        self._selected = cluster;
                    }

                    clusterLi.bind('click', {cluster: cluster}, function (event) {
                        var clusterLi;
                        clusterLi = $(this);

                        if (!clusterLi.hasClass('ui-state-highlight')) {
                            self._selected = event.data.cluster;
                            self._unselectAll();
                            clusterLi.addClass('ui-state-highlight');
                            self._trigger('select', null, {cluster: event.data.cluster});
                        }

                        event.stopPropagation();
                    });
                });
            } else if (!this.options.conf.params.hideClusterSelector && this.options.conf.clusters && this.options.conf.clusters.length === 1 &&
                       defaultCluster.id && this.options.conf.clusters[0].id !== defaultCluster.id) {
                // if we just have one cluster because the others are offline, but it is not the current one
                // force a reload with the proper param
                self._trigger('select', null, {cluster: self.options.conf.clusters[0]});
            } else {
                // hide the cluster box if no clusters are specified
                this.element.hide();
                return;
            }
        },

        destroy: function () {

            this.element.removeClass('hy-box hy-clusters ui-widget');

            this.headerDiv.remove();
            this.contentDiv.remove();

            $.Widget.prototype.destroy.apply(this, arguments);

            return this;
        },

        _unselectAll: function () {
            this._selected = null;
            this.contentUl.children('li.ui-state-highlight').removeClass('ui-state-highlight');

            return this;
        },

        selected: function () {
            return this._selected;
        }
    });

}(jQuery));

// ex:ts=4:et:
