/*global jQuery, window, efApplets.openMFDWindow, efEncodeHtml */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
 */

(function ($) {

    var mimeTypes, customMimeTypes;

    // TODO: add other file extensions
    mimeTypes = {
        'xls' : 'hy-mime-type-icon-excel',
        'doc' : 'hy-mime-type-icon-word',
        // TODO: mpeg and mpg will be reintroduced when we'll add the ability to disable preview for known mime types
        //' mpeg' : 'hy-mime-type-icon-video',
        // 'mpg' : 'hy-mime-type-icon-video',
        'glb' : 'hy-mime-type-icon-modelview',
        'glTF' : 'hy-mime-type-icon-modelview',
        'gltf' : 'hy-mime-type-icon-modelview',
        'mp4' : 'hy-mime-type-icon-video',
        'webm' : 'hy-mime-type-icon-video',
        'ogg' : 'hy-mime-type-icon-video',
        'url' : 'hy-mime-type-icon-url',
        'htm' : 'hy-mime-type-icon-html',
        'html' : 'hy-mime-type-icon-html',
        'css' : 'hy-mime-type-icon-text',
        'jpg' : 'hy-mime-type-icon-image',
        'JPG' : 'hy-mime-type-icon-image',
        'jpeg' : 'hy-mime-type-icon-image',
        'webp' : 'hy-mime-type-icon-image',
        'gif' : 'hy-mime-type-icon-image',
        'png' : 'hy-mime-type-icon-image',
        'mp3' : 'hy-mime-type-icon-audio',
        'wav' : 'hy-mime-type-icon-audio',
        'pdf' : 'hy-mime-type-icon-pdf',
        'PDF' : 'hy-mime-type-icon-pdf',
        'ppt' : 'hy-mime-type-icon-powerpoint',
        'txt' : 'hy-mime-type-icon-text',
        'conf' : 'hy-mime-type-icon-text',
        'nas' : 'hy-mime-type-icon-text',
        'dat' : 'hy-mime-type-icon-text',
        'bdf' : 'hy-mime-type-icon-text',
        'inp' : 'hy-mime-type-icon-text',
        'input' : 'hy-mime-type-icon-text',
        'ps1' : 'hy-mime-type-icon-text',
        'inc' : 'hy-mime-type-icon-text',
        'include' : 'hy-mime-type-icon-text',
        'cfd' : 'hy-mime-type-icon-text',
        'fem' : 'hy-mime-type-icon-text',
        'key' : 'hy-mime-type-icon-text',
        'las' : 'hy-mime-type-icon-text',
        'dvn' : 'hy-mime-type-icon-text',
        'rwd' : 'hy-mime-type-icon-text',
        'pvt' : 'hy-mime-type-icon-text',
        'ipynb' : 'hy-mime-type-icon-text',
        'grdecl' : 'hy-mime-type-icon-text',
        'config' : 'hy-mime-type-icon-text',
        'cfg' : 'hy-mime-type-icon-text',
        'log' : 'hy-mime-type-icon-text',
        'py' : 'hy-mime-type-icon-text',
        'java' : 'hy-mime-type-icon-text',
        'rb' : 'hy-mime-type-icon-text',
        'js' : 'hy-mime-type-icon-text',
        'ini' : 'hy-mime-type-icon-text',
        'md' : 'hy-mime-type-icon-text',
        'markdown' : 'hy-mime-type-icon-text',
        'csv' : 'hy-mime-type-icon-text',
        'env' : 'hy-mime-type-icon-text',
        'php' : 'hy-mime-type-icon-text',
        'xml' : 'hy-mime-type-icon-text',
        'json' : 'hy-mime-type-icon-text',
        'jsx' : 'hy-mime-type-icon-text',
        'tsx' : 'hy-mime-type-icon-text',
        'sql' : 'hy-mime-type-icon-text',
        'sh' : 'hy-mime-type-icon-text',
        'bat' : 'hy-mime-type-icon-text',
        'cmd' : 'hy-mime-type-icon-text',
        'pl' : 'hy-mime-type-icon-text',
        'ts' : 'hy-mime-type-icon-text',
        'go' : 'hy-mime-type-icon-text',
        'zip' : 'hy-mime-type-icon-archive',
        'Z' : 'hy-mime-type-icon-archive',
        'gz': 'hy-mime-type-icon-archive',
        'bz2': 'hy-mime-type-icon-archive'
    };

    customMimeTypes = {};

    // This function writes a two-framed window with user-controlled streaming download
    function streamingDownloadWindow(root_context, filename, uri, path, size, streaming_offset, keepalive, scrollatstart, plugin, extraURL) {
        var theStreamerWindow, slowStep, fastStep, slowRefresh, fastRefresh, myOptions, myUrl;

        // Tune these values according to your needs
        slowStep = "50";
        fastStep = "1000000";
        slowRefresh = "100";
        fastRefresh = "10";

        // These options control window behaviour
        myOptions = "toolbar=no," +
                    "location=no," +
                    "directories=no," +
                    "status=no," +
                    "menubar=no," +
                    "scrollbars=yes," +
                    "resizable=yes," +
                    "copyhistory=no";

        // This is the original streaming download url
        myUrl = "/" + root_context;
        myUrl = myUrl + "/" + "download";
        myUrl = myUrl + "/" + encodeURIComponent(filename);
        myUrl = myUrl + "?" + "_spooler=" + encodeURIComponent(uri);
        myUrl = myUrl + "&" + "_file=" + encodeURIComponent(path);
        myUrl = myUrl + "&" + "_plugin=" + plugin;
        myUrl = myUrl + "&" + "_streaming=on";
        myUrl = myUrl + "&" + "_size=" + size;
        myUrl = myUrl + "&" + "_offset=" + streaming_offset;
        myUrl = myUrl + "&" + "_keepalive=" + keepalive;
        if (extraURL && extraURL !== '') {
            myUrl = myUrl + extraURL;
        }

        // Let's open a new window
        // First parameter is empty because we are going to write its content dynamically
        theStreamerWindow = window.open('', '', myOptions);

        // Main window will contain two frames.
        // Upper frame will contain navigation buttons.
        // Lower frame will contain the real streaming file.
        // src="about:blank" is used to get empty frames because netscape 4.x requires an src
        // attribute in order to write inside a frame with windowName.frameName.document.write().
        // Fixed size for upper frame is needed because if you resize in netscape 4.x you get the
        // calling page(usually the spooler page) instead of dynamic html writtenI by JavaScript.
        theStreamerWindow.document.writeln('<html>');
        theStreamerWindow.document.writeln('  <head>');
        theStreamerWindow.document.writeln('  <title>EF Portal Streaming Download -- ' + efEncodeHtml(filename) + '</title>');
        theStreamerWindow.document.writeln('  </head>');
        theStreamerWindow.document.writeln('  <frameset rows="56,*" frameborder="no" framespacing="10" border="10">');
        theStreamerWindow.document.writeln('    <frame name="navigationFrame" src="about:blank" noresize></frame>');
        theStreamerWindow.document.writeln('    <frame name="content"></frame>');
        theStreamerWindow.document.writeln('  </frameset>');
        theStreamerWindow.document.writeln('</html>');

        // Let's write lower frame
        theStreamerWindow.content.document.location.href = myUrl;

        // Let's write upper frame.
        theStreamerWindow.navigationFrame.document.writeln('<html>');
        theStreamerWindow.navigationFrame.document.writeln('  <head>');
        theStreamerWindow.navigationFrame.document.writeln('    <script type="text/javascript">');
        theStreamerWindow.navigationFrame.document.writeln('      var scrolldelay1 = "";');
        theStreamerWindow.navigationFrame.document.writeln('      var scrolldelay2 = "";');
        theStreamerWindow.navigationFrame.document.writeln('      function pageScroll() {');
        theStreamerWindow.navigationFrame.document.writeln('        top.content.scrollBy(0,' + slowStep + ');');
        theStreamerWindow.navigationFrame.document.writeln('        scrolldelay1 = setTimeout("pageScroll()",' + slowRefresh + ');');
        theStreamerWindow.navigationFrame.document.writeln('      }');
        theStreamerWindow.navigationFrame.document.writeln('      function pageBottom() {');
        theStreamerWindow.navigationFrame.document.writeln('        top.content.scrollBy(0,' + fastStep + ');');
        theStreamerWindow.navigationFrame.document.writeln('        scrolldelay2 = setTimeout("pageBottom()",' + fastRefresh + ');');
        theStreamerWindow.navigationFrame.document.writeln('      }');
        theStreamerWindow.navigationFrame.document.writeln('      function stopScroll() {');
        theStreamerWindow.navigationFrame.document.writeln('        clearTimeout(scrolldelay1);');
        theStreamerWindow.navigationFrame.document.writeln('        clearTimeout(scrolldelay2);');
        theStreamerWindow.navigationFrame.document.writeln('      }');
        theStreamerWindow.navigationFrame.document.writeln('      function pageTop() {');
        theStreamerWindow.navigationFrame.document.writeln('        stopScroll();');
        theStreamerWindow.navigationFrame.document.writeln('        top.content.scroll(0,0);');
        theStreamerWindow.navigationFrame.document.writeln('      }');
        theStreamerWindow.navigationFrame.document.writeln('    </script>');
        theStreamerWindow.navigationFrame.document.writeln('  </head>');
        theStreamerWindow.navigationFrame.document.writeln('  <body>');
        theStreamerWindow.navigationFrame.document.writeln('    <form>');
        theStreamerWindow.navigationFrame.document.writeln('      <input type="button" value="Start Scroll" onclick="pageScroll()"/>');
        theStreamerWindow.navigationFrame.document.writeln('      <input type="button" value="Stop Scroll"  onclick="stopScroll()"/>');
        theStreamerWindow.navigationFrame.document.writeln('      <input type="button" value="Go to Top"    onclick="pageTop()"/>');
        theStreamerWindow.navigationFrame.document.writeln('      <input type="button" value="Go to Bottom" onclick="pageBottom()"/>');
        theStreamerWindow.navigationFrame.document.writeln('      <input type="button" value="Close"        onclick="top.close()"/>');
        theStreamerWindow.navigationFrame.document.writeln('    </form>');
        theStreamerWindow.navigationFrame.document.writeln('  </body>');

        if (scrollatstart === '1') {
            theStreamerWindow.navigationFrame.document.writeln(' <script type="text/javascript">');
            theStreamerWindow.navigationFrame.document.writeln('   pageScroll();');
            theStreamerWindow.navigationFrame.document.writeln(' </script>');
        }

        theStreamerWindow.navigationFrame.document.writeln('</html>');
    }

    function simpleInputDialog(dialogTitle, inputLabel, buttonLabel, oldValue, actionfunc) {
        var dialog, entry, button, dialogButtons;
        dialog = jQuery('<div class="hy-simple-input-dialog"></div>').appendTo(jQuery('body'));
        jQuery('<label for="new-value" style="display:block">' + inputLabel + ':</label>').appendTo(dialog);
        entry = jQuery('<input type="text" name="value" id="new-value" style="width:90%"></input>').val(oldValue).appendTo(dialog);

        dialogButtons = {
            Cancel: function () {
                jQuery(this).dialog("close");
            }
        };
        dialogButtons[buttonLabel] = function () {
            var newValue;

            newValue = entry.val();
            if (newValue.length <= 0) {
                return false;
            }

            jQuery(this).dialog("close");

            actionfunc(newValue);
        };

        dialog.dialog({
            title: dialogTitle,
            resizable: false,
            buttons: dialogButtons,
            modal: true
        });

        button = jQuery('button:contains(' + buttonLabel + ')', dialog.parent('div.ui-dialog'));
        button.addClass('ui-priority-primary');
        entry.keypress(function (e) {
            if (e.which === 13) {
                button.click();
                return false;
            }

            return true;
        });
    }

    $.extend($.hydrogen, {

        placesFormatter : function (cellvalue, options, rowObject) {
            var cl;

            if (rowObject.type === 'remote') {
                cl = 'hy-mime-type-icon-folder-network';
            } else {
                cl = 'hy-mime-type-icon-folder';
            }

            // return '<a class="hy-file-browser-place"><div class="hy-mime-type-icon ' + cl + ' img-bg"/><span>' + efEncodeHtml(cellvalue) + '</span></a>';
            return '<a class="hy-file-browser-place"><div class="hy-mime-type-icon ' + cl + ' img-bg"></div><span>' + efEncodeHtml(cellvalue) + '</span></a>';
        },

        fileNameFormatter : function (cellvalue, options, rowObject) {
            var row, linkFiles, disableFiles, ext, pos, tag, cl, icl, rel;

            row = $(rowObject);
            linkFiles = true;
            disableFiles = false;

            if (typeof efSpoolerData !== 'undefined') {
                linkFiles = efSpoolerData.getVrootType(options.colModel.formatoptions.widgetId) !== "hpc";
            }

            if (options.colModel.formatoptions !== undefined) {
                if (options.colModel.formatoptions.linkFiles !== undefined) {
                    linkFiles = options.colModel.formatoptions.linkFiles;
                }

                if (options.colModel.formatoptions.disableFiles !== undefined) {
                    disableFiles = options.colModel.formatoptions.disableFiles;
                }
            }

            if (row.attr('type') === 'folder') {
                tag = 'a';
                rel = cellvalue;
                cl = 'hy-file-browser-folder';
                icl = 'hy-mime-type-icon-folder';
            } else {
                if (linkFiles) {
                    tag = 'a';
                } else {
                    tag = 'span';
                }

                rel = $("size", row).text() + ':' + cellvalue;
                cl = 'hy-file-browser-file';

                if (disableFiles) {
                    cl += ' ui-state-disabled';
                }

                pos = cellvalue.lastIndexOf('.');
                if (pos < 0) {
                    ext = '';
                } else {
                    // ext = cellvalue.substr(pos + 1);
                    ext = cellvalue.substr(pos + 1).toLowerCase();
                }

                [mimeTypes, customMimeTypes].some(function(mt) {
                    icl = mt[ext];
                    return (icl !== undefined);
                });

                if (!icl) {
                    icl = 'hy-mime-type-icon-file';
                }
            }

            //return '<' + tag + ' rel="' + efEncodeHtml(rel) + '" class="hy-table-active-element ' + cl + '">' +
            //           '<div class="hy-mime-type-icon ' + icl + ' img-bg"/><span class="hy-filebrowser-param-name">' + efEncodeHtml(cellvalue) + '</span>' +
            //    '</' + tag + '>';
	    cellvalue=decodeURIComponent(cellvalue);
            rel=decodeURIComponent(rel);

            return '<' + tag + ' onmouseout="javascript:window.fileNameOnMouseOver(this, \'remove\')"  onmouseover="javascript: window.fileNameOnMouseOver(this, \'create\'); " rel="' + efEncodeHtml(rel) + '" class="hy-table-active-element ' + cl + '">' +
                '<div class="hy-mime-type-icon ' + icl + ' img-bg"></div><span class="hy-filebrowser-param-name">' + efEncodeHtml(cellvalue) + '</span>' +
                '</' + tag + '>';
        },

        fileNameUnformatter: function (cellvalue, options, cell) {
            return jQuery('.hy-filebrowser-param-name', cell).text();
        }
    });
    window.changeLocationHelper = function(p_id, p_path) {
        var r=$("#fm-browse-file-browser").data("ui-hyfilebrowser");
        var vroot={
            id: p_id,
            label: "test",
            path: p_path,
            type: ""};
        r._changeLocation(vroot);
    }

    // TODO: this needs to be loaded in the XSL alongside other libs. Main benefits:
    //       - Avoid unneeded (and risky!) setTimeout calls in fmEditFile function
    //       - Availability of EF_CACHE_TIMESTAMP and switch to non-minimized debug code)
    window.fmLoadAceScript = function(src, callback) {
        var script = document.createElement("script");
        script.type = "text/javascript";
        script.src = "/" + jQuery.enginframe.rootContext + "/hydrogen/third-party/ace/src-min-noconflict/" + src;
        // Add onload event handler
        script.onload = function() {
            if (typeof callback === "function") {
                callback();
            }
        };
        document.head.appendChild(script);
    }

    window.fmEditFile = function(lThis, pControl) {
        // TODO / IDEAS
        //   multi Sessions
        if (window.fmEditFilemode == true) {
            editor = window.fmEditModeEditor;
            if (pControl == undefined || pControl != "keep_open") {
                window.fmEditFilemode = false;
            }

            var editorContent = editor.getValue();
            $('#edit-upload-form').remove();
            var editorUploadFormHtml =
                '<form id="edit-upload-form" action="/' + jQuery.enginframe.rootContext + '/fm/lib/xml/com.enginframe.fm.xml?_uri=//com.enginframe.fm/upload" method="post">' +
                '  <input type="hidden" name="spooler" value="' + efEncodeHtml(self.options.conf.params.spoolerURI) + '"/>' +
                '  <input type="hidden" name="vroot" value="' + efEncodeHtml(self._currentVRoot.id) + '"/>' +
                '  <input type="hidden" name="path" value="' + efEncodeHtml(self._currentVRoot.path) + '"/>' +
                '  <input type="file" id="upload-form-file" name="files" multiple="multiple" style="width:100%"/>' +
                '</form>'
            form = jQuery(editorUploadFormHtml).appendTo("#fm_edit_btn");

            // Create a File object
            var file = new File([editorContent], window.fmEditorFileName, {type: "text/plain"});

            // Create a DataTransfer object (which is used to hold the file list)
            var dataTransfer = new DataTransfer();
            dataTransfer.items.add(file);

            // Set the file input's files
            document.getElementById('upload-form-file').files = dataTransfer.files;

            // attach handler to form's submit event
            form.on("submit", function() {
                var action = "Uploading file " + window.fmEditorFileName;
                var modalString = 'Please wait until action "' + action + '" has finished ...';
                var modalHTML =
                    '<div id="hyModal" class="modal" onClick="javascript: $(\'#hyModal\').remove();">' +
                    '  <div class="modal-content">' + modalString +
                    '    <div style="margin-top: 30px;" class="loader">' +
                    '      <div class="loader-inner">' +
                    '        <div class="loader-line-wrap">' +
                    '          <div class="loader-line" />' +
                    '        </div>' +
                    '        <div class="loader-line-wrap">' +
                    '          <div class="loader-line" />' +
                    '        </div>' +
                    '        <div class="loader-line-wrap">' +
                    '          <div class="loader-line" />' +
                    '        </div>' +
                    '        <div class="loader-line-wrap">' +
                    '          <div class="loader-line" />' +
                    '        </div>' +
                    '        <div class="loader-line-wrap">' +
                    '          <div class="loader-line" />' +
                    '        </div>' +
                    '      </div>' +
                    '    </div>' +
                    '  </div>' +
                    '</div>';
                $("body").append(modalHTML);
                $("#hyModal").css("display", "block");

                // create monitor
                var settings = {
                    data: {
                        spooler: self.options.conf.params.spoolerURI,
                        vroot: self._currentVRoot.id,
                        path: self._currentVRoot.path,
                        modal: true
                    }
                };
                $.hydrogen.fm_timer = window.setTimeout(function() {
                    jQuery.hydrogen.check_fm_log(settings);
                }, 100);

                jQuery(this).ajaxSubmit({
                    dataType: "xml",
                    success: function(responseText, statusText) {
                        var xmlResult;
                        if (responseText) {
                            xmlResult = $(responseText).find("ef\\:error, error");
                            if (xmlResult.length > 0) {
                                self.options.messageArea.hymessage("error", xmlResult);
                            } else {
                                self.options.messageArea.hymessage("clear", xmlResult);
                            }
                        } else {
                            self.options.messageArea.hymessage("clear", xmlResult);
                        }

                        isUploading = false;
                        if (pControl == undefined || pControl != "keep_open") {
                            $(document).off("keydown", window.fm_handleCtrlS);
                        }

                        jQuery.hydrogen.clear_fm_log();
                        // reload the fm
                        self.reload();
                    },
                    error: function (xhr, statusText, errorThrown) {
                        self.options.messageArea.hymessage("alert", "<strong>An unknown error occurred while performing the upload.</strong>");
                        isUploading = false; // not needed but for formal correctness
                        if (pControl == undefined || pControl != "keep_open") {
                            $(document).off('keydown', window.fm_handleCtrlS);
                        }
                        jQuery.hydrogen.clear_fm_log();
                    }
                }); // ajaxSubmit
                return false
            }) // form.on

            form.trigger("submit");

            return;
        }
        window.fmEditFilemode=true;
        
        // get data - includes HTML escaped content so avoid to use the below approach
        // var previewContent=$("#fm_overlay-content").html();
        // previewContent=previewContent.substr(8, previewContent.length - 18);
        
        $('#fm_overlay-content').html(
		    '<div>Language: \
                <select id="languageSelect"> \
                    <option value="plain_text">Plain text</option> \
                    <option value="sh">Bash</option> \
                    <option value="python">Python</option> \
                    <option value="matlab">Matlab</option> \
                    <option value="fortran">Fortran</option> \
                    <option value="r">R</option> \
                    <option value="javascript">JavaScript</option> \
                    <option value="html">HTML</option> \
                    <option value="xml">XML</option> \
                    <option value="json">JSON</option> \
                </select> \
                Theme: \
                <select id="themeSelect"> \
                    <option value="eclipse">Eclipse</option> \
                    <option value="monokai">Monokai</option> \
                    <option value="github">GitHub</option> \
                    <option value="terminal">Terminal</option> \
                    <option value="solarized_dark">Solarized Dark</option> \
                    <option value="twilight">Twilight</option> \
                    <option value="tomorrow_night">Tomorrow Night</option> \
                    <option value="solarized_light">Solarized Light</option> \
                    <option value="ambiance">Ambiance</option> \
                    <option value="cobalt">Cobalt</option> \
                    <option value="chrome">Chrome</option> \
                    <option value="xcode">Xcode</option> \
                </select> \
            </div> \
            <div id="ace_editor" \
                 style="height: 85%; overflow-y: auto;  overflow-x: hidden; font-size: 75%; width: 100%; max-width: 100%"> \
            </div> \
           ');

        if (window.fmEditModeEditor === undefined) {
            window.fmLoadAceScript('ace.js', window.fmEditFileSetupACE);
        } else {
            // insert into fm_overlay-content
            window.fmEditFileSetupACE();
        }
	    
        ovl = $("#fm_hydrogen_overlay");
        var windowWidth = $(window).width();
        var windowHeight = $(window).height();
        var contentWidth = ovl.outerWidth();
        var contentHeight = ovl.outerHeight();
        
        var newWidth = Math.min(windowWidth*0.9, contentWidth * 2.5);
        var newHeight = Math.min(windowHeight*0.9, contentHeight * 2.5);
        
        ovl.css({
            "width": newWidth + "px",
            "height": newHeight + "px"
        });
        
        var $overlay = ovl;
        var windowHeight = $(window).height();
        var targetTop = windowHeight * 0.1; // 20% of window height
        var targetLeft = windowWidth * 0.2; // 20% of window height
        var currentTop = $overlay.position().top;
        
        $overlay.css({
            "position": "fixed",
            "left": targetLeft,
            "right": "",
            "bottom": "auto"
        }).animate({
            "top": targetTop + "px"
        }, 500, "swing"); // 500ms duration, swing easing
        
        // add close button
        $("#fm_edit_btn").after(
            '<input id="save_keep_editor" type="button" value="Save and Keep open" \
                    onclick="window.fmEditFile(this, \'keep_open\');" style="cursor: pointer" /> \
            <input id="close_editor" type="button" value="Close" \
                   onclick="$(\'#fm_hydrogen_overlay\').remove(); window.fmEditFilemode=false;" style="cursor: pointer"/> \
            <a href="https://github.com/ajaxorg/ace/wiki/Default-Keyboard-Shortcuts" target="_new">Editor Keyboard Shortcuts</a> \
        ');
        var fileName = decodeURIComponent(window.fmEditFileURL.match(/\/download\/(.+?)\?/)[1]);
        window.fmEditorFileName = fileName;
        var oldHtml = $("#fm_overlay_info").html()
        $("#fm_overlay_info").html(
            'Editing File: <b>' + fileName + "</b> " + oldHtml.substring(oldHtml.indexOf('<input'))
        );

    }

    window.fmEditFileSetupACE = function() {
        var editor = ace.edit("ace_editor");
	
        editor.setOptions({
            maxLines: Infinity,
            minLines: 30,
            wrap: false,
            useWorker: false,
            autoScrollEditorIntoView: true,
            useSoftTabs: true,
            showPrintMargin: false,
            fontSize: "12pt"
        });
	
        editor.$blockScrolling=Infinity;
	
        // Function to change the editor mode
        function changeEditorMode(mode) {
            editor.session.setMode("ace/mode/" + mode);
        }
	
        // Function to change the editor theme
        function changeEditorTheme(theme) {
            editor.setTheme("ace/theme/" + theme);
        }
	
        // Set initial mode and theme
        changeEditorMode("plain_text");
        changeEditorTheme("eclipse");
	
        // Handle language selection change
        $('#languageSelect').on('change', function() {
            changeEditorMode($(this).val());
        });
	
        // Handle theme selection change
        $('#themeSelect').on('change', function() {
            changeEditorTheme($(this).val());
        });
	
        // Update editor content when language changes
        $('#languageSelect').on('change', function() {
            var selectedLang = $(this).val();
        });
	
        // Set initial content
        editor.setValue(window.fmEditFileData, -1);
        // previewContent="";
        window.fmEditFileData=""; // release data
	
        // Focus on the editor
        editor.focus();
	
        window.fmEditModeEditor=editor;
	
        // map ctrl-s
        window.fm_handleCtrlS = function (e) {
            if ((e.ctrlKey || e.metaKey) && e.key === "s") {
                e.stopPropagation();
                e.preventDefault();
                $(document).off("keydown", window.fm_handleCtrlS);
                $("#fm_edit_btn").click();
            }
        }
        $(document).on("keydown", window.fm_handleCtrlS);
	
        // change the button to save
        $("#fm_edit_btn").val("Save").attr("title", "Click or Ctrl-S to save changes");
    } // Setup ACE

    window.fileNameOnMouseOver = function (obj, action) {
        if (jQuery.hydrogen.isDragging || window.fmEditFilemode) return; 
        $('#fm_hydrogen_overlay').remove();
        window.fmEditFilePreviewActive = false;
        if (action == "remove") {
            $(obj).css({
                'display': '',
                'animation': ''
            });
            if (window.jQuery.hydrogen.xhr) {
                try {
                    window.jQuery.hydrogen.xhr.abort();
                } catch (_) { }
            }
            return;
        }
        // console.log("fileNameOnMouseOver obj");
        var arr = (obj && typeof obj.href === 'string') ? obj.href.split("&") : [];
        // console.log(arr);
        // console.log(obj);
        try {
            var size=Number(arr[2].replace("_size=", ""));
	    } catch (err) {
            return;
        } 
        // console.log(size);
        // console.log(obj.children[0]);
        // console.log(obj.children[0].className);
        // console.log(decodeURIComponent(obj.href));

	    // stop previous wiggle
        if (window.fmFileNameObj != undefined) {
            $(window.fmFileNameObj).css({   // stop wiggling the filename
	            'display': '',
	            'animation': ''
            });
        }
	    
        // add animation
        $(obj).css({'display': 'inline-block', 'animation': 'moveLeftRight 0.6s linear infinite'});
        $('<style>').prop('type', 'text/css').html(' \
            @keyframes moveLeftRight {              \
             0% { transform: translateX(0);       } \
            50% { transform: translateX(4.5px);   } \
           100% { transform: translateX(0);       } \
          } ').appendTo('head');  // also wiggle filename 
        window.fmFileNameObj = obj;
	    
        // Create overlay element and append to body
        ovlstr = '<div id="fm_hydrogen_overlay" style="width: 30%; box-shadow: 0 0 15px 5px rgb(113, 93, 93, 60%); background: white; opacity: 0.1;';
        ovlstr += 'padding: 6px; border-radius: 10px; ';
        ovlstr += 'position: absolute;  display: none;  z-index: 1000;">';
        obj.parentElement.removeAttribute('title');  // remove overlaying title info 
        var className = obj.children[0].className;
        var type = "";
        const regex = /\.(mat|inp|out|cfg|config|txt|csv|log|xml|json|js|dat|scr|script|bat|m|sh|md)$/i;   // return regex.test(filename);
        if (className.match("hy-mime-type-icon-image")) {
            ovlstr += '<img style=" width: 100%; max-width: 100%; height: auto;" src="" alt="Image"></img></div>';
            type = "img";
        } else if (className.match("hy-mime-type-icon-video")) {
            // Convert to web-compatible aac MP4
            // ffmpeg -i input.mp4 -vcodec h264 -acodec aac output.mp4
            ovlstr += '<div id="fm_overlay_info" class="fmdraggable" style="height: 22.7px; padding-left: 3px; background-color: #e7e7e7; cursor: move; font-size: 66%; width: 100%; max-width: 100%; ">Right click to keep the overlay; Click on the overlay to close it. <input id="fm_edit_btn" type="button" style="width: 54px; cursor: pointer;" value="Close" /></div><video width="100%" height="auto" controls \
                     crossorigin="anonymous" playsinline preload="metadata"> \
                     Your browser does not support the playback of this video.</video>';
            type = "video";
        } else if (className.match("hy-mime-type-icon-modelview")) {
            // convert the objects into glb or glTF format with respective tools
            // # obj2gltf (Node.js tool)
            // npm install -g obj2gltf
            // obj2gltf -i model.obj -o model.gltf
            // # gltf-pipeline (optimization tool)
            // npm install -g gltf-pipeline
            // gltf-pipeline -i model.gltf -o model.glb
            ovlstr += '<div id="fm_overlay_info" class="fmdraggable" style="z-index: 10;height: 22.7px; padding-left: 3px; background-color: #e7e7e7; cursor: move; font-size: 66%; width: 100%; max-width: 100%; ">Right click to keep the overlay; Click on the overlay to close it. <input id="fm_edit_btn" type="button" style="width: 54px; cursor: pointer;" value="Close" /><div style="width: 100%; height: 500px; background-color: white;" id="MV_background"></div></div>';
            type = "modelview";
        } else if (className.match("hy-mime-type-icon-text") ||
                   regex.test(arr[0])) {
            ovlstr += '<div id="fm_overlay_info" class="fmdraggable" style="height: 22.7px; padding-left: 3px; background-color: #e7e7e7; cursor: move; font-size: 66%; width: 100%; max-width: 100%; ">Right click to keep the overlay; Click on the overlay to close it. <input id="fm_edit_btn" type="button" style="width: 54px; cursor: pointer;" value="Edit" onclick="window.fmEditFile(this);"/></div>';
            ovlstr += '<div id="fm_overlay-content" style="margin-left: 8px; margin-bottom: 6px; position: absolute; top: 30px; bottom: 0; left: 0; right: 0; overflow-y: auto;  overflow-x: hidden; font-size: 75%; width: 100%; max-width: 98.7%; " alt="Text"></div>';
            ovlstr +=' </div>';
            type = "txt";
            // .ace_scrollbar-v {  display: none !important; } - still has black bar but no unecessary scrollbar
            $('<style>').prop('type', 'text/css').html('.ace_scrollbar-v { display: none !important; }').appendTo('head');
        } else if (className.match("hy-mime-type-icon-url") ||   regex.test(arr[0])) {
            ovlstr += '<div id="fm_overlay_info" class="fmdraggable" style="height: 22.7px; padding-left: 3px; background-color: #e7e7e7; cursor: move; font-size: 66%; width: 100%; max-width: 100%; ">Right click to keep the overlay; Click on the overlay to close it.</div>';
            ovlstr += '<div id="fm_overlay-content" style="margin-left: 8px; margin-bottom: 6px; position: absolute; top: 30px; bottom: 0; left: 0; right: 0; overflow-y: auto;  overflow-x: hidden; font-size: 75%; width: 100%; max-width: 98.7%; " alt="Text"></div>';
            ovlstr +=' </div>';
            type = "url";
        } else if (className.match("hy-mime-type-icon-pdf")) {
            ovlstr += '<div id="fm_overlay_info" class="fmdraggable" style="height: 21.5px; padding-left: 3px; background-color: #e7e7e7; cursor: move; font-size: 66%; width: 100%; max-width: 100%; ">Right click to keep the overlay; Click on the overlay to close it</div>';
            ovlstr += '<iframe id="fm_overlay-content" style="height: 95%; top: 22px; bottom: 0; left: 0; right: 0; overflow-y: auto;  overflow-x: hidden; font-size: 75%; width: 100%; max-width: 100%; "  alt="Text"></iframe>';
            ovlstr += "</div>";
            type = "pdf";
        }
        $('body').append(ovlstr);
        var $overlay = $('#fm_hydrogen_overlay');
        var position = $(obj).offset();
        $overlay.css({
            top: position.top+21,
            left: position.left+30,
            width: "30%" // , // Optional: match the width of the target div     // height: $(obj).height() // Optional: match the height of the target div
        });
        // allow for interaction with overlay via right click
        $(obj).on('contextmenu', function(event) {
            event.preventDefault(); // Prevent the default context menu
            // remove onmouseout
            $(obj).removeAttr("onmouseout");
        });
        if (type == "img" || type == "video" || type == "modelview") {
            if (type === "img") {
                var $img = $overlay.find('img');
                $img.attr('src', obj.href);
            } else if (type === "modelview") {
                // create iframe and modelviewer 
                const $iframe = $('<iframe>').insertAfter('#fm_edit_btn');
                $iframe.css({
                    'width': '100%',
                    'height': '500px',
                    'border': 'none',
                    'position': 'relative',
                    'z-index': '2'
                });
                $('#MV_background').css({
                    'position': 'absolute',
                    'top': '30px',
                    'left': '0px',
                    'z-index': '1',
                    'border-radius': '9px',
                    'pointer-events': 'none',
                    'display': 'flex',
                    'justify-content': 'center',
                    'align-items': 'center',
                    'font-family': 'Arial, sans-serif',
                    'font-size': '20px',
                    'background': 'linear-gradient(to bottom, white, #e0e0e0)', 
                    'color': '#666'
                }).text('Loading...');
                const iframeDoc = $iframe[0].contentDocument;
                iframeDoc.open();
                iframeDoc.write('<!DOCTYPE html><html><head></head><body></body></html>');
                iframeDoc.close();
                // Create elements
                const head = iframeDoc.createElement('head');
                const modelViewerScript = iframeDoc.createElement('script');
                modelViewerScript.type = 'module';
                modelViewerScript.src = 'https://ajax.googleapis.com/ajax/libs/model-viewer/4.0.0/model-viewer.min.js';
                const style = iframeDoc.createElement('style');
                style.textContent = '  model-viewer {  width: 100%; height: 483px; }';
                const body = iframeDoc.createElement('body');
                const modelViewer = iframeDoc.createElement('model-viewer');
                modelViewer.setAttribute('camera-controls', '');
                modelViewer.setAttribute('ar', '');
                modelViewer.setAttribute('touch-action', 'pan-y');
                modelViewer.setAttribute('shadow-intensity', '1');
                modelViewer.addEventListener('load', function() {
                    document.getElementById('MV_background').textContent = "";
                });
                head.appendChild(modelViewerScript);
                head.appendChild(style);
                body.appendChild(modelViewer);
                iframeDoc.documentElement.appendChild(head);
                iframeDoc.documentElement.appendChild(body);
                
                // Create XHR for model loading
                var e = obj.href;
                var xhr = new XMLHttpRequest();
                xhr.open('GET', e, true);
                xhr.responseType = 'blob';
                xhr.onload = function(e) {
                    if (this.status === 200) {
                        const modelUrl = URL.createObjectURL(this.response);
                        modelViewer.addEventListener('load', function() {
                            URL.revokeObjectURL(modelUrl);
                        }, { once: true });
                        modelViewer.addEventListener('error', function(error) {
                            URL.revokeObjectURL(modelUrl);
                            console.error('Model loading error:', error);
                        }, { once: true });
                        modelViewer.src = modelUrl;
                    } else {
                        console.error('XHR request failed:', this.status);
                    }
                };
                // Add progress monitoring for large files
                xhr.onprogress = function(e) {
                    if (e.lengthComputable) {
                        const percentComplete = (e.loaded / e.total) * 100;
                        $('#MV_background').text(percentComplete.toFixed(0) + '%');
                        if (percentComplete > 95.0) {
                            $('#MV_background').text("");
                        }
                    }
                };
                // Handle network errors
                xhr.onerror = function() {
                    console.error('Network error occurred while loading the model');
                };
                xhr.onabort = function() {
                    console.log('3D model load request was stopped ...');
                };
                window.jQuery.hydrogen.xhr = xhr;
                xhr.send();
            } else {
                var $img = $overlay.find('video');
                $img.attr('src', obj.href);
            }
            // Show the overlay
            if (type === "modelview") {
                $overlay.show().resizable({
                    handles: 'e, s, se',
                    minHeight: 210,
                    resize: function(event, ui) {
                        var overlayHeight = ui.size.height;
                        var headerHeight = $("#fm_overlay_info").outerHeight();
                        var contentHeight = overlayHeight - headerHeight - 12; // 12px for padding
                        $(this).find('#MV_background').css('height', contentHeight + 17 + 'px');
                        $iframe = $(this).find('iframe');
                        $iframe.css('height', contentHeight + 'px');
                        var $iframeContent = $iframe.contents();
                        $iframeContent.find('model-viewer').css('height', (contentHeight - 17) + 'px');
                        
                    }
                }).draggable().css({cursor: 'move', height: '517px'});
            } else {
                $overlay.show().resizable().draggable().css({cursor: 'move'});
            }
	        $overlay.animate({
                "opacity": "1",  
                "top": "+=6px"   
            }, 300, function () {
		        $(obj).css({
                    'display': '',
                    'animation': ''
		        });   });
        } else if (type == "pdf") {
	        var m = $overlay.find("iframe")[0];
            $overlay.css("height", "70%").css("border-radius", "3px").css("width", "50%");
            var e = obj.href + "&_t=" + (new Date()).getTime();
            var xhr = new XMLHttpRequest();
            xhr.open('GET', e, true);
            xhr.responseType = 'blob';
            xhr.onload = function(e) {
                if (this.status === 200) {
                    var blob = this.response;
                    var pdfUrl = URL.createObjectURL(blob);
                    try {
                        // m.innerHTML = "<b><pre>" + u + "</pre></b>";
                        // var url = URL.createObjectURL(u);
                        $('#fm_overlay-content').attr('src', pdfUrl)
			            $overlay.show().resizable({
			                start: function(event, ui) {
                                // console.log("start drag ...");
                                jQuery.hydrogen.isDragging = true;
                            },
                            stop: function(event, ui) {
                                // Set a timeout to reset isDragging. This ensures the click event has time to process.
                                // console.log("stop drag ...");
                                setTimeout(function() {
                                    jQuery.hydrogen.isDragging = false;
                                }, 100);
                            }
			            }).draggable({
			                handle: ".fmdraggable",
			                start: function(event, ui) {
                                // console.log("start drag ...");
                                jQuery.hydrogen.isDragging = true;
                            },
                            stop: function(event, ui) {
                                // Set a timeout to reset isDragging. This ensures the click event has time to process.
                                // console.log("stop drag ...");
                                setTimeout(function() {
                                    jQuery.hydrogen.isDragging = false;
                                }, 100);
                            }
			            });
			            $overlay.animate({
                            'opacity': '1',  // Animate opacity to 100%
                            'top': '-=6px'   // Move the div 10 pixels down
                        }, 240);
                        try {
                            var objDiv = document.getElementById("fm_hydrogen_overlay");
                            objDiv.scrollTop = objDiv.scrollHeight;
                            $(obj).css({   // stop wiggling the filename 
                                'display': '',
                                'animation': ''
                            });
                        } catch (_) { }
                    } catch (err) {
                        console.log(err)
                    }
		        }
	        };
	        xhr.onerror = function() {
                console.error('Error fetching the PDF.');
            };
            xhr.send();
        } else if (type == "txt" || type === "url") {
            var $div = $overlay.find('div')[1];
            // add height limit height: 30%;
            $overlay.css("height", "30%").css("border-radius", "3px");
            // $(obj).on('mousewheel DOMMouseScroll', function(e) {
            //      var delta = e.originalEvent.wheelDelta || -e.originalEvent.detail;
            //      var overlay = $('#fm_hydrogen_overlay');
            //      overlay.scrollTop(overlay.scrollTop() - delta);
            //      return false; // Prevent the default scroll behavior
            //  });
            // $(obj).on('keydown', function(e) {
            //         console.log(e);
            //       var overlay = $('#fm_hydrogen_overlay');
            //         var scrollAmount = 50; // Adjust the scroll amount as needed
            //         if (overlay.is(':visible')) {
            //             if (e.keyCode === 33) { // Page Up
            //                 e.preventDefault();
            //                 e.stopPropagation();
            //                 overlay.scrollTop(overlay.scrollTop() - scrollAmount);
            //             } else if (e.keyCode === 34) { // Page Down
            //                 e.preventDefault();
            //                 e.stopPropagation();
            //                 overlay.scrollTop(overlay.scrollTop() + scrollAmount);
            //             }
            //         }
            //         if (e.keyCode === 33) { // Page Up
            //             overlay.scrollTop(overlay.scrollTop() - scrollAmount);
            //             return false; // Prevent the default scroll behavior
            //         } else if (e.keyCode === 34) { // Page Down
            //             overlay.scrollTop(overlay.scrollTop() + scrollAmount);
            //             return false; // Prevent the default scroll behavior
            //         }
            //     });
            
            // limit the data we want to preview based on file size info from FM - 5MB limit atm
            // TODO: why for txt files only?
            var sizeLimit = 5 * 1024 * 1024;
            if (size > sizeLimit) {
                // larger than 5 MB 
                $div.innerHTML = "<b><pre>File size is large than 5 MB and cannot be previewed</pre></b>";
                $overlay.show().resizable({
                    start: function(event, ui) {
                        jQuery.hydrogen.isDragging = true;
                    },
                    stop: function(event, ui) {
                        // Set a timeout to reset isDragging. This ensures the click event has time to process.
                        setTimeout(function() {
                            jQuery.hydrogen.isDragging = false;
                        }, 100);
                    }
                }).draggable({
                    handle: ".fmdraggable",
                    start: function(event, ui) {
                        // console.log("start drag ...");
                        jQuery.hydrogen.isDragging = true;
                    },
                    stop: function(event, ui) {
                        // Set a timeout to reset isDragging. This ensures the click event has time to process.
                        setTimeout(function() {
                            jQuery.hydrogen.isDragging = false;
                        }, 100);
                    }
                });
                $overlay.animate({
                    "opacity": "1",  // Animate opacity to 100%
                    "top": "+=6px"   // Move the div 10 pixels down
                }, 240);
                var objDiv = document.getElementById("fm_hydrogen_overlay");
                objDiv.scrollTop = objDiv.scrollHeight;
                $(obj).css({
                    "display": "",
                    "animation": ""
                });
                $("#fm_edit_btn").remove();
                return;
            }

            if (window.fmEditFileCurrentAjaxRequest != undefined) {
	            window.fmEditFileCurrentAjaxRequest.abort();
            }
            var lHref = obj.href+"&_t="+(new Date()).getTime();
            window.fmEditFileCurrentAjaxRequest = $.ajax({
                url: lHref,
                type: 'GET',
                dataType: 'text',
                success: function(data) {
                    try {
                        if (type === "url") {
                            $div.innerHTML = 'Url: <b><a target="_new" href="' + data + '">' + data + '</a></b>';
                            var aElement = $(obj); // Get the <a> element as a jQuery object
                            // add link to text as well
                            aElement.attr('href', data);
                            aElement.attr('target', '_blank'); // Optional: also set target
                            var spanElement = aElement.find('span.hy-filebrowser-param-name');
                            if (spanElement.length > 0) {
                                var currentText = spanElement.text();
                                var newLink = $('<a>', {
                                    href: data,
                                    target: "_blank", 
                                    text: data // The link text
                                });
                                spanElement.append(' | Click here: ');
                                spanElement.append(newLink);
                            } else {
                                console.error("Span element not found inside the <a> tag.");
                            }
                            $(obj).css({
		                        'display': '',
		                        'animation': ''
	                        });
                            return;
                        } else
                            $div.innerHTML = '<b><pre>' + data + '</pre></b>'; // fill the text preview content
                        window.fmEditFileURL=lHref;
                        window.fmEditFileData=data; // store preview data without encoded html
                        window.fmEditFilePreviewActive=true;
                        $overlay.show().resizable({
			                start: function(event, ui) {
                                jQuery.hydrogen.isDragging = true;
                            },
                            stop: function(event, ui) {
                                // Set a timeout to reset isDragging. This ensures the click event has time to process.
                                setTimeout(function() {
                                    jQuery.hydrogen.isDragging = false;
                                }, 100);
                            }
			            }).draggable({
			                handle: ".fmdraggable",
			                start: function(event, ui) {
                                // console.log("start drag ...");
                                jQuery.hydrogen.isDragging = true;
                            },
                            stop: function(event, ui) {
                                // Set a timeout to reset isDragging. This ensures the click event has time to process.
                                // console.log("stop drag ...");
                                setTimeout(function() {
                                    jQuery.hydrogen.isDragging = false;
                                }, 100);
                            }
			            });
			            $overlay.animate({
                            'opacity': '1',  // Animate opacity to 100%
                            'top': '+=6px'   // Move the div 10 pixels down
                        }, 240);
			            // $overlay.scrollTop = $overlay.scrollHeight;
		                var objDiv = document.getElementById("fm_hydrogen_overlay");
                        objDiv.scrollTop = objDiv.scrollHeight;
                        $(obj).css({ // stop wiggling the filename
                            'display': '',
                            'animation': ''
                        });
                        // scroll logfile to end of file
                        const regex = /\.(log|logfile)$/i;
                        var fileName = decodeURIComponent(window.fmEditFileURL.match(/\/download\/(.+?)\?/)[1]);
                        if (regex.test(fileName)) {
                            $("#fm_overlay-content").animate({
                                scrollTop: $("#fm_overlay-content")[0].scrollHeight,
                                duration: 600,
                                easing: "swing"
                            });
                        }
		            } catch (_) { }
                },
                error: function(xhr, status, error) {
                    if (status !== 'abort') {
                        console.error('AJAX request failed:', status, error);
                    }
                    // console.log('Error:', error);
                }
            });
        } else { // if type 
	        $(obj).css({
		        'display': '',
		        'animation': ''
	        });
	    }
        // Hide overlay on click
        $('#fm_hydrogen_overlay').on('click', function() {
            // $(this).hide();
            // console.log("Clicked overlay ...");
	        if (jQuery.hydrogen.isDragging || window.fmEditFilemode) return;
	        // prevent close in case a selection is in the overlay ;) 
            var selection = window.getSelection();
            // console.log(selection);
            if (selection.rangeCount > 0 && selection.baseOffset < selection.extentOffset) {
                var range = selection.getRangeAt(0);
                var selectedTextContainer = range.commonAncestorContainer;
                // Check if the container of the selected text is inside yourDiv
                if ( selection.type == "Range" &&
                     ($("#fm_hydrogen_overlay").is(selectedTextContainer) ||
                      $("#fm_hydrogen_overlay").has(selectedTextContainer).length > 0)) {
                    // console.log("selection detected ... ");
                    return;
                }
            }
            if (window.jQuery.hydrogen.xhr) {
                try {
                    window.jQuery.hydrogen.xhr.abort();
                } catch (_) { }
            }
	    
            // $(obj).off('mousewheel DOMMouseScroll');
            // add mouseout event again in case it was removed
            $(obj).attr("onmouseout", "javascript:window.fileNameOnMouseOver(this, 'remove')");
            $('#fm_hydrogen_overlay').empty().remove();
            window.fmEditFilePreviewActive = false;
        });

    };
    
    $.widget('ui.hyfilebrowser', {

        options: {
            conf: {},
            messageArea: null
        },

        _create: function () {
            var self, firstLoad, errorMessage;

            firstLoad = true;

            self = this;

            this.element.addClass('hy-file-browser ui-widget');

            if (!this.options.conf.vroots || this.options.conf.vroots.length === 0) {
                errorMessage = 'Cannot access the file system since no \'place\' has been configured.';

                if (this.options.messageArea) {
                    this.options.messageArea.hymessage('alert', errorMessage);
                } else {
                    $("<div class='ui-state-error-text'>" + efEncodeHtml(errorMessage) + "</div>").appendTo(this.element);
                }

                return;
            }

            this._addCustomMimeTypes(customMimeTypes, this.options.conf.params.customExtensionsText, "hy-mime-type-icon-text");
            this._addCustomMimeTypes(customMimeTypes, this.options.conf.params.customExtensionsImage, "hy-mime-type-icon-image");

            this.locationsStack = [];
            this._createLocationBar();

            this.contentDiv = $('<div class="hy-file-browser-wrapper ui-helper-clearfix"></div>').appendTo(this.element);

            if (this.options.conf.vroots && this.options.conf.vroots.length > 1) {
                this.table = $('<div class="hy-file-browser-table-wrapper">' +
                                '  <div class="hy-file-browser-table-column">' +
                                '    <div class="hy-file-browser-table"></div>' +
                                '  </div>' +
                                '</div>').appendTo(this.contentDiv).find('.hy-file-browser-table').uniqueId();

                this._createVRootList();
            } else {
                this.table = $('<div class="hy-file-browser-table"></div>').appendTo(this.contentDiv).uniqueId();
            }

            // This is a fake footer we use to adjust the height of contentDiv
            //$('<div style="clear:left;width:100%;"/>').appendTo(this.contentDiv);
            $('<div></div>').appendTo(this.contentDiv);

            this.table.hytable({
                xmlreader: {
                    root: 'items',
                    row: 'item',
                    page: 'items>page',
                    total: 'items>total',
                    records: 'items>records',
                    repeatitems: false,
                    id: '[id]'
                },
                conf: this.options.conf,
                noItemsLabel: null,
                loadDataOnInit: false,
                stickySelection: true, // so it works even if we use incremental loading
                messageArea: this.options.messageArea,
                defaultLoadErrorMessage: 'Cannot obtain the list of files from the server.'
            });

            $('.ui-widget', this.contentDiv).removeClass('ui-widget');

            this._currentVRoot = null;
            $.each(this.options.conf.vroots, function (n, v) {
                // Make sure vroots have a valid path
                v.path = v.path || '/';
                v.type = v.type || '';
                if (n === 0) {
                    self._changeLocation(v);
                }
                return false;
            });

            this.table.bind('hytableaction', function (e, d) {
                self._trigger('action', null, d);
            });

            this.table.bind('hytableloaderror', function (e, d) {
                // if (firstLoad) do nothing
                // we do not have a default location for the filebrowser
                if (!firstLoad) {
                    setTimeout(function () {
                        // redirect to latest known path
                        self.changePath(self._currentlyShownVRoot.path);
                    }, 2000);
                }
                self._trigger('loaderror', null, d);
            });

            this.table.bind('hytableloadcomplete', function (e, d) {
                var path, newLoc;

                path = $(d.data).find('items').attr('path') || '/';
                path = decodeURIComponent(path);
                self._currentVRoot.path = $.hydrogen.normalizeFilepath(path);

                // Locations stack is disabled for RFB
                if (!self.options.conf.params.isRFB) {
                    if (self.locationsStack.length === 0) {
                        // check if we already have a stack we can use stored from previous sessions
                        var lSpooler = self.options.conf.params.spoolerURI;
                        var jstr = localStorage.getItem('fm_locationsStack_' + lSpooler);
                        if (jstr != undefined && jstr != "") {
                            var lStack = JSON.parse(jstr);
                            if (lStack.length > 0) {
                                self.locationsStack = lStack;
                                self._currentVRoot = self.locationsStack[lStack.length - 1];
                                h = jQuery.extend({}, self._currentVRoot);
                            }
                        }
                    }

                    if (self.locationsStack.length === 0 ||
                        (self.locationsStack[self.locationsStack.length - 1].id !== self._currentVRoot.id) ||
                        (self.locationsStack[self.locationsStack.length - 1].path !== self._currentVRoot.path)) {
                        // store new location in the saved stack
                        newLoc = jQuery.extend({}, self._currentVRoot);
                        self.locationsStack.push(newLoc);
                        var lSpooler = self.options.conf.params.spoolerURI;
                        var arrayLength = self.locationsStack.length;
                        // Calculate the start index for the last 20 items
                        var startIndex = Math.max(arrayLength - 30, 0); // Ensures that the startIndex is not negative
                        // Get the last 20 items (or fewer if the array is shorter)
                        var selectedItems = self.locationsStack.slice(startIndex);
                        localStorage.setItem("fm_locationsStack_" + lSpooler, JSON.stringify(selectedItems));
                    }
                }

                self._updateLocationBar();

                // FIXME: this seems wrong to me, since I thought it should be put
                // in gridComplete, but it seems loadComplete is called after gridComplete and we need to
                // know the value of self._rootPath
                $('a.hy-file-browser-file', self.table).each(function () {
                    var v, size, fname, fpath, href;

                    v = $(this).attr('rel').split(':');
                    size = v[0];
                    fname = v.slice(1).join(':');
                    fpath = '/' + self._currentVRoot.id + self._currentVRoot.path + '/' + fname;

                    href = '/' + $.enginframe.rootContext + '/download/' + encodeURIComponent(fname) + '?' +
                               '_file=' + encodeURIComponent(fpath) + '&' +
                               '_spooler=' + encodeURIComponent(self.options.conf.params.spoolerURI) + '&' +
                               '_size=' + size + '&' +
                               '_plugin=fm';

                    $(this).attr('href', href).attr('target', '_blank').click(function (event) {
                        // prevent the menu from opening
                        event.stopPropagation();
                    });
                });

                // Do not trigger the event when the file browser is populated for the first time
                if (!firstLoad) {
                    // Refresh only if VRoot or path changed
                    if (self._currentlyShownVRoot.id   !== self._currentVRoot.id ||
                        self._currentlyShownVRoot.path !== self._currentVRoot.path) {
                        self._trigger('directorychanged', null, {
                            spooler: self.options.conf.params.spoolerURI,
                            vroot: self._currentVRoot.id,
                            path: self._currentVRoot.path,
                            type: self._currentVRoot.type || ''
                        });
                    }
                } else {
                    firstLoad = false;
                }

                self._currentlyShownVRoot = {
                    id: self._currentVRoot.id,
                    path: self._currentVRoot.path,
                    type: self._currentVRoot.type
                };

                // NEW Drag Drop functionality 
                jQuery.hydrogen.DD_storedClick = function () {
                    if (jQuery.hydrogen.MFU_DD_Active == 1) return;
                    jQuery.hydrogen.MFU_DD_Active = 1;
                    var scriptHtml = '\
                        <div class="qq-uploader-selector qq-uploader">\
                          <div class="qq-upload-drop-area-selector qq-upload-drop-area" qq-hide-dropzone="qq-hide-dropzone">\
                            <span class="qq-upload-drop-area-text-selector"></span>\
                          </div>\
                          <div class="ef-fileupload-header">\
                            <div class="qq-total-progress-bar-container-selector qq-total-progress-bar-container">\
                              <div role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" class="qq-total-progress-bar-selector qq-progress-bar qq-total-progress-bar"></div>\
                            </div>\
                            <div class="ef-fileupload-buttons">\
                              <div class="qq-upload-button-selector qq-upload-button">Select files</div>\
                              <div class="qq-upload-button qq-upload-cancel-all qq-hide">Cancel all</div>\
                              <div class="qq-upload-button qq-upload-delete-all qq-hide">Delete all</div>\
                             </div>\
                             <div class="qq-drop-processing-selector qq-drop-processing">\
                               <div class="qq-drop-processing-spinner-selector qq-drop-processing-spinner"></div>\
                               <div class="qq-drop-processing-text">Processing...</div>\
                             </div>\
                          </div>\
                          <div class="ef-fileupload-list">\
                            <ul class="qq-upload-list-selector qq-upload-list" aria-live="polite" aria-relevant="additions removals">\
                              <li>\
                                <div class="qq-progress-bar-container-selector">\
                                  <div role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" class="qq-progress-bar-selector qq-progress-bar"></div>\
                                </div>\
                                <span class="qq-upload-spinner-selector qq-upload-spinner"></span>\
                                <!--<img class="qq-thumbnail-selector" qq-max-size="100" qq-server-scale="qq-server-scale" ></img>-->\
                                <div class="qq-upload-file-selector qq-upload-file"></div>\
                                <span class="qq-edit-filename-icon-selector qq-edit-filename-icon" aria-label="Edit filename"></span>\
                                <input class="qq-edit-filename-selector qq-edit-filename" tabindex="0" type="text" ></input>\
                                <div class="qq-upload-size-selector qq-upload-size"></div>\
                                <button type="button" class="qq-btn qq-upload-cancel-selector qq-upload-cancel">Cancel</button>\
                                <!-- <button type="button" class="qq-btn qq-upload-retry-selector qq-upload-retry">Retry</button>-->\
                                <button type="button" class="qq-btn qq-upload-delete-selector qq-upload-delete">Delete</button>\
                                <span role="status" class="qq-upload-status-text-selector qq-upload-status-text"></span>\
                              </li>\
                            </ul>\
                            <dialog class="qq-alert-dialog-selector">\
                              <div class="qq-dialog-message-selector"></div>\
                              <div class="qq-dialog-buttons">\
                                <button type="button" class="qq-cancel-button-selector">Close</button>\
                              </div>\
                            </dialog>\
                            <dialog class="qq-confirm-dialog-selector">\
                              <div class="qq-dialog-message-selector"></div>\
                              <div class="qq-dialog-buttons">\
                                <button type="button" class="qq-cancel-button-selector">No</button>\
                                <button type="button" class="qq-ok-button-selector">Yes</button>\
                              </div>\
                            </dialog>\
                            <dialog class="qq-prompt-dialog-selector">\
                              <div class="qq-dialog-message-selector"></div>\
                              <input type="text"></input>\
                              <div class="qq-dialog-buttons">\
                                <button type="button" class="qq-cancel-button-selector">Cancel</button>\
                                <button type="button" class="qq-ok-button-selector">Ok</button>\
                              </div>\
                            </dialog>\
                          </div>\
                        </div>';

                    var scriptTag = $('<script>', {
                        type: 'text/template',
                        id: 'ef-fileupload-template'
                    }).html(scriptHtml);
                    // Append the script tag to the body of the document
                    $('body').append(scriptTag);

                    var uploadElements = '\
                        <input id="dd_file" type="hidden">\
                        <div id="dd_file_widget" style="width:100%;height:150px;"></div>';

                    $("<div>")
                        .attr("id", "upload-dd-div")
                        .css({
                            "display": "none",
                            "height": "150px",
                            "border-radius": "5px",
                            "text-align": "center",
                            "color": "#999"
                        })
                        .html(uploadElements)
                        .insertAfter("#fm-browse-toolbar")
                        .slideDown(300, function () {
                            // fileupload() needs a service so that its spooler can be used
                            // by the UploadController servlet to perform upload operations.
                            // Service action is not invoked, so we can use an existing FM service
                            // with spooler TTL = 0 for this purpose. //com.enginframe.fm/browse has been chosen.
                            jQuery("#dd_file").fileupload({
                                optionId: "dd_file",
                                serviceOptionId: "_ui",
                                serviceUri: "//com.enginframe.fm/browse",
                                sdfUrl: window.location.origin + "/" + jQuery.enginframe.rootContext + "/fm/lib/xml/com.enginframe.fm.xml",
                                windowId: Date.now(),
                                efRootContext: jQuery.enginframe.rootContext,
                                fineUploaderElementId: "dd_file_widget",
                                multiple: true,
                                maxConnections: 3,
                                debug: false,
                                onStart: efFileupload.activation,
                                onCompletion: efFileupload.completion,
                            });
                            // add a close button
                            $('.qq-upload-button.qq-upload-delete-all')
                                .after('<div id="dd-close-button" class="qq-upload-button qq-upload-close">Close</div>')
                            $('#dd-close-button').on('click', function () {
                                $("#upload").removeClass("glowing")
                                    .attr("title", "Select files to upload by clicking or drag and drop to the area below")
                                    .removeAttr('style');
                                $("#upload-dd-div").slideUp(300, function () {
                                    jQuery.hydrogen.MFU_DD_Active = 0;
                                    // Restore the original click function
                                    $("#upload").off("click").on("click", jQuery.hydrogen.DD_storedClick);
                                    // Notify the cancelled upload
                                    $("#dd_file").fileupload("cancel");
                                    // Remove the whole upload div at the end
                                    this.remove();
                                });
                            });
                            $("#upload").addClass("glowing")
                                .attr("title", "Finalize Upload and move files to spooler by clicking here")
                                .css({
                                    "background-color": "#00b0e4 !important",
                                    "color": "white"
                                });
                            // New Upload click function when DD is open
                            $("#upload").off('click').on('click', function () {
                                // get file infos
                                var uploads = jQuery("#dd_file").fileupload("returnUploadedFiles");
                                if (uploads.length > 0) {
                                    // now move the files from the spooler to the right file place
                                    // call copy/move SDF with the names of the files
                                    var fdata = [];
                                    for (var i = 0; i < uploads.length; i++) {
                                        fdata.push({
                                            "name": uploads[i].filePath,
                                            "size": uploads[i].size + " bytes",
                                            "type": "file", // TODO: file or folder - necessary?
                                            "vrootid": "ddmode",
                                            "vrootpath": uploads[i].filePath,
                                            "vroottype": "file",
                                            "vrootspooler": uploads[i].spooler
                                        });
                                    }
                                    console.log("DD files to upload:"); console.log(fdata);
                                    console.log("starting move to final destination ... ");
                                    jQuery.hydrogen.invokeService({
                                        sdf: "/" + jQuery.enginframe.rootContext + "/fm/lib/xml/com.enginframe.fm.xml",
                                        uri: "//com.enginframe.fm/pasteCopied",
                                        modal: true,
                                        modal_message: "uploading files",
                                        data: {
                                            spooler: self.options.conf.params.spoolerURI,
                                            vroot: self._currentVRoot.id,
                                            path: self._currentVRoot.path,
                                            mode: "copy", // TODO: try to use move here and test with all backends
                                            data: JSON.stringify(fdata),
                                            EF_REUSE_SPOOLER: uploads[0].spooler, // Upload spooler is the same for any element
                                            EF_RESET_SPOOLER_TTL: "false" // Preserve ttl = 0 of the upload spooler for auto removal
                                        },
                                        success: function (e) {
                                            $("#upload").removeClass("glowing")
                                                .attr("title", "Upload files by selecting or drag and drop from the desktop").removeAttr('style');
                                            $("#upload-dd-div").slideUp(300, function () {
                                                jQuery.hydrogen.MFU_DD_Active = 0;
                                                $("#upload").off("click").on("click", jQuery.hydrogen.DD_storedClick);
                                                $("#dd_file").fileupload("close");
                                                // Remove the whole upload div at the end
                                                this.remove();
                                            });
                                            if (self.options.messageArea) {
                                                self.options.messageArea.hymessage("info", e, 4500);
                                                self.reload();
                                            }
                                        },
                                        error: function (e) {
                                            $("#upload").removeClass("glowing")
                                                .attr("title", "Upload files by selecting or drag and drop from the desktop").removeAttr('style');
                                            $("#upload-dd-div").slideUp(300, function () {
                                                jQuery.hydrogen.MFU_DD_Active = 0;
                                                $("#upload").off("click").on("click", jQuery.hydrogen.DD_storedClick);
                                                // Try to close the upload transaction anyway
                                                $("#dd_file").fileupload("close");
                                                // Remove the whole upload div at the end
                                                this.remove();
                                            });
                                            self.options.messageArea.hymessage("alert", e, false);
                                        },
                                        messagebox: self.options.messageArea
                                    })
                                    // self._showNotification("Files were uploaded successfully!")
                                } else {
                                    // close window
                                    $("#upload").removeClass("glowing").attr("title", "Upload files by selecting or drag and drop from the desktop").removeAttr('style');
                                    $("#upload-dd-div").slideUp(300, function () {
                                        jQuery.hydrogen.MFU_DD_Active = 0;
                                        $("#upload").off("click").on("click", jQuery.hydrogen.DD_storedClick);
                                        // Notify the cancelled upload
                                        $("#dd_file").fileupload("cancel");
                                        // Remove the whole upload div at the end
                                        this.remove();
                                    });
                                }
                            })  // $("#upload").on('click' ...
                        }); // $("<div>").slideDown(300, ...
                }; // hydrogen.DD_storedClick
                // Install the new function after the button is available (in File Manager only for now)
                if (self.options.conf.params.widgetId == "fm-browse") {
                    var startTime = Date.now();
                    var interval = setInterval(function() {
                        var element = $("#upload");
                        if (element.length > 0) {
                            clearInterval(interval);
                            element.attr("title", "Upload files by selecting or drag and drop from the desktop")
                                .off("click")
                                .on("click", jQuery.hydrogen.DD_storedClick);
                            return;
                        }
                        if (Date.now() - startTime >= 7000) { // 7 second timeout
                            clearInterval(interval);
                            console.warn("Upload button not found after 7 seconds");
                        }
                    }, 50);
                }
                self._trigger("loadcomplete", null, {})
            }); // end of hytableloadcomplete

            this.table.bind('hytablegridcomplete', function () {
                $('a.hy-file-browser-folder', self.table).click(function (event) {
                    event.stopPropagation();
                    self.changePath(self._currentVRoot.path + '/' + $(this).attr('rel'));
                });
                self._trigger('gridcomplete', null, {});
            });

            this.table.bind('hytableselectionchanged', function (e, data) {
                self._trigger('selectionchanged', e, data);
            });

            this.table.bind('hytabledoubleclickrow', function (e, data) {
                self._trigger('doubleclickrow', e, data);
            });
        },

        _addCustomMimeTypes: function(customMimeTypes, extensions, mimeType) {
            if ((extensions) && (extensions.trim().length > 0)) {
                var extensionsList = extensions.trim().split(":");
                extensionsList.forEach(function(ext) {
                    customMimeTypes[ext] = mimeType;
                });
            }
        },

        _createLocationBar: function () {
            var self, locationBar, locationWrapper, leftwidth;

            self = this;

            locationBar = $('<div class="hy-file-browser-location-bar ui-helper-clearfix"></div>').appendTo(this.element);
            locationWrapper = $('<div class="hy-file-browser-location-bar-wrapper"></div>').appendTo(locationBar);

            this.locBarHolder = $('<div class="hy-file-browser-location-bar-holder breadCrumbHolder breadCrumbModule"></div>').appendTo(locationWrapper);

            // Back button is hidden for RFB
            if (!this.options.conf.params.isRFB) {
                this.backButton = $(
                    '<a title="Go to the previous visited location" class="hy-file-browser-back-button hy-button hy-button-icon-left ui-corner-all ui-state-default ui-state-disabled" disabled="disabled">' +
                    '  <span class="ui-icon ui-icon-arrowthick-1-w"></span><span class="hy-button-icon-text">Back</span>' +
                    '</a>').appendTo(locationBar);
                this.backButton.click(function () {
                    self._goBack();
                });
            }

            this.upButton = $('<span class="hy-file-browser-up-button">' +
                        '  <button title="Open the parent folder" class="hy-button-icon-solo ui-corner-all ui-state-default ui-state-disabled" disabled="disabled">' +
                        '    <span class="ui-icon ui-icon-arrowthick-1-n">Move Up</span>' +
                        '  </button>' +
                        '</span>').appendTo(locationBar).find('button');

            this.upButton.click(function () {
                self._goUp();
            });

            $('<span class="hy-file-browser-location-label">Location:</span>').appendTo(locationBar);

            this.editLocationButton = $('<span class="hy-file-browser-edit-location-button">' +
                        '  <button title="Toggle between links and text-based location bar" class="hy-button-icon-solo ui-corner-left ui-state-default hy-button-toggleable">' +
                        '    <span class="ui-icon ui-icon-pencil">Edit Location</span>' +
                        '  </button>' +
                        '</span>').appendTo(locationBar).find('button');

            if ($.cookie('hy-file-browser-location-bar-mode') === 'text') {
                this.editLocationButton.addClass("ui-state-active");
            }

            $('button', locationBar).hover(function () {
                $(this).addClass("ui-state-hover");
            }, function () {
                $(this).removeClass("ui-state-hover");
            }).mousedown(function () {
                if ($(this).is('.ui-state-active.hy-button-toggleable')) {
                    $(this).removeClass("ui-state-active");
                } else {
                    $(this).addClass("ui-state-active");
                }
            }).mouseup(function () {
                if (!$(this).is('.hy-button-toggleable')) {
                    $(this).removeClass("ui-state-active");
                }
            });

            this.editLocationButton.click(function () {
                self._updateLocationBar();
            });

            // width of the controls on the left (up, label, edit)
            leftwidth = 0;
            locationBar.children(":not(.hy-file-browser-location-bar-wrapper):visible").each(function () {
                leftwidth += $(this).outerWidth(false);
            });
            this.locBarHolder.css('margin-left', leftwidth + 'px');
        },

        refreshVRootList: function () {
            var prev, res;

            prev = this._currentVRoot.id;

            $('div.hy-file-browser-vroot-list-column').remove();

            res = this._createVRootList();

            if (this.vrootList) {
                this.vrootList.jqGrid("setSelection", prev, false);
            }

            return res;
        },

        _createVRootList: function () {
            var self;

            self = this;

            this.vrootList = $('<div class="hy-file-browser-vroot-list-column">' +
                               '  <div class="hy-file-browser-vroot-list"><table width="100%"></table></div>' +
                               '</div>').appendTo(this.contentDiv).find('.hy-file-browser-vroot-list>table');

            this.vrootList.jqGrid({
                datatype: function () {
                    $.each(self.options.conf.vroots, function (n, v) {
                        self.vrootList.jqGrid('addRowData', v.id, {places: v.label, type: v.type});
                    });
                },
                width: self.vrootList.parent().width(),
                loadui: 'disable',
                height: this.options.conf.params.height,
                cellLayout: 4, // We set the borders to 0 in CSS
                colNames: ['Places'],
                colModel: [
                    {name: 'places', index: 'places', width: 1, sortable: false, formatter: $.hydrogen.placesFormatter}
                ],
                multiselect: false,
		        // onRightClickRow:     http://www.trirand.com/jqgridwiki/doku.php?id=wiki:events
                onSelectRow: function (id) {
                    if (id) {
                        $.each(self.options.conf.vroots, function (n, v) {
                            if (v.id === id) {
                                // v.path = '/';
				                $('.places-hist-overlay').remove(); jQuery.hydrogen.places_overlay=0;
                                self._changeLocation(v);
                                return false;
                            }
                        });
                    }
                },
                gridComplete: function () {
                    $('a.hy-file-browser-place', self.vrootList).click(function () {
                        $(this).parent().click();
                    });
		            // var self = this; 
		            // show overlays of previous locations for each place 
                    $('tr.jqgrow').filter(function() {
                        var regex = /^[0-9a-f]{40}$/; // Regular expression for 40-char hexadecimal
                        return regex.test(this.id);
                    }).each(function() {
                        // Your code here
                        // console.log("add mouse over");
                        // console.log(this.id);
			            var lineObj = $(this);
			            var r=$(this).children()[0];
                        // console.log(r);
                        $(r).removeAttr('title');
			            // console.log(lineObj.on('click'));
                        $(this).on("keypress", function(event) {
                            if (event.key === "t" || event.key === "T" ||
                                event.key === "r" || event.key === "R" ) {
                                // Retrieve from localStorage if it exists
                                var places_overlay_enable = JSON.parse(localStorage.getItem('places_overlay_enable'));
                                if (!places_overlay_enable) {
                                    places_overlay_enable = {
                                        "state": false,
                                        "time": new Date().getTime()
                                    };
                                } else {
                                    var currTime = new Date().getTime();
                                    if (currTime - places_overlay_enable.time > 630) {
                                        places_overlay_enable.state = !places_overlay_enable.state;
                                        places_overlay_enable.time = currTime;
                                        // Update jQuery.hydrogen object
                                    }
                                }
                                // Always store updated state in localStorage
                                localStorage.setItem('places_overlay_enable', JSON.stringify(places_overlay_enable));
                                jQuery.hydrogen.places_overlay_enable = places_overlay_enable;
                                // console.log(jQuery.hydrogen.places_overlay_enable);
                            }});
                        $(this).on('mouseover', function(ev) {
                            // Your onmouseover code here
                            // console.log('Mouseover event on:', this.id); // Example action
                            if (jQuery.hydrogen.places_overlay != undefined
                                && jQuery.hydrogen.places_overlay != this.id
                                && jQuery.hydrogen.places_overlay != 0
                               ) return;
                            if (jQuery.hydrogen.places_overlay_enable != undefined && jQuery.hydrogen.places_overlay_enable.state == false) return;
                            // check stack for entries for id
                            $('.places-hist-overlay').remove();
			                // if (self.locationsStack.length == 0) return;
			                if (self.locationsStack.length < 2) return;
                            // Create a new overlay element
                            var $overlay = $('<div class="places-hist-overlay"></div>').css({
                                position: 'absolute',
                                top: ev.pageY+9,  // Position near the mouse pointer
                                left: ev.pageX+9,
                                backgroundColor: 'white',
                                border: '1px solid #eee',
                                padding: '5px',
                                display: 'block',
                                fontSize: '72%',
				                overflowY: "auto",
                                overflowX: "hidden",
                                maxHeight: "30%",
				                maxWidth: "33%",
                                borderRadius: '5px',
                                boxShadow: '3px 3px 15px rgba(0, 0, 0, 0.3)',
                                zIndex: 1000 // Ensure it's on top
                            }).on('click', function() {
                                // Remove the overlay when the mouse clicks it (in the past leaves it ) 
                                // console.log("mouse click ...");
                                if (jQuery.hydrogen.isDragging || window.fmEditFilemode) return;
                                $(this).remove();
                                jQuery.hydrogen.places_overlay=0;
                            });
                            $overlay.append($('<div style="background-color: #ebebeb; cursor: move; font-size: 75%; font-weight: bold;" >Overview of recent locations - right click to keep the overlay; toggle display with t </div>'));
			                var lastpath="";
			                var found=0;
                            for (var f = self.locationsStack.length - 1; f >= 0; f--) {
                                var e = self.locationsStack[f];
                                // console.log(e);
                                if (e.id == this.id) {
                                    // console.log(e.path);
                                    if (lastpath != e.path) {
					                    // $("#fm-browse-file-browser").data("ui-hyfilebrowser")
					                    $overlay.append($('<div style="width: 90%;"><a href="#" onclick="javascript: changeLocationHelper(\''+
                                                          e.id+'\', \''+e.path+'\') ">'+e.path+'</a></div>'));
					                    found=1;
                                    }
                                    lastpath=e.path;
                                }
                            }
			                if (found == 0) return; // no entry to show ...
                            // Add the overlay to the body
                            $('body').append($overlay);
                            // find parent element we can use to close the overlay again
                            $('.places-hist-overlay').resizable({
                                // handle: ".fmdraggable",
                                start: function(e, C) {
                                    jQuery.hydrogen.isDragging = true
                                },
                                stop: function(e, C) {
                                    setTimeout(function() {
                                        jQuery.hydrogen.isDragging = false
                                    }, 100)
                                }
                            }).draggable({
                                // handle: ".fmdraggable",
                                start: function(e, C) {
                                    jQuery.hydrogen.isDragging = true
                                },
                                stop: function(e, C) {
                                    setTimeout(function() {
                                        jQuery.hydrogen.isDragging = false
                                    }, 100)
                                }
                            }).css({cursor: 'move'});
                            // jQuery.hydrogen.places_overlay=this.id;
                            // var currentElement = $('.places-hist-overlay'); // Assuming 'this' refers to the current element
                            var jqGridView = $(this.closest('.ui-jqgrid-view'));
                            // console.log("jqGridView");
                            // console.log(jqGridView);
                            jqGridView.on('mouseout', function() {
                                // Your code to execute when the mouse leaves jqGridView
                                // console.log('Mouse left jqGridView');
                                $(this).off('mouseout');
                                if (jQuery.hydrogen.places_overlay != undefined
                                    && jQuery.hydrogen.places_overlay != this.id
                                    && jQuery.hydrogen.places_overlay != 0
                                   ) return;
                                $('.places-hist-overlay').remove();
                            });
			            }).on('contextmenu', function(event) {
                            event.preventDefault(); // Prevent the default context menu
                            event.stopPropagation(); // Prevent the default context menu
                            // console.log('Right-click detected ... enable sticky overlay');
                            // remove onmouseout
                            $('.places-hist-overlay').removeAttr("onmouseout");
                            // add close button
                            jQuery.hydrogen.places_overlay=this.id;
                        }).on('mouseout', function(event) {
                            // console.log(" removing ...");
                            // $('.places-hist-overlay').remove();
                        });
                    });
                }
            })
        },
        _changeLocation: function (vroot) {
            if (this.vrootList) {
                this.vrootList.jqGrid("setSelection", vroot.id, false);
            }
            if (!this._currentVRoot || this._currentVRoot.id !== vroot.id ||
		this._currentVRoot.path !== vroot.path) {
		// console.log("current vroot");
		// console.log(this._currentVRoot);
		var saveVRoot = this._currentVRoot;
                this._currentVRoot = vroot;
		self=this;
                if (self.locationsStack.length === 0) {
		    var lSpooler=self.options.conf.params.spoolerURI;
		    // var jstr = jQuery.cookie('fm_locationsStack_'+lSpooler);
		    var jstr = localStorage.getItem('fm_locationsStack_' + lSpooler);
		    if (jstr != undefined && jstr != "") {
			var lStack = JSON.parse(jstr);
                        // console.log ("stack");
                        // console.log(lStack);
			self.locationsStack=lStack;
                    }
		}
		// find most recent path for present vroot
		var prevId = "";
                if (saveVRoot != undefined) prevId = saveVRoot.id
                if (this.locationsStack.length > 0
		    && prevId !== vroot.id  // we are switching the id / place 
		    /* && this._currentVRoot.id != this.locationsStack[this.locationsStack.length-1].id */ ) { 
                    // check for vroot in stack
                    for (var i=this.locationsStack.length-1; i >= 0 ; i--) {
                        var location=this.locationsStack[i];
                        // console.log(location);
                        if (location.id == this._currentVRoot.id) {
                            this._currentVRoot.path = location.path;
                            break;
                        }
                    }
                }
		if (this._currentVRoot.path == "") this._currentVRoot.path = "/";
                this.setSelection([]); // clear sticky selection when changing location
                this.reload();
            }
        },

        changeLocation: function (vrootid, path) {
            this._changeLocation({
                id: vrootid,
                path: path,
                type: this._currentVRoot.type
            });
        },

        changePath: function (path) {
            this._changeLocation({
                id: this._currentVRoot.id,
                path: path,
                type: this._currentVRoot.type
            });
        },

        _updateLocationBar: function () {
            var loc, locInput, self;

            loc = this._currentVRoot.path;

            this.table.hytable("setactionsServiceParams", {
                vroot: this._currentVRoot.id,
                path: this._currentVRoot.path
            });

            if (this.editLocationButton.is('.ui-state-active')) {
                $.cookie('hy-file-browser-location-bar-mode', 'text', {expires: 30});
                if (loc === "") {
                    loc = "/";
                }

                locInput = $('input', this.locBarHolder);
                if (!locInput.length) {
                    this.locBarHolder.empty();

                    // The surrounding span is needed to work around IE margin problem
                    locInput = $('<span><input class="hy-file-browser-locbar" type="text"></input></span>').appendTo(this.locBarHolder).find('input');

                    self = this;

                    locInput.keypress(function (e) {
                        if (e.which === 13) {
                            self.changePath('/' + $(this).val());
                            return false;
                        }

                        return true;
                    });

                    locInput.val(loc).select().trigger("focus");
                } else {
                    locInput.val(loc);
                }

            } else {
                $.cookie('hy-file-browser-location-bar-mode', 'link', {expires: 30});
                this._updateBreadCrumb(loc);
            }

            if (loc === "" || loc === "/") {
                this.upButton.addClass('ui-state-disabled').prop("disabled", true);
            } else {
                this.upButton.removeClass('ui-state-disabled').prop("disabled", false);
            }

            if (!this.options.conf.params.isRFB) {
                if (this.locationsStack.length > 1) {
                    this.backButton.removeClass('ui-state-disabled').prop("disabled", false);
                } else {
                    this.backButton.addClass('ui-state-disabled').prop("disabled", true);
                }
            }
        },

        _updateBreadCrumb: function (loc) {
            var self, pathComponents, breadCrumb, breadCrumbUl;

            self = this;
            this.locBarHolder.empty();

            breadCrumb = $('<div class="breadCrumb breadCrumbModule" ></div>').appendTo(this.locBarHolder);
            breadCrumbUl = $('<ul></ul>').appendTo(breadCrumb);

            pathComponents = loc.split('/');

            $.each(pathComponents, function (index) {
                var rel = pathComponents.slice(0, 1 + index).join('/');
                if (index === 0 || index < pathComponents.length - 1) {
                    $('<li><a href="#" rel="' + ((rel.length === 0) ? '/' : efEncodeHtml(rel)) + '">' + efEncodeHtml(this) + '</a></li>').appendTo(breadCrumbUl);
                } else {
                    $('<li>' + efEncodeHtml(this) + '</li>').appendTo(breadCrumbUl);
                }
            });

            breadCrumb.jBreadCrumb({
                minimumCompressionElements: 6,
                endElementsToLeaveOpen: 3,
                beginingElementsToLeaveOpen: 1,
                previewWidth: '2em'
            });

            $('a', breadCrumb).click(function () {
                self.changePath($(this).attr('rel'));
            });
        },

        filter: function (newFilter) {
            this.table.hytable('filter', newFilter);
            return this;
        },

        setHeight: function (h) {
            if (this.vrootList) {
                this.vrootList.jqGrid('setGridHeight', h);
            }
            this.table.hytable('setHeight', h);

            return this;
        },

        nVRoot: function () {
            return this.options.conf.vroots.length;
        },

        nFiles: function () {
            return this.table.hytable('nRecords');
        },

        currentPath: function () {
            return this._currentVRoot.path;
        },

        currentVRoot: function () {
            return this._currentVRoot.id;
        },

        _goUp: function () {
            var loc, idx;

            loc = this._currentVRoot.path;

            idx = loc.lastIndexOf('/');
            if (idx >= 0 && idx !== (loc.length - 1)) {
                loc = loc.substr(0, idx);
                this.changePath('/' + loc);
            }
        },

        _goBack: function () {
            if (this.locationsStack.length < 2) {
                return;
            }

            this.locationsStack.pop();
            this._changeLocation(this.locationsStack.pop());
        },

        destroy: function () {
            this.element.removeClass('hy-file-browser');
            this.contentDiv.remove();
            $.Widget.prototype.destroy.apply(this, arguments);
            return this;
        },

        selected: function () {
            return this.table.hytable('selected');
        },

        setSelection: function (sel) {
            return this.table.hytable('setSelection', sel);
        },

        getRowData: function (rowid) {
            return this.table.hytable('getRowData', rowid);
        },

        reload: function () {
	    // console.log(this.locationsStack);
	    // console.log(this.options);
            // console.log(this.options.conf.params.widgetId);
            var path=this._currentVRoot.path;
            // if (this.locationsStack.length > 0 && this._currentVRoot.id != this.locationsStack[this.locationsStack.length-1].id) {
            //     // check for vroot in stack
            //     for (var i=this.locationsStack.length-1; i >= 0 ; i--) {
            //         var stack=this.locationsStack[i];
            //         console.log(stack);
            //         if (stack.id == this._currentVRoot.id) {
            //             path = stack.path;
            //             break;
            //         }
            //     }
            // }
            this.table.hytable('setPostDataItem', 'spooler', this.options.conf.params.spoolerURI);
            this.table.hytable('setPostDataItem', 'vroot', this._currentVRoot.id);
            this.table.hytable('setPostDataItem', 'path', path);
            return this.table.hytable('reload');
        },

        _download: function (files, serviceUri) {
            var self;

            self = this;

            jQuery.hydrogen.invokeService({
                sdf: '/' + jQuery.enginframe.rootContext + '/fm/lib/xml/com.enginframe.fm.xml',
                uri: serviceUri,
                data: {
                    spooler: self.options.conf.params.spoolerURI,
                    vroot: self._currentVRoot.id,
                    path: self._currentVRoot.path,
                    files: files.join('\n')
                },
                success: function (xml) {
                    location.href = jQuery(xml).find('ef\\:redirect, redirect').first().text();
                },
                messagebox: self.options.messageArea
            });
        },

        downloadSelected: function () {
            var selectedFiles = this._getSelected();
            if (selectedFiles.length === 0) {
                return false
            }

            this._download(selectedFiles, '//com.enginframe.fm/download');
        },

        copyToLocal: function () {
            var selectedFiles = this._getSelected();
            if (selectedFiles.length === 0) {
                return false
            }

            this._copyToLocalDialog("Copying Files to Local Spooler", "Copy To Local");
            this._download(selectedFiles, '//com.enginframe.fm/copy.to.local');
        },

        getVrootType: function () {
            return this._currentVRoot.type;
        },

        _getSelected: function() {
            var selectedIds,
                selectedFiles = [],
                self = this;

            selectedIds = this.table.hytable('selected');

            if (selectedIds.length === 0) {
                return selectedFiles;
            }

            jQuery.each(selectedIds, function (index, value) {
                var rowData = self.table.hytable('getRowData', value);
                selectedFiles.push(rowData.name);
            });

            return selectedFiles;
        },

        _copyToLocalDialog: function(dialogTitle, buttonLabel) {
            var dialog = jQuery("#hy-copy-to-local-dialog");
            if (dialog.length === 0) {
                dialog = jQuery('<div class="ef-copy-to-local-dialog hy-simple-input-dialog" id="hy-copy-to-local-dialog"></div>').appendTo(jQuery('body'));
                jQuery('<div class="dialog-message" style="display:none;" ></div>').appendTo(dialog);
                jQuery('<div class="loading" style="position: absolute;background-color: #e4e4e4;text-align: center;width: calc(100% - 2em);"></div>').appendTo(dialog);
            }

            dialog.dialog({
                dialogClass: "ef-copy-to-local-dialog",
                title: dialogTitle,
                resizable: false,
                modal: true,
            });

            var msg = this._dialogMessage('hy-copy-to-local-dialog').val('')
            msg.hymessage().hymessage('info', "Please wait for the files to be copied. It may take a while...");

            var button = jQuery('button:contains(' + buttonLabel + ')', dialog.parent('div.ui-dialog'));
            button.addClass('ui-priority-primary');
        },

        _dialogMessage: function (dialogId) {
            return jQuery("#" + dialogId + " .dialog-message");
        },

        streamingDownload: function (rowId) {
            var fileLink, curPath, size, rowData, fname;

            rowData = this.table.hytable('getRowData', rowId);
            fname = rowData.name;

            fileLink = $('a.hy-file-browser-file[rel$="' + fname + '"]:first');
            if (fileLink.length > 0) {
                size = fileLink.attr('rel').split(':', 2)[0];
            }

            curPath = "/" + this._currentVRoot.id + this._currentVRoot.path + '/';

            streamingDownloadWindow($.enginframe.rootContext, /*root_context */
                                    fname, /* file name */
                                    this.options.conf.params.spoolerURI, /* uri */
                                    curPath + fname, /* path */
                                    size,  /* size */
                                    0, /* streaming_offset */
                                    true, /* keepalive */
                                    false, /* scrollatstart */
                                    "fm", /* plugin */
                                    null); /* extraURL */

            return this;
        },

        uploadSingle: function () {
            var dialog, label, form, isUploading, self;

            isUploading = false;
            dialog = jQuery('<div class="hy-simple-input-dialog"></div>').appendTo(jQuery('body'));
            label = jQuery('<label for="new-value">Files to upload:</span>').appendTo(dialog);
            form = jQuery('<form id="upload-form" action="/' +
                          jQuery.enginframe.rootContext + '/fm/lib/xml/com.enginframe.fm.xml?_uri=//com.enginframe.fm/upload" method="post">' +
                          '    <input type="hidden" name="spooler" value="' + efEncodeHtml(this.options.conf.params.spoolerURI) + '"/>' +
                          '    <input type="hidden" name="vroot" value="' + efEncodeHtml(this._currentVRoot.id) + '"/>' +
                          '    <input type="hidden" name="path" value="' + efEncodeHtml(this._currentVRoot.path) + '"/>' +
                          '    <input type="file" id="upload-form-file" name="files" multiple="multiple" style="width:100%"/>' +
                          '</form>').appendTo(dialog);

            dialog.dialog({
                title: "Upload",
                resizable: false,
                buttons: {
                    Cancel: function () {
                        jQuery(this).dialog("close");
                    },
                    Upload: function () {
			    form.trigger("submit");
                    }
                },
                beforeclose: function (event, ui) {
                    if (isUploading) {
                        return false;
                    }
                },
                modal: true
            });

            jQuery('button:contains("Upload")', dialog.parent('div.ui-dialog')).addClass('ui-priority-primary');

            self = this;

            // attach handler to form's submit event
            form.on("submit", function () {
                var newValue;

                if (isUploading) {
                    return false;
                }

                newValue = jQuery('#upload-form-file', jQuery(this)).val();
                if (newValue.length <= 0) {
                    return false;
                }

                isUploading  = true;

                jQuery('<img class="hy-upload-indicator" src="/' +
                        jQuery.enginframe.rootContext +
                        '/hydrogen/images/indicator.gif"/>').appendTo(jQuery('.ui-dialog-buttonpane', dialog.parent('div.ui-dialog')));

                dialog.dialog('disable');

                // submit the form
                jQuery(this).ajaxSubmit({
                    dataType: 'xml',
                    success: function (responseText, statusText) {
                        var xmlResult;

                        if (responseText) {
                            xmlResult = $(responseText).find('ef\\:error, error');
                            if (xmlResult.length > 0) {
                                self.options.messageArea.hymessage('error', xmlResult);
                            } else {
                                self.options.messageArea.hymessage('clear', xmlResult);
                            }
                        } else {
                            self.options.messageArea.hymessage('clear', xmlResult);
                        }

                        isUploading = false;
                        self.reload();
                        dialog.dialog('close');
                    },
                    error: function (xhr, statusText, errorThrown) {
                        self.options.messageArea.hymessage('alert', '<strong>An unknown error occurred while performing the upload.</strong>');
                        isUploading = false; // not needed but for formal correctness
                        dialog.dialog('close');
                    }
                });
                // return false to prevent normal browser submit and page navigation
                return false;
            });
        },

        _showNotification: function (msg) {
            if (this.options.messageArea) {
                // this.options.messageArea.hymessage("info", msg, 1000);
                this.options.messageArea.hymessage("info", msg, 4500);  // NSW 
            }
        },

        createNewFolder: function () {
            var self;

            self = this;

            simpleInputDialog("Create New Folder", "New folder name", "Create", "", function (folderName) {
                jQuery.hydrogen.invokeService({
                    sdf: '/' + jQuery.enginframe.rootContext + '/fm/lib/xml/com.enginframe.fm.xml',
                    uri: '//com.enginframe.fm/new.folder',
                    data: {
                        spooler: self.options.conf.params.spoolerURI,
                        vroot: self._currentVRoot.id,
                        path: self._currentVRoot.path,
                        name: folderName
                    },
                    success: function (xml) {
                        self._showNotification("The folder \"" + efEncodeHtml(folderName) + "\" has been created.");
                        self.reload();
                    },
                    messagebox: self.options.messageArea
                });
            });
        },

        rename: function (rowId) {
            var self, rowData, oldFileName;

            self = this;

            rowData = this.table.hytable('getRowData', rowId);
            oldFileName = rowData.name;

            if (oldFileName && oldFileName.length <= 0) {
                return false;
            }

            simpleInputDialog("Rename", "New name", "Rename", oldFileName, function (newName) {
                jQuery.hydrogen.invokeService({
                    sdf: '/' + jQuery.enginframe.rootContext + '/fm/lib/xml/com.enginframe.fm.xml',
                    uri: '//com.enginframe.fm/rename',
                    data: {
                        spooler: self.options.conf.params.spoolerURI,
                        vroot: self._currentVRoot.id,
                        path: self._currentVRoot.path,
                        oldname: oldFileName,
                        newname: newName
                    },
                    success: function (xml) {
                        self._showNotification("The file \"" + efEncodeHtml(oldFileName) + "\" has been renamed to \"" + efEncodeHtml(newName) + "\".");
                        self.reload();
                    },
                    messagebox: self.options.messageArea
                });
            });
        },

        _compress: function (files, suggestedName) {
            var self, dialog, entry, formatSelect, button, dialogButtons;

            self = this;

            dialog = jQuery('<div class="hy-simple-input-dialog">' +
                              '<label for="name">Archive Name:</label>' +
                              '<div>' +
                                '<span>' +
                                  '<input type="text" name="name" id="compress-name"/>' +
                                  '<select height="1" name="format" id="compress-format"/>' +
                                '</span>' +
                              '</div>' +
                            '</div>').appendTo(jQuery('body'));

            entry = jQuery('#compress-name', dialog);
            if (suggestedName) {
                entry.val(suggestedName);
            }

            formatSelect = jQuery('#compress-format', dialog);

            formatSelect.append(jQuery('<option value="zip">.zip</option>'));
            formatSelect.append(jQuery('<option value="tar.gz">.tar.gz</option>'));
            formatSelect.append(jQuery('<option value="tar.bz2">.tar.bz2</option>'));
            formatSelect.append(jQuery('<option value="tar">.tar</option>'));
            formatSelect.append(jQuery('<option value="tar.Z">.tar.Z</option>'));

            dialogButtons = {
                Cancel: function () {
                    jQuery(this).dialog("close");
                },
                Create: function () {
                    var entryValue;

                    entryValue = entry.val();
                    if (entryValue.length <= 0) {
                        return false;
                    }

                    jQuery(this).dialog("close");

                    jQuery.hydrogen.invokeService({
                        sdf: '/' + jQuery.enginframe.rootContext + '/fm/lib/xml/com.enginframe.fm.xml',
                        uri: '//com.enginframe.fm/create.archive',
                        data: {
                            spooler: self.options.conf.params.spoolerURI,
                            vroot: self._currentVRoot.id,
                            path: self._currentVRoot.path,
                            name: entryValue,
                            format: formatSelect.val(),
                            files: files.join('\n')
                        },
                        success: function (xml) {
                            self._showNotification("The archive \"" + efEncodeHtml(entryValue + "." + formatSelect.val()) + "\" has been created.");
                            self.reload();
                        },
                        messagebox: self.options.messageArea
                    });
                }
            };

            dialog.dialog({
                title: "Compress",
                resizable: false,
                buttons: dialogButtons,
                modal: true
            });

            button = jQuery('button:contains(Create)', dialog.parent('div.ui-dialog'));
            button.addClass('ui-priority-primary');
            entry.keypress(function (e) {
                if (e.which === 13) {
                    button.click();
                    return false;
                }

                return true;
            });
        },

        compress: function (rowId) {
            var rowData, fname;

            rowData = this.table.hytable('getRowData', rowId);
            fname = rowData.name;

            if (fname && fname.length <= 0) {
                return false;
            }

            this._compress([fname], fname);
        },

        compressSelected: function () {
            var selectedIds, suggestedName,
                selectedFiles = [],
                self = this;

            selectedIds = this.table.hytable('selected');

            if (selectedIds.length === 0) {
                return false;
            }

            jQuery.each(selectedIds, function (index, value) {
                var rowData = self.table.hytable('getRowData', value);
                selectedFiles.push(rowData.name);
            });

            if (selectedFiles.length === 1) {
                suggestedName = selectedFiles[0];
            }

            this._compress(selectedFiles, suggestedName);
        },
        copySelected: function() {
            var g, e, h = [], h_all = [], f = this;
            g = this.table.hytable("selected");
            if (g.length === 0) {
                return false
            } file_list_str="";
            jQuery.each(g, function(i, k) {
                var j = f.table.hytable("getRowData", k);
		// from this._currentlyShownVRoot
		// f.locationsStack
		j.vrootid=f._currentlyShownVRoot.id;
		j.vrootpath=f._currentlyShownVRoot.path;
		j.vroottype=f._currentlyShownVRoot.type;
		j.vrootspooler=f.options.conf.params.spoolerURI;
                h.push(j.name); h_all.push(j); file_list_str+="\""+j.name+"\", ";
		// console.log(j)
            });
	    var file_str="files"
            if (h.length === 1) {
                e = h[0]; file_str="file"
            }
	    this.copy_active=1
	    // jQuery.copy_active=1;
	    // this.table.copy_active=1;
            // this._copy(h, e)
	    // console.log(h);
	    var h_all_str = JSON.stringify(h_all);
	    jQuery.cookie('fm_copy', h_all_str, { expires: 3 })
	    sessionStorage.setItem('fm_copy', h_all_str);
	    // show paste and move buttons 
	    f._trigger("selectionchanged");
	    // let the paste and move buttons glow
	    $("#paste").toggleClass('glowing');
	    $("#move").toggleClass('glowing');
	    var noti_str=file_list_str.replace(/, $/,"") +" " +(h.length == 1?"has":"have") +" been marked for paste or move.\nTarget files will be overwritten by copy or paste.";
	    $("#move").attr('title', noti_str);
	    $("#paste").attr('title', noti_str);
	    // console.log(e); 
	    f._showNotification(noti_str);
        },
        pasteCopied: function(h) {
            var e, g, f;
            e = this;
            g = this.table.hytable("getRowData", h);
            f = g.name;
            if (f && f.length <= 0) {
                return false
            }
	    jQuery.hydrogen.invokeService({
                sdf: "/" + jQuery.enginframe.rootContext + "/fm/lib/xml/com.enginframe.fm.xml",
                uri: "//com.enginframe.fm/pasteCopied",
		modal_message: (h == "copy") ? "copying data" : "moving data" ,
		modal: true,
                data: {
                    spooler: e.options.conf.params.spoolerURI,
                    vroot: e._currentVRoot.id,
                    path: e._currentVRoot.path,
                    mode: h,
                    data: jQuery.cookie('fm_copy')
                },
                success: function(j) {
		    // console.log(j);
		    jQuery.removeCookie('fm_copy');sessionStorage.removeItem('fm_copy');
		    jQuery.hydrogen.clear_fm_log();
		    // e._showNotification(j);
		    if (e.options.messageArea) {
			if (j.match("background-color: yellow") || j.match("security mechanism")) {
			    e.options.messageArea.hymessage("alert", j, false);
			    setTimeout(function() { e.reload() }, 9000);
			} else {
			    e.options.messageArea.hymessage("info", j, 4500);
			    e.reload()
			}
		    }
		},
		error: function(j) {
                    // console.log(j);
                    jQuery.removeCookie('fm_copy');sessionStorage.removeItem('fm_copy');
                    jQuery.hydrogen.clear_fm_log();
		},
                messagebox: e.options.messageArea
            })
        },
        _delete: function (files, updateSelection) {
            var self;

            self = this;

            jQuery.hydrogen.invokeService({
                sdf: '/' + jQuery.enginframe.rootContext + '/fm/lib/xml/com.enginframe.fm.xml',
                uri: '//com.enginframe.fm/remove',
		modal: true,
		modal_message: "deleting data",
                data: {
                    spooler: self.options.conf.params.spoolerURI,
                    vroot: self._currentVRoot.id,
                    path: self._currentVRoot.path,
                    files: files.join('\n')
                },
                success: function (xml) {
                    self.setSelection(updateSelection);
		    jQuery.hydrogen.clear_fm_log();
                    self.reload();
                },
                messagebox: self.options.messageArea
            });
        },

        deleteItem: function (rowId) {
            var updateSelection, rowData, fname;

            rowData = this.table.hytable('getRowData', rowId);
            fname = rowData.name;

            if (fname && fname.length <= 0) {
                return false;
            }

            updateSelection = jQuery.grep(this.table.hytable('selected'),
                function(value) {
                    return value !== fname;
                }
            );

            this._delete([fname], updateSelection);
        },

        deleteSelected: function () {
            var selectedIds,
                selectedFiles = [],
                self = this;

            selectedIds = this.table.hytable('selected');

            if (selectedIds.length === 0) {
                return false;
            }

            jQuery.each(selectedIds, function (index, value) {
                var rowData = self.table.hytable('getRowData', value);
                selectedFiles.push(rowData.name);
            });

            this._delete(selectedFiles, []);
        },

        executeFileAction: function (sdf, uri, params) {
            var self;

            self = this;

            jQuery.hydrogen.invokeService({
                sdf: sdf,
                uri: uri,
                data: params,
                success: function (xml) {
                    self._showNotification("The Service has been submitted correctly.");
                    self.reload();
                },
                messagebox: self.options.messageArea
            });
        }
    });

}(jQuery));

// ex:ts=4:et:
