/*global jQuery, escape, DetectZoom, alert */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

(function ($) {

    $.hydrogen = $.hydrogen || {};

    $.extend($.hydrogen, {

        promptReconnect: function (session) {
            var form, msg;

            // the caller must specify either a form or a div as the placeholder
            if (session.formid) {
                form = $('form#' + session.formid);
                msg = $('<div></div>').hymessage().prependTo(form.parent(), 0);
            } else if (session.divid) {
                msg = $('<div></div>').hymessage().prependTo($('div#' + session.divid), 0);
            }

            msg.addClass("hy-interactive-duplicated-session");

            function createSessionBox(session) {
                var creationTime, href, boxwrap, encSessionName;
                creationTime = $.hydrogen.formatDate(session.creation, {inSentence: true, showSeconds: false});
                href = '?_uri=//com.enginframe.interactive/connect.session&amp;sessionUri=' +
                       encodeURIComponent(session.uri);
                encSessionName = efEncodeHtml(session.name);
                boxwrap = $('<div class="hy-interactive-duplicated-session-boxwrap">' +
                              '<div class="hy-interactive-duplicated-session-box">' +
                                '<div class="hy-interactive-duplicated-session-boxpad">' +
                                '  <a href="' + href + '">' +
                                     '<img title="Connect to session ' + encSessionName + '"' +
                                        'src="/' + $.enginframe.rootContext +
                                        '/download/interactive-data/screenshot.png?' +
                                        '_spooler=' + encodeURIComponent(session.uri) +
                                        '&amp;_efdm=local&amp;_size=-1&amp;' +
                                        '_file=interactive-data/screenshot.png' +
                                        '&amp;_' + Math.floor((Math.random() * 1000) + 1) +
                                     '"/>' +
                                   '</a>' +
                                   '<div class="hy-interactive-duplicated-session-info">' +
                                     '<div class="hy-interactive-duplicated-session-name" title="Connect to session ' +
                                         encSessionName + '"><a href="' + href + '">' + encSessionName + '</a>' +
                                     '</div>' +
                                     (session.project ?
                                        ('<div class="hy-interactive-duplicated-session-details project">' +
                                         'Project: <b>' + efEncodeHtml(session.project) + '</b></div>') : "") +
                                     '<div class="hy-interactive-duplicated-session-details">Started ' + creationTime +
                                     '</div>' +
                                     '<div class="hy-interactive-duplicated-session-details">Running on <b> ' +
                                         efEncodeHtml(session.host) + '</b>' +
                                     '</div>' +
                                   '</div>' +
                                '</div>' +
                              '</div>' +
                            '</div>');

                return boxwrap;
            }

            function showReconnectMessage(tot, label, sessions, allowMore) {
                var wrapper, table, message, more, action, messageDiv, encLabel = '';

                // needed because .html() strips the outer element
                wrapper = $('<div class="hy-interactive-duplicated-session-wrapper"></div>');

                if (tot === 0) {
                    msg.hide();
                } else {
                    $(sessions).each(function (i, v) {
                        createSessionBox(v).appendTo(wrapper);
                    });

                    if (label !== undefined && label !== '') {
                        encLabel = efEncodeHtml(label);
                        encLabel = '<i>' + encLabel + '</i> ';
                    }

                    if (allowMore === true || allowMore === "true") {
                        if (tot > 1) {
                            message = 'Do you want to reconnect to one of the existing ' + encLabel + 'sessions?';
                        } else {
                            message = 'Do you want to reconnect to the existing ' + encLabel + 'session?';
                        }
                    } else {
                        message = 'You cannot start a new session. ';
                        if (tot > 1) {
                             message = message + 'You already have ' + tot + ' ' + encLabel +
                                'active sessions and you have reached the maximum number allowed. ' +
                                'Please reconnect to one of them.';
                        } else {
                            message = message + 'You already have one ' + encLabel +
                                'active session and you have reached the maximum number allowed. ' +
                                'Please reconnect to the existing ' + encLabel + 'session.';
                        }
                    }

                    messageDiv = $('<div></div>');
                    $('<div class="hy-error-primary-message">' + message + '</div>').appendTo(messageDiv);
                    wrapper.appendTo(messageDiv);
                    $('<div class="hy-interactive-more-link">' +
                        'Reconnect now, or visit the ' +
                        '<a href="?_uri=//com.enginframe.interactive/list.sessions">List Sessions page</a>' +
                        ' to manage your sessions.' +
                      '</div>').appendTo(messageDiv);

                    msg.hymessage('info', messageDiv.html(), 0);
                }

                if (form && (allowMore === true || allowMore === "true")) {
                    action = form.attr('action');
                    form.attr('action', action + '&interactive_skipprompt');
                    form.show();
                }
            }

            // If we received the sessions array, we are in the _uri case, otherwise do the ajax call
            if (session.sessions) {
                showReconnectMessage(session.tot, session.label, session.sessions, session.allowMore);
            } else {
                form.hide();
                msg.hymessage("info", '<div class="loading">Please wait...</div>');
                $.hydrogen.invokeService({
                    sdf: $.hydrogen.SDF,
                    uri: "//ui.hydrogen/interactive.duplicated.sessions.data",
                    data: session,
                    success: function (xml) {
                        var doc, dup, tot, label, allowMore, sessions;

                        doc = $(xml);
                        dup = $('duplicated-sessions', doc);

                        tot = parseInt(dup.attr('tot'), 10);
                        label = dup.attr('label');
                        allowMore = dup.attr('allow-more') === "true";

                        sessions = [];

                        // We just show the first three
                        dup.find('spooler:lt(3)').each(function (i, e) {
                            var el = $(e);
                            sessions.push({
                                name: el.find('name').text(),
                                uri: el.find('uri').text(),
                                project: el.find('project').text(),
                                creation: el.find('creation-time').text(),
                                host: el.find('execution-host').text()
                            });
                        });

                        showReconnectMessage(tot, label, sessions, allowMore);
                    },
                    messagebox: msg
                });
            }
        },

        renameSessionDialog: function (sessionUri, messagebox, onSuccess) {
            var dialog, entry, button;

            dialog = $('<div class="hy-simple-input-dialog"></div>').appendTo($('body'));
            $('<label for="new-value" style="display:block">New name:</label>').appendTo(dialog);
            entry = $('<input type="text" name="value" id="new-value" style="width:90%"/>');
            entry.prop('disabled', true).appendTo(dialog);

            dialog.dialog({
                title: "Rename Session",
                resizable: false,
                modal: true,
                buttons: {
                    Cancel: function () {
                        $(this).dialog("close");
                    },
                    Rename: function () {
                        var newValue;

                        newValue = entry.val();
                        if (newValue.length <= 0) {
                            return false;
                        }

                        $(this).dialog("close");
                        $.hydrogen.invokeService({
                            sdf: '/' + $.enginframe.rootContext + '/interactive/lib/xml/com.enginframe.interactive.xml',
                            uri: '//com.enginframe.interactive/rename.session',
                            data: {
                                sessionUri: sessionUri,
                                name: newValue
                            },
                            success: function (xml) {
                                onSuccess();
                            },
                            messagebox: messagebox
                        });
                    }
                }
            });

            button = $('button:contains(Rename)', dialog.parent('div.ui-dialog'));
            button.prop('disabled', true).addClass('ui-priority-primary');
            entry.keypress(function (e) {
                if (e.which === 13) {
                    button.click();
                    return false;
                }

                return true;
            });

            dialog.dialog("option", "disabled", true);

            $.enginframe.invokeService({
                sdf: '/' + $.enginframe.rootContext + '/interactive/lib/xml/com.enginframe.interactive.xml',
                uri: '//com.enginframe.interactive/session.name',
                data: {
                    sessionUri: sessionUri
                },
                success: function (name) {
                    entry.val(name).prop('disabled', false).select();
                    button.prop('disabled', false);
                    dialog.dialog("option", "disabled", false);
                },
                error: function () {
                    entry.prop('disabled', false);
                    button.prop('disabled', false);
                    dialog.dialog("option", "disabled", false);
                }
            });
        }
    });

    $.fn.interactiveResolution = function (remote) {
        return this.each(function () {

            var self, presets, detailsRow, id, devicePxPerCssPx, width, height,
                widthEl, heightEl, fullScreenEl, allMonitorsEl, allMonitorsRow,
                defaultGeometry, autoGeometry;

            function customResolution() {
                var w, h, fs, am, regExpr;
                regExpr = new RegExp("^[1-9][0-9]*$");

                // w = $.trim(widthEl.val());
                w = String.prototype.trim.call(widthEl.val());
                if (!regExpr.test(w)) {
                    alert("Invalid display width.");
                    w = width;
                    widthEl.val(w);
                }

                // h = $.trim(heightEl.val());
                h = String.prototype.trim.call(heightEl.val());
                if (!regExpr.test(h)) {
                    alert("Invalid display height.");
                    h = height;
                    heightEl.val(h);
                }

                fs = fullScreenEl.prop("checked");
                if (fs === true) {
                    // Do not use show() since it add "display: block" breaking the tableWrapper
                    allMonitorsRow.css('display', '');
                    am = allMonitorsEl.prop("checked");
                } else {
                    allMonitorsRow.hide();
                    am = false;
                }
                self.val(w + "x" + h + ":" + fs + ":" + am);
            }

            function parseCustomGeometry(customGeometry) {
                var regex, values, geometryValues, w, h, fs, am;

                regex = new RegExp("^[1-9][0-9]*$");
                // values = $.trim(customGeometry).split(":", 3);
                values = String.prototype.trim.call(customGeometry).split(":", 3);
                geometryValues = values[0].split("x", 2);
                w = geometryValues[0];
                if (!w || !regex.test(w)) {
                    w = width;
                }
                widthEl.val(w);

                h = geometryValues[1];
                if (!h || !regex.test(h)) {
                    h = height;
                }
                heightEl.val(h);

                fs = values[1] === "true";
                am = fs && (values[2] === "true");
                if (fs) {
                    // Do not use show() since it add "display: block" breaking the tableWrapper
                    allMonitorsRow.css('display', '');
                } else {
                    allMonitorsRow.hide();
                }
                fullScreenEl.prop("checked", fs);
                allMonitorsEl.prop("checked", am);

                detailsRow.css('display', '');
                widthEl.trigger("focus");
                self.val(w + "x" + h + ":" + fs + ":" + am);
            }

            self = $(this);
            id = self.attr('id') || 'id-' + Math.floor(9999 * (Math.random() % 1));

            devicePxPerCssPx = DetectZoom.device();

            // FIXME: It seems this does not work with iPad
            width = Math.ceil(screen.width * devicePxPerCssPx);
            height = Math.ceil(screen.height * devicePxPerCssPx);

            autoGeometry = width + "x" + height + ":true:false";
            // defaultGeometry = $.trim(self.val());
            defaultGeometry = String.prototype.trim.call(self.val());
            // TODO: if defaultGeometry is empty check cookie
            if (autoGeometry === defaultGeometry) {
                defaultGeometry = "auto";
            }

            self.hide();
            presets = $('<select class="hy-interactive-geometry-preset-selector"/>').insertAfter(self);
            detailsRow = $('<tr>' +
                    '  <td colspan="2">' +
                    '    <div class="hy-interactive-geometry-details">' +
                    '      <table>' +
                    '        <tr>' +
                    '          <td>Resolution:</td>' +
                    '          <td>' +
                    '            <input type="text" size="5" maxlength="5" name="' + id + '-width"/> &#215; ' +
                    '            <input type="text" size="5" maxlength="5" name="' + id + '-height"/>' +
                    '          </td>' +
                    '        </tr>' +
                    '        <tr>' +
                    '          <td><label for="' + id + '-fullscreen">Fullscreen Mode:</label></td>' +
                    '          <td><input type="checkbox" name="' + id + '-fullscreen"/></td>' +
                    '        </tr>' +
                    '        <tr class="hy-interactive-geometry-details-all-monitors">' +
                    '          <td><label for="' + id + '-all-monitors">Use All Monitors:</label></td>' +
                    '          <td><input type="checkbox" name="' + id + '-all-monitors"/></td>' +
                    '        </tr>' +
                    '      </table>' +
                    '    </div>' +
                    '  </td>' +
                    '</tr>').hide().insertAfter(self.closest('tr'));

            widthEl = $(':input[name="' + id + '-width"]', detailsRow).val(width);
            heightEl = $(':input[name="' + id + '-height"]', detailsRow).val(height);
            fullScreenEl = $(':input[name="' + id + '-fullscreen"]', detailsRow);
            allMonitorsEl = $(':input[name="' + id + '-all-monitors"]', detailsRow);
            allMonitorsRow = $("tr.hy-interactive-geometry-details-all-monitors", detailsRow).hide();

            presets.change(function () {
                var first_enabled, value = $(this).val();
                // This is needed because disabling an option with the disabled attribute does not work in IE 7
                if (false ) { // $.browser.name === "msie" && parseInt($.browser.version, 10) <= 7
                    if (this.options[this.selectedIndex].disabled) {
                        if (this.lastSelectedIndex) {
                            this.selectedIndex = this.lastSelectedIndex;
                        } else {
                            first_enabled = $(this).children('option:not(:disabled)').get(0);
                            this.selectedIndex = first_enabled ? first_enabled.index : 0;
                        }
                    } else {
                        this.lastSelectedIndex = this.selectedIndex;
                    }
                }
                //end
                if (value === "custom") {
                    // Do not use show() since it add "display: block" breaking the tableWrapper
                    detailsRow.css('display', '');
                    customResolution();
                    widthEl.trigger("focus");
                } else {
                    detailsRow.hide();
                    if (value === "auto") {
                        self.val(autoGeometry);
                    } else {
                        self.val(value);
                    }
                }
            });

            $('input', detailsRow).change(customResolution);

            $.hydrogen.invokeService({
                sdf: "/" + $.enginframe.rootContext + "/interactive/lib/xml/com.enginframe.interactive.xml",
                uri: "//com.enginframe.interactive/list.resolutions",
                data: {
                    remote: remote
                },
                success: function (data, textStatus) {
                    var lines, hasCustom, firstOption, customOption, hasDefault;
                    hasCustom = false;
                    hasDefault = false;
                    lines = data.match(/[^\r\n]+/g);
                    $.each(lines, function (index, value) {
                        var geometry, label, i, option;
                        i = value.search(/\s/);
                        if (i > 0) {
                            // geometry = $.trim(value.substr(0, i));
                            geometry = String.prototype.trim.call(value.substr(0, i));
                            // label = $.trim(value.substr(i + 1));
                            label = String.prototype.trim.call(value.substr(i + 1));
                            option = $('<option value="' + geometry + '">' + efEncodeHtml(label) + '</option>').appendTo(presets);
                            if (geometry === defaultGeometry) {
                                // NSW option.attr("selected", "selected");
                                option.prop("selected", true);
                                hasDefault = true;
                            }
                            if (index === 0) {
                                firstOption = option;
                            }
                        // } else if ($.trim(value) === "custom") {
                        } else if (String.prototype.trim.call(value) === "custom") {
                            hasCustom = true;
                        }
                    });

                    if (hasCustom) {

                        $('<option class="hy-interactive-geometry-preset-selector-dash" disabled="disabled">' +
                            '----</option>').appendTo(presets);
                        if (false ) { // $.browser.name === "msie" && parseInt($.browser.version, 10) <= 7
                            $('.hy-interactive-geometry-preset-selector-dash').css('color', '#CCC');
                        }
                        customOption = $('<option value="custom">Custom...</option>').appendTo(presets);
                    }

                    if (!hasDefault) {
                        if (hasCustom && defaultGeometry) {
                            // NSW customOption.attr("selected", "selected");
                            customOption.prop("selected", true);
                            parseCustomGeometry(defaultGeometry);
                        } else {
                            try {
                                // firstOption.attr("selected", "selected");
                                firstOption.prop("selected", true);
                            } catch (e) {
                                // IE6 throws an exception that we can safely ignore, selected is set anyway
                            }
                            if (firstOption.val() === "auto") {
                                self.val(autoGeometry);
                            } else {
                                self.val(firstOption.val());
                            }
                        }
                    }
                    presets.css('width', 'auto');
                },
                dataType: 'text'
            });
        });
    };

    $(document).ready(function () {
        // convert ef:option@class=interactive-<remote>-geometry options to the list-of-resolutions widget
        $.each([ "dcv2", "dcv2sm" ], function(index, remote){
            $("input.interactive-" + remote + "-geometry").interactiveResolution(remote);
        });

        // Just a temporary filler before we redirect to the connection page
        $("div.interactive-wait").hymessage().hymessage('info',
            '<div class="hy-connect-session-primary-message">Your session will start soon, please wait...</div>');
    });

}(jQuery));

// ex:ts=4:et:
