/*global jQuery */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

(function ($) {

    $.widget('ui.hyprojects', {

        options: {
            conf: {},
            title: null
        },

        _create: function () {

            this.element.hide();
            this.element.addClass('hy-box hy-projects ui-widget');

            this.headerDiv = $('<div></div>').appendTo(this.element);
            this.contentDiv = $('<div></div>').appendTo(this.element);
            this.contentUl = $('<ul></ul>').appendTo(this.contentDiv);
            this.contentImg = $('<img/>').hide().appendTo(this.contentDiv);

            this.headerDiv.addClass('hy-box-header ui-widget-header');
            this.contentDiv.addClass('hy-box-content ui-widget-content');
            this.contentUl.addClass('ui-helper-reset');

            this.chartSrc = null;

            if (this.options.title === null) {
                this.headerDiv.text('Projects');
            } else {
                this.headerDiv.text(this.options.title);
            }

            this._active = null;
        },

        destroy: function () {

            this.element.removeClass('hy-box hy-projects ui-widget');

            this.headerDiv.remove();
            this.contentDiv.remove();

            $.Widget.prototype.destroy.apply(this, arguments);

            return this;
        },

        _clickHandler: function (event) {
            var projectLi, self;

            projectLi = $(this);

            if (projectLi.hasClass("ui-state-highlight")) {
                return;
            }

            self = event.data.self;

            self.unselectAll();

            projectLi.addClass('ui-state-highlight');
            self._active = event.data.realname;
            self._trigger('select', null, {formula: self.selected()});
        },

        update: function () {
            var self;
            self = this;
            $.enginframe.invokeService({
                sdf: this.options.conf.params.SDF,
                uri: this.options.conf.params.statsServiceUri,
                data: this.options.conf.params.statsServiceParams,
                success: function (xml) {
                    self._realUpdate(xml);
                },
                dataType: 'xml'
            });
        },

        resetSize: function () {
            if (this.chartSrc === null) {
                this._hideChart();
            } else {
                this._showChart();
            }

            return this;
        },

        _realUpdate: function (xml) {
            // Add projects
            var numOfProjects, others, chartData, chartLegend, self, othersLi;

            numOfProjects = 0;
            others = 0;
            chartData = [];
            chartLegend = [];

            this.contentUl.empty();

            self = this;

            $('stats>projects>project', xml).each(function () {
                var project, name, realname, projectLi, count;

                project = $(this);
                count = project.text();

                numOfProjects += 1;

                if (numOfProjects < 5) {
                    name = project.attr("name");
                    realname = name;

                    if (name === '') {
                        name = '[Unspecified]';  // FIXME: make this configurable
                    }

                    chartData.push(count);
                    chartLegend.push(name);

                    projectLi = $("<li></li>").text(name + " (" + count + ")");
                    self.contentUl.append(projectLi);

                    if (realname === self._active) {
                        projectLi.addClass("ui-state-highlight");
                    }

                    projectLi.bind('click', {self: self, realname: realname}, self._clickHandler);
                } else {
                    others += parseInt(count, 10);
                }
            });

            if (others > 0) {
                othersLi = $('<li>Others (' + others + ')</li>');
                othersLi.addClass('ui-state-disabled');
                this.contentUl.append(othersLi);

                chartData.push(others);
                chartLegend.push("Others");
            }

            if (numOfProjects > 0) {
                this.element.show();
            } else {
                this.element.hide();
            }

            if (numOfProjects > 1) {
                this.chartSrc = $.enginframe.chartsBaseUrl + "?cht=p&chd=t:" + chartData.toString() +
                        "&chdl=" + chartLegend.join("%7C") + "&chdlp=bv&chco=1F75CC";

                // Makes projects box visible (it is hidden by default)
                this._showChart();
            } else {
                this.chartSrc = null;

                this._hideChart();
            }

            return this;
        },

        _showChart: function () {
            var src, imgWidth;

            imgWidth = this.contentUl.innerWidth();

            src = this.chartSrc + "&chs=" + Math.floor(imgWidth) + "x" + Math.floor(imgWidth);
            this.contentImg.attr({
                width: imgWidth,
                height: imgWidth,
                src: src
            });

            // Makes projects box visible (it is hidden by default)
            this.contentImg.show();

            return this;
        },

        _hideChart: function () {
            this.contentImg.hide();

            return this;
        },

        selected: function () {
            if (this._active === null) {
                return null;
            }

            if (this._active === '') {
                return '!project';
            }

            return 'project = \'' + this._active + '\'';
        },

        unselectAll: function () {
            this._active = null;
            this.contentUl.children('li.ui-state-highlight').removeClass('ui-state-highlight');

            return this;
        }
    });

}(jQuery));

// ex:ts=4:et:
