/*global jQuery,Spinner*/
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

(function ($) {

    $.fn.spin = function (opts) {
        this.each(function () {
            var $this = $(this), data = $this.data();

            if (data.spinner) {
                data.spinner.stop();
                delete data.spinner;
            }

            if (opts !== false) {
                data.spinner = new Spinner($.extend({color: $this.css('color')}, opts)).spin(this);
            }
        });

        return this;
    };

    $.widget('ui.hysessions', {

        options: {
            conf: {},
            noItemsLabel: "No records to view",  // If set to null no message is shown
            messageArea: null,
            defaultFilter: null,
            defaultLoadErrorMessage: "Cannot obtain the requested data from the server."
        },

        _filter: '',
        _query: '',
        _sidx: '',
        _sord: 'asc',

        _params: null,

        _menu: null,
        _lastMenuRequest: null,

        _editMode: false,

        _create: function () {

            var self, sortBy;

            self = this;

            this.element.addClass('hy-sessions ui-widget');

            this.loadDiv = $('<div class="hy-sessions-loading-wrapper">' +
                               '<div class="loading ui-state-default ui-state-active">Loading ...</div>' +
                               '</div>').appendTo(this.element).find('.loading');

            this.headerDiv = $('<div class="hy-sessions-header ui-widget-content"></div>').appendTo(this.element);
            this.contentDiv = $('<div class="hy-sessions-content ui-widget-content"></div>').appendTo(this.element);

            this.sortBySelect =
                $('<div style="float:left">' +
                    '<span>Sort by:</span>' +
                    '<span><select class="hy-sessions-sort-by" name="sort-by" class="ui-state-default"/></span>' +
                    '</div>').appendTo(this.headerDiv).find('select');

            this.sortOrd =
                $('<div style="float:left" title="Change sort order">' +
                    '<span class="ui-grid-ico-sort ui-icon-asc ui-state-enabled ui-icon ui-icon-triangle-1-n">' +
                    '</span>' +
                    '<span class="ui-grid-ico-sort ui-icon-desc ui-state-disabled ui-icon ui-icon-triangle-1-s">' +
                    '</span>' +
                  '</div>').appendTo(this.headerDiv);

            this.modeButton = $('<div class="hy-sessions-mode-button">' +
                    '<button class=" hy-button hy-button-toggleable ui-corner-all ui-state-default">Edit</button>' +
                '</div>')
                .appendTo(this.headerDiv)
                .find('button')
                .hide()
                .click(function () {
                    if ($(this).is('.ui-state-active.hy-button-toggleable')) {
                        self.editMode(false);
                    } else {
                        self.editMode(true);
                    }
                });

            if (this.options.noItemsLabel) {
                this.noItemsDiv = $('<div class="hy-table-no-records ui-state-highlight">' +
                    this.options.noItemsLabel + '</div>').hide().appendTo(this.element);
            }

            this._params = {
                multiselect: false,
                sortBy: "_natural:asc",
                SDF: "",
                serviceUri: "",
                serviceParams: {},
                actionsServiceUri: null,
                actionsServiceParams: {},
                actionsServiceSDF: $.hydrogen.SDF
            };

            $.extend(this._params, this.options.conf.params);
            sortBy = this._params.sortBy.split(':', 2);

            if (this.options.defaultFilter) {
                this._filter = this.options.defaultFilter;
            }

            $.each(this.options.conf.colmodel, function (i, col) {
                var option;

                if (col.sortable && !col.hidden) {
                    option = $('<option value="' + col.name + '">' + efEncodeHtml(col.label) + '</option>').
                        appendTo(self.sortBySelect);

                    if (sortBy[0] === col.name) {
                        option.prop('selected', true);
                    }
                }
            });

            self._sidx = this.sortBySelect.val();

            this.sortBySelect.change(function (val) {
                self._sort($(this).val(), 'asc');
                self.reload();
            });

            this.sortOrd.click(function (val) {
                var sord;
                sord = self._sord === 'asc' ? 'desc' : 'asc';
                self._sort(self.sortBySelect.val(), sord);
                self.reload();
            });

            // FIXME: support this._params.multiselect
        },

        _sort: function (sidx, sord) {
            var self = this;

            self._sidx = sidx;
            if (sord === 'asc') {
                self._sord = 'asc';
                self.sortOrd.find('.ui-icon-asc').addClass('ui-state-enabled');
                self.sortOrd.find('.ui-icon-asc').removeClass('ui-state-disabled');
                self.sortOrd.find('.ui-icon-desc').addClass('ui-state-disabled');
                self.sortOrd.find('.ui-icon-desc').removeClass('ui-state-enabled');
            } else {
                self._sord = 'desc';
                self.sortOrd.find('.ui-icon-asc').addClass('ui-state-disabled');
                self.sortOrd.find('.ui-icon-asc').removeClass('ui-state-enabled');
                self.sortOrd.find('.ui-icon-desc').addClass('ui-state-enabled');
                self.sortOrd.find('.ui-icon-desc').removeClass('ui-state-disabled');
            }
        },

        _updateSessionForStatus: function (sessionUri, sessionDiv, status, name, sessionRemote, isShareable, owner) {
            var self, statusClass, mine, spinnerClass, statusLabel, imgSrc;

            self = this;

            statusClass = 'hy-interactive-session-status-' + status.toLowerCase();

            if (sessionDiv.hasClass(statusClass)) {
                return;
            }

            mine = sessionDiv.hasClass('hy-interactive-session-is-mine');
            sessionDiv.removeClass().addClass('hy-interactive-session').addClass(statusClass);
            if (mine) {
                sessionDiv.addClass('hy-interactive-session-is-mine');
            }

            $('.hy-interactive-session-screen-wrapper', sessionDiv).remove();
            $('.hy-interactive-session-close', sessionDiv).remove();

            spinnerClass = "hy-interactive-session-icon";
            statusLabel = status;
            switch (status) {
            case "Starting":
            case "Pending":
                spinnerClass = "hy-interactive-session-spinner";
                statusLabel = statusLabel + '...';
                break;
            case "Closing":
                statusLabel = statusLabel + '...';
                break;
            }

            if (status === "Running") {
                imgSrc = '/' + $.enginframe.rootContext + '/download/interactive-data/screenshot.png?_spooler=' +
                    encodeURIComponent(sessionUri) + '&amp;_efdm=local&amp;_size=-1&amp;' +
                    '_file=interactive-data/screenshot.png&amp;_' + Math.floor((Math.random() * 1000) + 1);
                if (isShareable !== "false" || owner === jQuery.enginframe.user.name) {
                    lUniq = (new Date()).getTime();
                    var overlayString = '<div id="hy-session-connection-overlay-' + lUniq + '" class="hy-session-connection-overlay">' +
                        'Connect to the DCV session with<br/>' +
                        '<a id="hy-dcvweb-' + lUniq + '" href="#dcvweb">&gt; Web browser</a><br/>' +
                        '<a id="hy-dcvuri-' + lUniq + '" href="#dcvuri">&gt; DCV Client via URI</a> <br/>' +
                        '<a id="hy-dcvfile-' + lUniq + '" href="#dcvfile">&gt; DCV Client connection file</a>' +
                        '</div>';
                    // FIXME: more CSS here!
                    var wrapper = '<div id="hy-session-connection-wrapper-' + lUniq + '" class="hy-interactive-session-screen-wrapper hy-cursor-pointer">' +
                        '<!-- Container div for image and possibly overlay -->' +
                        '<div style="position: relative; display: inline-block">' +
                            '<img style="margin-top: 12px; margin-left: 15px" width=200" height="112" src="' + imgSrc + '" title="Connect to session ' + efEncodeHtml(name) + ' owned by ' + jQuery.enginframe.user.name + '"/>';
                    if (self.options.conf.params.showOverlay === "true") {
                        wrapper +=  '<!-- Overlay div -->' +
                            '<div style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.0); color: white; display: block">' +
                                overlayString +
                            '</div>';
                    }

                    wrapper += '</div></div>'

                    $(wrapper)
                        .prependTo(sessionDiv)
                        .on("mouseenter", function(event){ self._screenshotZoomHandler(event, imgSrc, "create") })
                        .on("mouseleave", function(event){ self._screenshotZoomHandler(event, imgSrc, "remove") })
                        .click(function () {
                            self._trigger('connect', null, {sessionUri: sessionUri, sessionName: name, status: status, sessionRemote: sessionRemote});
                        });
                    $('#hy-dcvweb-' + lUniq).click(function() {
                        event.preventDefault();
                        event.stopPropagation();
                        self._trigger("connect", null, { sessionUri: sessionUri, sessionName: name, status: status, sessionRemote: sessionRemote + "#hy_dcvweb" });
                    });
                    $('#hy-dcvuri-' + lUniq).click(function(event) {
                        event.preventDefault();
                        event.stopPropagation();
                        self._trigger("connect", null, { sessionUri: sessionUri, sessionName: name, status: status, sessionRemote: sessionRemote + "#hy_dcvuri" });
                    });
                    $('#hy-dcvfile-' + lUniq).click(function() {
                        event.preventDefault();
                        event.stopPropagation();
                        self._trigger("connect", null, { sessionUri: sessionUri, sessionName: name, status: status, sessionRemote: sessionRemote+ "#hy_dcvfile" });
                    });
                }
            } else {
                $('<div class="hy-interactive-session-screen-wrapper">' +
                  '<div class="hy-interactive-session-screen">' +
                  '<div class="' + spinnerClass + '"></div>' +
                  '<div class="hy-interactive-session-status">' + efEncodeHtml(statusLabel) + '</div></div>')
                    .prependTo(sessionDiv);
            }
            if (mine && (status !== "Closing")) {
                $('<div class="hy-interactive-session-close"><a><img src="' +
                    '/' + $.enginframe.rootContext + '/hydrogen/images/close-window-light.png"/></a></div>').
                    appendTo(sessionDiv);
            }
        },

        _screenshotZoomHandler: function (event, imgSrc, action) {
            var self, thisElement;

            self = this;
            thisElement = event.currentTarget;

            if (jQuery.hydrogen.isDragging) return;

            $('#fm_hydrogen_overlay').remove();
            if (action == "remove") {
                $(thisElement).find(".hy-session-connection-overlay").animate({ opacity: 0 }, 200);
                return;
            }

            // Show the connection links overlay
            $(thisElement).find(".hy-session-connection-overlay").animate({ opacity: 1 }, 200);

            // Create overlay element and append to body
            // FIXME: move style to CSS!
            var overlayString='<div id="fm_hydrogen_overlay" style="width: 30%; box-shadow: 0 0 15px 5px rgb(113, 93, 93, 60%); background: white; opacity: 0.1; padding: 6px; border-radius: 10px; position: absolute; display: none; z-index: 1000;">' +
                '<div id="fm_overlay_info" class="fmdraggable" style="cursor: move; font-size: 66%; width: 100%; max-width: 100%; ">Right click to keep the overlay; Click on the overlay to close it</div>' +
                '<div id="fm_overlay-content" style="height: 85%; overflow-y: auto;  overflow-x: hidden; font-size: 75%; width: 100%; max-width: 100%; " alt="Text">' +
                    '<img src="'+ imgSrc +'" style=" width: 100%; max-width: 100%; height: auto;" alt="Image"/>' +
                '</div>' +
            '</div>';
            $('body').append(overlayString);

            var $overlay = $('#fm_hydrogen_overlay');
            var position = $(thisElement).offset();
             // Position directly above current
            $overlay.css({
                top: position.top - 30 ,
                left: position.left + 240
            });
            $(thisElement).on('contextmenu', function(event) {
                event.preventDefault();
                // Remove mouseleave event to preserve the overlay
                $(thisElement).off("mouseleave");
            });
            $overlay.show().resizable().draggable().css({cursor: 'move'});
            $overlay.animate({
                opacity: 1,
                top: "-=6px"
            }, 300);

            // Hide overlay on click
            $overlay.on('click', function() {
                if (jQuery.hydrogen.isDragging) return;

                // Add mouseleave event again in case it was removed by "contextmenu" event
                $(thisElement).on("mouseleave", function(event) { self._screenshotZoomHandler(event, imgSrc, "remove") });
                $overlay.remove();
            });

        },

        _updateContentDiv: function (xml) {
            var self, nRecords;

            self = this;

            this.contentDiv.empty();
            // There is no need to trigger 'selectionchanged' here since it will trigger a few lines later while
            // setting editMode

            this.sessionList = $('<div class="ui-widget ui-widget-content hy-interactive-session-list"></div>').
                    appendTo(this.contentDiv);

            $('list-spoolers>spooler', xml).each(function () {
                var session, sessionDiv, status, sessionUri, name, star, os, owner, n_shared, sharedLabel, sharedClass, warning, sessionRemote, isShareable;

                sharedClass = "";
                session = $(this);

                status = $('status', session).text() || "Failed";
                warning = $('warning', session).text();
                sessionUri = $('uri', session).text();
                sessionRemote = $('remote', session).text();
                name = $('name', session).text();
                star = $('star', session).text();
                os = $('os', session).text();
                owner = $('owner', session).text();
                isShareable = $('isShareable', session).text();
                n_shared = $('guests', session).children().length;

                sessionDiv = $('<div id="' + sessionUri + '"></div>').appendTo(self.sessionList);

                if (owner === jQuery.enginframe.user.name) {
                    sessionDiv.addClass('hy-interactive-session-is-mine');
                    if (n_shared === 1) {
                        sharedClass = "hy-interactive-session-is-shared";
                        sharedLabel = "Shared with " + $('guests :first-child', session).text();
                    } else if (n_shared > 1) {
                        sharedClass = "hy-interactive-session-is-shared";
                        sharedLabel = "Shared with " + n_shared + " people";
                    }
                } else {
                    sharedClass = "hy-interactive-session-is-shared hy-interactive-session-is-shared-by";
                    sharedLabel = "Shared by " + efEncodeHtml(owner);
                }

                $('<div class="hy-star hy-star-compact-page hy-star-' + ((star === 'true') ? 'on' : 'off') + '" ></div>').appendTo(sessionDiv).toggleStar(sessionUri);

                self._updateSessionForStatus(sessionUri, sessionDiv, status, name, sessionRemote, isShareable, owner);
                $('<a href="#" class="hy-interactive-session-name-wrapper">' +
                    '<div class="hy-interactive-session-name-box hy-interactive-session-os-' + efEncodeHtml(os) + ' ' +
                    sharedClass + '">' +
                    '<div class="hy-interactive-session-name" title="' + efEncodeHtml(name) + '">' + efEncodeHtml(name) + '</div>' +
                    ((n_shared > 0) ? '<span title="' + sharedLabel + '" class="hy-interactive-session-shared"></span>' : '') +
                    ((warning) ? '<span title="' + efEncodeHtml(warning) + '" class="hy-interactive-session-warning"></span>' : '') +
                    '<span class="ui-icon ui-icon-caret-1-e hy-selectable-item-menu hy-interactive-session-menu">' +
                    '</span>' +
                    '</div>' +
                  '</a>').appendTo(sessionDiv);

                $('<div class="hy-interactive-session-selector">' +
                    '<div class="hy-interactive-session-selector-checkbox" ></div>' +
                  '</div>').appendTo(sessionDiv);
            });

            this.editMode(this._editMode);

            $(".hy-interactive-session-name-wrapper", self.contentDiv).mousedown(
                function () {
                    var id;
                    if (self.editMode()) {
                        return false;
                    }
                    id = $(this).closest(".hy-interactive-session").attr("id");
                    self._populateMenu(this, id);
                    return false;
                }
            );

            this.sessionList.on('click', '.hy-interactive-session-close a', function () {
                var id, actionsServiceParams;

                if (self._params.actionsServiceUri && self._params.actionsServiceSDF) {

                    id = $(this).closest(".hy-interactive-session").attr("id");

                    actionsServiceParams = {
                        'rowId': id,
                        'widgetId': self._params.widgetId
                    };

                    $.extend(actionsServiceParams, self._params.actionsServiceParams);

                    // Expand special action params
                    $.each(actionsServiceParams, function (k, v) {
                        if (v) {
                            actionsServiceParams[k] = v.replace(/^@\{rowId\}$/, function () {
                                return id;
                            });
                        } else {
                            actionsServiceParams[k] = "";
                        }
                    });

                    $.enginframe.invokeService({
                        sdf: self._params.actionsServiceSDF,
                        uri: self._params.actionsServiceUri,
                        data: actionsServiceParams,
                        success: function (actionsJson) {
                            $.each(actionsJson, function (i, item) {
                                if ((item.id === "close") || (item.id === "cleanup")) {
                                    self._trigger('action', null,
                                                    {action: item.action, currentId: id});
                                    return false;
                                }
                            });
                        },
                        dataType: 'json'
                    });
                }
                return false;
            }).on('mouseenter', '.hy-interactive-session-close a', function () {
                $("img", $(this)).attr("src", '/' + $.enginframe.rootContext + '/hydrogen/images/close-window.png');
            }).on('mouseleave', '.hy-interactive-session-close a', function () {
                $("img", $(this)).attr("src", '/' + $.enginframe.rootContext +
                    '/hydrogen/images/close-window-light.png');
            });

            $(".hy-interactive-session-spinner", self.contentDiv).spin({
                lines: 11,
                length: 7,
                width: 5,
                radius: 10,
                corners: 1.0,
                rotate: 0,
                trail: 50,
                speed: 0.6,
                fps: 10,
                zIndex: 500, // high but less than dialogs
                shadow: "on",
                hwaccel: "off"
            });

            nRecords = parseInt($('list-spoolers>records', xml).text(), 10);
            if (nRecords === 0) {
                if (self.noItemsDiv) {
                    self.noItemsDiv.show();
                    self.editMode(false);
                    self.modeButton.hide();
                }
            } else {
                if (self.noItemsDiv) {
                    self.noItemsDiv.hide();
                    self.modeButton.show();
                }
            }
        },

        destroy: function () {

            this.element.removeClass('hy-compact-view ui-widget');

            this.headerDiv.remove();
            this.contentDiv.remove();

            $.Widget.prototype.destroy.apply(this, arguments);

            return this;
        },

        reload: function (refreshMode) {
            if ((refreshMode === 'auto') && this.editMode()) {
                // Ignore automatic refresh when in edit edit
                return;
            }

            if (this.element.is(':visible')) {
                var serviceParams, self = this;

                serviceParams = { view: "compact" };
                $.extend(serviceParams, self._params.serviceParams);

                self.loadDiv.show();

                $.hydrogen.invokeService({
                    sdf: self._params.SDF,
                    uri: self._params.serviceUri,
                    data: $.extend({
                        filter: self._filter,
                        query: self._query,
                        sidx: self._sidx,
                        sord: self._sord,
                        refresh: refreshMode || ""
                    }, serviceParams),
                    complete: function () {
                        self.loadDiv.hide();
                    },
                    success: function (xml) {
                        self._updateContentDiv(xml);

                        self._trigger('loadcomplete', null, {data: xml});
                    },
                    dataType: 'xml',
                    messagebox: self.options.messageArea,
                    defaultErrorMessage: self.options.defaultLoadErrorMessage
                });
            }

            return this;
        },

        updateSession: function (sessionUri, status, sessionRemote) {
            var sessionDiv, name;

            if (this.sessionList) {
                sessionDiv = $('#' + $.hydrogen.escapeSelector(sessionUri), this.sessionList);
                name = $('.hy-interactive-session-name', sessionDiv).text();
                this._updateSessionForStatus(sessionUri, sessionDiv, status, name, sessionRemote);
            }
        },

        selected: function () {
            var selectedItems = [];
            if (this.editMode()) {
                $(".hy-interactive-session.ui-selected", this.contentDiv).each(function () {
                    selectedItems.push($(this).attr("id"));
                });
            }
            return selectedItems;
        },

        editMode: function (editMode) {
            if (editMode === undefined) {
                return this._editMode;
            }

            this._setOption('editMode', editMode === true);

            return this;

        },

        // Note that you need to relaod after setting a filter
        filter: function (newFilter) {
            if (newFilter === undefined) {
                return this._filter;
            }

            this._setOption('filter', newFilter);

            return this;
        },

        // Note that you need to reload after setting a query
        query: function (newQuery) {
            if (newQuery === undefined) {
                return this._query;
            }

            this._setOption('query', newQuery);

            return this;
        },

        _setOption: function (key, value) {
            var self = this;

            switch (key) {
            case 'filter':
                this._filter = value;
                this._trigger('filterchange', null, {formula: value});
                break;
            case 'query':
                this._query = value;
                break;
            case 'editMode':
                this._editMode = value;
                if (value) {
                    this.sessionList.removeClass("hy-interactive-session-list-view-mode");
                    this.sessionList.addClass("hy-interactive-session-list-edit-mode");
                    $(".hy-interactive-session-selector", this.sessionList).show();
                    this.sessionList.bind("mousedown", function (e) {
                            // This is required to allow to deselect single items by clicking on them
                        e.metaKey = true;
                    }).selectable({
                        filter: ".hy-interactive-session",
                        stop: function () {
                            self._trigger('selectionchanged');
                        }
                    });
                    this.modeButton.html('Done').addClass("ui-state-active");
                } else {
                    this.sessionList.removeClass("hy-interactive-session-list-edit-mode");
                    this.sessionList.addClass("hy-interactive-session-list-view-mode");
                    $(".hy-interactive-session-selector", this.sessionList).hide();
                    if (this.sessionList.hasClass("ui-selectable")) {
                        this.sessionList.selectable("destroy");
                        $('.ui-selected', this.sessionList).removeClass('ui-selected');
                    }
                    this.modeButton.html('Edit').removeClass("ui-state-active");
                }
                this._trigger('modechanged', null, {mode: value ? "EDIT" : "VIEW"});
                this._trigger('selectionchanged');
                break;
            }

            $.Widget.prototype._setOption.apply(this, arguments);
        },

        _menuActivate: function (e, menuItem) {
            menuItem.data.widget._trigger('action', null,
                                            {action: menuItem.data.action, currentId: menuItem.data.rowid});
        },

        _populateMenu: function (element, id) {
            var menu_options, actionsServiceParams, self, nameBox;

            self = this;

            if (this._menu !== null) {
                this._menu.destroy();
            }

            nameBox = $(".hy-interactive-session-name-box", $(element));

            menu_options = {
                drawBorder: true,
                minWidth: 150,
                offsetLeft: nameBox.width() + ($(element).width() - nameBox.width()) / 2,
                offsetTop: -1 * (nameBox.height() / 2),
                onClick: this._menuActivate,
                divClass: "hy-interactive-session-popup-menu hy-table-menu",
                // effect: "blind",
                onClose: function () {
                    // row.removeClass("ui-state-ef-highlight");
                    self._menu.destroy();
                    self._menu = null;
                }
            };  // 2px more cause margins

            this._menu = new $.Menu($(element), null, menu_options);
            $.each(this.options.conf['single-action-items'], function (i, item) {
                self._menu.addItem(new $.MenuItem({
                    src: efEncodeHtml(item.name),
                    icon: item.icon,
                    addClass: item.classes,
                    data: {
                        menuid: item.id,
                        widget: self,
                        rowid: id,
                        action: item.action
                    }
                }, menu_options));
            });

            this._menu.show();
            if (this._params.actionsServiceUri && this._params.actionsServiceSDF) {

                if (this._lastMenuRequest) {
                    this._lastMenuRequest.abort();
                }

                actionsServiceParams = {
                    'rowId': id,
                    'widgetId': self._params.widgetId
                };
                $.extend(actionsServiceParams, self._params.actionsServiceParams);

                // Expand special action params
                $.each(actionsServiceParams, function (k, v) {
                    if (v) {
                        actionsServiceParams[k] = v.replace(/^@\{rowId\}$/, function () {
                            return id;
                        });
                    } else {
                        actionsServiceParams[k] = "";
                    }
                });

                // FIXME: do we really want to ignore error messages here?
                this._lastMenuRequest = $.enginframe.invokeService({
                    sdf: this._params.actionsServiceSDF,
                    uri: this._params.actionsServiceUri,
                    data: actionsServiceParams,
                    success: function (actionsJson) {
                        $.each(actionsJson, function (i, item) {
                            self._menu.addItem(new $.MenuItem({
                                src: efEncodeHtml(item.name),
                                icon: item.icon,
                                addClass: item.classes,
                                data: {
                                    menuid: item.id,
                                    widget: self,
                                    rowid: id,
                                    action: item.action
                                }
                            }, menu_options));
                        });
                        self._menu.show();
                    },
                    dataType: 'json'
                });
            }
        }
    });

}(jQuery));


// ex:ts=4:et:
