/*global jQuery */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

(function ($) {

    $.widget('ui.hysessionsharedialog', {

        options: {
            conf: {},
            sessionUri: '',
            supportViewOnly: false,
            onSave: function () {}
        },

        _create: function () {
            var self, shareUri;

            self = this;

            $.extend(this._params, this.options.conf.params);

            this.dialog = $('<div class="hy-action-dialog"></div>').appendTo($('body'));

            this.msg = $('<div></div>').hymessage().appendTo(this.dialog);
            this.content = $('<div class="hy-share-session-dialog-content">' +
                             '  <div class="hy-share-session-message">' +
                             '    Please enter the name of people you want to share your session with' +
                             '  </div>' +
                             '  <div>' +
                             '    <span class="hy-share-session-users-label">Collaborators:</span>' +
                             '    <span class="hy-share-session-users-loading"><p>Loading...</p></span>' +
                             '    <input id="users" class="hy-share-session-users-input" />' +
                             '  </div>' +
                             '</div>').appendTo(this.dialog);

            this.usersList = this.content.find('#users');

            if (this.options.supportViewOnly) {
                $('<div>' +
                  '  <span class="hy-share-session-users-label">Viewers:</span>' +
                  '  <span class="hy-share-session-users-loading"><p>Loading...</p></span>' +
                  '  <input id="viewers" class="hy-share-session-users-input" />' +
                  '</div>').appendTo(this.content);

                this.viewersList = this.content.find('#viewers');
            }

            this.dialog.dialog({
                title: 'Share Settings',
                width: jQuery(60).toPx(),
                bgiframe: true,
                modal: true,
                buttons: {
                    Cancel: function () {
                        self.dialog.dialog('close');
                    },
                    Save: function () {
                        // FIXME: Is this necessary now that tokeninput is used?
                        // We delay the real save in a timeout, because tagit uses a timeout
                        // of 400 ms in the blur event handler to save the last edited tag
                        setTimeout(function () {
                            self._save();
                        }, 500);
                    }
                }
            });

            this._getUsers();
        },

        _getUsers: function () {
            var self = this;

            jQuery.hydrogen.invokeService({
                sdf: $.hydrogen.SDF,
                uri: '//ui.hydrogen/interactive.session.users',
                data: {
                    sessionUri: this.options.sessionUri
                },
                success: function (xml) {
                    var doc, listUsersServiceUri, customSDF, customUri;

                    listUsersServiceUri = $.hydrogen.SDF + '?_uri=//ui.hydrogen/list.users.data';
                    customSDF = self.options.conf.params.listUsersSDF;
                    customUri = self.options.conf.params.listUsersServiceUri;
                    if (customSDF && customUri) {
                        listUsersServiceUri += '&customSDF=' + customSDF + '&customUri=' + customUri;
                    }

                    $(".hy-share-session-users-loading").remove();

                    doc = jQuery(xml);

                    self.usersList.show()
                        .tokenInput(listUsersServiceUri, {
                            queryParam: 'search',
                            minChars: 3,
                            preventDuplicates: true,
                            hintText: '',
                            width: 300,
                            zindex: 9999,
                            cursorDropdown: true,
                            theme: 'hydrogen',
                            resultsFormatter: function (item) {
                                if (item.name === item.id) {
                                    return '<li>' +
                                           '  <div class="hy-share-session-autocomplete-realname">' + efEncodeHtml(item.name) +'</div>' +
                                           '</li>';
                                }
                                else {
                                    return '<li>' +
                                           '  <div class="hy-share-session-autocomplete-realname">' + efEncodeHtml(item.name) +'</div>' +
                                           '  <div class="hy-share-session-autocomplete-username">' + efEncodeHtml(item.id) + '</div>' +
                                           '</li>';
                                }
                            }
                        });

                    jQuery('guests', doc).find('user').each(function (i, e) {
                        self.usersList.tokenInput('add', { id: jQuery(this).attr('id'), name: jQuery(this).text() });
                    });

                    if (self.options.supportViewOnly) {
                        self.viewersList.show()
                            .tokenInput(listUsersServiceUri, {
                                queryParam: 'search',
                                minChars: 3,
                                preventDuplicates: true,
                                hintText: '',
                                width: 300,
                                zindex: 9999,
                                cursorDropdown: true,
                                theme: 'hydrogen',
                                resultsFormatter: function (item) {
                                    if (item.name === item.id) {
                                        return '<li>' +
                                               '  <div class="hy-share-session-autocomplete-realname">' + efEncodeHtml(item.name) +'</div>' +
                                               '</li>';
                                    }
                                    else {
                                        return '<li>' +
                                               '  <div class="hy-share-session-autocomplete-realname">' + efEncodeHtml(item.name) +'</div>' +
                                               '  <div class="hy-share-session-autocomplete-username">' + efEncodeHtml(item.id) + '</div>' +
                                               '</li>';
                                    }
                                }
                            });

                        jQuery('guests', doc).find('viewer').each(function (i, e) {
                            self.viewersList.tokenInput('add', { id: jQuery(this).attr('id'), name: jQuery(this).text() });
                        });
                    }
                },
                messagebox: self.msg
            });
        },

        _save: function () {
            var self, fullAccessUsers, viewOnlyAccessUsers;

            self = this;

            fullAccessUsers = $.map(this.usersList.tokenInput('get'), function (e, i) { return e.id + '|' + e.name; });
            viewOnlyAccessUsers = this.options.supportViewOnly ? $.map(this.viewersList.tokenInput('get'), function (e, i) { return e.id + '|' + e.name; }) : [];

            $.hydrogen.invokeService({
                sdf: '/' + jQuery.enginframe.rootContext + '/interactive/lib/xml/com.enginframe.interactive.xml',
                uri: '//com.enginframe.interactive/set.session.guests',
                data: {
                    sessionUri: self.options.sessionUri,
                    fullAccessUsers: fullAccessUsers.join('\n'),
                    viewOnlyAccessUsers: viewOnlyAccessUsers.join('\n')
                },
                success: function (xml) {
                    self.dialog.dialog('close');
                    self.options.onSave();
                },
                messagebox: self.msg
            });
        },

        destroy: function () {
            this.dialog.remove();
            $.Widget.prototype.destroy.apply(this, arguments);
            return this;
        }
    });

}(jQuery));

// ex:ts=4:sw=4:et:
