/*global jQuery */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

(function ($) {

    // FIXME: Functions below are already in jquery.hyutils.js
    //        Remove them (and fix their calls) when they become public!
    function parseISO8601(iso8601) {
        var s;

        // s = jQuery.trim(iso8601);
        s = String.prototype.trim.call(iso8601);

        s = s.replace(/-/, "/").replace(/-/, "/");
        s = s.replace(/T/, " ").replace(/Z/, " UTC");
        s = s.replace(/([\+\-]\d\d)\:?(\d\d)/, " $1$2"); // -04:00 -> -0400

        return new Date(s);
    }

    // Pads numbers with a preceding 0 if the number is less than 10.
    function padWithZero(val) {
        if (parseInt(val, 10) < 10) {
            return "0" + val;
        }

        return val;
    }

    /*
     * Accepts the client's time zone offset from GMT in minutes as a parameter.
     * returns the timezone offset in the format [+|-}DDDD
     */
    function getTimeZone(timezoneOffset) {
        var hours, modMin, absHours, s;

        hours = Math.floor(timezoneOffset / 60);
        modMin = Math.abs(timezoneOffset % 60);
        s = (hours > 0) ? "-" : "+";
        absHours = Math.abs(hours);
        s += (absHours < 10) ? "0" + absHours : absHours;
        s += ":";
        s += ((modMin === 0) ? "00" : modMin);

        return s;
    }

    // Constants
    var DAY_IN_MILLISECONDS = 86400000;


    // General purposes private functions
    function ellipsize(string, len) {
        if (string && (string.length > len)) {
            return (string.slice(0, (len - 3)) + "...");
        }
        return string;
    }

    function formatAsISO8601Date(oDate) {
        var s;

        s  = oDate.getFullYear() + "-";
        s += padWithZero(oDate.getMonth() + 1) + "-";
        s += padWithZero(oDate.getDate());

        return s;
    }


    // The widget
    $.widget("ui.hyspoolerbar", {

        options: {
            spoolerData: {},
            conf: {},
            ellipsizedLength: 60, // FIXME
            notificationArea: null
        },

        _spooler: null,
        _creationDate: null,
        _expirationDate: null,

        _keepForever: false,

        _minExpirationDate: null,

        _timeZone: null,

        _create: function () {
            var content, self,
                nameElement, descriptionElement, projectElement, expiresOnElement, detailsElement,
                showEditableForm, triangleElement, now;

            content =
                '<div class="hy-spoolerbar-static ui-widget-header ui-helper-reset ui-state-default">' +
                   '<table class="hy-spoolerbar-table">' +
                     '<tr>' +
                       '<td class="hy-spoolerbar-colleft">' +
                         '<span class="ui-icon ui-icon-triangle-1-e hy-spoolerbar-expander-icon"></span>' +
                       '</td>' +
                       '<td class="hy-spoolerbar-colcenter">' +
                         '<div class="hy-spoolerbar-header">' +
                           '<div class="hy-spoolerbar-star hy-star hy-star-off"></div>' +
                           '<span class="hy-spooler-name hy-spoolerbar-editable-field"></span>' +
                         '</div>' +
                         '<div class="hy-spoolerbar-description-container ui-helper-hidden">' +
                           '<div class="hy-spoolerbar-separator"></div>' +
                           '<span class="hy-spooler-description hy-spoolerbar-editable-field"></span>' +
                         '</div>' +
                         '<div class="hy-spooler-details ui-helper-hidden">' +
                           '<div class="hy-spoolerbar-separator-large"></div>' +
                           '<label class="hy-spoolerbar-label">Project:</label>' +
                           '<span class="hy-spooler-project hy-spoolerbar-editable-field"></span>' +
                           '<div class="hy-spoolerbar-separator"></div>' +
                           '<div class="hy-spooler-details-status"></div>' +
                           '<label class="hy-spoolerbar-label">Created on:</label>' +
                           '<span class="hy-spooler-created-on hy-spoolerbar-not-editable-field"></span>' +
                           '<div class="hy-spoolerbar-separator"></div>' +
                           '<label class="hy-spoolerbar-label">Expires on:</label>' +
                           '<span class="hy-spooler-expires-on hy-spoolerbar-editable-field"></span>' +
                         '</div>' +
                       '</td>' +
                       '<td class="hy-spoolerbar-colright">' +
                         '<div class="hy-spoolerbar-status"></div>' +
                       '</td>' +
                     '</tr>' +
                   '</table>' +
                '</div>' +

                '<div class="hy-spoolerbar-editable ui-widget-header ui-helper-reset ' +
                            'ui-state-default ui-helper-hidden">' +
                   '<table class="hy-spoolerbar-table">' +
                     '<tr>' +
                       '<td class="hy-spoolerbar-colleft">' +
                         '<span class="ui-icon ui-icon-triangle-1-s ui-state-disabled hy-spoolerbar-expander-icon">' +
                         '</span>' +
                       '</td>' +
                       '<td class="hy-spoolerbar-colcenter">' +
                         '<div class="hy-spoolerbar-editable-content">' +
                           '<input class="hy-spooler-name-edit hy-spoolerbar-no-hint" type="text"' +
                                  'value="Spooler name" ></input>' +
                           '<textarea class="hy-spooler-description-edit" rows="2" title="Add a description here"></textarea>' +
                           '<div class="hy-spooler-details-edit ui-helper-hidden">' +
                             '<div>' +
                               '<label class="hy-spoolerbar-label">Project:</label>' +
                               '<input class="hy-spooler-project-edit" type="text" title="Add a project name" ></input>' +
                             '</div>' +
                             
                             '<div class="hy-spoolerbar-not-editable">' +
                               '<div class="hy-spooler-details-status"></div>' +
                             '</div>' +
                             
                             '<div class="hy-spoolerbar-not-editable">' +
                               '<label class="hy-spoolerbar-label">Created on:</label>' +
                               '<span class="hy-spooler-created-on-edit hy-spoolerbar-cursor-default"></span>' +
                             '</div>' +
                             '<div class="hy-spoolerbar-expiration-time-row">' +
                               '<label class="hy-spoolerbar-label">Expires on:</label>' +
                               '<span class="hy-spooler-expiration-time-control">' +
                                 '<input class="hy-spooler-expiration-time-edit hy-spoolerbar-datepicker ' +
                                               'hy-spoolerbar-no-hint" type="text" ></input>' +
                                 '<span class="hy-spooler-expiration-time-edit-label">&nbsp;at&nbsp;</span>' +
                                 '<span class="hy-spooler-expiration-time-edit-time hy-spoolerbar-cursor-default">' +
                                 '</span>' +
                               '</span>' +
                               '<span class="hy-spooler-expiration-time-never ui-helper-hidden">Never</span>' +
                               '<span class="hy-spooler-expiration-time-links">' +
                                 '<a class="hy-spoolerbar-link-keep-forever hy-spoolerbar-link">Keep forever...</a>' +
                                 '<a class="hy-spoolerbar-link-set-time hy-spoolerbar-link ui-helper-hidden">' +
                                   'Set expiration time...</a>' +
                               '</span>' +
                             '</div>' +
                           '</div>' +
                         '</div>' +
                         '<div class="hy-spoolerbar-buttonset">' +
                           '<button class="hy-spooler-save-button hy-button ui-priority-primary ui-state-default ' +
                                          'ui-corner-all">Save</button>' +
                           '<button class="hy-spooler-cancel-button hy-button ui-state-default ui-corner-all">Cancel' +
                           '</button>' +
                         '</div>' +
                       '</td>' +
                     '</tr>' +
                   '</table>' +
                '</div>';

            this.element.addClass("hy-spoolerbar ui-widget");
            $(content).appendTo(this.element);

            // Initialize spooler data.
            this._spooler = {
                "uri": "",
                "name": "",
                "creation-time": "1970-01-01T00:00+0000",
                "expiration-time": null,
                metadata: {
                    "EF_SPOOLER_DESCRIPTION": "",
                    "EF_SPOOLER_PROJECT": "",
                    "EF_SPOOLER_STAR": "false"
                }
            };
            // Merge with spooler data given as widget option.
            $.extend(true, this._spooler, this.options.spoolerData);

            this._creationDate = parseISO8601(this._spooler["creation-time"]);
            now = new Date();

            if (this._spooler["expiration-time"]) {
                this._expirationDate = parseISO8601(this._spooler["expiration-time"]);
                this._minExpirationDate = new Date(this._expirationDate);
                this._minExpirationDate.setFullYear(now.getFullYear());
                this._minExpirationDate.setMonth(now.getMonth());
                this._minExpirationDate.setDate(now.getDate());
                this._timeZone = getTimeZone(this._expirationDate.getTimezoneOffset());
            } else {
                this._minExpirationDate = new Date();
                this._timeZone = getTimeZone(this._minExpirationDate.getTimezoneOffset());
            }

            if (this._minExpirationDate <= now) {
                this._minExpirationDate.setTime(this._minExpirationDate.getTime() + DAY_IN_MILLISECONDS);
            }

            // Cache some DOM elements for convenience.
            nameElement = $(".hy-spooler-name", this.element);
            descriptionElement = $(".hy-spooler-description", this.element);
            projectElement = $(".hy-spooler-project", this.element);
            expiresOnElement = $(".hy-spooler-expires-on", this.element);
            triangleElement = $(".hy-spoolerbar-expander-icon", this.element);
            statusElement = $(".hy-spoolerbar-status", this.element);

            nameElement.html(efEncodeHtml(this._spooler.name));
            if (this._spooler.metadata.EF_SPOOLER_STAR === "true") {
                $(".hy-spoolerbar-star", this.element)
                    .removeClass("hy-star-off")
                    .addClass("hy-star-on");
            }
            if (this._spooler.metadata.EF_SPOOLER_DESCRIPTION.length > 0) {
                descriptionElement.html(efEncodeHtml(ellipsize(this._spooler.metadata.EF_SPOOLER_DESCRIPTION,
                                        this.options.ellipsizedLength)));
                $(".hy-spoolerbar-description-container", this.element).show();
            }
            projectElement.html(efEncodeHtml(this._spooler.metadata.EF_SPOOLER_PROJECT));
            $(".hy-spooler-created-on", this.element)
                .html($.datepicker.formatDate("DD, d MM yy", this._creationDate) +
                      " at " + padWithZero(this._creationDate.getHours()) + ":" +
                      padWithZero(this._creationDate.getMinutes()));
            if (this._expirationDate) {
                this._updateExpiresOnElement(expiresOnElement, this._expirationDate);
                this._showExpirationTimeControl(true);
                this._keepForever = false;
            } else {
                this._updateExpiresOnElement(expiresOnElement, null);
                this._showExpirationTimeControl(false);
                this._keepForever = true;
            }

            this._updateStatus(this.options.spoolerData.metadata.EF_SPOOLER_STATUS);

            $(".hy-spoolerbar-editable-field", this.element)
                .hover(
                    function () {
                        $(this).addClass("hy-spoolerbar-editable-field-hover");
                    },
                    function () {
                        $(this).removeClass("hy-spoolerbar-editable-field-hover");
                    }
                ).bind("click",
                    function () {
                        $(this).removeClass("hy-spoolerbar-editable-field-hover");
                    });

            self = this;

            $(".hy-spoolerbar-star", this.element).toggleStar(this._spooler.uri);

            // Closures needed to properly bind/unbind events.
            showEditableForm = function (e) {
                self._showEditable(e.data.mini);
                if (e.data.showDatePicker === true) {
                    self._showExpirationTimeControl(true);
                    self._keepForever = false;
                }
                if ($(e.data.edit, self.element).is(":visible")) {
                    $(e.data.edit, self.element).trigger("focus");
                }
                return false;
            };

            nameElement.bind("click",
                {mini: true, edit: 'input.hy-spooler-name-edit'}, showEditableForm);
            descriptionElement.bind("click",
                {mini: true, edit: 'textarea.hy-spooler-description-edit'}, showEditableForm);
            projectElement.bind("click",
                {mini: false, edit: 'input.hy-spooler-project-edit'}, showEditableForm);
            expiresOnElement.bind("click",
                {mini: false, edit: 'input.hy-spooler-expiration-time-edit', showDatePicker: true}, showEditableForm);

            detailsElement = $(".hy-spooler-details", this.element);

            $(".hy-spoolerbar-static", this.element).hover(
                function () {
                    $(this).addClass('ui-state-hover');
                },
                function () {
                    $(this).removeClass('ui-state-hover');
                }
            ).click(
                function () {
                    if (triangleElement.hasClass("ui-icon-triangle-1-e")) {
                        triangleElement
                            .removeClass("ui-icon-triangle-1-e")
                            .addClass("ui-icon-triangle-1-s");
                        nameElement
                            .unbind("click", showEditableForm)
                            .bind("click", {mini: false, edit: 'input.hy-spooler-name-edit'}, showEditableForm);
                        descriptionElement
                            .unbind("click", showEditableForm)
                            .bind("click", {mini: false, edit: 'textarea.hy-spooler-description-edit'},
                                    showEditableForm)
                            .html(efEncodeHtml(self._spooler.metadata.EF_SPOOLER_DESCRIPTION));
                        statusElement
                            .hide();
                        detailsElement
                            .fadeIn();
                        return false;
                    }
                    if (!$(this).hasClass("ui-state-disabled")) {
                        triangleElement
                            .removeClass("ui-icon-triangle-1-s")
                            .addClass("ui-icon-triangle-1-e");
                        nameElement
                            .unbind("click", showEditableForm)
                            .bind("click", {mini: true, edit: 'input.hy-spooler-name-edit'}, showEditableForm);
                        descriptionElement
                            .unbind("click", showEditableForm)
                            .bind("click", {mini: true, edit: 'input.hy-spooler-description-edit'}, showEditableForm)
                            .html(efEncodeHtml(ellipsize(self._spooler.metadata.EF_SPOOLER_DESCRIPTION,
                                            self.options.ellipsizedLength)));
                        detailsElement
                            .fadeOut("complete", function() {
                                statusElement.show();
                            });
                        return false;
                    }
                }
            );

            $(".hy-spoolerbar-link-keep-forever", this.element).click(function () {
                self._showExpirationTimeControl(false);
                self._keepForever = true;
            });

            $(".hy-spoolerbar-link-set-time", this.element).click(function () {
                self._showExpirationTimeControl(true);
                $(".hy-spooler-expiration-time-edit", self.element).trigger("focus");
                self._keepForever = false;
            });

            $("input:text:not(.hy-spoolerbar-no-hint), textarea", this.element)
                .inputHint({
                    className: "hy-spoolerbar-hint"
                });

            $(".hy-spoolerbar-datepicker", this.element).datepicker({
                dateFormat: "DD, d MM yy",
                constrainInput: true,
                changeMonth: true,
                changeYear: true,
                minDate: this._minExpirationDate
            });
        },

        _showExpirationTimeControl: function (visible) {
            if (visible) {
                $(".hy-spooler-expiration-time-control", this.element).show();
                $(".hy-spooler-expiration-time-never", this.element).hide();
                $(".hy-spoolerbar-link-keep-forever", this.element).show();
                $(".hy-spoolerbar-link-set-time", this.element).hide();
                $(".hy-spoolerbar-expiration-time-row", this.element).removeClass("hy-spoolerbar-not-editable");
            } else {
                $(".hy-spooler-expiration-time-control", this.element).hide();
                $(".hy-spooler-expiration-time-never", this.element).show();
                $(".hy-spoolerbar-link-keep-forever", this.element).hide();
                $(".hy-spoolerbar-link-set-time", this.element).show();
                $(".hy-spoolerbar-expiration-time-row", this.element).addClass("hy-spoolerbar-not-editable");
            }
        },

        _updateExpiresOnElement: function (expiresOnElement, isoDate, changed) {
            var now;
            if (isoDate) {
                now = new Date();
                expiresOnElement
                    .html($.datepicker.formatDate("DD, d MM yy", isoDate) +
                          " at " + padWithZero(isoDate.getHours()) + ":" +
                          padWithZero(isoDate.getMinutes()));
                if ((isoDate - now) < DAY_IN_MILLISECONDS) {
                    this._addNotification("This spooler will be deleted " +
                        (isoDate.getDate() === now.getDate() ? "today" : "tomorrow") +
                        " at " + padWithZero(isoDate.getHours()) + ":" +
                        padWithZero(isoDate.getMinutes() + "."),
                        true);
                }
            } else {
                expiresOnElement.html("Never");
                if (changed === true) {
                    this._addNotification("This spooler will never expire.", true);
                }
            }
        },

        _showEditable: function (isMini) {
            var element, self;

            $(".hy-spooler-name-edit", this.element).val(this._spooler.name);
            element = $(".hy-spooler-description-edit", this.element);
            if (this._spooler.metadata.EF_SPOOLER_DESCRIPTION.length > 0) {
                element
                    .removeClass("hy-spoolerbar-hint")
                    .val(this._spooler.metadata.EF_SPOOLER_DESCRIPTION);
            } else {
                element
                    .addClass("hy-spoolerbar-hint")
                    .val(element.attr("title"));
            }
            if (!isMini) {
                element = $(".hy-spooler-project-edit", this.element);
                if (this._spooler.metadata.EF_SPOOLER_PROJECT.length > 0) {
                    element
                        .removeClass("hy-spoolerbar-hint")
                        .val(this._spooler.metadata.EF_SPOOLER_PROJECT);
                } else {
                    element
                        .addClass("hy-spoolerbar-hint")
                        .val(element.attr("title"));
                }
                element = $(".hy-spooler-created-on-edit", this.element);
                if (element.html().length === 0) {
                    element.html($.datepicker.formatDate("DD, d MM yy", this._creationDate) +
                             " at " + padWithZero(this._creationDate.getHours()) + ":" +
                             padWithZero(this._creationDate.getMinutes()));
                }
                if (this._expirationDate) {
                    $(".hy-spooler-expiration-time-edit", this.element).val(
                        $.datepicker.formatDate("DD, d MM yy", this._expirationDate)
                    );
                    element = $(".hy-spooler-expiration-time-edit-time", this.element);
                    if (element.html().length === 0) {
                        element.html(padWithZero(this._expirationDate.getHours()) + ":" +
                            padWithZero(this._expirationDate.getMinutes()));
                    }
                    this._showExpirationTimeControl(true);
                } else {
                    $(".hy-spooler-expiration-time-edit", this.element).val(
                        $.datepicker.formatDate("DD, d MM yy", this._minExpirationDate)
                    );
                    element = $(".hy-spooler-expiration-time-edit-time", this.element);
                    if (element.html().length === 0) {
                        element.html(padWithZero(this._minExpirationDate.getHours()) + ":" +
                            padWithZero(this._minExpirationDate.getMinutes()));
                    }
                    this._showExpirationTimeControl(false);
                }
            }

            self = this;
            $(".hy-spooler-save-button", this.element)
                .unbind("click")
                .bind("click",
                    function () {
                        self._saveEditable(isMini);
                    });
            $(".hy-spooler-cancel-button", this.element)
                .unbind("click")
                .bind("click",
                    function () {
                        self._toggleEditableBar(isMini);
                    });

            this._toggleEditableBar(isMini);
        },

        _saveEditable: function (isMini) {
            var name, element, newExpirationDate, now, changed;

            this._removeNotifications();

            name = $(".hy-spooler-name-edit", this.element).val();
            if (name.length > 0) {
                this._spooler.name = name;
                $(".hy-spooler-name", this.element).html(efEncodeHtml(name));
            }

            element = $(".hy-spooler-description-edit", this.element);
            if (element.val() !== element.attr("title")) {
                this._spooler.metadata.EF_SPOOLER_DESCRIPTION = element.val();
                if (isMini) {
                    $(".hy-spooler-description", this.element).html(
                        efEncodeHtml(ellipsize(this._spooler.metadata.EF_SPOOLER_DESCRIPTION, this.options.ellipsizedLength))
                    );
                } else {
                    $(".hy-spooler-description", this.element).html(efEncodeHtml(this._spooler.metadata.EF_SPOOLER_DESCRIPTION));
                }
                $(".hy-spoolerbar-description-container", this.element).show();
            } else {
                this._spooler.metadata.EF_SPOOLER_DESCRIPTION = "";
                $(".hy-spoolerbar-description-container", this.element).hide();
            }

            if (!isMini) {
                element = $(".hy-spooler-project-edit", this.element);
                if (element.val() !== element.attr("title")) {
                    this._spooler.metadata.EF_SPOOLER_PROJECT = element.val();
                } else {
                    this._spooler.metadata.EF_SPOOLER_PROJECT = "";
                }
                $(".hy-spooler-project", this.element).html(efEncodeHtml(this._spooler.metadata.EF_SPOOLER_PROJECT));

                if (!this._keepForever) {
                    try {
                        newExpirationDate = $.datepicker.parseDate("DD, d MM yy",
                            $(".hy-spooler-expiration-time-edit", this.element).val());
                        newExpirationDate.setHours($(".hy-spooler-expiration-time-edit-time",
                            this.element).text().split(':')[0]);
                        newExpirationDate.setMinutes($(".hy-spooler-expiration-time-edit-time",
                            this.element).text().split(':')[1]);

                        now = new Date();

                        if (newExpirationDate < now) {
                            this._addError(
                                "The specified expiration date is in the past, please select a date in the future."
                            );
                            return;
                        }

                        this._expirationDate = newExpirationDate;

                        this._spooler["expiration-time"] = formatAsISO8601Date(this._expirationDate) + "T" +
                            padWithZero(this._expirationDate.getHours()) + ":" +
                            padWithZero(this._expirationDate.getMinutes()) + ":" +
                            padWithZero(this._expirationDate.getSeconds()) +
                            this._timeZone;
                    } catch (e) {
                        this._addError("The specified expiration date is not correct.");
                        return;
                    }
                } else {
                    changed = (this._expirationDate !== null);
                    this._expirationDate = null;
                    this._spooler["expiration-time"] = "forever";
                }

                this._updateExpiresOnElement($(".hy-spooler-expires-on", this.element),
                    this._expirationDate, changed);

            }

            this._toggleEditableBar(isMini);

            $.enginframe.invokeService({
                sdf: this.options.conf.params.SDF,
                uri: this.options.conf.params.resetSpoolerServiceUri,
                data: {
                    _selected: this._spooler.uri,
                    _name: this._spooler.name,
                    _description: this._spooler.metadata.EF_SPOOLER_DESCRIPTION,
                    _project: this._spooler.metadata.EF_SPOOLER_PROJECT,
                    _expirationTime: this._spooler["expiration-time"]
                },
                dataType: 'text'
            });
        },

        _toggleEditableBar: function (isMini) {
            var element;

            element = $(".hy-spoolerbar-editable", this.element);
            if (element.hasClass("isShown")) {
                element.removeClass("isShown").hide();
                $(".hy-spoolerbar-static", this.element).show();
            } else {
                element.addClass("isShown").show();
                $(".hy-spoolerbar-static", this.element).removeClass("ui-state-hover").hide();
                if (isMini) {
                    $(".hy-spooler-details-edit", this.element).hide();
                } else {
                    $(".hy-spooler-details-edit", this.element).show();
                }
            }
        },

        _addError: function (message) {
            if (this.options.notificationArea) {
                this.options.notificationArea.hymessage("alert", message);
            }
        },

        _addNotification: function (message, showLink) {
            var self;

            if (!this.options.notificationArea) {
                return;
            }

            if (showLink) {
                message = message +
                    ' <a class="hy-spoolerbar-link-change-date hy-spoolerbar-link">Change expiration date...</a>';
            }

            this.options.notificationArea.hymessage("info", message);

            self = this;

            $('.hy-spoolerbar-link-change-date', this.options.notificationArea).click(
                function () {
                    self._showEditable(false);
                    self._showExpirationTimeControl(true);
                    self._keepForever = false;
                    $(".hy-spooler-expiration-time-edit", self.element).trigger("focus");
                    $(this).fadeOut();
                }
            );
        },

        _removeNotifications: function () {
            if (this.options.notificationArea) {
                this.options.notificationArea.hymessage("clear");
            }
        },

        _updateStatus: function (status) {
            var statusElement;

            $('.hy-spoolerbar-status', this.element).empty();
            $('.hy-spooler-details-status', this.element).empty();

            if (status !== undefined && status !== 'No_jobs') {
                statusElement = $.hydrogen.spoolerStatusFormatter(status);

                $('.hy-spoolerbar-status', this.element)
                    .html(statusElement);
                $('.hy-spooler-details-status', this.element)
                    .append('<label class="hy-spoolerbar-label">Status:</label>')
                    .append(statusElement)
                    .append('<div class="hy-spoolerbar-separator"></div>');
            }
        },

        refreshStatus: function () {
            var self;

            self = this;
            // Invoked service has text/plain output, so it's better to use
            // enginframe.invokeService to correctly handle error messages.
            jQuery.enginframe.invokeService({
                sdf: this.options.conf.params.SDF,
                uri: this.options.conf.params.getSpoolerStatusServiceUri,
                data: {"spoolerUri": this._spooler["uri"]},
                success: function (status) {
                    self._updateStatus(status);
                },
                error: function (err) {
                    self.options.notificationArea.hymessage("alert", "<strong>" + err.responseText + "</strong>");
                }
            });
        },

        destroy: function () {

            // Better than this.element.children().first().remove() concerning performances
            $('#' + this.element.attr('id') + '> :first-child').remove();
            this.element.removeClass('hy-spoolerbar ui-widget');

            $.Widget.prototype.destroy.apply(this, arguments);

            return this;
        }
    });

}(jQuery));

// ex:ts=4:et:
